/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Configuration;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicinalProductIngredient;
import org.hl7.fhir.r4.model.Property;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.ResourceType;
import org.hl7.fhir.r4.model.StringType;

@ResourceDef(name="MedicinalProductPharmaceutical", profile="http://hl7.org/fhir/Profile/MedicinalProductPharmaceutical")
public class MedicinalProductPharmaceutical
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for the pharmaceutical medicinal product", formalDefinition="An identifier for the pharmaceutical medicinal product.")
    protected List<Identifier> identifier;
    @Child(name="administrableDoseForm", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The administrable dose form, after necessary reconstitution", formalDefinition="The administrable dose form, after necessary reconstitution.")
    protected CodeableConcept administrableDoseForm;
    @Child(name="unitOfPresentation", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Todo", formalDefinition="Todo.")
    protected CodeableConcept unitOfPresentation;
    @Child(name="routeOfAdministration", type={CodeableConcept.class}, order=3, min=1, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The path by which the pharmaceutical product is taken into or makes contact with the body", formalDefinition="The path by which the pharmaceutical product is taken into or makes contact with the body.")
    protected List<CodeableConcept> routeOfAdministration;
    @Child(name="ingredient", type={MedicinalProductIngredient.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Ingredient", formalDefinition="Ingredient.")
    protected List<Reference> ingredient;
    protected List<MedicinalProductIngredient> ingredientTarget;
    @Child(name="device", type={StringType.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Accompanying device", formalDefinition="Accompanying device.")
    protected List<StringType> device;
    @Child(name="characteristics", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Characteristics e.g. a products onset of action", formalDefinition="Characteristics e.g. a products onset of action.")
    protected List<MedicinalProductPharmaceuticalCharacteristicsComponent> characteristics;
    private static final long serialVersionUID = -1564698410L;

    public MedicinalProductPharmaceutical() {
    }

    public MedicinalProductPharmaceutical(CodeableConcept administrableDoseForm) {
        this.administrableDoseForm = administrableDoseForm;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public MedicinalProductPharmaceutical setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CodeableConcept getAdministrableDoseForm() {
        if (this.administrableDoseForm == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPharmaceutical.administrableDoseForm");
            }
            if (Configuration.doAutoCreate()) {
                this.administrableDoseForm = new CodeableConcept();
            }
        }
        return this.administrableDoseForm;
    }

    public boolean hasAdministrableDoseForm() {
        return this.administrableDoseForm != null && !this.administrableDoseForm.isEmpty();
    }

    public MedicinalProductPharmaceutical setAdministrableDoseForm(CodeableConcept value) {
        this.administrableDoseForm = value;
        return this;
    }

    public CodeableConcept getUnitOfPresentation() {
        if (this.unitOfPresentation == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MedicinalProductPharmaceutical.unitOfPresentation");
            }
            if (Configuration.doAutoCreate()) {
                this.unitOfPresentation = new CodeableConcept();
            }
        }
        return this.unitOfPresentation;
    }

    public boolean hasUnitOfPresentation() {
        return this.unitOfPresentation != null && !this.unitOfPresentation.isEmpty();
    }

    public MedicinalProductPharmaceutical setUnitOfPresentation(CodeableConcept value) {
        this.unitOfPresentation = value;
        return this;
    }

    public List<CodeableConcept> getRouteOfAdministration() {
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<CodeableConcept>();
        }
        return this.routeOfAdministration;
    }

    public MedicinalProductPharmaceutical setRouteOfAdministration(List<CodeableConcept> theRouteOfAdministration) {
        this.routeOfAdministration = theRouteOfAdministration;
        return this;
    }

    public boolean hasRouteOfAdministration() {
        if (this.routeOfAdministration == null) {
            return false;
        }
        for (CodeableConcept item : this.routeOfAdministration) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRouteOfAdministration() {
        CodeableConcept t = new CodeableConcept();
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<CodeableConcept>();
        }
        this.routeOfAdministration.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addRouteOfAdministration(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.routeOfAdministration == null) {
            this.routeOfAdministration = new ArrayList<CodeableConcept>();
        }
        this.routeOfAdministration.add(t);
        return this;
    }

    public CodeableConcept getRouteOfAdministrationFirstRep() {
        if (this.getRouteOfAdministration().isEmpty()) {
            this.addRouteOfAdministration();
        }
        return this.getRouteOfAdministration().get(0);
    }

    public List<Reference> getIngredient() {
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        return this.ingredient;
    }

    public MedicinalProductPharmaceutical setIngredient(List<Reference> theIngredient) {
        this.ingredient = theIngredient;
        return this;
    }

    public boolean hasIngredient() {
        if (this.ingredient == null) {
            return false;
        }
        for (Reference item : this.ingredient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addIngredient() {
        Reference t = new Reference();
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addIngredient(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.ingredient == null) {
            this.ingredient = new ArrayList<Reference>();
        }
        this.ingredient.add(t);
        return this;
    }

    public Reference getIngredientFirstRep() {
        if (this.getIngredient().isEmpty()) {
            this.addIngredient();
        }
        return this.getIngredient().get(0);
    }

    @Deprecated
    public List<MedicinalProductIngredient> getIngredientTarget() {
        if (this.ingredientTarget == null) {
            this.ingredientTarget = new ArrayList<MedicinalProductIngredient>();
        }
        return this.ingredientTarget;
    }

    @Deprecated
    public MedicinalProductIngredient addIngredientTarget() {
        MedicinalProductIngredient r = new MedicinalProductIngredient();
        if (this.ingredientTarget == null) {
            this.ingredientTarget = new ArrayList<MedicinalProductIngredient>();
        }
        this.ingredientTarget.add(r);
        return r;
    }

    public List<StringType> getDevice() {
        if (this.device == null) {
            this.device = new ArrayList<StringType>();
        }
        return this.device;
    }

    public MedicinalProductPharmaceutical setDevice(List<StringType> theDevice) {
        this.device = theDevice;
        return this;
    }

    public boolean hasDevice() {
        if (this.device == null) {
            return false;
        }
        for (StringType item : this.device) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addDeviceElement() {
        StringType t = new StringType();
        if (this.device == null) {
            this.device = new ArrayList<StringType>();
        }
        this.device.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addDevice(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.device == null) {
            this.device = new ArrayList<StringType>();
        }
        this.device.add(t);
        return this;
    }

    public boolean hasDevice(String value) {
        if (this.device == null) {
            return false;
        }
        for (StringType v : this.device) {
            if (!((String)v.getValue()).equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<MedicinalProductPharmaceuticalCharacteristicsComponent> getCharacteristics() {
        if (this.characteristics == null) {
            this.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
        }
        return this.characteristics;
    }

    public MedicinalProductPharmaceutical setCharacteristics(List<MedicinalProductPharmaceuticalCharacteristicsComponent> theCharacteristics) {
        this.characteristics = theCharacteristics;
        return this;
    }

    public boolean hasCharacteristics() {
        if (this.characteristics == null) {
            return false;
        }
        for (MedicinalProductPharmaceuticalCharacteristicsComponent item : this.characteristics) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MedicinalProductPharmaceuticalCharacteristicsComponent addCharacteristics() {
        MedicinalProductPharmaceuticalCharacteristicsComponent t = new MedicinalProductPharmaceuticalCharacteristicsComponent();
        if (this.characteristics == null) {
            this.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
        }
        this.characteristics.add(t);
        return t;
    }

    public MedicinalProductPharmaceutical addCharacteristics(MedicinalProductPharmaceuticalCharacteristicsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.characteristics == null) {
            this.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
        }
        this.characteristics.add(t);
        return this;
    }

    public MedicinalProductPharmaceuticalCharacteristicsComponent getCharacteristicsFirstRep() {
        if (this.getCharacteristics().isEmpty()) {
            this.addCharacteristics();
        }
        return this.getCharacteristics().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property("identifier", "Identifier", "An identifier for the pharmaceutical medicinal product.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property("administrableDoseForm", "CodeableConcept", "The administrable dose form, after necessary reconstitution.", 0, 1, this.administrableDoseForm));
        children.add(new Property("unitOfPresentation", "CodeableConcept", "Todo.", 0, 1, this.unitOfPresentation));
        children.add(new Property("routeOfAdministration", "CodeableConcept", "The path by which the pharmaceutical product is taken into or makes contact with the body.", 0, Integer.MAX_VALUE, this.routeOfAdministration));
        children.add(new Property("ingredient", "Reference(MedicinalProductIngredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient));
        children.add(new Property("device", "string", "Accompanying device.", 0, Integer.MAX_VALUE, this.device));
        children.add(new Property("characteristics", "", "Characteristics e.g. a products onset of action.", 0, Integer.MAX_VALUE, this.characteristics));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property("identifier", "Identifier", "An identifier for the pharmaceutical medicinal product.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case 1446105202: {
                return new Property("administrableDoseForm", "CodeableConcept", "The administrable dose form, after necessary reconstitution.", 0, 1, this.administrableDoseForm);
            }
            case -1427765963: {
                return new Property("unitOfPresentation", "CodeableConcept", "Todo.", 0, 1, this.unitOfPresentation);
            }
            case 1742084734: {
                return new Property("routeOfAdministration", "CodeableConcept", "The path by which the pharmaceutical product is taken into or makes contact with the body.", 0, Integer.MAX_VALUE, this.routeOfAdministration);
            }
            case -206409263: {
                return new Property("ingredient", "Reference(MedicinalProductIngredient)", "Ingredient.", 0, Integer.MAX_VALUE, this.ingredient);
            }
            case -1335157162: {
                return new Property("device", "string", "Accompanying device.", 0, Integer.MAX_VALUE, this.device);
            }
            case -1529171400: {
                return new Property("characteristics", "", "Characteristics e.g. a products onset of action.", 0, Integer.MAX_VALUE, this.characteristics);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1446105202: {
                Base[] baseArray;
                if (this.administrableDoseForm == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.administrableDoseForm;
                }
                return baseArray;
            }
            case -1427765963: {
                Base[] baseArray;
                if (this.unitOfPresentation == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.unitOfPresentation;
                }
                return baseArray;
            }
            case 1742084734: {
                return this.routeOfAdministration == null ? new Base[]{} : this.routeOfAdministration.toArray(new Base[this.routeOfAdministration.size()]);
            }
            case -206409263: {
                return this.ingredient == null ? new Base[]{} : this.ingredient.toArray(new Base[this.ingredient.size()]);
            }
            case -1335157162: {
                return this.device == null ? new Base[]{} : this.device.toArray(new Base[this.device.size()]);
            }
            case -1529171400: {
                return this.characteristics == null ? new Base[]{} : this.characteristics.toArray(new Base[this.characteristics.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                return value;
            }
            case 1446105202: {
                this.administrableDoseForm = this.castToCodeableConcept(value);
                return value;
            }
            case -1427765963: {
                this.unitOfPresentation = this.castToCodeableConcept(value);
                return value;
            }
            case 1742084734: {
                this.getRouteOfAdministration().add(this.castToCodeableConcept(value));
                return value;
            }
            case -206409263: {
                this.getIngredient().add(this.castToReference(value));
                return value;
            }
            case -1335157162: {
                this.getDevice().add(this.castToString(value));
                return value;
            }
            case -1529171400: {
                this.getCharacteristics().add((MedicinalProductPharmaceuticalCharacteristicsComponent)value);
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("administrableDoseForm")) {
            this.administrableDoseForm = this.castToCodeableConcept(value);
        } else if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = this.castToCodeableConcept(value);
        } else if (name.equals("routeOfAdministration")) {
            this.getRouteOfAdministration().add(this.castToCodeableConcept(value));
        } else if (name.equals("ingredient")) {
            this.getIngredient().add(this.castToReference(value));
        } else if (name.equals("device")) {
            this.getDevice().add(this.castToString(value));
        } else if (name.equals("characteristics")) {
            this.getCharacteristics().add((MedicinalProductPharmaceuticalCharacteristicsComponent)value);
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1446105202: {
                return this.getAdministrableDoseForm();
            }
            case -1427765963: {
                return this.getUnitOfPresentation();
            }
            case 1742084734: {
                return this.addRouteOfAdministration();
            }
            case -206409263: {
                return this.addIngredient();
            }
            case -1335157162: {
                return this.addDeviceElement();
            }
            case -1529171400: {
                return this.addCharacteristics();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case 1446105202: {
                return new String[]{"CodeableConcept"};
            }
            case -1427765963: {
                return new String[]{"CodeableConcept"};
            }
            case 1742084734: {
                return new String[]{"CodeableConcept"};
            }
            case -206409263: {
                return new String[]{"Reference"};
            }
            case -1335157162: {
                return new String[]{"string"};
            }
            case -1529171400: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("administrableDoseForm")) {
            this.administrableDoseForm = new CodeableConcept();
            return this.administrableDoseForm;
        }
        if (name.equals("unitOfPresentation")) {
            this.unitOfPresentation = new CodeableConcept();
            return this.unitOfPresentation;
        }
        if (name.equals("routeOfAdministration")) {
            return this.addRouteOfAdministration();
        }
        if (name.equals("ingredient")) {
            return this.addIngredient();
        }
        if (name.equals("device")) {
            throw new FHIRException("Cannot call addChild on a primitive type MedicinalProductPharmaceutical.device");
        }
        if (name.equals("characteristics")) {
            return this.addCharacteristics();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MedicinalProductPharmaceutical";
    }

    @Override
    public MedicinalProductPharmaceutical copy() {
        MedicinalProductPharmaceutical dst = new MedicinalProductPharmaceutical();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.administrableDoseForm = this.administrableDoseForm == null ? null : this.administrableDoseForm.copy();
        CodeableConcept codeableConcept = dst.unitOfPresentation = this.unitOfPresentation == null ? null : this.unitOfPresentation.copy();
        if (this.routeOfAdministration != null) {
            dst.routeOfAdministration = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.routeOfAdministration) {
                dst.routeOfAdministration.add(codeableConcept2.copy());
            }
        }
        if (this.ingredient != null) {
            dst.ingredient = new ArrayList<Reference>();
            for (Reference reference : this.ingredient) {
                dst.ingredient.add(reference.copy());
            }
        }
        if (this.device != null) {
            dst.device = new ArrayList<StringType>();
            for (StringType stringType : this.device) {
                dst.device.add(stringType.copy());
            }
        }
        if (this.characteristics != null) {
            dst.characteristics = new ArrayList<MedicinalProductPharmaceuticalCharacteristicsComponent>();
            for (MedicinalProductPharmaceuticalCharacteristicsComponent medicinalProductPharmaceuticalCharacteristicsComponent : this.characteristics) {
                dst.characteristics.add(medicinalProductPharmaceuticalCharacteristicsComponent.copy());
            }
        }
        return dst;
    }

    protected MedicinalProductPharmaceutical typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPharmaceutical)) {
            return false;
        }
        MedicinalProductPharmaceutical o = (MedicinalProductPharmaceutical)other_;
        return MedicinalProductPharmaceutical.compareDeep(this.identifier, o.identifier, true) && MedicinalProductPharmaceutical.compareDeep(this.administrableDoseForm, o.administrableDoseForm, true) && MedicinalProductPharmaceutical.compareDeep(this.unitOfPresentation, o.unitOfPresentation, true) && MedicinalProductPharmaceutical.compareDeep(this.routeOfAdministration, o.routeOfAdministration, true) && MedicinalProductPharmaceutical.compareDeep(this.ingredient, o.ingredient, true) && MedicinalProductPharmaceutical.compareDeep(this.device, o.device, true) && MedicinalProductPharmaceutical.compareDeep(this.characteristics, o.characteristics, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof MedicinalProductPharmaceutical)) {
            return false;
        }
        MedicinalProductPharmaceutical o = (MedicinalProductPharmaceutical)other_;
        return MedicinalProductPharmaceutical.compareValues(this.device, o.device, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.administrableDoseForm, this.unitOfPresentation, this.routeOfAdministration, this.ingredient, this.device, this.characteristics});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MedicinalProductPharmaceutical;
    }

    @Block
    public static class MedicinalProductPharmaceuticalCharacteristicsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A coded characteristic", formalDefinition="A coded characteristic.")
        protected CodeableConcept code;
        @Child(name="status", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The status of characteristic e.g. assigned or pending", formalDefinition="The status of characteristic e.g. assigned or pending.")
        protected CodeableConcept status;
        private static final long serialVersionUID = 1414556635L;

        public MedicinalProductPharmaceuticalCharacteristicsComponent() {
        }

        public MedicinalProductPharmaceuticalCharacteristicsComponent(CodeableConcept code) {
            this.code = code;
        }

        public CodeableConcept getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalCharacteristicsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new CodeableConcept();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MedicinalProductPharmaceuticalCharacteristicsComponent setCode(CodeableConcept value) {
            this.code = value;
            return this;
        }

        public CodeableConcept getStatus() {
            if (this.status == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MedicinalProductPharmaceuticalCharacteristicsComponent.status");
                }
                if (Configuration.doAutoCreate()) {
                    this.status = new CodeableConcept();
                }
            }
            return this.status;
        }

        public boolean hasStatus() {
            return this.status != null && !this.status.isEmpty();
        }

        public MedicinalProductPharmaceuticalCharacteristicsComponent setStatus(CodeableConcept value) {
            this.status = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("code", "CodeableConcept", "A coded characteristic.", 0, 1, this.code));
            children.add(new Property("status", "CodeableConcept", "The status of characteristic e.g. assigned or pending.", 0, 1, this.status));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case 3059181: {
                    return new Property("code", "CodeableConcept", "A coded characteristic.", 0, 1, this.code);
                }
                case -892481550: {
                    return new Property("status", "CodeableConcept", "The status of characteristic e.g. assigned or pending.", 0, 1, this.status);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    Base[] baseArray;
                    if (this.code == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.code;
                    }
                    return baseArray;
                }
                case -892481550: {
                    Base[] baseArray;
                    if (this.status == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.status;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    this.code = this.castToCodeableConcept(value);
                    return value;
                }
                case -892481550: {
                    this.status = this.castToCodeableConcept(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCodeableConcept(value);
            } else if (name.equals("status")) {
                this.status = this.castToCodeableConcept(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return this.getCode();
                }
                case -892481550: {
                    return this.getStatus();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 3059181: {
                    return new String[]{"CodeableConcept"};
                }
                case -892481550: {
                    return new String[]{"CodeableConcept"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new CodeableConcept();
                return this.code;
            }
            if (name.equals("status")) {
                this.status = new CodeableConcept();
                return this.status;
            }
            return super.addChild(name);
        }

        @Override
        public MedicinalProductPharmaceuticalCharacteristicsComponent copy() {
            MedicinalProductPharmaceuticalCharacteristicsComponent dst = new MedicinalProductPharmaceuticalCharacteristicsComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.status = this.status == null ? null : this.status.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalCharacteristicsComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalCharacteristicsComponent o = (MedicinalProductPharmaceuticalCharacteristicsComponent)other_;
            return MedicinalProductPharmaceuticalCharacteristicsComponent.compareDeep(this.code, o.code, true) && MedicinalProductPharmaceuticalCharacteristicsComponent.compareDeep(this.status, o.status, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof MedicinalProductPharmaceuticalCharacteristicsComponent)) {
                return false;
            }
            MedicinalProductPharmaceuticalCharacteristicsComponent o = (MedicinalProductPharmaceuticalCharacteristicsComponent)other_;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.code, this.status});
        }

        @Override
        public String fhirType() {
            return "MedicinalProductPharmaceutical.characteristics";
        }
    }
}

