/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum AdverseEventCategory {
    PRODUCTPROBLEM,
    PRODUCTQUALITY,
    PRODUCTUSEERROR,
    WRONGDOSE,
    INCORRECTPRESCRIBINGINFORMATION,
    WRONGTECHNIQUE,
    WRONGROUTEOFADMINISTRATION,
    WRONGRATE,
    WRONGDURATION,
    WRONGTIME,
    EXPIREDDRUG,
    MEDICALDEVICEUSEERROR,
    PROBLEMDIFFERENTMANUFACTURER,
    UNSAFEPHYSICALENVIRONMENT,
    NULL;


    public static AdverseEventCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("ProductProblem".equals(codeString)) {
            return PRODUCTPROBLEM;
        }
        if ("ProductQuality".equals(codeString)) {
            return PRODUCTQUALITY;
        }
        if ("ProductUseError".equals(codeString)) {
            return PRODUCTUSEERROR;
        }
        if ("WrongDose".equals(codeString)) {
            return WRONGDOSE;
        }
        if ("IncorrectPrescribingInformation".equals(codeString)) {
            return INCORRECTPRESCRIBINGINFORMATION;
        }
        if ("WrongTechnique".equals(codeString)) {
            return WRONGTECHNIQUE;
        }
        if ("WrongRouteOfAdministration".equals(codeString)) {
            return WRONGROUTEOFADMINISTRATION;
        }
        if ("WrongRate".equals(codeString)) {
            return WRONGRATE;
        }
        if ("WrongDuration".equals(codeString)) {
            return WRONGDURATION;
        }
        if ("WrongTime".equals(codeString)) {
            return WRONGTIME;
        }
        if ("ExpiredDrug".equals(codeString)) {
            return EXPIREDDRUG;
        }
        if ("MedicalDeviceUseError".equals(codeString)) {
            return MEDICALDEVICEUSEERROR;
        }
        if ("ProblemDifferentManufacturer".equals(codeString)) {
            return PROBLEMDIFFERENTMANUFACTURER;
        }
        if ("UnsafePhysicalEnvironment".equals(codeString)) {
            return UNSAFEPHYSICALENVIRONMENT;
        }
        throw new FHIRException("Unknown AdverseEventCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRODUCTPROBLEM: {
                return "ProductProblem";
            }
            case PRODUCTQUALITY: {
                return "ProductQuality";
            }
            case PRODUCTUSEERROR: {
                return "ProductUseError";
            }
            case WRONGDOSE: {
                return "WrongDose";
            }
            case INCORRECTPRESCRIBINGINFORMATION: {
                return "IncorrectPrescribingInformation";
            }
            case WRONGTECHNIQUE: {
                return "WrongTechnique";
            }
            case WRONGROUTEOFADMINISTRATION: {
                return "WrongRouteOfAdministration";
            }
            case WRONGRATE: {
                return "WrongRate";
            }
            case WRONGDURATION: {
                return "WrongDuration";
            }
            case WRONGTIME: {
                return "WrongTime";
            }
            case EXPIREDDRUG: {
                return "ExpiredDrug";
            }
            case MEDICALDEVICEUSEERROR: {
                return "MedicalDeviceUseError";
            }
            case PROBLEMDIFFERENTMANUFACTURER: {
                return "ProblemDifferentManufacturer";
            }
            case UNSAFEPHYSICALENVIRONMENT: {
                return "UnsafePhysicalEnvironment";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/adverse-event-category";
    }

    public String getDefinition() {
        switch (this) {
            case PRODUCTPROBLEM: {
                return "";
            }
            case PRODUCTQUALITY: {
                return "";
            }
            case PRODUCTUSEERROR: {
                return "";
            }
            case WRONGDOSE: {
                return "";
            }
            case INCORRECTPRESCRIBINGINFORMATION: {
                return "";
            }
            case WRONGTECHNIQUE: {
                return "";
            }
            case WRONGROUTEOFADMINISTRATION: {
                return "";
            }
            case WRONGRATE: {
                return "";
            }
            case WRONGDURATION: {
                return "";
            }
            case WRONGTIME: {
                return "";
            }
            case EXPIREDDRUG: {
                return "";
            }
            case MEDICALDEVICEUSEERROR: {
                return "";
            }
            case PROBLEMDIFFERENTMANUFACTURER: {
                return "";
            }
            case UNSAFEPHYSICALENVIRONMENT: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRODUCTPROBLEM: {
                return "Product Problem";
            }
            case PRODUCTQUALITY: {
                return "Product Quality";
            }
            case PRODUCTUSEERROR: {
                return "Product Use Error";
            }
            case WRONGDOSE: {
                return "Wrong Dose";
            }
            case INCORRECTPRESCRIBINGINFORMATION: {
                return "Incorrect Prescribing Information";
            }
            case WRONGTECHNIQUE: {
                return "Wrong Technique";
            }
            case WRONGROUTEOFADMINISTRATION: {
                return "Wrong Route of Administration";
            }
            case WRONGRATE: {
                return "Wrong Rate";
            }
            case WRONGDURATION: {
                return "Wrong Duration";
            }
            case WRONGTIME: {
                return "Wrong Time";
            }
            case EXPIREDDRUG: {
                return "Expired Drug";
            }
            case MEDICALDEVICEUSEERROR: {
                return "Medical Device Use Error";
            }
            case PROBLEMDIFFERENTMANUFACTURER: {
                return "Problem with Different Manufacturer of Same Medicine";
            }
            case UNSAFEPHYSICALENVIRONMENT: {
                return "Unsafe Physical Environment";
            }
        }
        return "?";
    }
}

