/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ConsentProvisionType {
    DENY,
    PERMIT,
    NULL;


    public static ConsentProvisionType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("deny".equals(codeString)) {
            return DENY;
        }
        if ("permit".equals(codeString)) {
            return PERMIT;
        }
        throw new FHIRException("Unknown ConsentProvisionType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case DENY: {
                return "deny";
            }
            case PERMIT: {
                return "permit";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/consent-provision-type";
    }

    public String getDefinition() {
        switch (this) {
            case DENY: {
                return "Consent is denied for actions meeting these rules";
            }
            case PERMIT: {
                return "Consent is provided for actions meeting these rules";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case DENY: {
                return "Opt Out";
            }
            case PERMIT: {
                return "Opt In";
            }
        }
        return "?";
    }
}

