/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum CopyNumberEvent {
    AMP,
    DEL,
    LOF,
    NULL;


    public static CopyNumberEvent fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("amp".equals(codeString)) {
            return AMP;
        }
        if ("del".equals(codeString)) {
            return DEL;
        }
        if ("lof".equals(codeString)) {
            return LOF;
        }
        throw new FHIRException("Unknown CopyNumberEvent code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case AMP: {
                return "amp";
            }
            case DEL: {
                return "del";
            }
            case LOF: {
                return "lof";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/copy-number-event";
    }

    public String getDefinition() {
        switch (this) {
            case AMP: {
                return "amplification";
            }
            case DEL: {
                return "deletion";
            }
            case LOF: {
                return "loss of function";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case AMP: {
                return "amplification";
            }
            case DEL: {
                return "deletion";
            }
            case LOF: {
                return "loss of function";
            }
        }
        return "?";
    }
}

