/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum DiscriminatorType {
    VALUE,
    EXISTS,
    PATTERN,
    TYPE,
    PROFILE,
    NULL;


    public static DiscriminatorType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("value".equals(codeString)) {
            return VALUE;
        }
        if ("exists".equals(codeString)) {
            return EXISTS;
        }
        if ("pattern".equals(codeString)) {
            return PATTERN;
        }
        if ("type".equals(codeString)) {
            return TYPE;
        }
        if ("profile".equals(codeString)) {
            return PROFILE;
        }
        throw new FHIRException("Unknown DiscriminatorType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case VALUE: {
                return "value";
            }
            case EXISTS: {
                return "exists";
            }
            case PATTERN: {
                return "pattern";
            }
            case TYPE: {
                return "type";
            }
            case PROFILE: {
                return "profile";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/discriminator-type";
    }

    public String getDefinition() {
        switch (this) {
            case VALUE: {
                return "The slices have different values in the nominated element";
            }
            case EXISTS: {
                return "The slices are differentiated by the presence or absence of the nominated element";
            }
            case PATTERN: {
                return "The slices have different values in the nominated element, as determined by testing them against the applicable ElementDefinition.pattern[x]";
            }
            case TYPE: {
                return "The slices are differentiated by type of the nominated element";
            }
            case PROFILE: {
                return "The slices are differentiated by conformance of the nominated element to a specified profile. Note that if the path specifies .resolve() then the profile is the target profile on the reference. In this case, validation by the possible profiles is required to differentiate the slices";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case VALUE: {
                return "Value";
            }
            case EXISTS: {
                return "Exists";
            }
            case PATTERN: {
                return "Pattern";
            }
            case TYPE: {
                return "Type";
            }
            case PROFILE: {
                return "Profile";
            }
        }
        return "?";
    }
}

