/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum EpisodeOfCareStatus {
    PLANNED,
    WAITLIST,
    ACTIVE,
    ONHOLD,
    FINISHED,
    CANCELLED,
    ENTEREDINERROR,
    NULL;


    public static EpisodeOfCareStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("planned".equals(codeString)) {
            return PLANNED;
        }
        if ("waitlist".equals(codeString)) {
            return WAITLIST;
        }
        if ("active".equals(codeString)) {
            return ACTIVE;
        }
        if ("onhold".equals(codeString)) {
            return ONHOLD;
        }
        if ("finished".equals(codeString)) {
            return FINISHED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown EpisodeOfCareStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PLANNED: {
                return "planned";
            }
            case WAITLIST: {
                return "waitlist";
            }
            case ACTIVE: {
                return "active";
            }
            case ONHOLD: {
                return "onhold";
            }
            case FINISHED: {
                return "finished";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/episode-of-care-status";
    }

    public String getDefinition() {
        switch (this) {
            case PLANNED: {
                return "This episode of care is planned to start at the date specified in the period.start. During this status, an organization may perform assessments to determine if the patient is eligible to receive services, or be organizing to make resources available to provide care services.";
            }
            case WAITLIST: {
                return "This episode has been placed on a waitlist, pending the episode being made active (or cancelled).";
            }
            case ACTIVE: {
                return "This episode of care is current.";
            }
            case ONHOLD: {
                return "This episode of care is on hold, the organization has limited responsibility for the patient (such as while on respite).";
            }
            case FINISHED: {
                return "This episode of care is finished and the organization is not expecting to be providing further care to the patient. Can also be known as \"closed\", \"completed\" or other similar terms.";
            }
            case CANCELLED: {
                return "The episode of care was cancelled, or withdrawn from service, often selected during the planned stage as the patient may have gone elsewhere, or the circumstances have changed and the organization is unable to provide the care. It indicates that services terminated outside the planned/expected workflow.";
            }
            case ENTEREDINERROR: {
                return "This instance should not have been part of this patient's medical record.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PLANNED: {
                return "Planned";
            }
            case WAITLIST: {
                return "Waitlist";
            }
            case ACTIVE: {
                return "Active";
            }
            case ONHOLD: {
                return "On Hold";
            }
            case FINISHED: {
                return "Finished";
            }
            case CANCELLED: {
                return "Cancelled";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
        }
        return "?";
    }
}

