/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.FailureAction;

public class FailureActionEnumFactory
implements EnumFactory<FailureAction> {
    @Override
    public FailureAction fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("fatal".equals(codeString)) {
            return FailureAction.FATAL;
        }
        if ("warn".equals(codeString)) {
            return FailureAction.WARN;
        }
        if ("rec-only".equals(codeString)) {
            return FailureAction.RECONLY;
        }
        if ("none".equals(codeString)) {
            return FailureAction.NONE;
        }
        throw new IllegalArgumentException("Unknown FailureAction code '" + codeString + "'");
    }

    @Override
    public String toCode(FailureAction code) {
        if (code == FailureAction.FATAL) {
            return "fatal";
        }
        if (code == FailureAction.WARN) {
            return "warn";
        }
        if (code == FailureAction.RECONLY) {
            return "rec-only";
        }
        if (code == FailureAction.NONE) {
            return "none";
        }
        return "?";
    }

    @Override
    public String toSystem(FailureAction code) {
        return code.getSystem();
    }
}

