/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ImplantStatus {
    FUNCTIONAL,
    NONFUNCTIONAL,
    DISABLED,
    UNKNOWN,
    NULL;


    public static ImplantStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("functional".equals(codeString)) {
            return FUNCTIONAL;
        }
        if ("non-functional".equals(codeString)) {
            return NONFUNCTIONAL;
        }
        if ("disabled".equals(codeString)) {
            return DISABLED;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ImplantStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FUNCTIONAL: {
                return "functional";
            }
            case NONFUNCTIONAL: {
                return "non-functional";
            }
            case DISABLED: {
                return "disabled";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/implant-status";
    }

    public String getDefinition() {
        switch (this) {
            case FUNCTIONAL: {
                return "The implanted device is working normally";
            }
            case NONFUNCTIONAL: {
                return "The implanted device is not working";
            }
            case DISABLED: {
                return "The implanted device has been turned off";
            }
            case UNKNOWN: {
                return "the functional status of the implant has not been determined";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FUNCTIONAL: {
                return "Functional";
            }
            case NONFUNCTIONAL: {
                return "Non-Functional";
            }
            case DISABLED: {
                return "Disabled";
            }
            case UNKNOWN: {
                return "Unknown";
            }
        }
        return "?";
    }
}

