/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MeasureReportType {
    INDIVIDUAL,
    SUBJECTLIST,
    SUMMARY,
    NULL;


    public static MeasureReportType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("individual".equals(codeString)) {
            return INDIVIDUAL;
        }
        if ("subject-list".equals(codeString)) {
            return SUBJECTLIST;
        }
        if ("summary".equals(codeString)) {
            return SUMMARY;
        }
        throw new FHIRException("Unknown MeasureReportType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case INDIVIDUAL: {
                return "individual";
            }
            case SUBJECTLIST: {
                return "subject-list";
            }
            case SUMMARY: {
                return "summary";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/measure-report-type";
    }

    public String getDefinition() {
        switch (this) {
            case INDIVIDUAL: {
                return "An individual report that provides information on the performance for a given measure with respect to a single subject";
            }
            case SUBJECTLIST: {
                return "A subject list report that includes a listing of subjects that satisfied each population criteria in the measure";
            }
            case SUMMARY: {
                return "A summary report that returns the number of members in each population criteria for the measure";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case INDIVIDUAL: {
                return "Individual";
            }
            case SUBJECTLIST: {
                return "Subject List";
            }
            case SUMMARY: {
                return "Summary";
            }
        }
        return "?";
    }
}

