/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MedicationRequestIntent {
    PROPOSAL,
    PLAN,
    ORDER,
    ORIGINALORDER,
    INSTANCEORDER,
    OPTION,
    NULL;


    public static MedicationRequestIntent fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return PLAN;
        }
        if ("order".equals(codeString)) {
            return ORDER;
        }
        if ("original-order".equals(codeString)) {
            return ORIGINALORDER;
        }
        if ("instance-order".equals(codeString)) {
            return INSTANCEORDER;
        }
        if ("option".equals(codeString)) {
            return OPTION;
        }
        throw new FHIRException("Unknown MedicationRequestIntent code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSAL: {
                return "proposal";
            }
            case PLAN: {
                return "plan";
            }
            case ORDER: {
                return "order";
            }
            case ORIGINALORDER: {
                return "original-order";
            }
            case INSTANCEORDER: {
                return "instance-order";
            }
            case OPTION: {
                return "option";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/medication-request-intent";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSAL: {
                return "The request is a suggestion made by someone/something that doesn't have an intention to ensure it occurs and without providing an authorization to act";
            }
            case PLAN: {
                return "The request represents an intension to ensure something occurs without providing an authorization for others to act";
            }
            case ORDER: {
                return "The request represents a request/demand and authorization for action";
            }
            case ORIGINALORDER: {
                return "The request represents the original authorization for the medication request.";
            }
            case INSTANCEORDER: {
                return "The request represents an instance for the particular order, for example a medication administration record.";
            }
            case OPTION: {
                return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or  other constraints among a set of requests.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSAL: {
                return "Proposal";
            }
            case PLAN: {
                return "Plan";
            }
            case ORDER: {
                return "Order";
            }
            case ORIGINALORDER: {
                return "Original Order";
            }
            case INSTANCEORDER: {
                return "Instance Order";
            }
            case OPTION: {
                return "Option";
            }
        }
        return "?";
    }
}

