/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum PolicyholderRelationship {
    CHILD,
    PARENT,
    SPOUSE,
    COMMON,
    OTHER,
    SELF,
    NULL;


    public static PolicyholderRelationship fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("child".equals(codeString)) {
            return CHILD;
        }
        if ("parent".equals(codeString)) {
            return PARENT;
        }
        if ("spouse".equals(codeString)) {
            return SPOUSE;
        }
        if ("common".equals(codeString)) {
            return COMMON;
        }
        if ("other".equals(codeString)) {
            return OTHER;
        }
        if ("self".equals(codeString)) {
            return SELF;
        }
        throw new FHIRException("Unknown PolicyholderRelationship code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case CHILD: {
                return "child";
            }
            case PARENT: {
                return "parent";
            }
            case SPOUSE: {
                return "spouse";
            }
            case COMMON: {
                return "common";
            }
            case OTHER: {
                return "other";
            }
            case SELF: {
                return "self";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/policyholder-relationship";
    }

    public String getDefinition() {
        switch (this) {
            case CHILD: {
                return "The Beneficiary is a child of the Policyholder";
            }
            case PARENT: {
                return "The Beneficiary is a parent of the Policyholder";
            }
            case SPOUSE: {
                return "The Beneficiary is a spouse or equivalent of the Policyholder";
            }
            case COMMON: {
                return "The Beneficiary is a common law spouse or equivalent of the Policyholder";
            }
            case OTHER: {
                return "The Beneficiary has some other relationship the Policyholder";
            }
            case SELF: {
                return "The Beneficiary is the Policyholder";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case CHILD: {
                return "Child";
            }
            case PARENT: {
                return "Parent";
            }
            case SPOUSE: {
                return "Spouse";
            }
            case COMMON: {
                return "Common Law Spouse";
            }
            case OTHER: {
                return "Other";
            }
            case SELF: {
                return "Self";
            }
        }
        return "?";
    }
}

