/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.r4.model.EnumFactory;
import org.hl7.fhir.r4.model.codesystems.PrimarySourceType;

public class PrimarySourceTypeEnumFactory
implements EnumFactory<PrimarySourceType> {
    @Override
    public PrimarySourceType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("lic-board".equals(codeString)) {
            return PrimarySourceType.LICBOARD;
        }
        if ("prim".equals(codeString)) {
            return PrimarySourceType.PRIM;
        }
        if ("cont-ed".equals(codeString)) {
            return PrimarySourceType.CONTED;
        }
        if ("post-serv".equals(codeString)) {
            return PrimarySourceType.POSTSERV;
        }
        if ("rel-own".equals(codeString)) {
            return PrimarySourceType.RELOWN;
        }
        if ("reg-auth".equals(codeString)) {
            return PrimarySourceType.REGAUTH;
        }
        if ("legal".equals(codeString)) {
            return PrimarySourceType.LEGAL;
        }
        if ("issuer".equals(codeString)) {
            return PrimarySourceType.ISSUER;
        }
        if ("auth-source".equals(codeString)) {
            return PrimarySourceType.AUTHSOURCE;
        }
        throw new IllegalArgumentException("Unknown PrimarySourceType code '" + codeString + "'");
    }

    @Override
    public String toCode(PrimarySourceType code) {
        if (code == PrimarySourceType.LICBOARD) {
            return "lic-board";
        }
        if (code == PrimarySourceType.PRIM) {
            return "prim";
        }
        if (code == PrimarySourceType.CONTED) {
            return "cont-ed";
        }
        if (code == PrimarySourceType.POSTSERV) {
            return "post-serv";
        }
        if (code == PrimarySourceType.RELOWN) {
            return "rel-own";
        }
        if (code == PrimarySourceType.REGAUTH) {
            return "reg-auth";
        }
        if (code == PrimarySourceType.LEGAL) {
            return "legal";
        }
        if (code == PrimarySourceType.ISSUER) {
            return "issuer";
        }
        if (code == PrimarySourceType.AUTHSOURCE) {
            return "auth-source";
        }
        return "?";
    }

    @Override
    public String toSystem(PrimarySourceType code) {
        return code.getSystem();
    }
}

