/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum VaccinationProtocolDoseStatusReason {
    ADVSTORAGE,
    COLDCHBRK,
    EXPLOT,
    OUTSIDESCHED,
    PRODRECALL,
    NULL;


    public static VaccinationProtocolDoseStatusReason fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("advstorage".equals(codeString)) {
            return ADVSTORAGE;
        }
        if ("coldchbrk".equals(codeString)) {
            return COLDCHBRK;
        }
        if ("explot".equals(codeString)) {
            return EXPLOT;
        }
        if ("outsidesched".equals(codeString)) {
            return OUTSIDESCHED;
        }
        if ("prodrecall".equals(codeString)) {
            return PRODRECALL;
        }
        throw new FHIRException("Unknown VaccinationProtocolDoseStatusReason code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ADVSTORAGE: {
                return "advstorage";
            }
            case COLDCHBRK: {
                return "coldchbrk";
            }
            case EXPLOT: {
                return "explot";
            }
            case OUTSIDESCHED: {
                return "outsidesched";
            }
            case PRODRECALL: {
                return "prodrecall";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/vaccination-protocol-dose-status-reason";
    }

    public String getDefinition() {
        switch (this) {
            case ADVSTORAGE: {
                return "The product was stored in a manner inconsistent with manufacturer guidelines potentially reducing the effectiveness of the product.";
            }
            case COLDCHBRK: {
                return "The product was stored at a temperature inconsistent with manufacturer guidelines potentially reducing the effectiveness of the product.";
            }
            case EXPLOT: {
                return "The product was administered after the expiration date associated with lot of vaccine.";
            }
            case OUTSIDESCHED: {
                return "The product was administered at a time inconsistent with the documented schedule.";
            }
            case PRODRECALL: {
                return "The product administered has been recalled by the manufacturer.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ADVSTORAGE: {
                return "Adverse storage condition";
            }
            case COLDCHBRK: {
                return "Cold chain break";
            }
            case EXPLOT: {
                return "Expired lot";
            }
            case OUTSIDESCHED: {
                return "Administered outside recommended schedule";
            }
            case PRODRECALL: {
                return "Product recall";
            }
        }
        return "?";
    }
}

