/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.hapi.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.api.BundleLinks;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.IdType;
import org.hl7.fhir.r4.model.Resource;

public class R4BundleFactory
implements IVersionSpecificBundleFactory {
    private String myBase;
    private Bundle myBundle;
    private final FhirContext myContext;

    public R4BundleFactory(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void addResourcesToBundle(List<IBaseResource> theResult, BundleTypeEnum theBundleType, String theServerBase, BundleInclusionRule theBundleInclusionRule, Set<Include> theIncludes) {
        this.ensureBundle();
        ArrayList includedResources = new ArrayList();
        HashSet<IIdType> addedResourceIds = new HashSet<IIdType>();
        for (IBaseResource next : theResult) {
            if (next.getIdElement().isEmpty()) continue;
            addedResourceIds.add(next.getIdElement());
        }
        for (IBaseResource next : theResult) {
            BundleEntrySearchModeEnum searchMode;
            HashSet<String> containedIds = new HashSet<String>();
            if (next instanceof DomainResource) {
                for (Resource nextContained : ((DomainResource)next).getContained()) {
                    if (!StringUtils.isNotBlank((CharSequence)nextContained.getId())) continue;
                    containedIds.add(nextContained.getId());
                }
            }
            ArrayList references = this.myContext.newTerser().getAllResourceReferences(next);
            do {
                ArrayList<IAnyResource> addedResourcesThisPass = new ArrayList<IAnyResource>();
                for (ResourceReferenceInfo nextRefInfo : references) {
                    IAnyResource nextRes;
                    if (theBundleInclusionRule != null && !theBundleInclusionRule.shouldIncludeReferencedResource(nextRefInfo, theIncludes) || (nextRes = (IAnyResource)nextRefInfo.getResourceReference().getResource()) == null || !nextRes.getIdElement().hasIdPart() || containedIds.contains(nextRes.getIdElement().getValue())) continue;
                    IIdType id = nextRes.getIdElement();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceType((IBaseResource)nextRes);
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    addedResourcesThisPass.add(nextRes);
                }
                includedResources.addAll(addedResourcesThisPass);
                references = new ArrayList();
                for (IAnyResource iResource : addedResourcesThisPass) {
                    List newReferences = this.myContext.newTerser().getAllResourceReferences((IBaseResource)iResource);
                    references.addAll(newReferences);
                }
            } while (!references.isEmpty());
            Bundle.BundleEntryComponent entry = this.myBundle.addEntry().setResource((Resource)next);
            Resource nextAsResource = (Resource)next;
            IIdType id = this.populateBundleEntryFullUrl(next, entry);
            BundleEntryTransactionMethodEnum httpVerb = (BundleEntryTransactionMethodEnum)ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.get((IBaseResource)nextAsResource);
            if (httpVerb != null) {
                entry.getRequest().getMethodElement().setValueAsString(httpVerb.name());
                if (id != null) {
                    entry.getRequest().setUrl(id.toUnqualified().getValue());
                }
            }
            if (BundleEntryTransactionMethodEnum.DELETE.equals((Object)httpVerb)) {
                entry.setResource(null);
            }
            if (theBundleType != null) {
                switch (theBundleType) {
                    case BATCH_RESPONSE: 
                    case TRANSACTION_RESPONSE: 
                    case HISTORY: {
                        if (id == null) break;
                        String version = id.getVersionIdPart();
                        if ("1".equals(version)) {
                            entry.getResponse().setStatus("201 Created");
                        } else if (StringUtils.isNotBlank((CharSequence)version)) {
                            entry.getResponse().setStatus("200 OK");
                        }
                        if (!StringUtils.isNotBlank((CharSequence)version)) break;
                        entry.getResponse().setEtag(RestfulServerUtils.createEtag((String)version));
                    }
                }
            }
            if ((searchMode = (BundleEntrySearchModeEnum)ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get((IBaseResource)nextAsResource)) == null) continue;
            entry.getSearch().getModeElement().setValueAsString(searchMode.getCode());
        }
        for (IBaseResource next : includedResources) {
            Bundle.BundleEntryComponent entry = this.myBundle.addEntry();
            entry.setResource((Resource)next).getSearch().setMode(Bundle.SearchEntryMode.INCLUDE);
            this.populateBundleEntryFullUrl(next, entry);
        }
    }

    public void addRootPropertiesToBundle(String theId, @Nonnull BundleLinks theBundleLinks, Integer theTotalResults, IPrimitiveType<Date> theLastUpdated) {
        this.ensureBundle();
        this.myBase = theBundleLinks.serverBase;
        if (this.myBundle.getIdElement().isEmpty()) {
            this.myBundle.setId(theId);
        }
        if (this.myBundle.getMeta().getLastUpdated() == null && theLastUpdated != null) {
            this.myBundle.getMeta().getLastUpdatedElement().setValueAsString(theLastUpdated.getValueAsString());
        }
        if (this.hasNoLinkOfType("self", this.myBundle) && StringUtils.isNotBlank((CharSequence)theBundleLinks.getSelf())) {
            this.myBundle.addLink().setRelation("self").setUrl(theBundleLinks.getSelf());
        }
        if (this.hasNoLinkOfType("next", this.myBundle) && StringUtils.isNotBlank((CharSequence)theBundleLinks.getNext())) {
            this.myBundle.addLink().setRelation("next").setUrl(theBundleLinks.getNext());
        }
        if (this.hasNoLinkOfType("previous", this.myBundle) && StringUtils.isNotBlank((CharSequence)theBundleLinks.getPrev())) {
            this.myBundle.addLink().setRelation("previous").setUrl(theBundleLinks.getPrev());
        }
        this.addTotalResultsToBundle(theTotalResults, theBundleLinks.bundleType);
    }

    public void addTotalResultsToBundle(Integer theTotalResults, BundleTypeEnum theBundleType) {
        this.ensureBundle();
        if (this.myBundle.getIdElement().isEmpty()) {
            this.myBundle.setId(UUID.randomUUID().toString());
        }
        if (this.myBundle.getTypeElement().isEmpty() && theBundleType != null) {
            this.myBundle.getTypeElement().setValueAsString(theBundleType.getCode());
        }
        if (this.myBundle.getTotalElement().isEmpty() && theTotalResults != null) {
            this.myBundle.getTotalElement().setValue((Object)theTotalResults);
        }
    }

    private void ensureBundle() {
        if (this.myBundle == null) {
            this.myBundle = new Bundle();
        }
    }

    public IBaseResource getResourceBundle() {
        return this.myBundle;
    }

    private boolean hasNoLinkOfType(String theLinkType, Bundle theBundle) {
        for (Bundle.BundleLinkComponent next : theBundle.getLink()) {
            if (!theLinkType.equals(next.getRelation())) continue;
            return false;
        }
        return true;
    }

    public void initializeWithBundleResource(IBaseResource theBundle) {
        this.myBundle = (Bundle)theBundle;
    }

    @Nullable
    private IIdType populateBundleEntryFullUrl(IBaseResource theResource, Bundle.BundleEntryComponent theEntry) {
        IIdType idElement;
        if (theResource.getIdElement().hasBaseUrl()) {
            idElement = theResource.getIdElement();
            theEntry.setFullUrl(idElement.toVersionless().getValue());
        } else if (StringUtils.isNotBlank((CharSequence)this.myBase) && theResource.getIdElement().hasIdPart()) {
            idElement = theResource.getIdElement().withServerBase(this.myBase, this.myContext.getResourceType(theResource));
            theEntry.setFullUrl(idElement.toVersionless().getValue());
        } else {
            idElement = null;
        }
        return idElement;
    }

    public List<IBaseResource> toListOfResources() {
        ArrayList<IBaseResource> retVal = new ArrayList<IBaseResource>();
        for (Bundle.BundleEntryComponent next : this.myBundle.getEntry()) {
            IdType id;
            String resourceType;
            if (next.getResource() != null) {
                retVal.add((IBaseResource)next.getResource());
                continue;
            }
            if (next.getResponse().getLocationElement().isEmpty() || !StringUtils.isNotBlank((CharSequence)(resourceType = (id = new IdType(next.getResponse().getLocation())).getResourceType()))) continue;
            IAnyResource res = (IAnyResource)this.myContext.getResourceDefinition(resourceType).newInstance();
            res.setId((IIdType)id);
            retVal.add((IBaseResource)res);
        }
        return retVal;
    }
}

