/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.hapi.ctx;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.util.CoverageIgnore;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.ParserType;
import org.hl7.fhir.r5.hapi.ctx.IValidationSupport;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.r5.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.r5.utils.INarrativeGenerator;
import org.hl7.fhir.r5.utils.IResourceValidator;
import org.hl7.fhir.utilities.TranslationServices;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public final class HapiWorkerContext
implements IWorkerContext,
ValueSetExpander,
ValueSetExpanderFactory {
    private final FhirContext myCtx;
    private final Cache<String, Resource> myFetchedResourceCache;
    private IValidationSupport myValidationSupport;
    private Parameters myExpansionProfile;
    private String myOverrideVersionNs;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        Validate.notNull((Object)theCtx, (String)"theCtx must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theValidationSupport, (String)"theValidationSupport must not be null", (Object[])new Object[0]);
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
        long timeoutMillis = 10000L;
        if (System.getProperties().containsKey("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS")) {
            timeoutMillis = Long.parseLong(System.getProperty("TEST_SYSTEM_PROP_VALIDATION_RESOURCE_CACHES_MS"));
        }
        this.myFetchedResourceCache = Caffeine.newBuilder().expireAfterWrite(timeoutMillis, TimeUnit.MILLISECONDS).build();
    }

    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.fetchAllStructureDefinitions(this.myCtx);
    }

    public List<StructureDefinition> getStructures() {
        return this.allStructures();
    }

    public CodeSystem fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return this.myValidationSupport.fetchCodeSystem(this.myCtx, theSystem);
    }

    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException();
    }

    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander getExpander() {
        ValueSetExpanderSimple retVal = new ValueSetExpanderSimple((IWorkerContext)this);
        retVal.setMaxExpansionSize(Integer.MAX_VALUE);
        return retVal;
    }

    public INarrativeGenerator getNarrativeGenerator(String thePrefix, String theBasePath) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(String theType) {
        throw new UnsupportedOperationException();
    }

    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ResourceType next : ResourceType.values()) {
            result.add(next.name());
        }
        Collections.sort(result);
        return result;
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException();
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException();
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException();
    }

    public String oid2Uri(String theCode) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(this.myCtx, theSystem);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(theOptions, next, theVs);
            if (!retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, null);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(theOptions, system, code, display, theVs);
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay) {
        IContextValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(this.myCtx, theSystem, theCode, theDisplay, null);
        if (result == null) {
            return null;
        }
        return new IWorkerContext.ValidationResult((ValidationMessage.IssueSeverity)result.getSeverity(), result.getMessage(), (CodeSystem.ConceptDefinitionComponent)result.asConceptDefinition());
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        if ("http://hl7.org/fhir/ValueSet/languages".equals(theVs.getUrl())) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theSystem);
            definition.setDisplay(theCode);
            return new IWorkerContext.ValidationResult(definition);
        }
        if ("http://hl7.org/fhir/ValueSet/mimetypes".equals(theVs.getUrl())) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theSystem);
            definition.setDisplay(theCode);
            return new IWorkerContext.ValidationResult(definition);
        }
        IContextValidationSupport.CodeValidationResult outcome = StringUtils.isNotBlank((CharSequence)theVs.getUrl()) ? this.myValidationSupport.validateCode(this.myCtx, theSystem, theCode, theDisplay, theVs.getUrl()) : this.myValidationSupport.validateCodeInValueSet(this.myCtx, theSystem, theCode, theDisplay, (IBaseResource)theVs);
        if (outcome != null && outcome.isOk()) {
            CodeSystem.ConceptDefinitionComponent definition = new CodeSystem.ConceptDefinitionComponent();
            definition.setCode(theCode);
            definition.setDisplay(outcome.getDisplay());
            return new IWorkerContext.ValidationResult(definition);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + Constants.codeSystemWithDefaultDescription((String)theSystem) + "]");
    }

    public IWorkerContext.ValidationResult validateCode(ValidationOptions theOptions, String code, ValueSet vs) {
        return this.validateCode(theOptions, null, code, null, vs);
    }

    @CoverageIgnore
    public List<CanonicalResource> allConformanceResources() {
        throw new UnsupportedOperationException();
    }

    public void generateSnapshot(StructureDefinition p) throws FHIRException {
    }

    public void generateSnapshot(StructureDefinition mr, boolean ifLogical) {
    }

    public Parameters getExpansionParameters() {
        return this.myExpansionProfile;
    }

    public void setExpansionProfile(Parameters theExpParameters) {
        this.myExpansionProfile = theExpParameters;
    }

    @CoverageIgnore
    public boolean hasCache() {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet theSource, Parameters theProfile) {
        ValueSetExpander.ValueSetExpansionOutcome vso;
        try {
            vso = this.getExpander().expand(theSource, theProfile);
        }
        catch (InvalidRequestException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InternalErrorException((Throwable)e);
        }
        if (vso.getError() != null) {
            throw new InvalidRequestException(vso.getError());
        }
        return vso;
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk, boolean theHeiarchical) {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent theInc, boolean theHeiarchical) throws TerminologyServiceException {
        return this.myValidationSupport.expandValueSet(this.myCtx, theInc);
    }

    public IWorkerContext.ILoggingService getLogger() {
        throw new UnsupportedOperationException();
    }

    public void setLogger(IWorkerContext.ILoggingService theLogger) {
        throw new UnsupportedOperationException();
    }

    public String getVersion() {
        return this.myCtx.getVersion().getVersion().getFhirVersionString();
    }

    public UcumService getUcumService() {
        throw new UnsupportedOperationException();
    }

    public void setUcumService(UcumService ucumService) {
        throw new UnsupportedOperationException();
    }

    public boolean isNoTerminologyServer() {
        return false;
    }

    public TranslationServices translator() {
        throw new UnsupportedOperationException();
    }

    public List<StructureMap> listTransforms() {
        throw new UnsupportedOperationException();
    }

    public StructureMap getTransform(String url) {
        throw new UnsupportedOperationException();
    }

    public String getOverrideVersionNs() {
        return this.myOverrideVersionNs;
    }

    public void setOverrideVersionNs(String value) {
        this.myOverrideVersionNs = value;
    }

    public StructureDefinition fetchTypeDefinition(String typeName) {
        return this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }

    public List<String> getTypeNames() {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null) {
            return null;
        }
        Resource retVal = (Resource)this.myFetchedResourceCache.get((Object)theUri, t -> (Resource)this.myValidationSupport.fetchResource(this.myCtx, theClass, theUri));
        return (T)retVal;
    }

    public <T extends Resource> T fetchResourceWithException(Class<T> theClass, String theUri) throws FHIRException {
        T retVal = this.fetchResource(theClass, theUri);
        if (retVal == null) {
            throw new FHIRException("Could not find resource: " + theUri);
        }
        return retVal;
    }

    public Resource fetchResourceById(String theType, String theUri) {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException();
    }

    public void cacheResource(Resource theRes) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public Set<String> getResourceNamesAsSet() {
        return this.myCtx.getResourceNames();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ElementDefinition.ElementDefinitionBindingComponent theBinding, boolean theCacheOk, boolean theHeiarchical) throws FHIRException {
        throw new UnsupportedOperationException();
    }

    public String getLinkForUrl(String corePath, String url) {
        throw new UnsupportedOperationException();
    }

    public Map<String, byte[]> getBinaries() {
        return null;
    }
}

