/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.ucum;

import org.hl7.fhir.utilities.ucum.Canonical;
import org.hl7.fhir.utilities.ucum.Component;
import org.hl7.fhir.utilities.ucum.Factor;
import org.hl7.fhir.utilities.ucum.Operator;
import org.hl7.fhir.utilities.ucum.Symbol;
import org.hl7.fhir.utilities.ucum.Term;

public class ExpressionComposer {
    public String compose(Term term) {
        if (term == null) {
            return "1";
        }
        StringBuilder bldr = new StringBuilder();
        this.composeTerm(bldr, term);
        return bldr.toString();
    }

    private void composeTerm(StringBuilder bldr, Term term) {
        if (term.getComp() != null) {
            this.composeComp(bldr, term.getComp());
        }
        if (term.getOp() != null) {
            this.composeOp(bldr, term.getOp());
        }
        if (term.getTerm() != null) {
            this.composeTerm(bldr, term.getTerm());
        }
    }

    private void composeComp(StringBuilder bldr, Component comp) {
        if (comp instanceof Factor) {
            this.composeFactor(bldr, (Factor)comp);
        } else if (comp instanceof Symbol) {
            this.composeSymbol(bldr, (Symbol)comp);
        } else if (comp instanceof Term) {
            bldr.append('(');
            this.composeTerm(bldr, (Term)comp);
            bldr.append(')');
        } else {
            bldr.append('?');
        }
    }

    private void composeSymbol(StringBuilder bldr, Symbol symbol) {
        if (symbol.getPrefix() != null) {
            bldr.append(symbol.getPrefix().getCode());
        }
        bldr.append(symbol.getUnit().getCode());
        if (symbol.getExponent() != 1) {
            bldr.append(symbol.getExponent());
        }
    }

    private void composeFactor(StringBuilder bldr, Factor comp) {
        bldr.append(comp.getValue());
    }

    private void composeOp(StringBuilder bldr, Operator op) {
        if (op == Operator.DIVISION) {
            bldr.append("/");
        } else {
            bldr.append(".");
        }
    }

    public String compose(Canonical can) {
        return this.compose(can, true);
    }

    public String compose(Canonical can, boolean value) {
        StringBuilder b = new StringBuilder();
        if (value) {
            b.append(can.getValue().asDecimal());
        }
        boolean first = true;
        for (Canonical.CanonicalUnit c : can.getUnits()) {
            if (first) {
                first = false;
            } else {
                b.append(".");
            }
            b.append(c.getBase().getCode());
            if (c.getExponent() == 1) continue;
            b.append(c.getExponent());
        }
        return b.toString();
    }
}

