/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu3.validation;

import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu3.context.IWorkerContext;
import org.hl7.fhir.dstu3.model.ElementDefinition;
import org.hl7.fhir.dstu3.model.StructureDefinition;
import org.hl7.fhir.dstu3.utils.FHIRPathEngine;
import org.hl7.fhir.dstu3.validation.BaseValidator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ProfileValidator
extends BaseValidator {
    IWorkerContext context;

    public void setContext(IWorkerContext context) {
        this.context = context;
    }

    @Override
    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean b, String msg) {
        String rn = path.contains(".") ? path.substring(0, path.indexOf(".")) : path;
        return super.rule(errors, type, path, b, msg, "<a href=\"" + rn.toLowerCase() + ".html\">" + rn + "</a>: " + Utilities.escapeXml((String)msg));
    }

    public List<ValidationMessage> validate(StructureDefinition profile, boolean forBuild) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        for (ElementDefinition ec : profile.getDifferential().getElement()) {
            this.checkExtensions(profile, errors, "differential", ec);
        }
        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "missing Snapshot at " + profile.getName() + "." + profile.getName());
        for (ElementDefinition ec : profile.getSnapshot().getElement()) {
            this.checkExtensions(profile, errors, "snapshot", ec);
        }
        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "A snapshot is required")) {
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                this.checkExtensions(profile, errors, "snapshot", ed);
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!forBuild || this.inExemptList(inv.getKey()) || !this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId() + "::" + ed.getPath() + "::" + inv.getKey(), inv.hasExpression(), "The invariant has no FHIR Path expression (" + inv.getXpath() + ")")) continue;
                    try {
                        new FHIRPathEngine(this.context).check(null, profile.getType(), ed.getPath(), inv.getExpression());
                    }
                    catch (Exception exception) {}
                }
            }
        }
        return errors;
    }

    private boolean inExemptList(String key) {
        return key.startsWith("txt-");
    }

    private void checkExtensions(StructureDefinition profile, List<ValidationMessage> errors, String kind, ElementDefinition ec) {
        if (!ec.getType().isEmpty() && "Extension".equals(((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getCode()) && ((ElementDefinition.TypeRefComponent)ec.getType().get(0)).hasProfile()) {
            String url = ((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getProfile();
            StructureDefinition defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), defn != null, "Unable to find Extension '" + url + "' referenced at " + profile.getUrl() + " " + kind + " " + ec.getPath() + " (" + ec.getSliceName() + ")");
        }
    }
}

