/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.formats.IParser;
import org.hl7.fhir.instance.formats.ParserType;
import org.hl7.fhir.instance.hapi.validation.IValidationSupport;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Resource;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.terminologies.ValueSetExpander;
import org.hl7.fhir.instance.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.instance.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.instance.utils.INarrativeGenerator;
import org.hl7.fhir.instance.utils.IResourceValidator;
import org.hl7.fhir.instance.utils.IWorkerContext;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public final class HapiWorkerContext
implements IWorkerContext,
ValueSetExpanderFactory,
ValueSetExpander {
    private final FhirContext myCtx;
    private IValidationSupport myValidationSupport;

    public HapiWorkerContext(FhirContext theCtx, IValidationSupport theValidationSupport) {
        this.myCtx = theCtx;
        this.myValidationSupport = theValidationSupport;
    }

    public List<StructureDefinition> allStructures() {
        return this.myValidationSupport.allStructures();
    }

    public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet theSource) throws ValueSetExpander.ETooCostly, Exception {
        ValueSetExpanderSimple vse = new ValueSetExpanderSimple((IWorkerContext)this, (ValueSetExpanderFactory)this);
        ValueSetExpander.ValueSetExpansionOutcome vso = vse.expand(theSource);
        if (vso.getError() != null) {
            return null;
        }
        return vso;
    }

    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent theInc) {
        return this.myValidationSupport.expandValueSet(this.myCtx, theInc);
    }

    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet theSource, boolean theCacheOk) {
        throw new UnsupportedOperationException();
    }

    public ValueSet fetchCodeSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return this.myValidationSupport.fetchCodeSystem(this.myCtx, theSystem);
    }

    public <T extends Resource> T fetchResource(Class<T> theClass, String theUri) {
        if (this.myValidationSupport == null) {
            return null;
        }
        return (T)((Resource)this.myValidationSupport.fetchResource(this.myCtx, theClass, theUri));
    }

    public List<ConceptMap> findMapsForSource(String theUrl) {
        throw new UnsupportedOperationException();
    }

    public String getAbbreviation(String theName) {
        throw new UnsupportedOperationException();
    }

    public ValueSetExpander getExpander() {
        return this;
    }

    public INarrativeGenerator getNarrativeGenerator(String thePrefix, String theBasePath) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(ParserType theType) {
        throw new UnsupportedOperationException();
    }

    public IParser getParser(String theType) {
        throw new UnsupportedOperationException();
    }

    public List<String> getResourceNames() {
        throw new UnsupportedOperationException();
    }

    public <T extends Resource> boolean hasResource(Class<T> theClass_, String theUri) {
        throw new UnsupportedOperationException();
    }

    public IParser newJsonParser() {
        throw new UnsupportedOperationException();
    }

    public IResourceValidator newValidator() {
        throw new UnsupportedOperationException();
    }

    public IParser newXmlParser() {
        throw new UnsupportedOperationException();
    }

    public boolean supportsSystem(String theSystem) {
        if (this.myValidationSupport == null) {
            return false;
        }
        return this.myValidationSupport.isCodeSystemSupported(this.myCtx, theSystem);
    }

    public IWorkerContext.ValidationResult validateCode(CodeableConcept theCode, ValueSet theVs) {
        for (Coding next : theCode.getCoding()) {
            IWorkerContext.ValidationResult retVal = this.validateCode(next, theVs);
            if (retVal == null || !retVal.isOk()) continue;
            return retVal;
        }
        return new IWorkerContext.ValidationResult(null, null);
    }

    public IWorkerContext.ValidationResult validateCode(Coding theCode, ValueSet theVs) {
        String system = theCode.getSystem();
        String code = theCode.getCode();
        String display = theCode.getDisplay();
        return this.validateCode(system, code, display, theVs);
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = this.myValidationSupport.validateCode(this.myCtx, theSystem, theCode, theDisplay);
        if (result == null) {
            return null;
        }
        return new IWorkerContext.ValidationResult(result.getSeverity(), result.getMessage(), result.asConceptDefinition());
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet.ConceptSetComponent theVsi) {
        throw new UnsupportedOperationException();
    }

    public IWorkerContext.ValidationResult validateCode(String theSystem, String theCode, String theDisplay, ValueSet theVs) {
        if (theSystem == null || StringUtils.equals((CharSequence)theSystem, (CharSequence)theVs.getCodeSystem().getSystem())) {
            for (ValueSet.ConceptDefinitionComponent next : theVs.getCodeSystem().getConcept()) {
                IWorkerContext.ValidationResult retVal = this.validateCodeSystem(theCode, next);
                if (retVal == null || !retVal.isOk()) continue;
                return retVal;
            }
        }
        for (ValueSet.ConceptSetComponent nextComposeConceptSet : theVs.getCompose().getInclude()) {
            IWorkerContext.ValidationResult result;
            String nextSystem = theSystem;
            if (nextSystem == null && StringUtils.isNotBlank((CharSequence)nextComposeConceptSet.getSystem())) {
                nextSystem = nextComposeConceptSet.getSystem();
            }
            if (!StringUtils.equals((CharSequence)nextSystem, (CharSequence)nextComposeConceptSet.getSystem())) continue;
            for (ValueSet.ConceptReferenceComponent nextComposeCode : nextComposeConceptSet.getConcept()) {
                ValueSet.ConceptDefinitionComponent conceptDef = new ValueSet.ConceptDefinitionComponent();
                conceptDef.setCode(nextComposeCode.getCode());
                conceptDef.setDisplay(nextComposeCode.getDisplay());
                IWorkerContext.ValidationResult retVal = this.validateCodeSystem(theCode, conceptDef);
                if (retVal == null || !retVal.isOk()) continue;
                return retVal;
            }
            if (!nextComposeConceptSet.getConcept().isEmpty() || !(result = this.validateCode(nextSystem, theCode, null)).isOk()) continue;
            return result;
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown code[" + theCode + "] in system[" + theSystem + "]");
    }

    private IWorkerContext.ValidationResult validateCodeSystem(String theCode, ValueSet.ConceptDefinitionComponent theConcept) {
        if (StringUtils.equals((CharSequence)theCode, (CharSequence)theConcept.getCode())) {
            return new IWorkerContext.ValidationResult(theConcept);
        }
        for (ValueSet.ConceptDefinitionComponent next : theConcept.getConcept()) {
            IWorkerContext.ValidationResult retVal = this.validateCodeSystem(theCode, next);
            if (retVal == null || !retVal.isOk()) continue;
            return retVal;
        }
        return null;
    }
}

