/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.hapi.validation;

import ca.uhn.fhir.context.FhirContext;
import java.util.List;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public interface IValidationSupport {
    public List<StructureDefinition> allStructures();

    public ValueSet.ValueSetExpansionComponent expandValueSet(FhirContext var1, ValueSet.ConceptSetComponent var2);

    public ValueSet fetchCodeSystem(FhirContext var1, String var2);

    public <T extends IBaseResource> T fetchResource(FhirContext var1, Class<T> var2, String var3);

    public boolean isCodeSystemSupported(FhirContext var1, String var2);

    public CodeValidationResult validateCode(FhirContext var1, String var2, String var3, String var4);

    public static class CodeValidationResult {
        private ValueSet.ConceptDefinitionComponent definition;
        private String message;
        private ValidationMessage.IssueSeverity severity;

        public CodeValidationResult(ValueSet.ConceptDefinitionComponent definition) {
            this.definition = definition;
        }

        public CodeValidationResult(ValidationMessage.IssueSeverity severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        public CodeValidationResult(ValidationMessage.IssueSeverity severity, String message, ValueSet.ConceptDefinitionComponent definition) {
            this.severity = severity;
            this.message = message;
            this.definition = definition;
        }

        public ValueSet.ConceptDefinitionComponent asConceptDefinition() {
            return this.definition;
        }

        public String getDisplay() {
            return this.definition == null ? "??" : this.definition.getDisplay();
        }

        public String getMessage() {
            return this.message;
        }

        public ValidationMessage.IssueSeverity getSeverity() {
            return this.severity;
        }

        public boolean isOk() {
            return this.definition != null;
        }
    }
}

