/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.util.List;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ValidationErrorHandler
implements ErrorHandler {
    private List<ValidationMessage> outputs;
    private String path;

    public ValidationErrorHandler(List<ValidationMessage> outputs, String path) {
        this.outputs = outputs;
        this.path = path;
    }

    @Override
    public void error(SAXParseException arg0) throws SAXException {
        this.outputs.add(new ValidationMessage(ValidationMessage.Source.Schema, ValidationMessage.IssueType.INVALID, arg0.getLineNumber(), arg0.getColumnNumber(), this.path, arg0.getMessage(), ValidationMessage.IssueSeverity.ERROR));
    }

    @Override
    public void fatalError(SAXParseException arg0) throws SAXException {
        this.outputs.add(new ValidationMessage(ValidationMessage.Source.Schema, ValidationMessage.IssueType.INVALID, arg0.getLineNumber(), arg0.getColumnNumber(), this.path, arg0.getMessage(), ValidationMessage.IssueSeverity.FATAL));
    }

    @Override
    public void warning(SAXParseException arg0) throws SAXException {
        this.outputs.add(new ValidationMessage(ValidationMessage.Source.Schema, ValidationMessage.IssueType.INVALID, arg0.getLineNumber(), arg0.getColumnNumber(), this.path, arg0.getMessage(), ValidationMessage.IssueSeverity.WARNING));
    }
}

