/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.instance.validation;

import java.util.Stack;
import org.hl7.fhir.instance.validation.XmlLocationData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.UserDataHandler;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.events.MutationEvent;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;
import org.xml.sax.helpers.XMLFilterImpl;

public class XmlLocationAnnotator
extends XMLFilterImpl {
    private Locator locator;
    private Stack<Locator> locatorStack = new Stack();
    private Stack<Element> elementStack = new Stack();
    private UserDataHandler dataHandler = new LocationDataHandler();

    public XmlLocationAnnotator(XMLReader xmlReader, Document dom) {
        super(xmlReader);
        EventListener modListener = new EventListener(){

            @Override
            public void handleEvent(Event e) {
                EventTarget target = ((MutationEvent)e).getTarget();
                XmlLocationAnnotator.this.elementStack.push((Element)((Object)target));
            }
        };
        ((EventTarget)((Object)dom)).addEventListener("DOMNodeInserted", modListener, true);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
        this.locator = locator;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(uri, localName, qName, atts);
        this.locatorStack.push(new LocatorImpl(this.locator));
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        super.endElement(uri, localName, qName);
        if (this.locatorStack.size() > 0) {
            Locator startLocator = this.locatorStack.pop();
            XmlLocationData location = new XmlLocationData(startLocator.getSystemId(), startLocator.getLineNumber(), startLocator.getColumnNumber(), this.locator.getLineNumber(), this.locator.getColumnNumber());
            Element lastAddedElement = this.elementStack.pop();
            lastAddedElement.setUserData("locationDataKey", location, this.dataHandler);
        }
    }

    private class LocationDataHandler
    implements UserDataHandler {
        private LocationDataHandler() {
        }

        @Override
        public void handle(short operation, String key, Object data, Node src, Node dst) {
            XmlLocationData locatonData;
            if (src != null && dst != null && (locatonData = (XmlLocationData)src.getUserData("locationDataKey")) != null) {
                dst.setUserData("locationDataKey", locatonData, XmlLocationAnnotator.this.dataHandler);
            }
        }
    }
}

