/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2.formats.JsonParser;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.utils.client.FHIRToolingClient;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class BatchLoader {
    public static void main(String[] args) throws IOException, Exception {
        if (args.length < 4) {
            System.out.println("Batch uploader takes 4 parameters in order: server base url, file/folder to upload, xml/json, and batch size");
        } else {
            String server = args[0];
            String file = args[1];
            JsonParser p = new JsonParser();
            int size = Integer.parseInt(args[3]);
            size = 500;
            if (file.endsWith(".xml")) {
                throw new FHIRException("Unimplemented file type " + file);
            }
            if (file.endsWith(".json")) {
                throw new FHIRException("Unimplemented file type " + file);
            }
            if (file.endsWith(".zip")) {
                BatchLoader.LoadZipFile(server, file, p, size, 0, -1);
            } else if (new File(file).isDirectory()) {
                BatchLoader.LoadDirectory(server, file, p, size);
            } else {
                throw new FHIRException("Unknown file type " + file);
            }
        }
    }

    private static void LoadDirectory(String server, String file, IParser p, int size) throws IOException, Exception {
        BatchLoader.LoadZipFile(server, Utilities.path((String[])new String[]{file, "Immunization.json.zip"}), p, size, 0, -1);
    }

    private static void LoadZipFile(String server, String file, IParser p, int size, int start, int end) throws IOException, Exception {
        ZipEntry entry;
        System.out.println("Load Zip file " + file);
        Bundle b = new Bundle();
        b.setType(Bundle.BundleType.COLLECTION);
        b.setId(UUID.randomUUID().toString().toLowerCase());
        ZipInputStream zip = new ZipInputStream(new FileInputStream(file));
        while ((entry = zip.getNextEntry()) != null) {
            try {
                Resource r = p.parse(zip);
                b.addEntry().setResource(r);
            }
            catch (Exception e) {
                throw new Exception("Error parsing " + entry.getName() + ": " + e.getMessage(), e);
            }
        }
        BatchLoader.loadBundle(server, b, size, start, end);
    }

    private static int loadBundle(String server, Bundle b, int size, int start, int end) throws URISyntaxException {
        System.out.println("Post to " + server + ". size = " + Integer.toString(size) + ", start = " + Integer.toString(start) + ", total = " + Integer.toString(b.getEntry().size()));
        FHIRToolingClient client = new FHIRToolingClient(server);
        int c = start;
        if (end == -1) {
            end = b.getEntry().size();
        }
        while (c < end) {
            Bundle bt = new Bundle();
            bt.setType(Bundle.BundleType.BATCH);
            bt.setId(UUID.randomUUID().toString().toLowerCase());
            for (int i = c; i < Math.min(b.getEntry().size(), c + size); ++i) {
                Bundle.BundleEntryComponent be = bt.addEntry();
                be.setResource(b.getEntry().get(i).getResource());
                be.getRequest().setMethod(Bundle.HTTPVerb.PUT);
                be.getRequest().setUrl(be.getResource().getResourceType().toString() + "/" + be.getResource().getId());
            }
            System.out.print("  posting..");
            long ms = System.currentTimeMillis();
            Bundle resp = client.transaction(bt);
            for (int i = 0; i < resp.getEntry().size(); ++i) {
                Bundle.BundleEntryComponent t = resp.getEntry().get(i);
                if (t.getResponse().getStatus().startsWith("2")) continue;
                System.out.println("failed status at " + Integer.toString(i) + ": " + t.getResponse().getStatus());
                return c + i;
            }
            System.out.println("  ..done: " + Integer.toString(c += size) + ". (" + Long.toString(System.currentTimeMillis() - ms) + " ms)");
        }
        System.out.println(" done");
        return c;
    }
}

