/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.Claim;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Coverage;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Money;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.PositiveIntType;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ClaimResponse", profile="http://hl7.org/fhir/Profile/ClaimResponse")
public class ClaimResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Response  number", formalDefinition="The Response business identifier.")
    protected List<Identifier> identifier;
    @Child(name="request", type={Claim.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Id of resource triggering adjudication", formalDefinition="Original request resource referrence.")
    protected Reference request;
    protected Claim requestTarget;
    @Child(name="ruleset", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Resource version", formalDefinition="The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.")
    protected Coding ruleset;
    @Child(name="originalRuleset", type={Coding.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
    protected Coding originalRuleset;
    @Child(name="created", type={DateTimeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Creation date", formalDefinition="The date when the enclosed suite of services were performed or completed.")
    protected DateTimeType created;
    @Child(name="organization", type={Organization.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer", formalDefinition="The Insurer who produced this adjudicated response.")
    protected Reference organization;
    protected Organization organizationTarget;
    @Child(name="requestProvider", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible practitioner", formalDefinition="The practitioner who is responsible for the services rendered to the patient.")
    protected Reference requestProvider;
    protected Practitioner requestProviderTarget;
    @Child(name="requestOrganization", type={Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible organization", formalDefinition="The organization which is responsible for the services rendered to the patient.")
    protected Reference requestOrganization;
    protected Organization requestOrganizationTarget;
    @Child(name="outcome", type={CodeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="complete | error", formalDefinition="Transaction status: error, complete.")
    protected Enumeration<Enumerations.RemittanceOutcome> outcome;
    @Child(name="disposition", type={StringType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Disposition Message", formalDefinition="A description of the status of the adjudication.")
    protected StringType disposition;
    @Child(name="payeeType", type={Coding.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Party to be paid any benefits payable", formalDefinition="Party to be reimbursed: Subscriber, provider, other.")
    protected Coding payeeType;
    @Child(name="item", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Line items", formalDefinition="The first tier service adjudications for submitted services.")
    protected List<ItemsComponent> item;
    @Child(name="addItem", type={}, order=12, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Insurer added line items", formalDefinition="The first tier service adjudications for payor added services.")
    protected List<AddedItemComponent> addItem;
    @Child(name="error", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Processing errors", formalDefinition="Mutually exclusive with Services Provided (Item).")
    protected List<ErrorsComponent> error;
    @Child(name="totalCost", type={Money.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total Cost of service from the Claim", formalDefinition="The total cost of the services reported.")
    protected Money totalCost;
    @Child(name="unallocDeductable", type={Money.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unallocated deductible", formalDefinition="The amount of deductible applied which was not allocated to any particular service line.")
    protected Money unallocDeductable;
    @Child(name="totalBenefit", type={Money.class}, order=16, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Total benefit payable for the Claim", formalDefinition="Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductible).")
    protected Money totalBenefit;
    @Child(name="paymentAdjustment", type={Money.class}, order=17, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment adjustment for non-Claim issues", formalDefinition="Adjustment to the payment of this transaction which is not related to adjudication of this transaction.")
    protected Money paymentAdjustment;
    @Child(name="paymentAdjustmentReason", type={Coding.class}, order=18, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for Payment adjustment", formalDefinition="Reason for the payment adjustment.")
    protected Coding paymentAdjustmentReason;
    @Child(name="paymentDate", type={DateType.class}, order=19, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Expected data of Payment", formalDefinition="Estimated payment data.")
    protected DateType paymentDate;
    @Child(name="paymentAmount", type={Money.class}, order=20, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment amount", formalDefinition="Payable less any payment adjustment.")
    protected Money paymentAmount;
    @Child(name="paymentRef", type={Identifier.class}, order=21, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Payment identifier", formalDefinition="Payment identifier.")
    protected Identifier paymentRef;
    @Child(name="reserved", type={Coding.class}, order=22, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Funds reserved status", formalDefinition="Status of funds reservation (For provider, for Patient, None).")
    protected Coding reserved;
    @Child(name="form", type={Coding.class}, order=23, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Printed Form Identifier", formalDefinition="The form to be used for printing the content.")
    protected Coding form;
    @Child(name="note", type={}, order=24, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Processing notes", formalDefinition="Note text.")
    protected List<NotesComponent> note;
    @Child(name="coverage", type={}, order=25, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Insurance or medical plan", formalDefinition="Financial instrument by which payment information for health care.")
    protected List<CoverageComponent> coverage;
    private static final long serialVersionUID = 2021598689L;
    @SearchParamDefinition(name="identifier", path="ClaimResponse.identifier", description="The identity of the insurer", type="token")
    public static final String SP_IDENTIFIER = "identifier";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ClaimResponse addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Reference getRequest() {
        if (this.request == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.request = new Reference();
            }
        }
        return this.request;
    }

    public boolean hasRequest() {
        return this.request != null && !this.request.isEmpty();
    }

    public ClaimResponse setRequest(Reference value) {
        this.request = value;
        return this;
    }

    public Claim getRequestTarget() {
        if (this.requestTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.request");
            }
            if (Configuration.doAutoCreate()) {
                this.requestTarget = new Claim();
            }
        }
        return this.requestTarget;
    }

    public ClaimResponse setRequestTarget(Claim value) {
        this.requestTarget = value;
        return this;
    }

    public Coding getRuleset() {
        if (this.ruleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.ruleset");
            }
            if (Configuration.doAutoCreate()) {
                this.ruleset = new Coding();
            }
        }
        return this.ruleset;
    }

    public boolean hasRuleset() {
        return this.ruleset != null && !this.ruleset.isEmpty();
    }

    public ClaimResponse setRuleset(Coding value) {
        this.ruleset = value;
        return this;
    }

    public Coding getOriginalRuleset() {
        if (this.originalRuleset == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.originalRuleset");
            }
            if (Configuration.doAutoCreate()) {
                this.originalRuleset = new Coding();
            }
        }
        return this.originalRuleset;
    }

    public boolean hasOriginalRuleset() {
        return this.originalRuleset != null && !this.originalRuleset.isEmpty();
    }

    public ClaimResponse setOriginalRuleset(Coding value) {
        this.originalRuleset = value;
        return this;
    }

    public DateTimeType getCreatedElement() {
        if (this.created == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.created");
            }
            if (Configuration.doAutoCreate()) {
                this.created = new DateTimeType();
            }
        }
        return this.created;
    }

    public boolean hasCreatedElement() {
        return this.created != null && !this.created.isEmpty();
    }

    public boolean hasCreated() {
        return this.created != null && !this.created.isEmpty();
    }

    public ClaimResponse setCreatedElement(DateTimeType value) {
        this.created = value;
        return this;
    }

    public Date getCreated() {
        return this.created == null ? null : (Date)this.created.getValue();
    }

    public ClaimResponse setCreated(Date value) {
        if (value == null) {
            this.created = null;
        } else {
            if (this.created == null) {
                this.created = new DateTimeType();
            }
            this.created.setValue(value);
        }
        return this;
    }

    public Reference getOrganization() {
        if (this.organization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organization = new Reference();
            }
        }
        return this.organization;
    }

    public boolean hasOrganization() {
        return this.organization != null && !this.organization.isEmpty();
    }

    public ClaimResponse setOrganization(Reference value) {
        this.organization = value;
        return this;
    }

    public Organization getOrganizationTarget() {
        if (this.organizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.organization");
            }
            if (Configuration.doAutoCreate()) {
                this.organizationTarget = new Organization();
            }
        }
        return this.organizationTarget;
    }

    public ClaimResponse setOrganizationTarget(Organization value) {
        this.organizationTarget = value;
        return this;
    }

    public Reference getRequestProvider() {
        if (this.requestProvider == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProvider = new Reference();
            }
        }
        return this.requestProvider;
    }

    public boolean hasRequestProvider() {
        return this.requestProvider != null && !this.requestProvider.isEmpty();
    }

    public ClaimResponse setRequestProvider(Reference value) {
        this.requestProvider = value;
        return this;
    }

    public Practitioner getRequestProviderTarget() {
        if (this.requestProviderTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestProvider");
            }
            if (Configuration.doAutoCreate()) {
                this.requestProviderTarget = new Practitioner();
            }
        }
        return this.requestProviderTarget;
    }

    public ClaimResponse setRequestProviderTarget(Practitioner value) {
        this.requestProviderTarget = value;
        return this;
    }

    public Reference getRequestOrganization() {
        if (this.requestOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganization = new Reference();
            }
        }
        return this.requestOrganization;
    }

    public boolean hasRequestOrganization() {
        return this.requestOrganization != null && !this.requestOrganization.isEmpty();
    }

    public ClaimResponse setRequestOrganization(Reference value) {
        this.requestOrganization = value;
        return this;
    }

    public Organization getRequestOrganizationTarget() {
        if (this.requestOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.requestOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.requestOrganizationTarget = new Organization();
            }
        }
        return this.requestOrganizationTarget;
    }

    public ClaimResponse setRequestOrganizationTarget(Organization value) {
        this.requestOrganizationTarget = value;
        return this;
    }

    public Enumeration<Enumerations.RemittanceOutcome> getOutcomeElement() {
        if (this.outcome == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.outcome");
            }
            if (Configuration.doAutoCreate()) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
        }
        return this.outcome;
    }

    public boolean hasOutcomeElement() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public boolean hasOutcome() {
        return this.outcome != null && !this.outcome.isEmpty();
    }

    public ClaimResponse setOutcomeElement(Enumeration<Enumerations.RemittanceOutcome> value) {
        this.outcome = value;
        return this;
    }

    public Enumerations.RemittanceOutcome getOutcome() {
        return this.outcome == null ? null : (Enumerations.RemittanceOutcome)((Object)this.outcome.getValue());
    }

    public ClaimResponse setOutcome(Enumerations.RemittanceOutcome value) {
        if (value == null) {
            this.outcome = null;
        } else {
            if (this.outcome == null) {
                this.outcome = new Enumeration<Enumerations.RemittanceOutcome>(new Enumerations.RemittanceOutcomeEnumFactory());
            }
            this.outcome.setValue((Object)value);
        }
        return this;
    }

    public StringType getDispositionElement() {
        if (this.disposition == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.disposition");
            }
            if (Configuration.doAutoCreate()) {
                this.disposition = new StringType();
            }
        }
        return this.disposition;
    }

    public boolean hasDispositionElement() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public boolean hasDisposition() {
        return this.disposition != null && !this.disposition.isEmpty();
    }

    public ClaimResponse setDispositionElement(StringType value) {
        this.disposition = value;
        return this;
    }

    public String getDisposition() {
        return this.disposition == null ? null : (String)this.disposition.getValue();
    }

    public ClaimResponse setDisposition(String value) {
        if (Utilities.noString((String)value)) {
            this.disposition = null;
        } else {
            if (this.disposition == null) {
                this.disposition = new StringType();
            }
            this.disposition.setValue(value);
        }
        return this;
    }

    public Coding getPayeeType() {
        if (this.payeeType == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.payeeType");
            }
            if (Configuration.doAutoCreate()) {
                this.payeeType = new Coding();
            }
        }
        return this.payeeType;
    }

    public boolean hasPayeeType() {
        return this.payeeType != null && !this.payeeType.isEmpty();
    }

    public ClaimResponse setPayeeType(Coding value) {
        this.payeeType = value;
        return this;
    }

    public List<ItemsComponent> getItem() {
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        return this.item;
    }

    public boolean hasItem() {
        if (this.item == null) {
            return false;
        }
        for (ItemsComponent item : this.item) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ItemsComponent addItem() {
        ItemsComponent t = new ItemsComponent();
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return t;
    }

    public ClaimResponse addItem(ItemsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.item == null) {
            this.item = new ArrayList<ItemsComponent>();
        }
        this.item.add(t);
        return this;
    }

    public List<AddedItemComponent> getAddItem() {
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        return this.addItem;
    }

    public boolean hasAddItem() {
        if (this.addItem == null) {
            return false;
        }
        for (AddedItemComponent item : this.addItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public AddedItemComponent addAddItem() {
        AddedItemComponent t = new AddedItemComponent();
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return t;
    }

    public ClaimResponse addAddItem(AddedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.addItem == null) {
            this.addItem = new ArrayList<AddedItemComponent>();
        }
        this.addItem.add(t);
        return this;
    }

    public List<ErrorsComponent> getError() {
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        return this.error;
    }

    public boolean hasError() {
        if (this.error == null) {
            return false;
        }
        for (ErrorsComponent item : this.error) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ErrorsComponent addError() {
        ErrorsComponent t = new ErrorsComponent();
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return t;
    }

    public ClaimResponse addError(ErrorsComponent t) {
        if (t == null) {
            return this;
        }
        if (this.error == null) {
            this.error = new ArrayList<ErrorsComponent>();
        }
        this.error.add(t);
        return this;
    }

    public Money getTotalCost() {
        if (this.totalCost == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.totalCost");
            }
            if (Configuration.doAutoCreate()) {
                this.totalCost = new Money();
            }
        }
        return this.totalCost;
    }

    public boolean hasTotalCost() {
        return this.totalCost != null && !this.totalCost.isEmpty();
    }

    public ClaimResponse setTotalCost(Money value) {
        this.totalCost = value;
        return this;
    }

    public Money getUnallocDeductable() {
        if (this.unallocDeductable == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.unallocDeductable");
            }
            if (Configuration.doAutoCreate()) {
                this.unallocDeductable = new Money();
            }
        }
        return this.unallocDeductable;
    }

    public boolean hasUnallocDeductable() {
        return this.unallocDeductable != null && !this.unallocDeductable.isEmpty();
    }

    public ClaimResponse setUnallocDeductable(Money value) {
        this.unallocDeductable = value;
        return this;
    }

    public Money getTotalBenefit() {
        if (this.totalBenefit == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.totalBenefit");
            }
            if (Configuration.doAutoCreate()) {
                this.totalBenefit = new Money();
            }
        }
        return this.totalBenefit;
    }

    public boolean hasTotalBenefit() {
        return this.totalBenefit != null && !this.totalBenefit.isEmpty();
    }

    public ClaimResponse setTotalBenefit(Money value) {
        this.totalBenefit = value;
        return this;
    }

    public Money getPaymentAdjustment() {
        if (this.paymentAdjustment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.paymentAdjustment");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentAdjustment = new Money();
            }
        }
        return this.paymentAdjustment;
    }

    public boolean hasPaymentAdjustment() {
        return this.paymentAdjustment != null && !this.paymentAdjustment.isEmpty();
    }

    public ClaimResponse setPaymentAdjustment(Money value) {
        this.paymentAdjustment = value;
        return this;
    }

    public Coding getPaymentAdjustmentReason() {
        if (this.paymentAdjustmentReason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.paymentAdjustmentReason");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentAdjustmentReason = new Coding();
            }
        }
        return this.paymentAdjustmentReason;
    }

    public boolean hasPaymentAdjustmentReason() {
        return this.paymentAdjustmentReason != null && !this.paymentAdjustmentReason.isEmpty();
    }

    public ClaimResponse setPaymentAdjustmentReason(Coding value) {
        this.paymentAdjustmentReason = value;
        return this;
    }

    public DateType getPaymentDateElement() {
        if (this.paymentDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.paymentDate");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentDate = new DateType();
            }
        }
        return this.paymentDate;
    }

    public boolean hasPaymentDateElement() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public boolean hasPaymentDate() {
        return this.paymentDate != null && !this.paymentDate.isEmpty();
    }

    public ClaimResponse setPaymentDateElement(DateType value) {
        this.paymentDate = value;
        return this;
    }

    public Date getPaymentDate() {
        return this.paymentDate == null ? null : (Date)this.paymentDate.getValue();
    }

    public ClaimResponse setPaymentDate(Date value) {
        if (value == null) {
            this.paymentDate = null;
        } else {
            if (this.paymentDate == null) {
                this.paymentDate = new DateType();
            }
            this.paymentDate.setValue(value);
        }
        return this;
    }

    public Money getPaymentAmount() {
        if (this.paymentAmount == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.paymentAmount");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentAmount = new Money();
            }
        }
        return this.paymentAmount;
    }

    public boolean hasPaymentAmount() {
        return this.paymentAmount != null && !this.paymentAmount.isEmpty();
    }

    public ClaimResponse setPaymentAmount(Money value) {
        this.paymentAmount = value;
        return this;
    }

    public Identifier getPaymentRef() {
        if (this.paymentRef == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.paymentRef");
            }
            if (Configuration.doAutoCreate()) {
                this.paymentRef = new Identifier();
            }
        }
        return this.paymentRef;
    }

    public boolean hasPaymentRef() {
        return this.paymentRef != null && !this.paymentRef.isEmpty();
    }

    public ClaimResponse setPaymentRef(Identifier value) {
        this.paymentRef = value;
        return this;
    }

    public Coding getReserved() {
        if (this.reserved == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.reserved");
            }
            if (Configuration.doAutoCreate()) {
                this.reserved = new Coding();
            }
        }
        return this.reserved;
    }

    public boolean hasReserved() {
        return this.reserved != null && !this.reserved.isEmpty();
    }

    public ClaimResponse setReserved(Coding value) {
        this.reserved = value;
        return this;
    }

    public Coding getForm() {
        if (this.form == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ClaimResponse.form");
            }
            if (Configuration.doAutoCreate()) {
                this.form = new Coding();
            }
        }
        return this.form;
    }

    public boolean hasForm() {
        return this.form != null && !this.form.isEmpty();
    }

    public ClaimResponse setForm(Coding value) {
        this.form = value;
        return this;
    }

    public List<NotesComponent> getNote() {
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        return this.note;
    }

    public boolean hasNote() {
        if (this.note == null) {
            return false;
        }
        for (NotesComponent item : this.note) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public NotesComponent addNote() {
        NotesComponent t = new NotesComponent();
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return t;
    }

    public ClaimResponse addNote(NotesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.note == null) {
            this.note = new ArrayList<NotesComponent>();
        }
        this.note.add(t);
        return this;
    }

    public List<CoverageComponent> getCoverage() {
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        return this.coverage;
    }

    public boolean hasCoverage() {
        if (this.coverage == null) {
            return false;
        }
        for (CoverageComponent item : this.coverage) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CoverageComponent addCoverage() {
        CoverageComponent t = new CoverageComponent();
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return t;
    }

    public ClaimResponse addCoverage(CoverageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.coverage == null) {
            this.coverage = new ArrayList<CoverageComponent>();
        }
        this.coverage.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The Response business identifier.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("request", "Reference(Claim)", "Original request resource referrence.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property("ruleset", "Coding", "The version of the style of resource contents. This should be mapped to the allowable profiles for this and supporting resources.", 0, Integer.MAX_VALUE, this.ruleset));
        childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        childrenList.add(new Property("created", "dateTime", "The date when the enclosed suite of services were performed or completed.", 0, Integer.MAX_VALUE, this.created));
        childrenList.add(new Property("organization", "Reference(Organization)", "The Insurer who produced this adjudicated response.", 0, Integer.MAX_VALUE, this.organization));
        childrenList.add(new Property("requestProvider", "Reference(Practitioner)", "The practitioner who is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestProvider));
        childrenList.add(new Property("requestOrganization", "Reference(Organization)", "The organization which is responsible for the services rendered to the patient.", 0, Integer.MAX_VALUE, this.requestOrganization));
        childrenList.add(new Property("outcome", "code", "Transaction status: error, complete.", 0, Integer.MAX_VALUE, this.outcome));
        childrenList.add(new Property("disposition", "string", "A description of the status of the adjudication.", 0, Integer.MAX_VALUE, this.disposition));
        childrenList.add(new Property("payeeType", "Coding", "Party to be reimbursed: Subscriber, provider, other.", 0, Integer.MAX_VALUE, this.payeeType));
        childrenList.add(new Property("item", "", "The first tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.item));
        childrenList.add(new Property("addItem", "", "The first tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.addItem));
        childrenList.add(new Property("error", "", "Mutually exclusive with Services Provided (Item).", 0, Integer.MAX_VALUE, this.error));
        childrenList.add(new Property("totalCost", "Money", "The total cost of the services reported.", 0, Integer.MAX_VALUE, this.totalCost));
        childrenList.add(new Property("unallocDeductable", "Money", "The amount of deductible applied which was not allocated to any particular service line.", 0, Integer.MAX_VALUE, this.unallocDeductable));
        childrenList.add(new Property("totalBenefit", "Money", "Total amount of benefit payable (Equal to sum of the Benefit amounts from all detail lines and additions less the Unallocated Deductible).", 0, Integer.MAX_VALUE, this.totalBenefit));
        childrenList.add(new Property("paymentAdjustment", "Money", "Adjustment to the payment of this transaction which is not related to adjudication of this transaction.", 0, Integer.MAX_VALUE, this.paymentAdjustment));
        childrenList.add(new Property("paymentAdjustmentReason", "Coding", "Reason for the payment adjustment.", 0, Integer.MAX_VALUE, this.paymentAdjustmentReason));
        childrenList.add(new Property("paymentDate", "date", "Estimated payment data.", 0, Integer.MAX_VALUE, this.paymentDate));
        childrenList.add(new Property("paymentAmount", "Money", "Payable less any payment adjustment.", 0, Integer.MAX_VALUE, this.paymentAmount));
        childrenList.add(new Property("paymentRef", "Identifier", "Payment identifier.", 0, Integer.MAX_VALUE, this.paymentRef));
        childrenList.add(new Property("reserved", "Coding", "Status of funds reservation (For provider, for Patient, None).", 0, Integer.MAX_VALUE, this.reserved));
        childrenList.add(new Property("form", "Coding", "The form to be used for printing the content.", 0, Integer.MAX_VALUE, this.form));
        childrenList.add(new Property("note", "", "Note text.", 0, Integer.MAX_VALUE, this.note));
        childrenList.add(new Property("coverage", "", "Financial instrument by which payment information for health care.", 0, Integer.MAX_VALUE, this.coverage));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("request")) {
            this.request = this.castToReference(value);
        } else if (name.equals("ruleset")) {
            this.ruleset = this.castToCoding(value);
        } else if (name.equals("originalRuleset")) {
            this.originalRuleset = this.castToCoding(value);
        } else if (name.equals("created")) {
            this.created = this.castToDateTime(value);
        } else if (name.equals("organization")) {
            this.organization = this.castToReference(value);
        } else if (name.equals("requestProvider")) {
            this.requestProvider = this.castToReference(value);
        } else if (name.equals("requestOrganization")) {
            this.requestOrganization = this.castToReference(value);
        } else if (name.equals("outcome")) {
            this.outcome = new Enumerations.RemittanceOutcomeEnumFactory().fromType(value);
        } else if (name.equals("disposition")) {
            this.disposition = this.castToString(value);
        } else if (name.equals("payeeType")) {
            this.payeeType = this.castToCoding(value);
        } else if (name.equals("item")) {
            this.getItem().add((ItemsComponent)value);
        } else if (name.equals("addItem")) {
            this.getAddItem().add((AddedItemComponent)value);
        } else if (name.equals("error")) {
            this.getError().add((ErrorsComponent)value);
        } else if (name.equals("totalCost")) {
            this.totalCost = this.castToMoney(value);
        } else if (name.equals("unallocDeductable")) {
            this.unallocDeductable = this.castToMoney(value);
        } else if (name.equals("totalBenefit")) {
            this.totalBenefit = this.castToMoney(value);
        } else if (name.equals("paymentAdjustment")) {
            this.paymentAdjustment = this.castToMoney(value);
        } else if (name.equals("paymentAdjustmentReason")) {
            this.paymentAdjustmentReason = this.castToCoding(value);
        } else if (name.equals("paymentDate")) {
            this.paymentDate = this.castToDate(value);
        } else if (name.equals("paymentAmount")) {
            this.paymentAmount = this.castToMoney(value);
        } else if (name.equals("paymentRef")) {
            this.paymentRef = this.castToIdentifier(value);
        } else if (name.equals("reserved")) {
            this.reserved = this.castToCoding(value);
        } else if (name.equals("form")) {
            this.form = this.castToCoding(value);
        } else if (name.equals("note")) {
            this.getNote().add((NotesComponent)value);
        } else if (name.equals("coverage")) {
            this.getCoverage().add((CoverageComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("request")) {
            this.request = new Reference();
            return this.request;
        }
        if (name.equals("ruleset")) {
            this.ruleset = new Coding();
            return this.ruleset;
        }
        if (name.equals("originalRuleset")) {
            this.originalRuleset = new Coding();
            return this.originalRuleset;
        }
        if (name.equals("created")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.created");
        }
        if (name.equals("organization")) {
            this.organization = new Reference();
            return this.organization;
        }
        if (name.equals("requestProvider")) {
            this.requestProvider = new Reference();
            return this.requestProvider;
        }
        if (name.equals("requestOrganization")) {
            this.requestOrganization = new Reference();
            return this.requestOrganization;
        }
        if (name.equals("outcome")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.outcome");
        }
        if (name.equals("disposition")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.disposition");
        }
        if (name.equals("payeeType")) {
            this.payeeType = new Coding();
            return this.payeeType;
        }
        if (name.equals("item")) {
            return this.addItem();
        }
        if (name.equals("addItem")) {
            return this.addAddItem();
        }
        if (name.equals("error")) {
            return this.addError();
        }
        if (name.equals("totalCost")) {
            this.totalCost = new Money();
            return this.totalCost;
        }
        if (name.equals("unallocDeductable")) {
            this.unallocDeductable = new Money();
            return this.unallocDeductable;
        }
        if (name.equals("totalBenefit")) {
            this.totalBenefit = new Money();
            return this.totalBenefit;
        }
        if (name.equals("paymentAdjustment")) {
            this.paymentAdjustment = new Money();
            return this.paymentAdjustment;
        }
        if (name.equals("paymentAdjustmentReason")) {
            this.paymentAdjustmentReason = new Coding();
            return this.paymentAdjustmentReason;
        }
        if (name.equals("paymentDate")) {
            throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.paymentDate");
        }
        if (name.equals("paymentAmount")) {
            this.paymentAmount = new Money();
            return this.paymentAmount;
        }
        if (name.equals("paymentRef")) {
            this.paymentRef = new Identifier();
            return this.paymentRef;
        }
        if (name.equals("reserved")) {
            this.reserved = new Coding();
            return this.reserved;
        }
        if (name.equals("form")) {
            this.form = new Coding();
            return this.form;
        }
        if (name.equals("note")) {
            return this.addNote();
        }
        if (name.equals("coverage")) {
            return this.addCoverage();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ClaimResponse";
    }

    @Override
    public ClaimResponse copy() {
        ClaimResponse dst = new ClaimResponse();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.request = this.request == null ? null : this.request.copy();
        dst.ruleset = this.ruleset == null ? null : this.ruleset.copy();
        dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
        dst.created = this.created == null ? null : this.created.copy();
        dst.organization = this.organization == null ? null : this.organization.copy();
        dst.requestProvider = this.requestProvider == null ? null : this.requestProvider.copy();
        dst.requestOrganization = this.requestOrganization == null ? null : this.requestOrganization.copy();
        dst.outcome = this.outcome == null ? null : this.outcome.copy();
        dst.disposition = this.disposition == null ? null : this.disposition.copy();
        Coding coding = dst.payeeType = this.payeeType == null ? null : this.payeeType.copy();
        if (this.item != null) {
            dst.item = new ArrayList<ItemsComponent>();
            for (ItemsComponent itemsComponent : this.item) {
                dst.item.add(itemsComponent.copy());
            }
        }
        if (this.addItem != null) {
            dst.addItem = new ArrayList<AddedItemComponent>();
            for (AddedItemComponent addedItemComponent : this.addItem) {
                dst.addItem.add(addedItemComponent.copy());
            }
        }
        if (this.error != null) {
            dst.error = new ArrayList<ErrorsComponent>();
            for (ErrorsComponent errorsComponent : this.error) {
                dst.error.add(errorsComponent.copy());
            }
        }
        dst.totalCost = this.totalCost == null ? null : this.totalCost.copy();
        dst.unallocDeductable = this.unallocDeductable == null ? null : this.unallocDeductable.copy();
        dst.totalBenefit = this.totalBenefit == null ? null : this.totalBenefit.copy();
        dst.paymentAdjustment = this.paymentAdjustment == null ? null : this.paymentAdjustment.copy();
        dst.paymentAdjustmentReason = this.paymentAdjustmentReason == null ? null : this.paymentAdjustmentReason.copy();
        dst.paymentDate = this.paymentDate == null ? null : this.paymentDate.copy();
        dst.paymentAmount = this.paymentAmount == null ? null : this.paymentAmount.copy();
        dst.paymentRef = this.paymentRef == null ? null : this.paymentRef.copy();
        dst.reserved = this.reserved == null ? null : this.reserved.copy();
        Coding coding2 = dst.form = this.form == null ? null : this.form.copy();
        if (this.note != null) {
            dst.note = new ArrayList<NotesComponent>();
            for (NotesComponent notesComponent : this.note) {
                dst.note.add(notesComponent.copy());
            }
        }
        if (this.coverage != null) {
            dst.coverage = new ArrayList<CoverageComponent>();
            for (CoverageComponent coverageComponent : this.coverage) {
                dst.coverage.add(coverageComponent.copy());
            }
        }
        return dst;
    }

    protected ClaimResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other;
        return ClaimResponse.compareDeep(this.identifier, o.identifier, true) && ClaimResponse.compareDeep(this.request, o.request, true) && ClaimResponse.compareDeep(this.ruleset, o.ruleset, true) && ClaimResponse.compareDeep(this.originalRuleset, o.originalRuleset, true) && ClaimResponse.compareDeep(this.created, o.created, true) && ClaimResponse.compareDeep(this.organization, o.organization, true) && ClaimResponse.compareDeep(this.requestProvider, o.requestProvider, true) && ClaimResponse.compareDeep(this.requestOrganization, o.requestOrganization, true) && ClaimResponse.compareDeep(this.outcome, o.outcome, true) && ClaimResponse.compareDeep(this.disposition, o.disposition, true) && ClaimResponse.compareDeep(this.payeeType, o.payeeType, true) && ClaimResponse.compareDeep(this.item, o.item, true) && ClaimResponse.compareDeep(this.addItem, o.addItem, true) && ClaimResponse.compareDeep(this.error, o.error, true) && ClaimResponse.compareDeep(this.totalCost, o.totalCost, true) && ClaimResponse.compareDeep(this.unallocDeductable, o.unallocDeductable, true) && ClaimResponse.compareDeep(this.totalBenefit, o.totalBenefit, true) && ClaimResponse.compareDeep(this.paymentAdjustment, o.paymentAdjustment, true) && ClaimResponse.compareDeep(this.paymentAdjustmentReason, o.paymentAdjustmentReason, true) && ClaimResponse.compareDeep(this.paymentDate, o.paymentDate, true) && ClaimResponse.compareDeep(this.paymentAmount, o.paymentAmount, true) && ClaimResponse.compareDeep(this.paymentRef, o.paymentRef, true) && ClaimResponse.compareDeep(this.reserved, o.reserved, true) && ClaimResponse.compareDeep(this.form, o.form, true) && ClaimResponse.compareDeep(this.note, o.note, true) && ClaimResponse.compareDeep(this.coverage, o.coverage, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ClaimResponse)) {
            return false;
        }
        ClaimResponse o = (ClaimResponse)other;
        return ClaimResponse.compareValues(this.created, o.created, true) && ClaimResponse.compareValues(this.outcome, o.outcome, true) && ClaimResponse.compareValues(this.disposition, o.disposition, true) && ClaimResponse.compareValues(this.paymentDate, o.paymentDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.request != null && !this.request.isEmpty() || this.ruleset != null && !this.ruleset.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty() || this.created != null && !this.created.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.requestProvider != null && !this.requestProvider.isEmpty() || this.requestOrganization != null && !this.requestOrganization.isEmpty() || this.outcome != null && !this.outcome.isEmpty() || this.disposition != null && !this.disposition.isEmpty() || this.payeeType != null && !this.payeeType.isEmpty() || this.item != null && !this.item.isEmpty() || this.addItem != null && !this.addItem.isEmpty() || this.error != null && !this.error.isEmpty() || this.totalCost != null && !this.totalCost.isEmpty() || this.unallocDeductable != null && !this.unallocDeductable.isEmpty() || this.totalBenefit != null && !this.totalBenefit.isEmpty() || this.paymentAdjustment != null && !this.paymentAdjustment.isEmpty() || this.paymentAdjustmentReason != null && !this.paymentAdjustmentReason.isEmpty() || this.paymentDate != null && !this.paymentDate.isEmpty() || this.paymentAmount != null && !this.paymentAmount.isEmpty() || this.paymentRef != null && !this.paymentRef.isEmpty() || this.reserved != null && !this.reserved.isEmpty() || this.form != null && !this.form.isEmpty() || this.note != null && !this.note.isEmpty() || this.coverage != null && !this.coverage.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ClaimResponse;
    }

    @Block
    public static class CoverageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequence", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance identifier", formalDefinition="A service line item.")
        protected PositiveIntType sequence;
        @Child(name="focal", type={BooleanType.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Is the focal Coverage", formalDefinition="The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.")
        protected BooleanType focal;
        @Child(name="coverage", type={Coverage.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Insurance information", formalDefinition="Reference to the program or plan identification, underwriter or payor.")
        protected Reference coverage;
        protected Coverage coverageTarget;
        @Child(name="businessArrangement", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Business agreement", formalDefinition="The contract number of a business agreement which describes the terms and conditions.")
        protected StringType businessArrangement;
        @Child(name="relationship", type={Coding.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Patient relationship to subscriber", formalDefinition="The relationship of the patient to the subscriber.")
        protected Coding relationship;
        @Child(name="preAuthRef", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Pre-Authorization/Determination Reference", formalDefinition="A list of references from the Insurer to which these services pertain.")
        protected List<StringType> preAuthRef;
        @Child(name="claimResponse", type={ClaimResponse.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication results", formalDefinition="The Coverages adjudication details.")
        protected Reference claimResponse;
        protected ClaimResponse claimResponseTarget;
        @Child(name="originalRuleset", type={Coding.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Original version", formalDefinition="The style (standard) and version of the original material which was converted into this resource.")
        protected Coding originalRuleset;
        private static final long serialVersionUID = 621250924L;

        public CoverageComponent() {
        }

        public CoverageComponent(PositiveIntType sequence, BooleanType focal, Reference coverage, Coding relationship) {
            this.sequence = sequence;
            this.focal = focal;
            this.coverage = coverage;
            this.relationship = relationship;
        }

        public PositiveIntType getSequenceElement() {
            if (this.sequence == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.sequence");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequence = new PositiveIntType();
                }
            }
            return this.sequence;
        }

        public boolean hasSequenceElement() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public boolean hasSequence() {
            return this.sequence != null && !this.sequence.isEmpty();
        }

        public CoverageComponent setSequenceElement(PositiveIntType value) {
            this.sequence = value;
            return this;
        }

        public int getSequence() {
            return this.sequence == null || this.sequence.isEmpty() ? 0 : (Integer)this.sequence.getValue();
        }

        public CoverageComponent setSequence(int value) {
            if (this.sequence == null) {
                this.sequence = new PositiveIntType();
            }
            this.sequence.setValue((Object)value);
            return this;
        }

        public BooleanType getFocalElement() {
            if (this.focal == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.focal");
                }
                if (Configuration.doAutoCreate()) {
                    this.focal = new BooleanType();
                }
            }
            return this.focal;
        }

        public boolean hasFocalElement() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public boolean hasFocal() {
            return this.focal != null && !this.focal.isEmpty();
        }

        public CoverageComponent setFocalElement(BooleanType value) {
            this.focal = value;
            return this;
        }

        public boolean getFocal() {
            return this.focal == null || this.focal.isEmpty() ? false : (Boolean)this.focal.getValue();
        }

        public CoverageComponent setFocal(boolean value) {
            if (this.focal == null) {
                this.focal = new BooleanType();
            }
            this.focal.setValue((Object)value);
            return this;
        }

        public Reference getCoverage() {
            if (this.coverage == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverage = new Reference();
                }
            }
            return this.coverage;
        }

        public boolean hasCoverage() {
            return this.coverage != null && !this.coverage.isEmpty();
        }

        public CoverageComponent setCoverage(Reference value) {
            this.coverage = value;
            return this;
        }

        public Coverage getCoverageTarget() {
            if (this.coverageTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.coverage");
                }
                if (Configuration.doAutoCreate()) {
                    this.coverageTarget = new Coverage();
                }
            }
            return this.coverageTarget;
        }

        public CoverageComponent setCoverageTarget(Coverage value) {
            this.coverageTarget = value;
            return this;
        }

        public StringType getBusinessArrangementElement() {
            if (this.businessArrangement == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.businessArrangement");
                }
                if (Configuration.doAutoCreate()) {
                    this.businessArrangement = new StringType();
                }
            }
            return this.businessArrangement;
        }

        public boolean hasBusinessArrangementElement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public boolean hasBusinessArrangement() {
            return this.businessArrangement != null && !this.businessArrangement.isEmpty();
        }

        public CoverageComponent setBusinessArrangementElement(StringType value) {
            this.businessArrangement = value;
            return this;
        }

        public String getBusinessArrangement() {
            return this.businessArrangement == null ? null : (String)this.businessArrangement.getValue();
        }

        public CoverageComponent setBusinessArrangement(String value) {
            if (Utilities.noString((String)value)) {
                this.businessArrangement = null;
            } else {
                if (this.businessArrangement == null) {
                    this.businessArrangement = new StringType();
                }
                this.businessArrangement.setValue(value);
            }
            return this;
        }

        public Coding getRelationship() {
            if (this.relationship == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.relationship");
                }
                if (Configuration.doAutoCreate()) {
                    this.relationship = new Coding();
                }
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            return this.relationship != null && !this.relationship.isEmpty();
        }

        public CoverageComponent setRelationship(Coding value) {
            this.relationship = value;
            return this;
        }

        public List<StringType> getPreAuthRef() {
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            return this.preAuthRef;
        }

        public boolean hasPreAuthRef() {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType item : this.preAuthRef) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public StringType addPreAuthRefElement() {
            StringType t = new StringType();
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return t;
        }

        public CoverageComponent addPreAuthRef(String value) {
            StringType t = new StringType();
            t.setValue(value);
            if (this.preAuthRef == null) {
                this.preAuthRef = new ArrayList<StringType>();
            }
            this.preAuthRef.add(t);
            return this;
        }

        public boolean hasPreAuthRef(String value) {
            if (this.preAuthRef == null) {
                return false;
            }
            for (StringType v : this.preAuthRef) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Reference getClaimResponse() {
            if (this.claimResponse == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponse = new Reference();
                }
            }
            return this.claimResponse;
        }

        public boolean hasClaimResponse() {
            return this.claimResponse != null && !this.claimResponse.isEmpty();
        }

        public CoverageComponent setClaimResponse(Reference value) {
            this.claimResponse = value;
            return this;
        }

        public ClaimResponse getClaimResponseTarget() {
            if (this.claimResponseTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.claimResponse");
                }
                if (Configuration.doAutoCreate()) {
                    this.claimResponseTarget = new ClaimResponse();
                }
            }
            return this.claimResponseTarget;
        }

        public CoverageComponent setClaimResponseTarget(ClaimResponse value) {
            this.claimResponseTarget = value;
            return this;
        }

        public Coding getOriginalRuleset() {
            if (this.originalRuleset == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create CoverageComponent.originalRuleset");
                }
                if (Configuration.doAutoCreate()) {
                    this.originalRuleset = new Coding();
                }
            }
            return this.originalRuleset;
        }

        public boolean hasOriginalRuleset() {
            return this.originalRuleset != null && !this.originalRuleset.isEmpty();
        }

        public CoverageComponent setOriginalRuleset(Coding value) {
            this.originalRuleset = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequence", "positiveInt", "A service line item.", 0, Integer.MAX_VALUE, this.sequence));
            childrenList.add(new Property("focal", "boolean", "The instance number of the Coverage which is the focus for adjudication. The Coverage against which the claim is to be adjudicated.", 0, Integer.MAX_VALUE, this.focal));
            childrenList.add(new Property("coverage", "Reference(Coverage)", "Reference to the program or plan identification, underwriter or payor.", 0, Integer.MAX_VALUE, this.coverage));
            childrenList.add(new Property("businessArrangement", "string", "The contract number of a business agreement which describes the terms and conditions.", 0, Integer.MAX_VALUE, this.businessArrangement));
            childrenList.add(new Property("relationship", "Coding", "The relationship of the patient to the subscriber.", 0, Integer.MAX_VALUE, this.relationship));
            childrenList.add(new Property("preAuthRef", "string", "A list of references from the Insurer to which these services pertain.", 0, Integer.MAX_VALUE, this.preAuthRef));
            childrenList.add(new Property("claimResponse", "Reference(ClaimResponse)", "The Coverages adjudication details.", 0, Integer.MAX_VALUE, this.claimResponse));
            childrenList.add(new Property("originalRuleset", "Coding", "The style (standard) and version of the original material which was converted into this resource.", 0, Integer.MAX_VALUE, this.originalRuleset));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequence")) {
                this.sequence = this.castToPositiveInt(value);
            } else if (name.equals("focal")) {
                this.focal = this.castToBoolean(value);
            } else if (name.equals("coverage")) {
                this.coverage = this.castToReference(value);
            } else if (name.equals("businessArrangement")) {
                this.businessArrangement = this.castToString(value);
            } else if (name.equals("relationship")) {
                this.relationship = this.castToCoding(value);
            } else if (name.equals("preAuthRef")) {
                this.getPreAuthRef().add(this.castToString(value));
            } else if (name.equals("claimResponse")) {
                this.claimResponse = this.castToReference(value);
            } else if (name.equals("originalRuleset")) {
                this.originalRuleset = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequence")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequence");
            }
            if (name.equals("focal")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.focal");
            }
            if (name.equals("coverage")) {
                this.coverage = new Reference();
                return this.coverage;
            }
            if (name.equals("businessArrangement")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.businessArrangement");
            }
            if (name.equals("relationship")) {
                this.relationship = new Coding();
                return this.relationship;
            }
            if (name.equals("preAuthRef")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.preAuthRef");
            }
            if (name.equals("claimResponse")) {
                this.claimResponse = new Reference();
                return this.claimResponse;
            }
            if (name.equals("originalRuleset")) {
                this.originalRuleset = new Coding();
                return this.originalRuleset;
            }
            return super.addChild(name);
        }

        @Override
        public CoverageComponent copy() {
            CoverageComponent dst = new CoverageComponent();
            this.copyValues(dst);
            dst.sequence = this.sequence == null ? null : this.sequence.copy();
            dst.focal = this.focal == null ? null : this.focal.copy();
            dst.coverage = this.coverage == null ? null : this.coverage.copy();
            dst.businessArrangement = this.businessArrangement == null ? null : this.businessArrangement.copy();
            Coding coding = dst.relationship = this.relationship == null ? null : this.relationship.copy();
            if (this.preAuthRef != null) {
                dst.preAuthRef = new ArrayList<StringType>();
                for (StringType i : this.preAuthRef) {
                    dst.preAuthRef.add(i.copy());
                }
            }
            dst.claimResponse = this.claimResponse == null ? null : this.claimResponse.copy();
            dst.originalRuleset = this.originalRuleset == null ? null : this.originalRuleset.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other;
            return CoverageComponent.compareDeep(this.sequence, o.sequence, true) && CoverageComponent.compareDeep(this.focal, o.focal, true) && CoverageComponent.compareDeep(this.coverage, o.coverage, true) && CoverageComponent.compareDeep(this.businessArrangement, o.businessArrangement, true) && CoverageComponent.compareDeep(this.relationship, o.relationship, true) && CoverageComponent.compareDeep(this.preAuthRef, o.preAuthRef, true) && CoverageComponent.compareDeep(this.claimResponse, o.claimResponse, true) && CoverageComponent.compareDeep(this.originalRuleset, o.originalRuleset, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof CoverageComponent)) {
                return false;
            }
            CoverageComponent o = (CoverageComponent)other;
            return CoverageComponent.compareValues(this.sequence, o.sequence, true) && CoverageComponent.compareValues(this.focal, o.focal, true) && CoverageComponent.compareValues(this.businessArrangement, o.businessArrangement, true) && CoverageComponent.compareValues(this.preAuthRef, o.preAuthRef, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequence != null && !this.sequence.isEmpty() || this.focal != null && !this.focal.isEmpty() || this.coverage != null && !this.coverage.isEmpty() || this.businessArrangement != null && !this.businessArrangement.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.preAuthRef != null && !this.preAuthRef.isEmpty() || this.claimResponse != null && !this.claimResponse.isEmpty() || this.originalRuleset != null && !this.originalRuleset.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.coverage";
        }
    }

    @Block
    public static class NotesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="number", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Note Number for this note", formalDefinition="An integer associated with each note which may be referred to from each service line item.")
        protected PositiveIntType number;
        @Child(name="type", type={Coding.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="display | print | printoper", formalDefinition="The note purpose: Print/Display.")
        protected Coding type;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Note explanatory text", formalDefinition="The note text.")
        protected StringType text;
        private static final long serialVersionUID = 1768923951L;

        public PositiveIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new PositiveIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public NotesComponent setNumberElement(PositiveIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public NotesComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new PositiveIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public NotesComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create NotesComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public NotesComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public NotesComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("number", "positiveInt", "An integer associated with each note which may be referred to from each service line item.", 0, Integer.MAX_VALUE, this.number));
            childrenList.add(new Property("type", "Coding", "The note purpose: Print/Display.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("text", "string", "The note text.", 0, Integer.MAX_VALUE, this.text));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("number")) {
                this.number = this.castToPositiveInt(value);
            } else if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.number");
            }
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.text");
            }
            return super.addChild(name);
        }

        @Override
        public NotesComponent copy() {
            NotesComponent dst = new NotesComponent();
            this.copyValues(dst);
            dst.number = this.number == null ? null : this.number.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.text = this.text == null ? null : this.text.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareDeep(this.number, o.number, true) && NotesComponent.compareDeep(this.type, o.type, true) && NotesComponent.compareDeep(this.text, o.text, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof NotesComponent)) {
                return false;
            }
            NotesComponent o = (NotesComponent)other;
            return NotesComponent.compareValues(this.number, o.number, true) && NotesComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.number != null && !this.number.isEmpty() || this.type != null && !this.type.isEmpty() || this.text != null && !this.text.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.note";
        }
    }

    @Block
    public static class ErrorsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Item sequence number", formalDefinition="The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="detailSequenceLinkId", type={PositiveIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Detail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected PositiveIntType detailSequenceLinkId;
        @Child(name="subdetailSequenceLinkId", type={PositiveIntType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Subdetail sequence number", formalDefinition="The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.")
        protected PositiveIntType subdetailSequenceLinkId;
        @Child(name="code", type={Coding.class}, order=4, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Error code detailing processing issues", formalDefinition="An error code,froma specified code system, which details why the claim could not be adjudicated.")
        protected Coding code;
        private static final long serialVersionUID = -1893641175L;

        public ErrorsComponent() {
        }

        public ErrorsComponent(Coding code) {
            this.code = code;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorsComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public ErrorsComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public ErrorsComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public PositiveIntType getDetailSequenceLinkIdElement() {
            if (this.detailSequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorsComponent.detailSequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailSequenceLinkId = new PositiveIntType();
                }
            }
            return this.detailSequenceLinkId;
        }

        public boolean hasDetailSequenceLinkIdElement() {
            return this.detailSequenceLinkId != null && !this.detailSequenceLinkId.isEmpty();
        }

        public boolean hasDetailSequenceLinkId() {
            return this.detailSequenceLinkId != null && !this.detailSequenceLinkId.isEmpty();
        }

        public ErrorsComponent setDetailSequenceLinkIdElement(PositiveIntType value) {
            this.detailSequenceLinkId = value;
            return this;
        }

        public int getDetailSequenceLinkId() {
            return this.detailSequenceLinkId == null || this.detailSequenceLinkId.isEmpty() ? 0 : (Integer)this.detailSequenceLinkId.getValue();
        }

        public ErrorsComponent setDetailSequenceLinkId(int value) {
            if (this.detailSequenceLinkId == null) {
                this.detailSequenceLinkId = new PositiveIntType();
            }
            this.detailSequenceLinkId.setValue((Object)value);
            return this;
        }

        public PositiveIntType getSubdetailSequenceLinkIdElement() {
            if (this.subdetailSequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorsComponent.subdetailSequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.subdetailSequenceLinkId = new PositiveIntType();
                }
            }
            return this.subdetailSequenceLinkId;
        }

        public boolean hasSubdetailSequenceLinkIdElement() {
            return this.subdetailSequenceLinkId != null && !this.subdetailSequenceLinkId.isEmpty();
        }

        public boolean hasSubdetailSequenceLinkId() {
            return this.subdetailSequenceLinkId != null && !this.subdetailSequenceLinkId.isEmpty();
        }

        public ErrorsComponent setSubdetailSequenceLinkIdElement(PositiveIntType value) {
            this.subdetailSequenceLinkId = value;
            return this;
        }

        public int getSubdetailSequenceLinkId() {
            return this.subdetailSequenceLinkId == null || this.subdetailSequenceLinkId.isEmpty() ? 0 : (Integer)this.subdetailSequenceLinkId.getValue();
        }

        public ErrorsComponent setSubdetailSequenceLinkId(int value) {
            if (this.subdetailSequenceLinkId == null) {
                this.subdetailSequenceLinkId = new PositiveIntType();
            }
            this.subdetailSequenceLinkId.setValue((Object)value);
            return this;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ErrorsComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ErrorsComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequenceLinkId", "positiveInt", "The sequence number of the line item submitted which contains the error. This value is omitted when the error is elsewhere.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
            childrenList.add(new Property("detailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.detailSequenceLinkId));
            childrenList.add(new Property("subdetailSequenceLinkId", "positiveInt", "The sequence number of the addition within the line item submitted which contains the error. This value is omitted when the error is not related to an Addition.", 0, Integer.MAX_VALUE, this.subdetailSequenceLinkId));
            childrenList.add(new Property("code", "Coding", "An error code,froma specified code system, which details why the claim could not be adjudicated.", 0, Integer.MAX_VALUE, this.code));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("detailSequenceLinkId")) {
                this.detailSequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("subdetailSequenceLinkId")) {
                this.subdetailSequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("detailSequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.detailSequenceLinkId");
            }
            if (name.equals("subdetailSequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.subdetailSequenceLinkId");
            }
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            return super.addChild(name);
        }

        @Override
        public ErrorsComponent copy() {
            ErrorsComponent dst = new ErrorsComponent();
            this.copyValues(dst);
            dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            dst.detailSequenceLinkId = this.detailSequenceLinkId == null ? null : this.detailSequenceLinkId.copy();
            dst.subdetailSequenceLinkId = this.subdetailSequenceLinkId == null ? null : this.subdetailSequenceLinkId.copy();
            dst.code = this.code == null ? null : this.code.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other;
            return ErrorsComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && ErrorsComponent.compareDeep(this.detailSequenceLinkId, o.detailSequenceLinkId, true) && ErrorsComponent.compareDeep(this.subdetailSequenceLinkId, o.subdetailSequenceLinkId, true) && ErrorsComponent.compareDeep(this.code, o.code, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ErrorsComponent)) {
                return false;
            }
            ErrorsComponent o = (ErrorsComponent)other;
            return ErrorsComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && ErrorsComponent.compareValues(this.detailSequenceLinkId, o.detailSequenceLinkId, true) && ErrorsComponent.compareValues(this.subdetailSequenceLinkId, o.subdetailSequenceLinkId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty() || this.detailSequenceLinkId != null && !this.detailSequenceLinkId.isEmpty() || this.subdetailSequenceLinkId != null && !this.subdetailSequenceLinkId.isEmpty() || this.code != null && !this.code.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.error";
        }
    }

    @Block
    public static class AddedItemDetailAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        protected Coding code;
        @Child(name="amount", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -949880587L;

        public AddedItemDetailAdjudicationComponent() {
        }

        public AddedItemDetailAdjudicationComponent(Coding code) {
            this.code = code;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailAdjudicationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public AddedItemDetailAdjudicationComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AddedItemDetailAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemDetailAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AddedItemDetailAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public AddedItemDetailAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "Coding", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("amount", "Money", "Monetary amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.value");
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemDetailAdjudicationComponent copy() {
            AddedItemDetailAdjudicationComponent dst = new AddedItemDetailAdjudicationComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemDetailAdjudicationComponent)) {
                return false;
            }
            AddedItemDetailAdjudicationComponent o = (AddedItemDetailAdjudicationComponent)other;
            return AddedItemDetailAdjudicationComponent.compareDeep(this.code, o.code, true) && AddedItemDetailAdjudicationComponent.compareDeep(this.amount, o.amount, true) && AddedItemDetailAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemDetailAdjudicationComponent)) {
                return false;
            }
            AddedItemDetailAdjudicationComponent o = (AddedItemDetailAdjudicationComponent)other;
            return AddedItemDetailAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.detail.adjudication";
        }
    }

    @Block
    public static class AddedItemsDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="service", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="fee", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Professional fee or Product charge", formalDefinition="The fee charged for the professional service or product..")
        protected Money fee;
        @Child(name="adjudication", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Added items detail adjudication", formalDefinition="The adjudications results.")
        protected List<AddedItemDetailAdjudicationComponent> adjudication;
        private static final long serialVersionUID = -2104242020L;

        public AddedItemsDetailComponent() {
        }

        public AddedItemsDetailComponent(Coding service) {
            this.service = service;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemsDetailComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public AddedItemsDetailComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public Money getFee() {
            if (this.fee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemsDetailComponent.fee");
                }
                if (Configuration.doAutoCreate()) {
                    this.fee = new Money();
                }
            }
            return this.fee;
        }

        public boolean hasFee() {
            return this.fee != null && !this.fee.isEmpty();
        }

        public AddedItemsDetailComponent setFee(Money value) {
            this.fee = value;
            return this;
        }

        public List<AddedItemDetailAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AddedItemDetailAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemDetailAdjudicationComponent addAdjudication() {
            AddedItemDetailAdjudicationComponent t = new AddedItemDetailAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemsDetailComponent addAdjudication(AddedItemDetailAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("service", "Coding", "A code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("fee", "Money", "The fee charged for the professional service or product..", 0, Integer.MAX_VALUE, this.fee));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("fee")) {
                this.fee = this.castToMoney(value);
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AddedItemDetailAdjudicationComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("fee")) {
                this.fee = new Money();
                return this.fee;
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemsDetailComponent copy() {
            AddedItemsDetailComponent dst = new AddedItemsDetailComponent();
            this.copyValues(dst);
            dst.service = this.service == null ? null : this.service.copy();
            Money money = dst.fee = this.fee == null ? null : this.fee.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AddedItemDetailAdjudicationComponent>();
                for (AddedItemDetailAdjudicationComponent i : this.adjudication) {
                    dst.adjudication.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemsDetailComponent)) {
                return false;
            }
            AddedItemsDetailComponent o = (AddedItemsDetailComponent)other;
            return AddedItemsDetailComponent.compareDeep(this.service, o.service, true) && AddedItemsDetailComponent.compareDeep(this.fee, o.fee, true) && AddedItemsDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemsDetailComponent)) {
                return false;
            }
            AddedItemsDetailComponent o = (AddedItemsDetailComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.service != null && !this.service.isEmpty() || this.fee != null && !this.fee.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.detail";
        }
    }

    @Block
    public static class AddedItemAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        protected Coding code;
        @Child(name="amount", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -949880587L;

        public AddedItemAdjudicationComponent() {
        }

        public AddedItemAdjudicationComponent(Coding code) {
            this.code = code;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemAdjudicationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public AddedItemAdjudicationComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public AddedItemAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public AddedItemAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public AddedItemAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "Coding", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("amount", "Money", "Monetary amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.value");
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemAdjudicationComponent copy() {
            AddedItemAdjudicationComponent dst = new AddedItemAdjudicationComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemAdjudicationComponent)) {
                return false;
            }
            AddedItemAdjudicationComponent o = (AddedItemAdjudicationComponent)other;
            return AddedItemAdjudicationComponent.compareDeep(this.code, o.code, true) && AddedItemAdjudicationComponent.compareDeep(this.amount, o.amount, true) && AddedItemAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemAdjudicationComponent)) {
                return false;
            }
            AddedItemAdjudicationComponent o = (AddedItemAdjudicationComponent)other;
            return AddedItemAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem.adjudication";
        }
    }

    @Block
    public static class AddedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Service instances", formalDefinition="List of input service items which this service line is intended to replace.")
        protected List<PositiveIntType> sequenceLinkId;
        @Child(name="service", type={Coding.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Group, Service or Product", formalDefinition="A code to indicate the Professional Service or Product supplied.")
        protected Coding service;
        @Child(name="fee", type={Money.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Professional fee or Product charge", formalDefinition="The fee charged for the professional service or product..")
        protected Money fee;
        @Child(name="noteNumberLinkId", type={PositiveIntType.class}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumberLinkId;
        @Child(name="adjudication", type={}, order=5, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Added items adjudication", formalDefinition="The adjudications results.")
        protected List<AddedItemAdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Added items details", formalDefinition="The second tier service adjudications for payor added services.")
        protected List<AddedItemsDetailComponent> detail;
        private static final long serialVersionUID = -1675935854L;

        public AddedItemComponent() {
        }

        public AddedItemComponent(Coding service) {
            this.service = service;
        }

        public List<PositiveIntType> getSequenceLinkId() {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkId() {
            if (this.sequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.sequenceLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addSequenceLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.sequenceLinkId.add(t);
            return t;
        }

        public AddedItemComponent addSequenceLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new ArrayList<PositiveIntType>();
            }
            this.sequenceLinkId.add(t);
            return this;
        }

        public boolean hasSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.sequenceLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public Coding getService() {
            if (this.service == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.service");
                }
                if (Configuration.doAutoCreate()) {
                    this.service = new Coding();
                }
            }
            return this.service;
        }

        public boolean hasService() {
            return this.service != null && !this.service.isEmpty();
        }

        public AddedItemComponent setService(Coding value) {
            this.service = value;
            return this;
        }

        public Money getFee() {
            if (this.fee == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AddedItemComponent.fee");
                }
                if (Configuration.doAutoCreate()) {
                    this.fee = new Money();
                }
            }
            return this.fee;
        }

        public boolean hasFee() {
            return this.fee != null && !this.fee.isEmpty();
        }

        public AddedItemComponent setFee(Money value) {
            this.fee = value;
            return this;
        }

        public List<PositiveIntType> getNoteNumberLinkId() {
            if (this.noteNumberLinkId == null) {
                this.noteNumberLinkId = new ArrayList<PositiveIntType>();
            }
            return this.noteNumberLinkId;
        }

        public boolean hasNoteNumberLinkId() {
            if (this.noteNumberLinkId == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumberLinkId) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberLinkIdElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumberLinkId == null) {
                this.noteNumberLinkId = new ArrayList<PositiveIntType>();
            }
            this.noteNumberLinkId.add(t);
            return t;
        }

        public AddedItemComponent addNoteNumberLinkId(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumberLinkId == null) {
                this.noteNumberLinkId = new ArrayList<PositiveIntType>();
            }
            this.noteNumberLinkId.add(t);
            return this;
        }

        public boolean hasNoteNumberLinkId(int value) {
            if (this.noteNumberLinkId == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumberLinkId) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<AddedItemAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (AddedItemAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemAdjudicationComponent addAdjudication() {
            AddedItemAdjudicationComponent t = new AddedItemAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public AddedItemComponent addAdjudication(AddedItemAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public List<AddedItemsDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemsDetailComponent>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (AddedItemsDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public AddedItemsDetailComponent addDetail() {
            AddedItemsDetailComponent t = new AddedItemsDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemsDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public AddedItemComponent addDetail(AddedItemsDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<AddedItemsDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequenceLinkId", "positiveInt", "List of input service items which this service line is intended to replace.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
            childrenList.add(new Property("service", "Coding", "A code to indicate the Professional Service or Product supplied.", 0, Integer.MAX_VALUE, this.service));
            childrenList.add(new Property("fee", "Money", "The fee charged for the professional service or product..", 0, Integer.MAX_VALUE, this.fee));
            childrenList.add(new Property("noteNumberLinkId", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumberLinkId));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
            childrenList.add(new Property("detail", "", "The second tier service adjudications for payor added services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.getSequenceLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("service")) {
                this.service = this.castToCoding(value);
            } else if (name.equals("fee")) {
                this.fee = this.castToMoney(value);
            } else if (name.equals("noteNumberLinkId")) {
                this.getNoteNumberLinkId().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((AddedItemAdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((AddedItemsDetailComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("service")) {
                this.service = new Coding();
                return this.service;
            }
            if (name.equals("fee")) {
                this.fee = new Money();
                return this.fee;
            }
            if (name.equals("noteNumberLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumberLinkId");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public AddedItemComponent copy() {
            AddedItemComponent dst = new AddedItemComponent();
            this.copyValues(dst);
            if (this.sequenceLinkId != null) {
                dst.sequenceLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.sequenceLinkId) {
                    dst.sequenceLinkId.add(positiveIntType.copy());
                }
            }
            dst.service = this.service == null ? null : this.service.copy();
            Money money = dst.fee = this.fee == null ? null : this.fee.copy();
            if (this.noteNumberLinkId != null) {
                dst.noteNumberLinkId = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType : this.noteNumberLinkId) {
                    dst.noteNumberLinkId.add(positiveIntType.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<AddedItemAdjudicationComponent>();
                for (AddedItemAdjudicationComponent addedItemAdjudicationComponent : this.adjudication) {
                    dst.adjudication.add(addedItemAdjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<AddedItemsDetailComponent>();
                for (AddedItemsDetailComponent addedItemsDetailComponent : this.detail) {
                    dst.detail.add(addedItemsDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other;
            return AddedItemComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && AddedItemComponent.compareDeep(this.service, o.service, true) && AddedItemComponent.compareDeep(this.fee, o.fee, true) && AddedItemComponent.compareDeep(this.noteNumberLinkId, o.noteNumberLinkId, true) && AddedItemComponent.compareDeep(this.adjudication, o.adjudication, true) && AddedItemComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AddedItemComponent)) {
                return false;
            }
            AddedItemComponent o = (AddedItemComponent)other;
            return AddedItemComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && AddedItemComponent.compareValues(this.noteNumberLinkId, o.noteNumberLinkId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty() || this.service != null && !this.service.isEmpty() || this.fee != null && !this.fee.isEmpty() || this.noteNumberLinkId != null && !this.noteNumberLinkId.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.addItem";
        }
    }

    @Block
    public static class SubdetailAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        protected Coding code;
        @Child(name="amount", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -949880587L;

        public SubdetailAdjudicationComponent() {
        }

        public SubdetailAdjudicationComponent(Coding code) {
            this.code = code;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubdetailAdjudicationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public SubdetailAdjudicationComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubdetailAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public SubdetailAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubdetailAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public SubdetailAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public SubdetailAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "Coding", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("amount", "Money", "Monetary amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.value");
            }
            return super.addChild(name);
        }

        @Override
        public SubdetailAdjudicationComponent copy() {
            SubdetailAdjudicationComponent dst = new SubdetailAdjudicationComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubdetailAdjudicationComponent)) {
                return false;
            }
            SubdetailAdjudicationComponent o = (SubdetailAdjudicationComponent)other;
            return SubdetailAdjudicationComponent.compareDeep(this.code, o.code, true) && SubdetailAdjudicationComponent.compareDeep(this.amount, o.amount, true) && SubdetailAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubdetailAdjudicationComponent)) {
                return false;
            }
            SubdetailAdjudicationComponent o = (SubdetailAdjudicationComponent)other;
            return SubdetailAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail.subDetail.adjudication";
        }
    }

    @Block
    public static class SubDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="adjudication", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Subdetail adjudication", formalDefinition="The adjudications results.")
        protected List<SubdetailAdjudicationComponent> adjudication;
        private static final long serialVersionUID = 1780202110L;

        public SubDetailComponent() {
        }

        public SubDetailComponent(PositiveIntType sequenceLinkId) {
            this.sequenceLinkId = sequenceLinkId;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SubDetailComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public SubDetailComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public SubDetailComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public List<SubdetailAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<SubdetailAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (SubdetailAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubdetailAdjudicationComponent addAdjudication() {
            SubdetailAdjudicationComponent t = new SubdetailAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<SubdetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public SubDetailComponent addAdjudication(SubdetailAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<SubdetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((SubdetailAdjudicationComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            return super.addChild(name);
        }

        @Override
        public SubDetailComponent copy() {
            SubDetailComponent dst = new SubDetailComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<SubdetailAdjudicationComponent>();
                for (SubdetailAdjudicationComponent i : this.adjudication) {
                    dst.adjudication.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && SubDetailComponent.compareDeep(this.adjudication, o.adjudication, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SubDetailComponent)) {
                return false;
            }
            SubDetailComponent o = (SubDetailComponent)other;
            return SubDetailComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail.subDetail";
        }
    }

    @Block
    public static class DetailAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        protected Coding code;
        @Child(name="amount", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -949880587L;

        public DetailAdjudicationComponent() {
        }

        public DetailAdjudicationComponent(Coding code) {
            this.code = code;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailAdjudicationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public DetailAdjudicationComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public DetailAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DetailAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public DetailAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public DetailAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "Coding", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("amount", "Money", "Monetary amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.value");
            }
            return super.addChild(name);
        }

        @Override
        public DetailAdjudicationComponent copy() {
            DetailAdjudicationComponent dst = new DetailAdjudicationComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DetailAdjudicationComponent)) {
                return false;
            }
            DetailAdjudicationComponent o = (DetailAdjudicationComponent)other;
            return DetailAdjudicationComponent.compareDeep(this.code, o.code, true) && DetailAdjudicationComponent.compareDeep(this.amount, o.amount, true) && DetailAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DetailAdjudicationComponent)) {
                return false;
            }
            DetailAdjudicationComponent o = (DetailAdjudicationComponent)other;
            return DetailAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail.adjudication";
        }
    }

    @Block
    public static class ItemDetailComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="adjudication", type={}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Detail adjudication", formalDefinition="The adjudications results.")
        protected List<DetailAdjudicationComponent> adjudication;
        @Child(name="subDetail", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Subdetail line items", formalDefinition="The third tier service adjudications for submitted services.")
        protected List<SubDetailComponent> subDetail;
        private static final long serialVersionUID = -1751018357L;

        public ItemDetailComponent() {
        }

        public ItemDetailComponent(PositiveIntType sequenceLinkId) {
            this.sequenceLinkId = sequenceLinkId;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemDetailComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public ItemDetailComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public ItemDetailComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public List<DetailAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<DetailAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (DetailAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public DetailAdjudicationComponent addAdjudication() {
            DetailAdjudicationComponent t = new DetailAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<DetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemDetailComponent addAdjudication(DetailAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<DetailAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public List<SubDetailComponent> getSubDetail() {
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            return this.subDetail;
        }

        public boolean hasSubDetail() {
            if (this.subDetail == null) {
                return false;
            }
            for (SubDetailComponent item : this.subDetail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public SubDetailComponent addSubDetail() {
            SubDetailComponent t = new SubDetailComponent();
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return t;
        }

        public ItemDetailComponent addSubDetail(SubDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.subDetail == null) {
                this.subDetail = new ArrayList<SubDetailComponent>();
            }
            this.subDetail.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
            childrenList.add(new Property("subDetail", "", "The third tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.subDetail));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((DetailAdjudicationComponent)value);
            } else if (name.equals("subDetail")) {
                this.getSubDetail().add((SubDetailComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("subDetail")) {
                return this.addSubDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemDetailComponent copy() {
            ItemDetailComponent dst = new ItemDetailComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<DetailAdjudicationComponent>();
                for (DetailAdjudicationComponent detailAdjudicationComponent : this.adjudication) {
                    dst.adjudication.add(detailAdjudicationComponent.copy());
                }
            }
            if (this.subDetail != null) {
                dst.subDetail = new ArrayList<SubDetailComponent>();
                for (SubDetailComponent subDetailComponent : this.subDetail) {
                    dst.subDetail.add(subDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other;
            return ItemDetailComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && ItemDetailComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemDetailComponent.compareDeep(this.subDetail, o.subDetail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemDetailComponent)) {
                return false;
            }
            ItemDetailComponent o = (ItemDetailComponent)other;
            return ItemDetailComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty() || this.subDetail != null && !this.subDetail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.detail";
        }
    }

    @Block
    public static class ItemAdjudicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="code", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication category such as co-pay, eligible, benefit, etc.", formalDefinition="Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.")
        protected Coding code;
        @Child(name="amount", type={Money.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Monetary amount", formalDefinition="Monetary amount associated with the code.")
        protected Money amount;
        @Child(name="value", type={DecimalType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Non-monetary value", formalDefinition="A non-monetary value for example a percentage. Mutually exclusive to the amount element above.")
        protected DecimalType value;
        private static final long serialVersionUID = -949880587L;

        public ItemAdjudicationComponent() {
        }

        public ItemAdjudicationComponent(Coding code) {
            this.code = code;
        }

        public Coding getCode() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemAdjudicationComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Coding();
                }
            }
            return this.code;
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public ItemAdjudicationComponent setCode(Coding value) {
            this.code = value;
            return this;
        }

        public Money getAmount() {
            if (this.amount == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemAdjudicationComponent.amount");
                }
                if (Configuration.doAutoCreate()) {
                    this.amount = new Money();
                }
            }
            return this.amount;
        }

        public boolean hasAmount() {
            return this.amount != null && !this.amount.isEmpty();
        }

        public ItemAdjudicationComponent setAmount(Money value) {
            this.amount = value;
            return this;
        }

        public DecimalType getValueElement() {
            if (this.value == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemAdjudicationComponent.value");
                }
                if (Configuration.doAutoCreate()) {
                    this.value = new DecimalType();
                }
            }
            return this.value;
        }

        public boolean hasValueElement() {
            return this.value != null && !this.value.isEmpty();
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public ItemAdjudicationComponent setValueElement(DecimalType value) {
            this.value = value;
            return this;
        }

        public BigDecimal getValue() {
            return this.value == null ? null : (BigDecimal)this.value.getValue();
        }

        public ItemAdjudicationComponent setValue(BigDecimal value) {
            if (value == null) {
                this.value = null;
            } else {
                if (this.value == null) {
                    this.value = new DecimalType();
                }
                this.value.setValue(value);
            }
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("code", "Coding", "Code indicating: Co-Pay, deductible, eligible, benefit, tax, etc.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("amount", "Money", "Monetary amount associated with the code.", 0, Integer.MAX_VALUE, this.amount));
            childrenList.add(new Property("value", "decimal", "A non-monetary value for example a percentage. Mutually exclusive to the amount element above.", 0, Integer.MAX_VALUE, this.value));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("code")) {
                this.code = this.castToCoding(value);
            } else if (name.equals("amount")) {
                this.amount = this.castToMoney(value);
            } else if (name.equals("value")) {
                this.value = this.castToDecimal(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("code")) {
                this.code = new Coding();
                return this.code;
            }
            if (name.equals("amount")) {
                this.amount = new Money();
                return this.amount;
            }
            if (name.equals("value")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.value");
            }
            return super.addChild(name);
        }

        @Override
        public ItemAdjudicationComponent copy() {
            ItemAdjudicationComponent dst = new ItemAdjudicationComponent();
            this.copyValues(dst);
            dst.code = this.code == null ? null : this.code.copy();
            dst.amount = this.amount == null ? null : this.amount.copy();
            dst.value = this.value == null ? null : this.value.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemAdjudicationComponent)) {
                return false;
            }
            ItemAdjudicationComponent o = (ItemAdjudicationComponent)other;
            return ItemAdjudicationComponent.compareDeep(this.code, o.code, true) && ItemAdjudicationComponent.compareDeep(this.amount, o.amount, true) && ItemAdjudicationComponent.compareDeep(this.value, o.value, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemAdjudicationComponent)) {
                return false;
            }
            ItemAdjudicationComponent o = (ItemAdjudicationComponent)other;
            return ItemAdjudicationComponent.compareValues(this.value, o.value, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.code != null && !this.code.isEmpty() || this.amount != null && !this.amount.isEmpty() || this.value != null && !this.value.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item.adjudication";
        }
    }

    @Block
    public static class ItemsComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="sequenceLinkId", type={PositiveIntType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Service instance", formalDefinition="A service line number.")
        protected PositiveIntType sequenceLinkId;
        @Child(name="noteNumber", type={PositiveIntType.class}, order=2, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="List of note numbers which apply", formalDefinition="A list of note references to the notes provided below.")
        protected List<PositiveIntType> noteNumber;
        @Child(name="adjudication", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Adjudication details", formalDefinition="The adjudications results.")
        protected List<ItemAdjudicationComponent> adjudication;
        @Child(name="detail", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="Detail line items", formalDefinition="The second tier service adjudications for submitted services.")
        protected List<ItemDetailComponent> detail;
        private static final long serialVersionUID = -1917866697L;

        public ItemsComponent() {
        }

        public ItemsComponent(PositiveIntType sequenceLinkId) {
            this.sequenceLinkId = sequenceLinkId;
        }

        public PositiveIntType getSequenceLinkIdElement() {
            if (this.sequenceLinkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ItemsComponent.sequenceLinkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.sequenceLinkId = new PositiveIntType();
                }
            }
            return this.sequenceLinkId;
        }

        public boolean hasSequenceLinkIdElement() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public boolean hasSequenceLinkId() {
            return this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty();
        }

        public ItemsComponent setSequenceLinkIdElement(PositiveIntType value) {
            this.sequenceLinkId = value;
            return this;
        }

        public int getSequenceLinkId() {
            return this.sequenceLinkId == null || this.sequenceLinkId.isEmpty() ? 0 : (Integer)this.sequenceLinkId.getValue();
        }

        public ItemsComponent setSequenceLinkId(int value) {
            if (this.sequenceLinkId == null) {
                this.sequenceLinkId = new PositiveIntType();
            }
            this.sequenceLinkId.setValue((Object)value);
            return this;
        }

        public List<PositiveIntType> getNoteNumber() {
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            return this.noteNumber;
        }

        public boolean hasNoteNumber() {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType item : this.noteNumber) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public PositiveIntType addNoteNumberElement() {
            PositiveIntType t = new PositiveIntType();
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return t;
        }

        public ItemsComponent addNoteNumber(int value) {
            PositiveIntType t = new PositiveIntType();
            t.setValue((Object)value);
            if (this.noteNumber == null) {
                this.noteNumber = new ArrayList<PositiveIntType>();
            }
            this.noteNumber.add(t);
            return this;
        }

        public boolean hasNoteNumber(int value) {
            if (this.noteNumber == null) {
                return false;
            }
            for (PositiveIntType v : this.noteNumber) {
                if (!v.equals(value)) continue;
                return true;
            }
            return false;
        }

        public List<ItemAdjudicationComponent> getAdjudication() {
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<ItemAdjudicationComponent>();
            }
            return this.adjudication;
        }

        public boolean hasAdjudication() {
            if (this.adjudication == null) {
                return false;
            }
            for (ItemAdjudicationComponent item : this.adjudication) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ItemAdjudicationComponent addAdjudication() {
            ItemAdjudicationComponent t = new ItemAdjudicationComponent();
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<ItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return t;
        }

        public ItemsComponent addAdjudication(ItemAdjudicationComponent t) {
            if (t == null) {
                return this;
            }
            if (this.adjudication == null) {
                this.adjudication = new ArrayList<ItemAdjudicationComponent>();
            }
            this.adjudication.add(t);
            return this;
        }

        public List<ItemDetailComponent> getDetail() {
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            return this.detail;
        }

        public boolean hasDetail() {
            if (this.detail == null) {
                return false;
            }
            for (ItemDetailComponent item : this.detail) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ItemDetailComponent addDetail() {
            ItemDetailComponent t = new ItemDetailComponent();
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return t;
        }

        public ItemsComponent addDetail(ItemDetailComponent t) {
            if (t == null) {
                return this;
            }
            if (this.detail == null) {
                this.detail = new ArrayList<ItemDetailComponent>();
            }
            this.detail.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("sequenceLinkId", "positiveInt", "A service line number.", 0, Integer.MAX_VALUE, this.sequenceLinkId));
            childrenList.add(new Property("noteNumber", "positiveInt", "A list of note references to the notes provided below.", 0, Integer.MAX_VALUE, this.noteNumber));
            childrenList.add(new Property("adjudication", "", "The adjudications results.", 0, Integer.MAX_VALUE, this.adjudication));
            childrenList.add(new Property("detail", "", "The second tier service adjudications for submitted services.", 0, Integer.MAX_VALUE, this.detail));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                this.sequenceLinkId = this.castToPositiveInt(value);
            } else if (name.equals("noteNumber")) {
                this.getNoteNumber().add(this.castToPositiveInt(value));
            } else if (name.equals("adjudication")) {
                this.getAdjudication().add((ItemAdjudicationComponent)value);
            } else if (name.equals("detail")) {
                this.getDetail().add((ItemDetailComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("sequenceLinkId")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.sequenceLinkId");
            }
            if (name.equals("noteNumber")) {
                throw new FHIRException("Cannot call addChild on a primitive type ClaimResponse.noteNumber");
            }
            if (name.equals("adjudication")) {
                return this.addAdjudication();
            }
            if (name.equals("detail")) {
                return this.addDetail();
            }
            return super.addChild(name);
        }

        @Override
        public ItemsComponent copy() {
            ItemsComponent dst = new ItemsComponent();
            this.copyValues(dst);
            PositiveIntType positiveIntType = dst.sequenceLinkId = this.sequenceLinkId == null ? null : this.sequenceLinkId.copy();
            if (this.noteNumber != null) {
                dst.noteNumber = new ArrayList<PositiveIntType>();
                for (PositiveIntType positiveIntType2 : this.noteNumber) {
                    dst.noteNumber.add(positiveIntType2.copy());
                }
            }
            if (this.adjudication != null) {
                dst.adjudication = new ArrayList<ItemAdjudicationComponent>();
                for (ItemAdjudicationComponent itemAdjudicationComponent : this.adjudication) {
                    dst.adjudication.add(itemAdjudicationComponent.copy());
                }
            }
            if (this.detail != null) {
                dst.detail = new ArrayList<ItemDetailComponent>();
                for (ItemDetailComponent itemDetailComponent : this.detail) {
                    dst.detail.add(itemDetailComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareDeep(this.sequenceLinkId, o.sequenceLinkId, true) && ItemsComponent.compareDeep(this.noteNumber, o.noteNumber, true) && ItemsComponent.compareDeep(this.adjudication, o.adjudication, true) && ItemsComponent.compareDeep(this.detail, o.detail, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ItemsComponent)) {
                return false;
            }
            ItemsComponent o = (ItemsComponent)other;
            return ItemsComponent.compareValues(this.sequenceLinkId, o.sequenceLinkId, true) && ItemsComponent.compareValues(this.noteNumber, o.noteNumber, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.sequenceLinkId != null && !this.sequenceLinkId.isEmpty() || this.noteNumber != null && !this.noteNumber.isEmpty() || this.adjudication != null && !this.adjudication.isEmpty() || this.detail != null && !this.detail.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ClaimResponse.item";
        }
    }
}

