/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils;

import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.hl7.fhir.dstu2.formats.IParser;
import org.hl7.fhir.dstu2.formats.JsonParser;
import org.hl7.fhir.dstu2.formats.ParserType;
import org.hl7.fhir.dstu2.formats.XmlParser;
import org.hl7.fhir.dstu2.model.Bundle;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.ElementDefinition;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpansionCache;
import org.hl7.fhir.dstu2.utils.BaseWorkerContext;
import org.hl7.fhir.dstu2.utils.INarrativeGenerator;
import org.hl7.fhir.dstu2.utils.IWorkerContext;
import org.hl7.fhir.dstu2.utils.NarrativeGenerator;
import org.hl7.fhir.dstu2.utils.ProfileUtilities;
import org.hl7.fhir.dstu2.utils.client.FHIRToolingClient;
import org.hl7.fhir.dstu2.utils.validation.IResourceValidator;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.CSFileInputStream;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class SimpleWorkerContext
extends BaseWorkerContext
implements IWorkerContext,
ProfileUtilities.ProfileKnowledgeProvider {
    private Map<String, StructureDefinition> structures = new HashMap<String, StructureDefinition>();

    public static SimpleWorkerContext fromPack(String path) throws FileNotFoundException, IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromPack(path);
        return res;
    }

    public static SimpleWorkerContext fromClassPath() throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        res.loadFromStream(SimpleWorkerContext.class.getResourceAsStream("validation.zip"));
        return res;
    }

    public static SimpleWorkerContext fromDefinitions(Map<String, byte[]> source) throws IOException, FHIRException {
        SimpleWorkerContext res = new SimpleWorkerContext();
        for (String name : source.keySet()) {
            if (!name.endsWith(".xml")) continue;
            res.loadFromFile(new ByteArrayInputStream(source.get(name)), name);
        }
        return res;
    }

    public void connectToTSServer(String url, String userAgent) throws URISyntaxException {
        this.txServer = new FHIRToolingClient(url, userAgent);
    }

    private void loadFromFile(InputStream stream, String name) throws IOException, FHIRException {
        XmlParser xml = new XmlParser();
        Bundle f = (Bundle)xml.parse(stream);
        for (Bundle.BundleEntryComponent e : f.getEntry()) {
            if (e.getFullUrl() == null) {
                System.out.println("unidentified resource in " + name + " (no fullUrl)");
            }
            this.seeResource(e.getFullUrl(), e.getResource());
        }
    }

    public void seeResource(String url, Resource r) throws FHIRException {
        if (r instanceof StructureDefinition) {
            this.seeProfile(url, (StructureDefinition)r);
        } else if (r instanceof ValueSet) {
            this.seeValueSet(url, (ValueSet)r);
        } else if (r instanceof ConceptMap) {
            this.maps.put(((ConceptMap)r).getUrl(), (ConceptMap)r);
        }
    }

    private void seeValueSet(String url, ValueSet vs) throws DefinitionException {
        if (Utilities.noString((String)url)) {
            url = vs.getUrl();
        }
        if (this.valueSets.containsKey(vs.getUrl())) {
            throw new DefinitionException("Duplicate Profile " + vs.getUrl());
        }
        this.valueSets.put(vs.getId(), vs);
        this.valueSets.put(vs.getUrl(), vs);
        if (!vs.getUrl().equals(url)) {
            this.valueSets.put(url, vs);
        }
        if (vs.hasCodeSystem()) {
            this.codeSystems.put(vs.getCodeSystem().getSystem().toString(), vs);
        }
    }

    private void seeProfile(String url, StructureDefinition p) throws FHIRException {
        if (Utilities.noString((String)url)) {
            url = p.getUrl();
        }
        if (!p.hasSnapshot()) {
            if (!p.hasBase()) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") has no base and no snapshot");
            }
            StructureDefinition sd = this.fetchResource(StructureDefinition.class, p.getBase());
            if (sd == null) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + ") base " + p.getBase() + " could not be resolved");
            }
            ArrayList<ValidationMessage> msgs = new ArrayList<ValidationMessage>();
            ProfileUtilities pu = new ProfileUtilities(this, msgs, this);
            pu.generateSnapshot(sd, p, p.getUrl(), p.getName());
            for (ValidationMessage msg : msgs) {
                if (msg.getLevel() != ValidationMessage.IssueSeverity.ERROR && msg.getLevel() != ValidationMessage.IssueSeverity.FATAL) continue;
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot: " + msg.getMessage());
            }
            if (!p.hasSnapshot()) {
                throw new DefinitionException("Profile " + p.getName() + " (" + p.getUrl() + "). Error generating snapshot");
            }
            pu = null;
        }
        if (this.structures.containsKey(p.getUrl())) {
            throw new DefinitionException("Duplicate structures " + p.getUrl());
        }
        this.structures.put(p.getId(), p);
        this.structures.put(p.getUrl(), p);
        if (!p.getUrl().equals(url)) {
            this.structures.put(url, p);
        }
    }

    private void loadFromPack(String path) throws FileNotFoundException, IOException, FHIRException {
        this.loadFromStream((InputStream)new CSFileInputStream(path));
    }

    private void loadFromStream(InputStream stream) throws IOException, FHIRException {
        ZipEntry ze;
        ZipInputStream zip = new ZipInputStream(stream);
        while ((ze = zip.getNextEntry()) != null) {
            if (ze.getName().endsWith(".xml")) {
                String name = ze.getName();
                this.loadFromFile(zip, name);
            }
            zip.closeEntry();
        }
        zip.close();
    }

    @Override
    public IParser getParser(ParserType type) {
        switch (type) {
            case JSON: {
                return this.newJsonParser();
            }
            case XML: {
                return this.newXmlParser();
            }
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser getParser(String type) {
        if (type.equalsIgnoreCase("JSON")) {
            return new JsonParser();
        }
        if (type.equalsIgnoreCase("XML")) {
            return new XmlParser();
        }
        throw new Error("Parser Type " + type.toString() + " not supported");
    }

    @Override
    public IParser newJsonParser() {
        return new JsonParser();
    }

    @Override
    public IParser newXmlParser() {
        return new XmlParser();
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResource(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public INarrativeGenerator getNarrativeGenerator(String prefix, String basePath) {
        return new NarrativeGenerator(prefix, basePath, this);
    }

    @Override
    public IResourceValidator newValidator() {
        throw new Error("not supported at this time");
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        if (class_ == StructureDefinition.class && !uri.contains("/")) {
            uri = "http://hl7.org/fhir/StructureDefinition/" + uri;
        }
        if (uri.startsWith("http:")) {
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (class_ == StructureDefinition.class) {
                if (this.structures.containsKey(uri)) {
                    return (T)this.structures.get(uri);
                }
                return null;
            }
            if (class_ == ValueSet.class) {
                if (this.valueSets.containsKey(uri)) {
                    return (T)((Resource)this.valueSets.get(uri));
                }
                if (this.codeSystems.containsKey(uri)) {
                    return (T)((Resource)this.codeSystems.get(uri));
                }
                return null;
            }
        }
        if (class_ == null && uri.contains("/")) {
            return null;
        }
        throw new Error("not done yet");
    }

    public int totalCount() {
        return this.valueSets.size() + this.maps.size() + this.structures.size();
    }

    public void setCache(ValueSetExpansionCache cache) {
        this.expansionCache = cache;
    }

    @Override
    public List<String> getResourceNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (StructureDefinition sd : this.structures.values()) {
            if (sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || sd.hasConstrainedType()) continue;
            result.add(sd.getName());
        }
        Collections.sort(result);
        return result;
    }

    @Override
    public String getAbbreviation(String name) {
        return "xxx";
    }

    @Override
    public boolean isDatatype(String typeSimple) {
        return false;
    }

    @Override
    public boolean isResource(String t) {
        StructureDefinition sd;
        try {
            sd = this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + t);
        }
        catch (Exception e) {
            return false;
        }
        if (sd == null) {
            return false;
        }
        if (sd.hasConstrainedType()) {
            return false;
        }
        return sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    @Override
    public boolean hasLinkFor(String typeSimple) {
        return false;
    }

    @Override
    public String getLinkFor(String typeSimple) {
        return null;
    }

    @Override
    public ProfileUtilities.ProfileKnowledgeProvider.BindingResolution resolveBinding(ElementDefinition.ElementDefinitionBindingComponent binding) {
        return null;
    }

    @Override
    public String getLinkForProfile(StructureDefinition profile, String url) {
        return null;
    }

    @Override
    public List<StructureDefinition> allStructures() {
        ArrayList<StructureDefinition> res = new ArrayList<StructureDefinition>();
        res.addAll(this.structures.values());
        return res;
    }
}

