/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BodySite;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Timing;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;

@ResourceDef(name="DeviceUseRequest", profile="http://hl7.org/fhir/Profile/DeviceUseRequest")
public class DeviceUseRequest
extends DomainResource {
    @Child(name="bodySite", type={CodeableConcept.class, BodySite.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Target body site", formalDefinition="Indicates the site on the subject's body where the device should be used ( i.e. the target site).")
    protected Type bodySite;
    @Child(name="status", type={CodeType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="proposed | planned | requested | received | accepted | in-progress | completed | suspended | rejected | aborted", formalDefinition="The status of the request.")
    protected Enumeration<DeviceUseRequestStatus> status;
    @Child(name="device", type={Device.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Device requested", formalDefinition="The details of the device  to be used.")
    protected Reference device;
    protected Device deviceTarget;
    @Child(name="encounter", type={Encounter.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Encounter motivating request", formalDefinition="An encounter that provides additional context in which this request is made.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="identifier", type={Identifier.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Request identifier", formalDefinition="Identifiers assigned to this order by the orderer or by the receiver.")
    protected List<Identifier> identifier;
    @Child(name="indication", type={CodeableConcept.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Reason for request", formalDefinition="Reason or justification for the use of this device.")
    protected List<CodeableConcept> indication;
    @Child(name="notes", type={StringType.class}, order=6, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Notes or comments", formalDefinition="Details about this request that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.")
    protected List<StringType> notes;
    @Child(name="prnReason", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="PRN", formalDefinition="The proposed act must be performed if the indicated conditions occur, e.g.., shortness of breath, SpO2 less than x%.")
    protected List<CodeableConcept> prnReason;
    @Child(name="orderedOn", type={DateTimeType.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When ordered", formalDefinition="The time when the request was made.")
    protected DateTimeType orderedOn;
    @Child(name="recordedOn", type={DateTimeType.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When recorded", formalDefinition="The time at which the request was made/recorded.")
    protected DateTimeType recordedOn;
    @Child(name="subject", type={Patient.class}, order=10, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Focus of request", formalDefinition="The patient who will use the device.")
    protected Reference subject;
    protected Patient subjectTarget;
    @Child(name="timing", type={Timing.class, Period.class, DateTimeType.class}, order=11, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Schedule for use", formalDefinition="The timing schedule for the use of the device The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".")
    protected Type timing;
    @Child(name="priority", type={CodeType.class}, order=12, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="routine | urgent | stat | asap", formalDefinition="Characterizes how quickly the  use of device must be initiated. Includes concepts such as stat, urgent, routine.")
    protected Enumeration<DeviceUseRequestPriority> priority;
    private static final long serialVersionUID = 1208477058L;
    @SearchParamDefinition(name="subject", path="DeviceUseRequest.subject", description="Search by subject", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="patient", path="DeviceUseRequest.subject", description="Search by subject - a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="device", path="DeviceUseRequest.device", description="Device requested", type="reference")
    public static final String SP_DEVICE = "device";

    public DeviceUseRequest() {
    }

    public DeviceUseRequest(Reference device, Reference subject) {
        this.device = device;
        this.subject = subject;
    }

    public Type getBodySite() {
        return this.bodySite;
    }

    public CodeableConcept getBodySiteCodeableConcept() throws FHIRException {
        if (!(this.bodySite instanceof CodeableConcept)) {
            throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.bodySite.getClass().getName() + " was encountered");
        }
        return (CodeableConcept)this.bodySite;
    }

    public boolean hasBodySiteCodeableConcept() {
        return this.bodySite instanceof CodeableConcept;
    }

    public Reference getBodySiteReference() throws FHIRException {
        if (!(this.bodySite instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.bodySite.getClass().getName() + " was encountered");
        }
        return (Reference)this.bodySite;
    }

    public boolean hasBodySiteReference() {
        return this.bodySite instanceof Reference;
    }

    public boolean hasBodySite() {
        return this.bodySite != null && !this.bodySite.isEmpty();
    }

    public DeviceUseRequest setBodySite(Type value) {
        this.bodySite = value;
        return this;
    }

    public Enumeration<DeviceUseRequestStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DeviceUseRequestStatus>(new DeviceUseRequestStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DeviceUseRequest setStatusElement(Enumeration<DeviceUseRequestStatus> value) {
        this.status = value;
        return this;
    }

    public DeviceUseRequestStatus getStatus() {
        return this.status == null ? null : (DeviceUseRequestStatus)((Object)this.status.getValue());
    }

    public DeviceUseRequest setStatus(DeviceUseRequestStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<DeviceUseRequestStatus>(new DeviceUseRequestStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Reference getDevice() {
        if (this.device == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.device");
            }
            if (Configuration.doAutoCreate()) {
                this.device = new Reference();
            }
        }
        return this.device;
    }

    public boolean hasDevice() {
        return this.device != null && !this.device.isEmpty();
    }

    public DeviceUseRequest setDevice(Reference value) {
        this.device = value;
        return this;
    }

    public Device getDeviceTarget() {
        if (this.deviceTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.device");
            }
            if (Configuration.doAutoCreate()) {
                this.deviceTarget = new Device();
            }
        }
        return this.deviceTarget;
    }

    public DeviceUseRequest setDeviceTarget(Device value) {
        this.deviceTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DeviceUseRequest setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public DeviceUseRequest setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DeviceUseRequest addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public List<CodeableConcept> getIndication() {
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        return this.indication;
    }

    public boolean hasIndication() {
        if (this.indication == null) {
            return false;
        }
        for (CodeableConcept item : this.indication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addIndication() {
        CodeableConcept t = new CodeableConcept();
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        this.indication.add(t);
        return t;
    }

    public DeviceUseRequest addIndication(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.indication == null) {
            this.indication = new ArrayList<CodeableConcept>();
        }
        this.indication.add(t);
        return this;
    }

    public List<StringType> getNotes() {
        if (this.notes == null) {
            this.notes = new ArrayList<StringType>();
        }
        return this.notes;
    }

    public boolean hasNotes() {
        if (this.notes == null) {
            return false;
        }
        for (StringType item : this.notes) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public StringType addNotesElement() {
        StringType t = new StringType();
        if (this.notes == null) {
            this.notes = new ArrayList<StringType>();
        }
        this.notes.add(t);
        return t;
    }

    public DeviceUseRequest addNotes(String value) {
        StringType t = new StringType();
        t.setValue(value);
        if (this.notes == null) {
            this.notes = new ArrayList<StringType>();
        }
        this.notes.add(t);
        return this;
    }

    public boolean hasNotes(String value) {
        if (this.notes == null) {
            return false;
        }
        for (StringType v : this.notes) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    public List<CodeableConcept> getPrnReason() {
        if (this.prnReason == null) {
            this.prnReason = new ArrayList<CodeableConcept>();
        }
        return this.prnReason;
    }

    public boolean hasPrnReason() {
        if (this.prnReason == null) {
            return false;
        }
        for (CodeableConcept item : this.prnReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addPrnReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.prnReason == null) {
            this.prnReason = new ArrayList<CodeableConcept>();
        }
        this.prnReason.add(t);
        return t;
    }

    public DeviceUseRequest addPrnReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.prnReason == null) {
            this.prnReason = new ArrayList<CodeableConcept>();
        }
        this.prnReason.add(t);
        return this;
    }

    public DateTimeType getOrderedOnElement() {
        if (this.orderedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.orderedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.orderedOn = new DateTimeType();
            }
        }
        return this.orderedOn;
    }

    public boolean hasOrderedOnElement() {
        return this.orderedOn != null && !this.orderedOn.isEmpty();
    }

    public boolean hasOrderedOn() {
        return this.orderedOn != null && !this.orderedOn.isEmpty();
    }

    public DeviceUseRequest setOrderedOnElement(DateTimeType value) {
        this.orderedOn = value;
        return this;
    }

    public Date getOrderedOn() {
        return this.orderedOn == null ? null : (Date)this.orderedOn.getValue();
    }

    public DeviceUseRequest setOrderedOn(Date value) {
        if (value == null) {
            this.orderedOn = null;
        } else {
            if (this.orderedOn == null) {
                this.orderedOn = new DateTimeType();
            }
            this.orderedOn.setValue(value);
        }
        return this;
    }

    public DateTimeType getRecordedOnElement() {
        if (this.recordedOn == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.recordedOn");
            }
            if (Configuration.doAutoCreate()) {
                this.recordedOn = new DateTimeType();
            }
        }
        return this.recordedOn;
    }

    public boolean hasRecordedOnElement() {
        return this.recordedOn != null && !this.recordedOn.isEmpty();
    }

    public boolean hasRecordedOn() {
        return this.recordedOn != null && !this.recordedOn.isEmpty();
    }

    public DeviceUseRequest setRecordedOnElement(DateTimeType value) {
        this.recordedOn = value;
        return this;
    }

    public Date getRecordedOn() {
        return this.recordedOn == null ? null : (Date)this.recordedOn.getValue();
    }

    public DeviceUseRequest setRecordedOn(Date value) {
        if (value == null) {
            this.recordedOn = null;
        } else {
            if (this.recordedOn == null) {
                this.recordedOn = new DateTimeType();
            }
            this.recordedOn.setValue(value);
        }
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DeviceUseRequest setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Patient getSubjectTarget() {
        if (this.subjectTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subjectTarget = new Patient();
            }
        }
        return this.subjectTarget;
    }

    public DeviceUseRequest setSubjectTarget(Patient value) {
        this.subjectTarget = value;
        return this;
    }

    public Type getTiming() {
        return this.timing;
    }

    public Timing getTimingTiming() throws FHIRException {
        if (!(this.timing instanceof Timing)) {
            throw new FHIRException("Type mismatch: the type Timing was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Timing)this.timing;
    }

    public boolean hasTimingTiming() {
        return this.timing instanceof Timing;
    }

    public Period getTimingPeriod() throws FHIRException {
        if (!(this.timing instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (Period)this.timing;
    }

    public boolean hasTimingPeriod() {
        return this.timing instanceof Period;
    }

    public DateTimeType getTimingDateTimeType() throws FHIRException {
        if (!(this.timing instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.timing.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.timing;
    }

    public boolean hasTimingDateTimeType() {
        return this.timing instanceof DateTimeType;
    }

    public boolean hasTiming() {
        return this.timing != null && !this.timing.isEmpty();
    }

    public DeviceUseRequest setTiming(Type value) {
        this.timing = value;
        return this;
    }

    public Enumeration<DeviceUseRequestPriority> getPriorityElement() {
        if (this.priority == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DeviceUseRequest.priority");
            }
            if (Configuration.doAutoCreate()) {
                this.priority = new Enumeration<DeviceUseRequestPriority>(new DeviceUseRequestPriorityEnumFactory());
            }
        }
        return this.priority;
    }

    public boolean hasPriorityElement() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public boolean hasPriority() {
        return this.priority != null && !this.priority.isEmpty();
    }

    public DeviceUseRequest setPriorityElement(Enumeration<DeviceUseRequestPriority> value) {
        this.priority = value;
        return this;
    }

    public DeviceUseRequestPriority getPriority() {
        return this.priority == null ? null : (DeviceUseRequestPriority)((Object)this.priority.getValue());
    }

    public DeviceUseRequest setPriority(DeviceUseRequestPriority value) {
        if (value == null) {
            this.priority = null;
        } else {
            if (this.priority == null) {
                this.priority = new Enumeration<DeviceUseRequestPriority>(new DeviceUseRequestPriorityEnumFactory());
            }
            this.priority.setValue((Object)value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("bodySite[x]", "CodeableConcept|Reference(BodySite)", "Indicates the site on the subject's body where the device should be used ( i.e. the target site).", 0, Integer.MAX_VALUE, this.bodySite));
        childrenList.add(new Property("status", "code", "The status of the request.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_DEVICE, "Reference(Device)", "The details of the device  to be used.", 0, Integer.MAX_VALUE, this.device));
        childrenList.add(new Property("encounter", "Reference(Encounter)", "An encounter that provides additional context in which this request is made.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("identifier", "Identifier", "Identifiers assigned to this order by the orderer or by the receiver.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("indication", "CodeableConcept", "Reason or justification for the use of this device.", 0, Integer.MAX_VALUE, this.indication));
        childrenList.add(new Property("notes", "string", "Details about this request that were not represented at all or sufficiently in one of the attributes provided in a class. These may include for example a comment, an instruction, or a note associated with the statement.", 0, Integer.MAX_VALUE, this.notes));
        childrenList.add(new Property("prnReason", "CodeableConcept", "The proposed act must be performed if the indicated conditions occur, e.g.., shortness of breath, SpO2 less than x%.", 0, Integer.MAX_VALUE, this.prnReason));
        childrenList.add(new Property("orderedOn", "dateTime", "The time when the request was made.", 0, Integer.MAX_VALUE, this.orderedOn));
        childrenList.add(new Property("recordedOn", "dateTime", "The time at which the request was made/recorded.", 0, Integer.MAX_VALUE, this.recordedOn));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient)", "The patient who will use the device.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("timing[x]", "Timing|Period|dateTime", "The timing schedule for the use of the device The Schedule data type allows many different expressions, for example. \"Every 8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\"; \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\".", 0, Integer.MAX_VALUE, this.timing));
        childrenList.add(new Property("priority", "code", "Characterizes how quickly the  use of device must be initiated. Includes concepts such as stat, urgent, routine.", 0, Integer.MAX_VALUE, this.priority));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("bodySite[x]")) {
            this.bodySite = (Type)value;
        } else if (name.equals("status")) {
            this.status = new DeviceUseRequestStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_DEVICE)) {
            this.device = this.castToReference(value);
        } else if (name.equals("encounter")) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("identifier")) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("indication")) {
            this.getIndication().add(this.castToCodeableConcept(value));
        } else if (name.equals("notes")) {
            this.getNotes().add(this.castToString(value));
        } else if (name.equals("prnReason")) {
            this.getPrnReason().add(this.castToCodeableConcept(value));
        } else if (name.equals("orderedOn")) {
            this.orderedOn = this.castToDateTime(value);
        } else if (name.equals("recordedOn")) {
            this.recordedOn = this.castToDateTime(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals("timing[x]")) {
            this.timing = (Type)value;
        } else if (name.equals("priority")) {
            this.priority = new DeviceUseRequestPriorityEnumFactory().fromType(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("bodySiteCodeableConcept")) {
            this.bodySite = new CodeableConcept();
            return this.bodySite;
        }
        if (name.equals("bodySiteReference")) {
            this.bodySite = new Reference();
            return this.bodySite;
        }
        if (name.equals("status")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceUseRequest.status");
        }
        if (name.equals(SP_DEVICE)) {
            this.device = new Reference();
            return this.device;
        }
        if (name.equals("encounter")) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("identifier")) {
            return this.addIdentifier();
        }
        if (name.equals("indication")) {
            return this.addIndication();
        }
        if (name.equals("notes")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceUseRequest.notes");
        }
        if (name.equals("prnReason")) {
            return this.addPrnReason();
        }
        if (name.equals("orderedOn")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceUseRequest.orderedOn");
        }
        if (name.equals("recordedOn")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceUseRequest.recordedOn");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals("timingTiming")) {
            this.timing = new Timing();
            return this.timing;
        }
        if (name.equals("timingPeriod")) {
            this.timing = new Period();
            return this.timing;
        }
        if (name.equals("timingDateTime")) {
            this.timing = new DateTimeType();
            return this.timing;
        }
        if (name.equals("priority")) {
            throw new FHIRException("Cannot call addChild on a singleton property DeviceUseRequest.priority");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DeviceUseRequest";
    }

    @Override
    public DeviceUseRequest copy() {
        DeviceUseRequest dst = new DeviceUseRequest();
        this.copyValues(dst);
        dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.device = this.device == null ? null : this.device.copy();
        Reference reference = dst.encounter = this.encounter == null ? null : this.encounter.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.indication != null) {
            dst.indication = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.indication) {
                dst.indication.add(codeableConcept.copy());
            }
        }
        if (this.notes != null) {
            dst.notes = new ArrayList<StringType>();
            for (StringType stringType : this.notes) {
                dst.notes.add(stringType.copy());
            }
        }
        if (this.prnReason != null) {
            dst.prnReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.prnReason) {
                dst.prnReason.add(codeableConcept.copy());
            }
        }
        dst.orderedOn = this.orderedOn == null ? null : this.orderedOn.copy();
        dst.recordedOn = this.recordedOn == null ? null : this.recordedOn.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.timing = this.timing == null ? null : this.timing.copy();
        dst.priority = this.priority == null ? null : this.priority.copy();
        return dst;
    }

    protected DeviceUseRequest typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DeviceUseRequest)) {
            return false;
        }
        DeviceUseRequest o = (DeviceUseRequest)other;
        return DeviceUseRequest.compareDeep(this.bodySite, o.bodySite, true) && DeviceUseRequest.compareDeep(this.status, o.status, true) && DeviceUseRequest.compareDeep(this.device, o.device, true) && DeviceUseRequest.compareDeep(this.encounter, o.encounter, true) && DeviceUseRequest.compareDeep(this.identifier, o.identifier, true) && DeviceUseRequest.compareDeep(this.indication, o.indication, true) && DeviceUseRequest.compareDeep(this.notes, o.notes, true) && DeviceUseRequest.compareDeep(this.prnReason, o.prnReason, true) && DeviceUseRequest.compareDeep(this.orderedOn, o.orderedOn, true) && DeviceUseRequest.compareDeep(this.recordedOn, o.recordedOn, true) && DeviceUseRequest.compareDeep(this.subject, o.subject, true) && DeviceUseRequest.compareDeep(this.timing, o.timing, true) && DeviceUseRequest.compareDeep(this.priority, o.priority, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DeviceUseRequest)) {
            return false;
        }
        DeviceUseRequest o = (DeviceUseRequest)other;
        return DeviceUseRequest.compareValues(this.status, o.status, true) && DeviceUseRequest.compareValues(this.notes, o.notes, true) && DeviceUseRequest.compareValues(this.orderedOn, o.orderedOn, true) && DeviceUseRequest.compareValues(this.recordedOn, o.recordedOn, true) && DeviceUseRequest.compareValues(this.priority, o.priority, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.status != null && !this.status.isEmpty() || this.device != null && !this.device.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.indication != null && !this.indication.isEmpty() || this.notes != null && !this.notes.isEmpty() || this.prnReason != null && !this.prnReason.isEmpty() || this.orderedOn != null && !this.orderedOn.isEmpty() || this.recordedOn != null && !this.recordedOn.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.timing != null && !this.timing.isEmpty() || this.priority != null && !this.priority.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DeviceUseRequest;
    }

    public static class DeviceUseRequestPriorityEnumFactory
    implements EnumFactory<DeviceUseRequestPriority> {
        @Override
        public DeviceUseRequestPriority fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return DeviceUseRequestPriority.ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return DeviceUseRequestPriority.URGENT;
            }
            if ("stat".equals(codeString)) {
                return DeviceUseRequestPriority.STAT;
            }
            if ("asap".equals(codeString)) {
                return DeviceUseRequestPriority.ASAP;
            }
            throw new IllegalArgumentException("Unknown DeviceUseRequestPriority code '" + codeString + "'");
        }

        public Enumeration<DeviceUseRequestPriority> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return new Enumeration<DeviceUseRequestPriority>(this, DeviceUseRequestPriority.ROUTINE);
            }
            if ("urgent".equals(codeString)) {
                return new Enumeration<DeviceUseRequestPriority>(this, DeviceUseRequestPriority.URGENT);
            }
            if ("stat".equals(codeString)) {
                return new Enumeration<DeviceUseRequestPriority>(this, DeviceUseRequestPriority.STAT);
            }
            if ("asap".equals(codeString)) {
                return new Enumeration<DeviceUseRequestPriority>(this, DeviceUseRequestPriority.ASAP);
            }
            throw new FHIRException("Unknown DeviceUseRequestPriority code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceUseRequestPriority code) {
            if (code == DeviceUseRequestPriority.ROUTINE) {
                return "routine";
            }
            if (code == DeviceUseRequestPriority.URGENT) {
                return "urgent";
            }
            if (code == DeviceUseRequestPriority.STAT) {
                return "stat";
            }
            if (code == DeviceUseRequestPriority.ASAP) {
                return "asap";
            }
            return "?";
        }
    }

    public static enum DeviceUseRequestPriority {
        ROUTINE,
        URGENT,
        STAT,
        ASAP,
        NULL;


        public static DeviceUseRequestPriority fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("routine".equals(codeString)) {
                return ROUTINE;
            }
            if ("urgent".equals(codeString)) {
                return URGENT;
            }
            if ("stat".equals(codeString)) {
                return STAT;
            }
            if ("asap".equals(codeString)) {
                return ASAP;
            }
            throw new FHIRException("Unknown DeviceUseRequestPriority code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ROUTINE: {
                    return "routine";
                }
                case URGENT: {
                    return "urgent";
                }
                case STAT: {
                    return "stat";
                }
                case ASAP: {
                    return "asap";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ROUTINE: {
                    return "http://hl7.org/fhir/device-use-request-priority";
                }
                case URGENT: {
                    return "http://hl7.org/fhir/device-use-request-priority";
                }
                case STAT: {
                    return "http://hl7.org/fhir/device-use-request-priority";
                }
                case ASAP: {
                    return "http://hl7.org/fhir/device-use-request-priority";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ROUTINE: {
                    return "The request has a normal priority.";
                }
                case URGENT: {
                    return "The request should be done urgently.";
                }
                case STAT: {
                    return "The request is time-critical.";
                }
                case ASAP: {
                    return "The request should be acted on as soon as possible.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ROUTINE: {
                    return "Routine";
                }
                case URGENT: {
                    return "Urgent";
                }
                case STAT: {
                    return "Stat";
                }
                case ASAP: {
                    return "ASAP";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }

    public static class DeviceUseRequestStatusEnumFactory
    implements EnumFactory<DeviceUseRequestStatus> {
        @Override
        public DeviceUseRequestStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return DeviceUseRequestStatus.PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return DeviceUseRequestStatus.PLANNED;
            }
            if ("requested".equals(codeString)) {
                return DeviceUseRequestStatus.REQUESTED;
            }
            if ("received".equals(codeString)) {
                return DeviceUseRequestStatus.RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return DeviceUseRequestStatus.ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return DeviceUseRequestStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return DeviceUseRequestStatus.COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return DeviceUseRequestStatus.SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return DeviceUseRequestStatus.REJECTED;
            }
            if ("aborted".equals(codeString)) {
                return DeviceUseRequestStatus.ABORTED;
            }
            throw new IllegalArgumentException("Unknown DeviceUseRequestStatus code '" + codeString + "'");
        }

        public Enumeration<DeviceUseRequestStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.PROPOSED);
            }
            if ("planned".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.PLANNED);
            }
            if ("requested".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.REQUESTED);
            }
            if ("received".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.RECEIVED);
            }
            if ("accepted".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.ACCEPTED);
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.COMPLETED);
            }
            if ("suspended".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.SUSPENDED);
            }
            if ("rejected".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.REJECTED);
            }
            if ("aborted".equals(codeString)) {
                return new Enumeration<DeviceUseRequestStatus>(this, DeviceUseRequestStatus.ABORTED);
            }
            throw new FHIRException("Unknown DeviceUseRequestStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DeviceUseRequestStatus code) {
            if (code == DeviceUseRequestStatus.PROPOSED) {
                return "proposed";
            }
            if (code == DeviceUseRequestStatus.PLANNED) {
                return "planned";
            }
            if (code == DeviceUseRequestStatus.REQUESTED) {
                return "requested";
            }
            if (code == DeviceUseRequestStatus.RECEIVED) {
                return "received";
            }
            if (code == DeviceUseRequestStatus.ACCEPTED) {
                return "accepted";
            }
            if (code == DeviceUseRequestStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == DeviceUseRequestStatus.COMPLETED) {
                return "completed";
            }
            if (code == DeviceUseRequestStatus.SUSPENDED) {
                return "suspended";
            }
            if (code == DeviceUseRequestStatus.REJECTED) {
                return "rejected";
            }
            if (code == DeviceUseRequestStatus.ABORTED) {
                return "aborted";
            }
            return "?";
        }
    }

    public static enum DeviceUseRequestStatus {
        PROPOSED,
        PLANNED,
        REQUESTED,
        RECEIVED,
        ACCEPTED,
        INPROGRESS,
        COMPLETED,
        SUSPENDED,
        REJECTED,
        ABORTED,
        NULL;


        public static DeviceUseRequestStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("proposed".equals(codeString)) {
                return PROPOSED;
            }
            if ("planned".equals(codeString)) {
                return PLANNED;
            }
            if ("requested".equals(codeString)) {
                return REQUESTED;
            }
            if ("received".equals(codeString)) {
                return RECEIVED;
            }
            if ("accepted".equals(codeString)) {
                return ACCEPTED;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("suspended".equals(codeString)) {
                return SUSPENDED;
            }
            if ("rejected".equals(codeString)) {
                return REJECTED;
            }
            if ("aborted".equals(codeString)) {
                return ABORTED;
            }
            throw new FHIRException("Unknown DeviceUseRequestStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case PROPOSED: {
                    return "proposed";
                }
                case PLANNED: {
                    return "planned";
                }
                case REQUESTED: {
                    return "requested";
                }
                case RECEIVED: {
                    return "received";
                }
                case ACCEPTED: {
                    return "accepted";
                }
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case SUSPENDED: {
                    return "suspended";
                }
                case REJECTED: {
                    return "rejected";
                }
                case ABORTED: {
                    return "aborted";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case PROPOSED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case PLANNED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case REQUESTED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case RECEIVED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case ACCEPTED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case INPROGRESS: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case SUSPENDED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case REJECTED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case ABORTED: {
                    return "http://hl7.org/fhir/device-use-request-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case PROPOSED: {
                    return "The request has been proposed.";
                }
                case PLANNED: {
                    return "The request has been planned.";
                }
                case REQUESTED: {
                    return "The request has been placed.";
                }
                case RECEIVED: {
                    return "The receiving system has received the request but not yet decided whether it will be performed.";
                }
                case ACCEPTED: {
                    return "The receiving system has accepted the request but work has not yet commenced.";
                }
                case INPROGRESS: {
                    return "The work to fulfill the order is happening.";
                }
                case COMPLETED: {
                    return "The work has been complete, the report(s) released, and no further work is planned.";
                }
                case SUSPENDED: {
                    return "The request has been held by originating system/user request.";
                }
                case REJECTED: {
                    return "The receiving system has declined to fulfill the request.";
                }
                case ABORTED: {
                    return "The request was attempted, but due to some procedural error, it could not be completed.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case PROPOSED: {
                    return "Proposed";
                }
                case PLANNED: {
                    return "Planned";
                }
                case REQUESTED: {
                    return "Requested";
                }
                case RECEIVED: {
                    return "Received";
                }
                case ACCEPTED: {
                    return "Accepted";
                }
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case SUSPENDED: {
                    return "Suspended";
                }
                case REJECTED: {
                    return "Rejected";
                }
                case ABORTED: {
                    return "Aborted";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

