/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Address;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Enumerations;
import org.hl7.fhir.dstu2.model.HumanName;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;

@ResourceDef(name="Patient", profile="http://hl7.org/fhir/Profile/Patient")
public class Patient
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="An identifier for this patient", formalDefinition="An identifier for this patient.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this patient's record is in active use", formalDefinition="Whether this patient record is in active use.")
    protected BooleanType active;
    @Child(name="name", type={HumanName.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A name associated with the patient", formalDefinition="A name associated with the individual.")
    protected List<HumanName> name;
    @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A contact detail for the individual", formalDefinition="A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.")
    protected List<ContactPoint> telecom;
    @Child(name="gender", type={CodeType.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="birthDate", type={DateType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date of birth for the individual", formalDefinition="The date of birth for the individual.")
    protected DateType birthDate;
    @Child(name="deceased", type={BooleanType.class, DateTimeType.class}, order=6, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Indicates if the individual is deceased or not", formalDefinition="Indicates if the individual is deceased or not.")
    protected Type deceased;
    @Child(name="address", type={Address.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Addresses for the individual", formalDefinition="Addresses for the individual.")
    protected List<Address> address;
    @Child(name="maritalStatus", type={CodeableConcept.class}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Marital (civil) status of a patient", formalDefinition="This field contains a patient's most recent marital (civil) status.")
    protected CodeableConcept maritalStatus;
    @Child(name="multipleBirth", type={BooleanType.class, IntegerType.class}, order=9, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Whether patient is part of a multiple birth", formalDefinition="Indicates whether the patient is part of a multiple or indicates the actual birth order.")
    protected Type multipleBirth;
    @Child(name="photo", type={Attachment.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image of the patient", formalDefinition="Image of the patient.")
    protected List<Attachment> photo;
    @Child(name="contact", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A contact party (e.g. guardian, partner, friend) for the patient", formalDefinition="A contact party (e.g. guardian, partner, friend) for the patient.")
    protected List<ContactComponent> contact;
    @Child(name="animal", type={}, order=12, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="This patient is known to be an animal (non-human)", formalDefinition="This patient is known to be an animal.")
    protected AnimalComponent animal;
    @Child(name="communication", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A list of Languages which may be used to communicate with the patient about his or her health", formalDefinition="Languages which may be used to communicate with the patient about his or her health.")
    protected List<PatientCommunicationComponent> communication;
    @Child(name="careProvider", type={Organization.class, Practitioner.class}, order=14, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Patient's nominated primary care provider", formalDefinition="Patient's nominated care provider.")
    protected List<Reference> careProvider;
    protected List<Resource> careProviderTarget;
    @Child(name="managingOrganization", type={Organization.class}, order=15, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Organization that is the custodian of the patient record", formalDefinition="Organization that is the custodian of the patient record.")
    protected Reference managingOrganization;
    protected Organization managingOrganizationTarget;
    @Child(name="link", type={}, order=16, min=0, max=-1, modifier=true, summary=false)
    @Description(shortDefinition="Link to another patient resource that concerns the same actual person", formalDefinition="Link to another patient resource that concerns the same actual patient.")
    protected List<PatientLinkComponent> link;
    private static final long serialVersionUID = 2019992554L;
    @SearchParamDefinition(name="birthdate", path="Patient.birthDate", description="The patient's date of birth", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    @SearchParamDefinition(name="deceased", path="Patient.deceased[x]", description="This patient has been marked as deceased, or as a death date entered", type="token")
    public static final String SP_DECEASED = "deceased";
    @SearchParamDefinition(name="address-state", path="Patient.address.state", description="A state specified in an address", type="string")
    public static final String SP_ADDRESSSTATE = "address-state";
    @SearchParamDefinition(name="gender", path="Patient.gender", description="Gender of the patient", type="token")
    public static final String SP_GENDER = "gender";
    @SearchParamDefinition(name="animal-species", path="Patient.animal.species", description="The species for animal patients", type="token")
    public static final String SP_ANIMALSPECIES = "animal-species";
    @SearchParamDefinition(name="link", path="Patient.link.other", description="All patients linked to the given patient", type="reference")
    public static final String SP_LINK = "link";
    @SearchParamDefinition(name="language", path="Patient.communication.language", description="Language code (irrespective of use value)", type="token")
    public static final String SP_LANGUAGE = "language";
    @SearchParamDefinition(name="deathdate", path="Patient.deceasedDateTime", description="The date of death has been provided and satisfies this search value", type="date")
    public static final String SP_DEATHDATE = "deathdate";
    @SearchParamDefinition(name="animal-breed", path="Patient.animal.breed", description="The breed for animal patients", type="token")
    public static final String SP_ANIMALBREED = "animal-breed";
    @SearchParamDefinition(name="address-country", path="Patient.address.country", description="A country specified in an address", type="string")
    public static final String SP_ADDRESSCOUNTRY = "address-country";
    @SearchParamDefinition(name="phonetic", path="Patient.name", description="A portion of either family or given name using some kind of phonetic matching algorithm", type="string")
    public static final String SP_PHONETIC = "phonetic";
    @SearchParamDefinition(name="telecom", path="Patient.telecom", description="The value in any kind of telecom details of the patient", type="token")
    public static final String SP_TELECOM = "telecom";
    @SearchParamDefinition(name="address-city", path="Patient.address.city", description="A city specified in an address", type="string")
    public static final String SP_ADDRESSCITY = "address-city";
    @SearchParamDefinition(name="email", path="Patient.telecom.where(system='email')", description="A value in an email contact", type="token")
    public static final String SP_EMAIL = "email";
    @SearchParamDefinition(name="identifier", path="Patient.identifier", description="A patient identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="given", path="Patient.name.given", description="A portion of the given name of the patient", type="string")
    public static final String SP_GIVEN = "given";
    @SearchParamDefinition(name="address", path="Patient.address", description="An address in any kind of address/part of the patient", type="string")
    public static final String SP_ADDRESS = "address";
    @SearchParamDefinition(name="active", path="Patient.active", description="Whether the patient record is active", type="token")
    public static final String SP_ACTIVE = "active";
    @SearchParamDefinition(name="address-postalcode", path="Patient.address.postalCode", description="A postalCode specified in an address", type="string")
    public static final String SP_ADDRESSPOSTALCODE = "address-postalcode";
    @SearchParamDefinition(name="careprovider", path="Patient.careProvider", description="Patient's nominated care provider, could be a care manager, not the organization that manages the record", type="reference")
    public static final String SP_CAREPROVIDER = "careprovider";
    @SearchParamDefinition(name="phone", path="Patient.telecom.where(system='phone')", description="A value in a phone contact", type="token")
    public static final String SP_PHONE = "phone";
    @SearchParamDefinition(name="organization", path="Patient.managingOrganization", description="The organization at which this person is a patient", type="reference")
    public static final String SP_ORGANIZATION = "organization";
    @SearchParamDefinition(name="name", path="Patient.name", description="A portion of either family or given name of the patient", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="address-use", path="Patient.address.use", description="A use code specified in an address", type="token")
    public static final String SP_ADDRESSUSE = "address-use";
    @SearchParamDefinition(name="family", path="Patient.name.family", description="A portion of the family name of the patient", type="string")
    public static final String SP_FAMILY = "family";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Patient addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public Patient setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public Patient setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public List<HumanName> getName() {
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        return this.name;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (HumanName item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HumanName addName() {
        HumanName t = new HumanName();
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return t;
    }

    public Patient addName(HumanName t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return this;
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public Patient addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public Patient setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public Patient setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public DateType getBirthDateElement() {
        if (this.birthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.birthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.birthDate = new DateType();
            }
        }
        return this.birthDate;
    }

    public boolean hasBirthDateElement() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public boolean hasBirthDate() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public Patient setBirthDateElement(DateType value) {
        this.birthDate = value;
        return this;
    }

    public Date getBirthDate() {
        return this.birthDate == null ? null : (Date)this.birthDate.getValue();
    }

    public Patient setBirthDate(Date value) {
        if (value == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateType();
            }
            this.birthDate.setValue(value);
        }
        return this;
    }

    public Type getDeceased() {
        return this.deceased;
    }

    public BooleanType getDeceasedBooleanType() throws FHIRException {
        if (!(this.deceased instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.deceased;
    }

    public boolean hasDeceasedBooleanType() {
        return this.deceased instanceof BooleanType;
    }

    public DateTimeType getDeceasedDateTimeType() throws FHIRException {
        if (!(this.deceased instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.deceased.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.deceased;
    }

    public boolean hasDeceasedDateTimeType() {
        return this.deceased instanceof DateTimeType;
    }

    public boolean hasDeceased() {
        return this.deceased != null && !this.deceased.isEmpty();
    }

    public Patient setDeceased(Type value) {
        this.deceased = value;
        return this;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public Patient addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public CodeableConcept getMaritalStatus() {
        if (this.maritalStatus == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.maritalStatus");
            }
            if (Configuration.doAutoCreate()) {
                this.maritalStatus = new CodeableConcept();
            }
        }
        return this.maritalStatus;
    }

    public boolean hasMaritalStatus() {
        return this.maritalStatus != null && !this.maritalStatus.isEmpty();
    }

    public Patient setMaritalStatus(CodeableConcept value) {
        this.maritalStatus = value;
        return this;
    }

    public Type getMultipleBirth() {
        return this.multipleBirth;
    }

    public BooleanType getMultipleBirthBooleanType() throws FHIRException {
        if (!(this.multipleBirth instanceof BooleanType)) {
            throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.multipleBirth.getClass().getName() + " was encountered");
        }
        return (BooleanType)this.multipleBirth;
    }

    public boolean hasMultipleBirthBooleanType() {
        return this.multipleBirth instanceof BooleanType;
    }

    public IntegerType getMultipleBirthIntegerType() throws FHIRException {
        if (!(this.multipleBirth instanceof IntegerType)) {
            throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.multipleBirth.getClass().getName() + " was encountered");
        }
        return (IntegerType)this.multipleBirth;
    }

    public boolean hasMultipleBirthIntegerType() {
        return this.multipleBirth instanceof IntegerType;
    }

    public boolean hasMultipleBirth() {
        return this.multipleBirth != null && !this.multipleBirth.isEmpty();
    }

    public Patient setMultipleBirth(Type value) {
        this.multipleBirth = value;
        return this;
    }

    public List<Attachment> getPhoto() {
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        return this.photo;
    }

    public boolean hasPhoto() {
        if (this.photo == null) {
            return false;
        }
        for (Attachment item : this.photo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPhoto() {
        Attachment t = new Attachment();
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return t;
    }

    public Patient addPhoto(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return this;
    }

    public List<ContactComponent> getContact() {
        if (this.contact == null) {
            this.contact = new ArrayList<ContactComponent>();
        }
        return this.contact;
    }

    public boolean hasContact() {
        if (this.contact == null) {
            return false;
        }
        for (ContactComponent item : this.contact) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactComponent addContact() {
        ContactComponent t = new ContactComponent();
        if (this.contact == null) {
            this.contact = new ArrayList<ContactComponent>();
        }
        this.contact.add(t);
        return t;
    }

    public Patient addContact(ContactComponent t) {
        if (t == null) {
            return this;
        }
        if (this.contact == null) {
            this.contact = new ArrayList<ContactComponent>();
        }
        this.contact.add(t);
        return this;
    }

    public AnimalComponent getAnimal() {
        if (this.animal == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.animal");
            }
            if (Configuration.doAutoCreate()) {
                this.animal = new AnimalComponent();
            }
        }
        return this.animal;
    }

    public boolean hasAnimal() {
        return this.animal != null && !this.animal.isEmpty();
    }

    public Patient setAnimal(AnimalComponent value) {
        this.animal = value;
        return this;
    }

    public List<PatientCommunicationComponent> getCommunication() {
        if (this.communication == null) {
            this.communication = new ArrayList<PatientCommunicationComponent>();
        }
        return this.communication;
    }

    public boolean hasCommunication() {
        if (this.communication == null) {
            return false;
        }
        for (PatientCommunicationComponent item : this.communication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PatientCommunicationComponent addCommunication() {
        PatientCommunicationComponent t = new PatientCommunicationComponent();
        if (this.communication == null) {
            this.communication = new ArrayList<PatientCommunicationComponent>();
        }
        this.communication.add(t);
        return t;
    }

    public Patient addCommunication(PatientCommunicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.communication == null) {
            this.communication = new ArrayList<PatientCommunicationComponent>();
        }
        this.communication.add(t);
        return this;
    }

    public List<Reference> getCareProvider() {
        if (this.careProvider == null) {
            this.careProvider = new ArrayList<Reference>();
        }
        return this.careProvider;
    }

    public boolean hasCareProvider() {
        if (this.careProvider == null) {
            return false;
        }
        for (Reference item : this.careProvider) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addCareProvider() {
        Reference t = new Reference();
        if (this.careProvider == null) {
            this.careProvider = new ArrayList<Reference>();
        }
        this.careProvider.add(t);
        return t;
    }

    public Patient addCareProvider(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.careProvider == null) {
            this.careProvider = new ArrayList<Reference>();
        }
        this.careProvider.add(t);
        return this;
    }

    public List<Resource> getCareProviderTarget() {
        if (this.careProviderTarget == null) {
            this.careProviderTarget = new ArrayList<Resource>();
        }
        return this.careProviderTarget;
    }

    public Reference getManagingOrganization() {
        if (this.managingOrganization == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganization = new Reference();
            }
        }
        return this.managingOrganization;
    }

    public boolean hasManagingOrganization() {
        return this.managingOrganization != null && !this.managingOrganization.isEmpty();
    }

    public Patient setManagingOrganization(Reference value) {
        this.managingOrganization = value;
        return this;
    }

    public Organization getManagingOrganizationTarget() {
        if (this.managingOrganizationTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Patient.managingOrganization");
            }
            if (Configuration.doAutoCreate()) {
                this.managingOrganizationTarget = new Organization();
            }
        }
        return this.managingOrganizationTarget;
    }

    public Patient setManagingOrganizationTarget(Organization value) {
        this.managingOrganizationTarget = value;
        return this;
    }

    public List<PatientLinkComponent> getLink() {
        if (this.link == null) {
            this.link = new ArrayList<PatientLinkComponent>();
        }
        return this.link;
    }

    public boolean hasLink() {
        if (this.link == null) {
            return false;
        }
        for (PatientLinkComponent item : this.link) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public PatientLinkComponent addLink() {
        PatientLinkComponent t = new PatientLinkComponent();
        if (this.link == null) {
            this.link = new ArrayList<PatientLinkComponent>();
        }
        this.link.add(t);
        return t;
    }

    public Patient addLink(PatientLinkComponent t) {
        if (t == null) {
            return this;
        }
        if (this.link == null) {
            this.link = new ArrayList<PatientLinkComponent>();
        }
        this.link.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "An identifier for this patient.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_ACTIVE, "boolean", "Whether this patient record is in active use.", 0, Integer.MAX_VALUE, this.active));
        childrenList.add(new Property(SP_NAME, "HumanName", "A name associated with the individual.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_TELECOM, "ContactPoint", "A contact detail (e.g. a telephone number or an email address) by which the individual may be contacted.", 0, Integer.MAX_VALUE, this.telecom));
        childrenList.add(new Property(SP_GENDER, "code", "Administrative Gender - the gender that the patient is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
        childrenList.add(new Property("birthDate", "date", "The date of birth for the individual.", 0, Integer.MAX_VALUE, this.birthDate));
        childrenList.add(new Property("deceased[x]", "boolean|dateTime", "Indicates if the individual is deceased or not.", 0, Integer.MAX_VALUE, this.deceased));
        childrenList.add(new Property(SP_ADDRESS, "Address", "Addresses for the individual.", 0, Integer.MAX_VALUE, this.address));
        childrenList.add(new Property("maritalStatus", "CodeableConcept", "This field contains a patient's most recent marital (civil) status.", 0, Integer.MAX_VALUE, this.maritalStatus));
        childrenList.add(new Property("multipleBirth[x]", "boolean|integer", "Indicates whether the patient is part of a multiple or indicates the actual birth order.", 0, Integer.MAX_VALUE, this.multipleBirth));
        childrenList.add(new Property("photo", "Attachment", "Image of the patient.", 0, Integer.MAX_VALUE, this.photo));
        childrenList.add(new Property("contact", "", "A contact party (e.g. guardian, partner, friend) for the patient.", 0, Integer.MAX_VALUE, this.contact));
        childrenList.add(new Property("animal", "", "This patient is known to be an animal.", 0, Integer.MAX_VALUE, this.animal));
        childrenList.add(new Property("communication", "", "Languages which may be used to communicate with the patient about his or her health.", 0, Integer.MAX_VALUE, this.communication));
        childrenList.add(new Property("careProvider", "Reference(Organization|Practitioner)", "Patient's nominated care provider.", 0, Integer.MAX_VALUE, this.careProvider));
        childrenList.add(new Property("managingOrganization", "Reference(Organization)", "Organization that is the custodian of the patient record.", 0, Integer.MAX_VALUE, this.managingOrganization));
        childrenList.add(new Property(SP_LINK, "", "Link to another patient resource that concerns the same actual patient.", 0, Integer.MAX_VALUE, this.link));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = this.castToBoolean(value);
        } else if (name.equals(SP_NAME)) {
            this.getName().add(this.castToHumanName(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(this.castToContactPoint(value));
        } else if (name.equals(SP_GENDER)) {
            this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
        } else if (name.equals("birthDate")) {
            this.birthDate = this.castToDate(value);
        } else if (name.equals("deceased[x]")) {
            this.deceased = (Type)value;
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(this.castToAddress(value));
        } else if (name.equals("maritalStatus")) {
            this.maritalStatus = this.castToCodeableConcept(value);
        } else if (name.equals("multipleBirth[x]")) {
            this.multipleBirth = (Type)value;
        } else if (name.equals("photo")) {
            this.getPhoto().add(this.castToAttachment(value));
        } else if (name.equals("contact")) {
            this.getContact().add((ContactComponent)value);
        } else if (name.equals("animal")) {
            this.animal = (AnimalComponent)value;
        } else if (name.equals("communication")) {
            this.getCommunication().add((PatientCommunicationComponent)value);
        } else if (name.equals("careProvider")) {
            this.getCareProvider().add(this.castToReference(value));
        } else if (name.equals("managingOrganization")) {
            this.managingOrganization = this.castToReference(value);
        } else if (name.equals(SP_LINK)) {
            this.getLink().add((PatientLinkComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a singleton property Patient.active");
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a singleton property Patient.gender");
        }
        if (name.equals("birthDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property Patient.birthDate");
        }
        if (name.equals("deceasedBoolean")) {
            this.deceased = new BooleanType();
            return this.deceased;
        }
        if (name.equals("deceasedDateTime")) {
            this.deceased = new DateTimeType();
            return this.deceased;
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals("maritalStatus")) {
            this.maritalStatus = new CodeableConcept();
            return this.maritalStatus;
        }
        if (name.equals("multipleBirthBoolean")) {
            this.multipleBirth = new BooleanType();
            return this.multipleBirth;
        }
        if (name.equals("multipleBirthInteger")) {
            this.multipleBirth = new IntegerType();
            return this.multipleBirth;
        }
        if (name.equals("photo")) {
            return this.addPhoto();
        }
        if (name.equals("contact")) {
            return this.addContact();
        }
        if (name.equals("animal")) {
            this.animal = new AnimalComponent();
            return this.animal;
        }
        if (name.equals("communication")) {
            return this.addCommunication();
        }
        if (name.equals("careProvider")) {
            return this.addCareProvider();
        }
        if (name.equals("managingOrganization")) {
            this.managingOrganization = new Reference();
            return this.managingOrganization;
        }
        if (name.equals(SP_LINK)) {
            return this.addLink();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Patient";
    }

    @Override
    public Patient copy() {
        Patient dst = new Patient();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        BooleanType booleanType = dst.active = this.active == null ? null : this.active.copy();
        if (this.name != null) {
            dst.name = new ArrayList<HumanName>();
            for (HumanName humanName : this.name) {
                dst.name.add(humanName.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.gender = this.gender == null ? null : this.gender.copy();
        dst.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        Type type = dst.deceased = this.deceased == null ? null : this.deceased.copy();
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        dst.maritalStatus = this.maritalStatus == null ? null : this.maritalStatus.copy();
        Type type2 = dst.multipleBirth = this.multipleBirth == null ? null : this.multipleBirth.copy();
        if (this.photo != null) {
            dst.photo = new ArrayList<Attachment>();
            for (Attachment attachment : this.photo) {
                dst.photo.add(attachment.copy());
            }
        }
        if (this.contact != null) {
            dst.contact = new ArrayList<ContactComponent>();
            for (ContactComponent contactComponent : this.contact) {
                dst.contact.add(contactComponent.copy());
            }
        }
        AnimalComponent animalComponent = dst.animal = this.animal == null ? null : this.animal.copy();
        if (this.communication != null) {
            dst.communication = new ArrayList<PatientCommunicationComponent>();
            for (PatientCommunicationComponent patientCommunicationComponent : this.communication) {
                dst.communication.add(patientCommunicationComponent.copy());
            }
        }
        if (this.careProvider != null) {
            dst.careProvider = new ArrayList<Reference>();
            for (Reference reference : this.careProvider) {
                dst.careProvider.add(reference.copy());
            }
        }
        Reference reference = dst.managingOrganization = this.managingOrganization == null ? null : this.managingOrganization.copy();
        if (this.link != null) {
            dst.link = new ArrayList<PatientLinkComponent>();
            for (PatientLinkComponent patientLinkComponent : this.link) {
                dst.link.add(patientLinkComponent.copy());
            }
        }
        return dst;
    }

    protected Patient typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Patient)) {
            return false;
        }
        Patient o = (Patient)other;
        return Patient.compareDeep(this.identifier, o.identifier, true) && Patient.compareDeep(this.active, o.active, true) && Patient.compareDeep(this.name, o.name, true) && Patient.compareDeep(this.telecom, o.telecom, true) && Patient.compareDeep(this.gender, o.gender, true) && Patient.compareDeep(this.birthDate, o.birthDate, true) && Patient.compareDeep(this.deceased, o.deceased, true) && Patient.compareDeep(this.address, o.address, true) && Patient.compareDeep(this.maritalStatus, o.maritalStatus, true) && Patient.compareDeep(this.multipleBirth, o.multipleBirth, true) && Patient.compareDeep(this.photo, o.photo, true) && Patient.compareDeep(this.contact, o.contact, true) && Patient.compareDeep(this.animal, o.animal, true) && Patient.compareDeep(this.communication, o.communication, true) && Patient.compareDeep(this.careProvider, o.careProvider, true) && Patient.compareDeep(this.managingOrganization, o.managingOrganization, true) && Patient.compareDeep(this.link, o.link, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Patient)) {
            return false;
        }
        Patient o = (Patient)other;
        return Patient.compareValues(this.active, o.active, true) && Patient.compareValues(this.gender, o.gender, true) && Patient.compareValues(this.birthDate, o.birthDate, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.active != null && !this.active.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.gender != null && !this.gender.isEmpty() || this.birthDate != null && !this.birthDate.isEmpty() || this.deceased != null && !this.deceased.isEmpty() || this.address != null && !this.address.isEmpty() || this.maritalStatus != null && !this.maritalStatus.isEmpty() || this.multipleBirth != null && !this.multipleBirth.isEmpty() || this.photo != null && !this.photo.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.animal != null && !this.animal.isEmpty() || this.communication != null && !this.communication.isEmpty() || this.careProvider != null && !this.careProvider.isEmpty() || this.managingOrganization != null && !this.managingOrganization.isEmpty() || this.link != null && !this.link.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Patient;
    }

    @Block
    public static class PatientLinkComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="other", type={Patient.class}, order=1, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="The other patient resource that the link refers to", formalDefinition="The other patient resource that the link refers to.")
        protected Reference other;
        protected Patient otherTarget;
        @Child(name="type", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=false)
        @Description(shortDefinition="replace | refer | seealso - type of link", formalDefinition="The type of link between this patient resource and another patient resource.")
        protected Enumeration<LinkType> type;
        private static final long serialVersionUID = -1942104050L;

        public PatientLinkComponent() {
        }

        public PatientLinkComponent(Reference other, Enumeration<LinkType> type) {
            this.other = other;
            this.type = type;
        }

        public Reference getOther() {
            if (this.other == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientLinkComponent.other");
                }
                if (Configuration.doAutoCreate()) {
                    this.other = new Reference();
                }
            }
            return this.other;
        }

        public boolean hasOther() {
            return this.other != null && !this.other.isEmpty();
        }

        public PatientLinkComponent setOther(Reference value) {
            this.other = value;
            return this;
        }

        public Patient getOtherTarget() {
            if (this.otherTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientLinkComponent.other");
                }
                if (Configuration.doAutoCreate()) {
                    this.otherTarget = new Patient();
                }
            }
            return this.otherTarget;
        }

        public PatientLinkComponent setOtherTarget(Patient value) {
            this.otherTarget = value;
            return this;
        }

        public Enumeration<LinkType> getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientLinkComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Enumeration<LinkType>(new LinkTypeEnumFactory());
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public PatientLinkComponent setTypeElement(Enumeration<LinkType> value) {
            this.type = value;
            return this;
        }

        public LinkType getType() {
            return this.type == null ? null : (LinkType)((Object)this.type.getValue());
        }

        public PatientLinkComponent setType(LinkType value) {
            if (this.type == null) {
                this.type = new Enumeration<LinkType>(new LinkTypeEnumFactory());
            }
            this.type.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("other", "Reference(Patient)", "The other patient resource that the link refers to.", 0, Integer.MAX_VALUE, this.other));
            childrenList.add(new Property("type", "code", "The type of link between this patient resource and another patient resource.", 0, Integer.MAX_VALUE, this.type));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("other")) {
                this.other = this.castToReference(value);
            } else if (name.equals("type")) {
                this.type = new LinkTypeEnumFactory().fromType(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("other")) {
                this.other = new Reference();
                return this.other;
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a singleton property Patient.type");
            }
            return super.addChild(name);
        }

        @Override
        public PatientLinkComponent copy() {
            PatientLinkComponent dst = new PatientLinkComponent();
            this.copyValues(dst);
            dst.other = this.other == null ? null : this.other.copy();
            dst.type = this.type == null ? null : this.type.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PatientLinkComponent)) {
                return false;
            }
            PatientLinkComponent o = (PatientLinkComponent)other;
            return PatientLinkComponent.compareDeep(other, o.other, true) && PatientLinkComponent.compareDeep(this.type, o.type, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PatientLinkComponent)) {
                return false;
            }
            PatientLinkComponent o = (PatientLinkComponent)other;
            return PatientLinkComponent.compareValues(this.type, o.type, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.other != null && !this.other.isEmpty() || this.type != null && !this.type.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Patient.link";
        }
    }

    @Block
    public static class PatientCommunicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The language which can be used to communicate with the patient about his or her health", formalDefinition="The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.")
        protected CodeableConcept language;
        @Child(name="preferred", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language preference indicator", formalDefinition="Indicates whether or not the patient prefers this language (over other languages he masters up a certain level).")
        protected BooleanType preferred;
        private static final long serialVersionUID = 633792918L;

        public PatientCommunicationComponent() {
        }

        public PatientCommunicationComponent(CodeableConcept language) {
            this.language = language;
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientCommunicationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public PatientCommunicationComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public BooleanType getPreferredElement() {
            if (this.preferred == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create PatientCommunicationComponent.preferred");
                }
                if (Configuration.doAutoCreate()) {
                    this.preferred = new BooleanType();
                }
            }
            return this.preferred;
        }

        public boolean hasPreferredElement() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public boolean hasPreferred() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public PatientCommunicationComponent setPreferredElement(BooleanType value) {
            this.preferred = value;
            return this;
        }

        public boolean getPreferred() {
            return this.preferred == null || this.preferred.isEmpty() ? false : (Boolean)this.preferred.getValue();
        }

        public PatientCommunicationComponent setPreferred(boolean value) {
            if (this.preferred == null) {
                this.preferred = new BooleanType();
            }
            this.preferred.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Patient.SP_LANGUAGE, "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-EN\" for England English.", 0, Integer.MAX_VALUE, this.language));
            childrenList.add(new Property("preferred", "boolean", "Indicates whether or not the patient prefers this language (over other languages he masters up a certain level).", 0, Integer.MAX_VALUE, this.preferred));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Patient.SP_LANGUAGE)) {
                this.language = this.castToCodeableConcept(value);
            } else if (name.equals("preferred")) {
                this.preferred = this.castToBoolean(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Patient.SP_LANGUAGE)) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("preferred")) {
                throw new FHIRException("Cannot call addChild on a singleton property Patient.preferred");
            }
            return super.addChild(name);
        }

        @Override
        public PatientCommunicationComponent copy() {
            PatientCommunicationComponent dst = new PatientCommunicationComponent();
            this.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.preferred = this.preferred == null ? null : this.preferred.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof PatientCommunicationComponent)) {
                return false;
            }
            PatientCommunicationComponent o = (PatientCommunicationComponent)other;
            return PatientCommunicationComponent.compareDeep(this.language, o.language, true) && PatientCommunicationComponent.compareDeep(this.preferred, o.preferred, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof PatientCommunicationComponent)) {
                return false;
            }
            PatientCommunicationComponent o = (PatientCommunicationComponent)other;
            return PatientCommunicationComponent.compareValues(this.preferred, o.preferred, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.language != null && !this.language.isEmpty() || this.preferred != null && !this.preferred.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Patient.communication";
        }
    }

    @Block
    public static class AnimalComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="species", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="E.g. Dog, Cow", formalDefinition="Identifies the high level taxonomic categorization of the kind of animal.")
        protected CodeableConcept species;
        @Child(name="breed", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="E.g. Poodle, Angus", formalDefinition="Identifies the detailed categorization of the kind of animal.")
        protected CodeableConcept breed;
        @Child(name="genderStatus", type={CodeableConcept.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="E.g. Neutered, Intact", formalDefinition="Indicates the current state of the animal's reproductive organs.")
        protected CodeableConcept genderStatus;
        private static final long serialVersionUID = -549738382L;

        public AnimalComponent() {
        }

        public AnimalComponent(CodeableConcept species) {
            this.species = species;
        }

        public CodeableConcept getSpecies() {
            if (this.species == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AnimalComponent.species");
                }
                if (Configuration.doAutoCreate()) {
                    this.species = new CodeableConcept();
                }
            }
            return this.species;
        }

        public boolean hasSpecies() {
            return this.species != null && !this.species.isEmpty();
        }

        public AnimalComponent setSpecies(CodeableConcept value) {
            this.species = value;
            return this;
        }

        public CodeableConcept getBreed() {
            if (this.breed == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AnimalComponent.breed");
                }
                if (Configuration.doAutoCreate()) {
                    this.breed = new CodeableConcept();
                }
            }
            return this.breed;
        }

        public boolean hasBreed() {
            return this.breed != null && !this.breed.isEmpty();
        }

        public AnimalComponent setBreed(CodeableConcept value) {
            this.breed = value;
            return this;
        }

        public CodeableConcept getGenderStatus() {
            if (this.genderStatus == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create AnimalComponent.genderStatus");
                }
                if (Configuration.doAutoCreate()) {
                    this.genderStatus = new CodeableConcept();
                }
            }
            return this.genderStatus;
        }

        public boolean hasGenderStatus() {
            return this.genderStatus != null && !this.genderStatus.isEmpty();
        }

        public AnimalComponent setGenderStatus(CodeableConcept value) {
            this.genderStatus = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("species", "CodeableConcept", "Identifies the high level taxonomic categorization of the kind of animal.", 0, Integer.MAX_VALUE, this.species));
            childrenList.add(new Property("breed", "CodeableConcept", "Identifies the detailed categorization of the kind of animal.", 0, Integer.MAX_VALUE, this.breed));
            childrenList.add(new Property("genderStatus", "CodeableConcept", "Indicates the current state of the animal's reproductive organs.", 0, Integer.MAX_VALUE, this.genderStatus));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("species")) {
                this.species = this.castToCodeableConcept(value);
            } else if (name.equals("breed")) {
                this.breed = this.castToCodeableConcept(value);
            } else if (name.equals("genderStatus")) {
                this.genderStatus = this.castToCodeableConcept(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("species")) {
                this.species = new CodeableConcept();
                return this.species;
            }
            if (name.equals("breed")) {
                this.breed = new CodeableConcept();
                return this.breed;
            }
            if (name.equals("genderStatus")) {
                this.genderStatus = new CodeableConcept();
                return this.genderStatus;
            }
            return super.addChild(name);
        }

        @Override
        public AnimalComponent copy() {
            AnimalComponent dst = new AnimalComponent();
            this.copyValues(dst);
            dst.species = this.species == null ? null : this.species.copy();
            dst.breed = this.breed == null ? null : this.breed.copy();
            dst.genderStatus = this.genderStatus == null ? null : this.genderStatus.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof AnimalComponent)) {
                return false;
            }
            AnimalComponent o = (AnimalComponent)other;
            return AnimalComponent.compareDeep(this.species, o.species, true) && AnimalComponent.compareDeep(this.breed, o.breed, true) && AnimalComponent.compareDeep(this.genderStatus, o.genderStatus, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof AnimalComponent)) {
                return false;
            }
            AnimalComponent o = (AnimalComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.species != null && !this.species.isEmpty() || this.breed != null && !this.breed.isEmpty() || this.genderStatus != null && !this.genderStatus.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Patient.animal";
        }
    }

    @Block
    public static class ContactComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="relationship", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The kind of relationship", formalDefinition="The nature of the relationship between the patient and the contact person.")
        protected List<CodeableConcept> relationship;
        @Child(name="name", type={HumanName.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="A name associated with the contact person", formalDefinition="A name associated with the contact person.")
        protected HumanName name;
        @Child(name="telecom", type={ContactPoint.class}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="A contact detail for the person", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
        protected List<ContactPoint> telecom;
        @Child(name="address", type={Address.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Address for the contact person", formalDefinition="Address for the contact person.")
        protected Address address;
        @Child(name="gender", type={CodeType.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the contact person is considered to have for administration and record keeping purposes.")
        protected Enumeration<Enumerations.AdministrativeGender> gender;
        @Child(name="organization", type={Organization.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Organization that is associated with the contact", formalDefinition="Organization on behalf of which the contact is acting or for which the contact is working.")
        protected Reference organization;
        protected Organization organizationTarget;
        @Child(name="period", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The period during which this contact person or organization is valid to be contacted relating to this patient", formalDefinition="The period during which this contact person or organization is valid to be contacted relating to this patient.")
        protected Period period;
        private static final long serialVersionUID = 364269017L;

        public List<CodeableConcept> getRelationship() {
            if (this.relationship == null) {
                this.relationship = new ArrayList<CodeableConcept>();
            }
            return this.relationship;
        }

        public boolean hasRelationship() {
            if (this.relationship == null) {
                return false;
            }
            for (CodeableConcept item : this.relationship) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRelationship() {
            CodeableConcept t = new CodeableConcept();
            if (this.relationship == null) {
                this.relationship = new ArrayList<CodeableConcept>();
            }
            this.relationship.add(t);
            return t;
        }

        public ContactComponent addRelationship(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.relationship == null) {
                this.relationship = new ArrayList<CodeableConcept>();
            }
            this.relationship.add(t);
            return this;
        }

        public HumanName getName() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new HumanName();
                }
            }
            return this.name;
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public ContactComponent setName(HumanName value) {
            this.name = value;
            return this;
        }

        public List<ContactPoint> getTelecom() {
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            return this.telecom;
        }

        public boolean hasTelecom() {
            if (this.telecom == null) {
                return false;
            }
            for (ContactPoint item : this.telecom) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ContactPoint addTelecom() {
            ContactPoint t = new ContactPoint();
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return t;
        }

        public ContactComponent addTelecom(ContactPoint t) {
            if (t == null) {
                return this;
            }
            if (this.telecom == null) {
                this.telecom = new ArrayList<ContactPoint>();
            }
            this.telecom.add(t);
            return this;
        }

        public Address getAddress() {
            if (this.address == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.address");
                }
                if (Configuration.doAutoCreate()) {
                    this.address = new Address();
                }
            }
            return this.address;
        }

        public boolean hasAddress() {
            return this.address != null && !this.address.isEmpty();
        }

        public ContactComponent setAddress(Address value) {
            this.address = value;
            return this;
        }

        public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
            if (this.gender == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.gender");
                }
                if (Configuration.doAutoCreate()) {
                    this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
                }
            }
            return this.gender;
        }

        public boolean hasGenderElement() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public boolean hasGender() {
            return this.gender != null && !this.gender.isEmpty();
        }

        public ContactComponent setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
            this.gender = value;
            return this;
        }

        public Enumerations.AdministrativeGender getGender() {
            return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
        }

        public ContactComponent setGender(Enumerations.AdministrativeGender value) {
            if (value == null) {
                this.gender = null;
            } else {
                if (this.gender == null) {
                    this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
                }
                this.gender.setValue((Object)value);
            }
            return this;
        }

        public Reference getOrganization() {
            if (this.organization == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organization = new Reference();
                }
            }
            return this.organization;
        }

        public boolean hasOrganization() {
            return this.organization != null && !this.organization.isEmpty();
        }

        public ContactComponent setOrganization(Reference value) {
            this.organization = value;
            return this;
        }

        public Organization getOrganizationTarget() {
            if (this.organizationTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.organization");
                }
                if (Configuration.doAutoCreate()) {
                    this.organizationTarget = new Organization();
                }
            }
            return this.organizationTarget;
        }

        public ContactComponent setOrganizationTarget(Organization value) {
            this.organizationTarget = value;
            return this;
        }

        public Period getPeriod() {
            if (this.period == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ContactComponent.period");
                }
                if (Configuration.doAutoCreate()) {
                    this.period = new Period();
                }
            }
            return this.period;
        }

        public boolean hasPeriod() {
            return this.period != null && !this.period.isEmpty();
        }

        public ContactComponent setPeriod(Period value) {
            this.period = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("relationship", "CodeableConcept", "The nature of the relationship between the patient and the contact person.", 0, Integer.MAX_VALUE, this.relationship));
            childrenList.add(new Property(Patient.SP_NAME, "HumanName", "A name associated with the contact person.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(Patient.SP_TELECOM, "ContactPoint", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
            childrenList.add(new Property(Patient.SP_ADDRESS, "Address", "Address for the contact person.", 0, Integer.MAX_VALUE, this.address));
            childrenList.add(new Property(Patient.SP_GENDER, "code", "Administrative Gender - the gender that the contact person is considered to have for administration and record keeping purposes.", 0, Integer.MAX_VALUE, this.gender));
            childrenList.add(new Property(Patient.SP_ORGANIZATION, "Reference(Organization)", "Organization on behalf of which the contact is acting or for which the contact is working.", 0, Integer.MAX_VALUE, this.organization));
            childrenList.add(new Property("period", "Period", "The period during which this contact person or organization is valid to be contacted relating to this patient.", 0, Integer.MAX_VALUE, this.period));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("relationship")) {
                this.getRelationship().add(this.castToCodeableConcept(value));
            } else if (name.equals(Patient.SP_NAME)) {
                this.name = this.castToHumanName(value);
            } else if (name.equals(Patient.SP_TELECOM)) {
                this.getTelecom().add(this.castToContactPoint(value));
            } else if (name.equals(Patient.SP_ADDRESS)) {
                this.address = this.castToAddress(value);
            } else if (name.equals(Patient.SP_GENDER)) {
                this.gender = new Enumerations.AdministrativeGenderEnumFactory().fromType(value);
            } else if (name.equals(Patient.SP_ORGANIZATION)) {
                this.organization = this.castToReference(value);
            } else if (name.equals("period")) {
                this.period = this.castToPeriod(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("relationship")) {
                return this.addRelationship();
            }
            if (name.equals(Patient.SP_NAME)) {
                this.name = new HumanName();
                return this.name;
            }
            if (name.equals(Patient.SP_TELECOM)) {
                return this.addTelecom();
            }
            if (name.equals(Patient.SP_ADDRESS)) {
                this.address = new Address();
                return this.address;
            }
            if (name.equals(Patient.SP_GENDER)) {
                throw new FHIRException("Cannot call addChild on a singleton property Patient.gender");
            }
            if (name.equals(Patient.SP_ORGANIZATION)) {
                this.organization = new Reference();
                return this.organization;
            }
            if (name.equals("period")) {
                this.period = new Period();
                return this.period;
            }
            return super.addChild(name);
        }

        @Override
        public ContactComponent copy() {
            ContactComponent dst = new ContactComponent();
            this.copyValues(dst);
            if (this.relationship != null) {
                dst.relationship = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.relationship) {
                    dst.relationship.add(codeableConcept.copy());
                }
            }
            HumanName humanName = dst.name = this.name == null ? null : this.name.copy();
            if (this.telecom != null) {
                dst.telecom = new ArrayList<ContactPoint>();
                for (ContactPoint contactPoint : this.telecom) {
                    dst.telecom.add(contactPoint.copy());
                }
            }
            dst.address = this.address == null ? null : this.address.copy();
            dst.gender = this.gender == null ? null : this.gender.copy();
            dst.organization = this.organization == null ? null : this.organization.copy();
            dst.period = this.period == null ? null : this.period.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ContactComponent)) {
                return false;
            }
            ContactComponent o = (ContactComponent)other;
            return ContactComponent.compareDeep(this.relationship, o.relationship, true) && ContactComponent.compareDeep(this.name, o.name, true) && ContactComponent.compareDeep(this.telecom, o.telecom, true) && ContactComponent.compareDeep(this.address, o.address, true) && ContactComponent.compareDeep(this.gender, o.gender, true) && ContactComponent.compareDeep(this.organization, o.organization, true) && ContactComponent.compareDeep(this.period, o.period, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ContactComponent)) {
                return false;
            }
            ContactComponent o = (ContactComponent)other;
            return ContactComponent.compareValues(this.gender, o.gender, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.relationship != null && !this.relationship.isEmpty() || this.name != null && !this.name.isEmpty() || this.telecom != null && !this.telecom.isEmpty() || this.address != null && !this.address.isEmpty() || this.gender != null && !this.gender.isEmpty() || this.organization != null && !this.organization.isEmpty() || this.period != null && !this.period.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Patient.contact";
        }
    }

    public static class LinkTypeEnumFactory
    implements EnumFactory<LinkType> {
        @Override
        public LinkType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("replace".equals(codeString)) {
                return LinkType.REPLACE;
            }
            if ("refer".equals(codeString)) {
                return LinkType.REFER;
            }
            if ("seealso".equals(codeString)) {
                return LinkType.SEEALSO;
            }
            throw new IllegalArgumentException("Unknown LinkType code '" + codeString + "'");
        }

        public Enumeration<LinkType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replace".equals(codeString)) {
                return new Enumeration<LinkType>(this, LinkType.REPLACE);
            }
            if ("refer".equals(codeString)) {
                return new Enumeration<LinkType>(this, LinkType.REFER);
            }
            if ("seealso".equals(codeString)) {
                return new Enumeration<LinkType>(this, LinkType.SEEALSO);
            }
            throw new FHIRException("Unknown LinkType code '" + codeString + "'");
        }

        @Override
        public String toCode(LinkType code) {
            if (code == LinkType.REPLACE) {
                return "replace";
            }
            if (code == LinkType.REFER) {
                return "refer";
            }
            if (code == LinkType.SEEALSO) {
                return "seealso";
            }
            return "?";
        }
    }

    public static enum LinkType {
        REPLACE,
        REFER,
        SEEALSO,
        NULL;


        public static LinkType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("replace".equals(codeString)) {
                return REPLACE;
            }
            if ("refer".equals(codeString)) {
                return REFER;
            }
            if ("seealso".equals(codeString)) {
                return SEEALSO;
            }
            throw new FHIRException("Unknown LinkType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REPLACE: {
                    return "replace";
                }
                case REFER: {
                    return "refer";
                }
                case SEEALSO: {
                    return "seealso";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REPLACE: {
                    return "http://hl7.org/fhir/link-type";
                }
                case REFER: {
                    return "http://hl7.org/fhir/link-type";
                }
                case SEEALSO: {
                    return "http://hl7.org/fhir/link-type";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REPLACE: {
                    return "The patient resource containing this link must no longer be used. The link points forward to another patient resource that must be used in lieu of the patient resource that contains this link.";
                }
                case REFER: {
                    return "The patient resource containing this link is in use and valid but not considered the main source of information about a patient. The link points forward to another patient resource that should be consulted to retrieve additional patient information.";
                }
                case SEEALSO: {
                    return "The patient resource containing this link is in use and valid, but points to another patient resource that is known to contain data about the same person. Data in this resource might overlap or contradict information found in the other patient resource. This link does not indicate any relative importance of the resources concerned, and both should be regarded as equally valid.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REPLACE: {
                    return "Replace";
                }
                case REFER: {
                    return "Refer";
                }
                case SEEALSO: {
                    return "See also";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

