/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.ConceptMap;
import org.hl7.fhir.dstu2.model.Conformance;
import org.hl7.fhir.dstu2.model.Extension;
import org.hl7.fhir.dstu2.model.Parameters;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.StructureDefinition;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpansionCache;
import org.hl7.fhir.dstu2.utils.IWorkerContext;
import org.hl7.fhir.dstu2.utils.ToolingExtensions;
import org.hl7.fhir.dstu2.utils.client.FHIRToolingClient;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public abstract class BaseWorkerContext
extends I18nBase
implements IWorkerContext {
    protected Map<String, ValueSet> codeSystems = new HashMap<String, ValueSet>();
    protected Map<String, ValueSet> valueSets = new HashMap<String, ValueSet>();
    protected Map<String, ConceptMap> maps = new HashMap<String, ConceptMap>();
    protected ValueSetExpanderFactory expansionCache = new ValueSetExpansionCache(this);
    protected boolean cacheValidation;
    private Set<String> failed = new HashSet<String>();
    protected Map<String, Map<String, IWorkerContext.ValidationResult>> validationCache = new HashMap<String, Map<String, IWorkerContext.ValidationResult>>();
    protected FHIRToolingClient txServer;
    private Locale locale;
    private ResourceBundle i18Nmessages;

    @Override
    public ValueSet fetchCodeSystem(String system) {
        return this.codeSystems.get(system);
    }

    @Override
    public boolean supportsSystem(String system) {
        if (this.codeSystems.containsKey(system)) {
            return true;
        }
        Conformance conf = this.txServer.getConformanceStatement();
        for (Extension ex : ToolingExtensions.getExtensions(conf, "http://hl7.org/fhir/StructureDefinition/conformance-supported-system")) {
            if (!system.equals(((UriType)ex.getValue()).getValue())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ValueSetExpander.ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk) {
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("_limit", "10000");
            params.put("_incomplete", "true");
            params.put("profile", "http://www.healthintersections.com.au/fhir/expansion/no-details");
            ValueSet result = this.txServer.expandValueset(vs, null, params);
            return new ValueSetExpander.ValueSetExpansionOutcome(result);
        }
        catch (Exception e) {
            return new ValueSetExpander.ValueSetExpansionOutcome("Error expanding ValueSet \"" + vs.getUrl() + ": " + e.getMessage());
        }
    }

    private IWorkerContext.ValidationResult handleByCache(ValueSet vs, Coding coding, boolean tryCache) {
        String cacheId = this.cacheId(coding);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        if (cache == null) {
            cache = new HashMap<String, IWorkerContext.ValidationResult>();
            this.validationCache.put(vs.getUrl(), cache);
        }
        if (cache.containsKey(cacheId)) {
            return cache.get(cacheId);
        }
        if (!tryCache) {
            return null;
        }
        if (!this.cacheValidation) {
            return null;
        }
        if (this.failed.contains(vs.getUrl())) {
            return null;
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true);
        if (vse.getValueset() == null || this.notcomplete(vse.getValueset())) {
            this.failed.add(vs.getUrl());
            return null;
        }
        IWorkerContext.ValidationResult res = this.validateCode(coding, vse.getValueset());
        cache.put(cacheId, res);
        return res;
    }

    private boolean notcomplete(ValueSet vs) {
        if (!vs.hasExpansion()) {
            return true;
        }
        if (!vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-unclosed").isEmpty()) {
            return true;
        }
        return !vs.getExpansion().getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-toocostly").isEmpty();
    }

    private IWorkerContext.ValidationResult handleByCache(ValueSet vs, CodeableConcept concept, boolean tryCache) {
        String cacheId = this.cacheId(concept);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        if (cache == null) {
            cache = new HashMap<String, IWorkerContext.ValidationResult>();
            this.validationCache.put(vs.getUrl(), cache);
        }
        if (cache.containsKey(cacheId)) {
            return cache.get(cacheId);
        }
        if (this.validationCache.containsKey(vs.getUrl()) && this.validationCache.get(vs.getUrl()).containsKey(cacheId)) {
            return this.validationCache.get(vs.getUrl()).get(cacheId);
        }
        if (!tryCache) {
            return null;
        }
        if (!this.cacheValidation) {
            return null;
        }
        if (this.failed.contains(vs.getUrl())) {
            return null;
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true);
        if (vse.getValueset() == null || this.notcomplete(vse.getValueset())) {
            this.failed.add(vs.getUrl());
            return null;
        }
        IWorkerContext.ValidationResult res = this.validateCode(concept, vse.getValueset());
        cache.put(cacheId, res);
        return res;
    }

    private String cacheId(Coding coding) {
        return "|" + coding.getSystem() + "|" + coding.getVersion() + "|" + coding.getCode() + "|" + coding.getDisplay();
    }

    private String cacheId(CodeableConcept cc) {
        StringBuilder b = new StringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append("#");
            b.append(this.cacheId(c));
        }
        return b.toString();
    }

    private IWorkerContext.ValidationResult verifyCodeExternal(ValueSet vs, Coding coding, boolean tryCache) {
        IWorkerContext.ValidationResult res = this.handleByCache(vs, coding, tryCache);
        if (res != null) {
            return res;
        }
        Parameters pin = new Parameters();
        pin.addParameter().setName("coding").setValue(coding);
        pin.addParameter().setName("valueSet").setResource(vs);
        res = this.serverValidateCode(pin);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        cache.put(this.cacheId(coding), res);
        return res;
    }

    private IWorkerContext.ValidationResult verifyCodeExternal(ValueSet vs, CodeableConcept cc, boolean tryCache) {
        IWorkerContext.ValidationResult res = this.handleByCache(vs, cc, tryCache);
        if (res != null) {
            return res;
        }
        Parameters pin = new Parameters();
        pin.addParameter().setName("codeableConcept").setValue(cc);
        pin.addParameter().setName("valueSet").setResource(vs);
        res = this.serverValidateCode(pin);
        Map<String, IWorkerContext.ValidationResult> cache = this.validationCache.get(vs.getUrl());
        cache.put(this.cacheId(cc), res);
        return res;
    }

    private IWorkerContext.ValidationResult serverValidateCode(Parameters pin) {
        Parameters pout = this.txServer.operateType(ValueSet.class, "validate-code", pin);
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        for (Parameters.ParametersParameterComponent p : pout.getParameter()) {
            if (p.getName().equals("result")) {
                ok = (Boolean)((BooleanType)p.getValue()).getValue();
                continue;
            }
            if (p.getName().equals("message")) {
                message = (String)((StringType)p.getValue()).getValue();
                continue;
            }
            if (!p.getName().equals("display")) continue;
            display = (String)((StringType)p.getValue()).getValue();
        }
        if (!ok) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, message);
        }
        if (display != null) {
            return new IWorkerContext.ValidationResult(new ValueSet.ConceptDefinitionComponent().setDisplay(display));
        }
        return new IWorkerContext.ValidationResult(null);
    }

    @Override
    public ValueSet.ValueSetExpansionComponent expandVS(ValueSet.ConceptSetComponent inc) {
        ValueSet vs = new ValueSet();
        vs.setCompose(new ValueSet.ValueSetComposeComponent());
        vs.getCompose().getInclude().add(inc);
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expandVS(vs, true);
        return vse.getValueset().getExpansion();
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display) {
        try {
            if (this.codeSystems.containsKey(system)) {
                return this.verifyCodeInternal(this.codeSystems.get(system), system, code, display);
            }
            return this.verifyCodeExternal(null, new Coding().setSystem(system).setCode(code).setDisplay(display), true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(Coding code, ValueSet vs) {
        try {
            if (this.codeSystems.containsKey(code.getSystem()) || vs.hasExpansion()) {
                return this.verifyCodeInternal(this.codeSystems.get(code.getSystem()), code.getSystem(), code.getCode(), code.getDisplay());
            }
            return this.verifyCodeExternal(vs, code, true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + code.getSystem() + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(CodeableConcept code, ValueSet vs) {
        try {
            if (vs.hasCodeSystem() || vs.hasExpansion()) {
                return this.verifyCodeInternal(vs, code);
            }
            return this.verifyCodeExternal(vs, code, true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code.toString() + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet vs) {
        try {
            if (system == null && vs.hasCodeSystem()) {
                return this.verifyCodeInternal(vs, vs.getCodeSystem().getSystem(), code, display);
            }
            if (this.codeSystems.containsKey(system) || vs.hasExpansion()) {
                return this.verifyCodeInternal(vs, system, code, display);
            }
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    @Override
    public IWorkerContext.ValidationResult validateCode(String system, String code, String display, ValueSet.ConceptSetComponent vsi) {
        try {
            ValueSet vs = new ValueSet().setUrl(Utilities.makeUuidUrn());
            vs.getCompose().addInclude(vsi);
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), true);
        }
        catch (Exception e) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.FATAL, "Error validating code \"" + code + "\" in system \"" + system + "\": " + e.getMessage());
        }
    }

    @Override
    public List<ConceptMap> findMapsForSource(String url) {
        ArrayList<ConceptMap> res = new ArrayList<ConceptMap>();
        for (ConceptMap map : this.maps.values()) {
            if (!((Reference)map.getSource()).getReference().equals(url)) continue;
            res.add(map);
        }
        return res;
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, CodeableConcept code) throws FileNotFoundException, ValueSetExpander.ETooCostly, IOException {
        for (Coding c : code.getCoding()) {
            IWorkerContext.ValidationResult res = this.verifyCodeInternal(vs, c.getSystem(), c.getCode(), c.getDisplay());
            if (!res.isOk()) continue;
            return res;
        }
        if (code.getCoding().isEmpty()) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "None code provided");
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "None of the codes are in the specified value set");
    }

    private IWorkerContext.ValidationResult verifyCodeInternal(ValueSet vs, String system, String code, String display) throws FileNotFoundException, ValueSetExpander.ETooCostly, IOException {
        if (vs.hasExpansion()) {
            return this.verifyCodeInExpansion(vs, system, code, display);
        }
        if (vs.hasCodeSystem() && !vs.hasCompose()) {
            return this.verifyCodeInCodeSystem(vs, system, code, display);
        }
        ValueSetExpander.ValueSetExpansionOutcome vse = this.expansionCache.getExpander().expand(vs);
        if (vse.getValueset() != null) {
            return this.verifyCodeExternal(vs, new Coding().setSystem(system).setCode(code).setDisplay(display), false);
        }
        return this.verifyCodeInExpansion(vse.getValueset(), system, code, display);
    }

    private IWorkerContext.ValidationResult verifyCodeInCodeSystem(ValueSet vs, String system, String code, String display) {
        ValueSet.ConceptDefinitionComponent cc = this.findCodeInConcept(vs.getCodeSystem().getConcept(), code);
        if (cc == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown Code " + code + " in " + vs.getCodeSystem().getSystem());
        }
        if (display == null) {
            return new IWorkerContext.ValidationResult(cc);
        }
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (cc.hasDisplay()) {
            b.append(cc.getDisplay());
            if (display.equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(cc);
            }
        }
        for (ValueSet.ConceptDefinitionDesignationComponent ds : cc.getDesignation()) {
            b.append(ds.getValue());
            if (!display.equalsIgnoreCase(ds.getValue())) continue;
            return new IWorkerContext.ValidationResult(cc);
        }
        return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Display Name for " + code + " must be one of '" + b.toString() + "'");
    }

    private IWorkerContext.ValidationResult verifyCodeInExpansion(ValueSet vs, String system, String code, String display) {
        ValueSet.ValueSetExpansionContainsComponent cc = this.findCode(vs.getExpansion().getContains(), code);
        if (cc == null) {
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Unknown Code " + code + " in " + vs.getCodeSystem().getSystem());
        }
        if (display == null) {
            return new IWorkerContext.ValidationResult(new ValueSet.ConceptDefinitionComponent().setCode(code).setDisplay(cc.getDisplay()));
        }
        if (cc.hasDisplay()) {
            if (display.equalsIgnoreCase(cc.getDisplay())) {
                return new IWorkerContext.ValidationResult(new ValueSet.ConceptDefinitionComponent().setCode(code).setDisplay(cc.getDisplay()));
            }
            return new IWorkerContext.ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Display Name for " + code + " must be '" + cc.getDisplay() + "'");
        }
        return null;
    }

    private ValueSet.ValueSetExpansionContainsComponent findCode(List<ValueSet.ValueSetExpansionContainsComponent> contains, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent cc : contains) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            ValueSet.ValueSetExpansionContainsComponent c = this.findCode(cc.getContains(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    private ValueSet.ConceptDefinitionComponent findCodeInConcept(List<ValueSet.ConceptDefinitionComponent> concept, String code) {
        for (ValueSet.ConceptDefinitionComponent cc : concept) {
            if (code.equals(cc.getCode())) {
                return cc;
            }
            ValueSet.ConceptDefinitionComponent c = this.findCodeInConcept(cc.getConcept(), code);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        return (StructureDefinition)this.fetchResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/" + typeName);
    }
}

