/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DiagnosticOrder;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.ImagingObjectSelection;
import org.hl7.fhir.dstu2.model.ImagingStudy;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Media;
import org.hl7.fhir.dstu2.model.Observation;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.ProcedureRequest;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.ReferralRequest;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.Specimen;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="DiagnosticReport", profile="http://hl7.org/fhir/Profile/DiagnosticReport")
public class DiagnosticReport
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Id for external references to this report", formalDefinition="The local ID assigned to the report by the order filler, usually by the Information System of the diagnostic service provider.")
    protected List<Identifier> identifier;
    @Child(name="status", type={CodeType.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="registered | partial | final | corrected | appended | cancelled | entered-in-error", formalDefinition="The status of the diagnostic report as a whole.")
    protected Enumeration<DiagnosticReportStatus> status;
    @Child(name="category", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Service category", formalDefinition="A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.")
    protected CodeableConcept category;
    @Child(name="code", type={CodeableConcept.class}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Name/Code for this diagnostic report", formalDefinition="A code or name that describes this diagnostic report.")
    protected CodeableConcept code;
    @Child(name="subject", type={Patient.class, Group.class, Device.class, Location.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the report, usually, but not always, the patient", formalDefinition="The subject of the report. Usually, but not always, this is a patient. However diagnostic services also perform analyses on specimens collected from a variety of other sources.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="encounter", type={Encounter.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Health care event when test ordered", formalDefinition="The link to the health care event (encounter) when the order was made.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="effective", type={DateTimeType.class, Period.class}, order=6, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Clinically Relevant time/time-period for report", formalDefinition="The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.")
    protected Type effective;
    @Child(name="issued", type={InstantType.class}, order=7, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="DateTime this version was released", formalDefinition="The date and time that this version of the report was released from the source diagnostic service.")
    protected InstantType issued;
    @Child(name="performer", type={Practitioner.class, Organization.class}, order=8, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Responsible Diagnostic Service", formalDefinition="The diagnostic service that is responsible for issuing the report.")
    protected Reference performer;
    protected Resource performerTarget;
    @Child(name="request", type={DiagnosticOrder.class, ProcedureRequest.class, ReferralRequest.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="What was requested", formalDefinition="Details concerning a test or procedure requested.")
    protected List<Reference> request;
    protected List<Resource> requestTarget;
    @Child(name="specimen", type={Specimen.class}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Specimens this report is based on", formalDefinition="Details about the specimens on which this diagnostic report is based.")
    protected List<Reference> specimen;
    protected List<Specimen> specimenTarget;
    @Child(name="result", type={Observation.class}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Observations - simple, or complex nested groups", formalDefinition="Observations that are part of this diagnostic report. Observations can be simple name/value pairs (e.g. \"atomic\" results), or they can be grouping observations that include references to other members of the group (e.g. \"panels\").")
    protected List<Reference> result;
    protected List<Observation> resultTarget;
    @Child(name="imagingStudy", type={ImagingStudy.class, ImagingObjectSelection.class}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Reference to full details of imaging associated with the diagnostic report", formalDefinition="One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.")
    protected List<Reference> imagingStudy;
    protected List<Resource> imagingStudyTarget;
    @Child(name="image", type={}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Key images associated with this report", formalDefinition="A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).")
    protected List<DiagnosticReportImageComponent> image;
    @Child(name="conclusion", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Clinical Interpretation of test results", formalDefinition="Concise and clinically contextualized narrative interpretation of the diagnostic report.")
    protected StringType conclusion;
    @Child(name="codedDiagnosis", type={CodeableConcept.class}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Codes for the conclusion", formalDefinition="Codes for the conclusion.")
    protected List<CodeableConcept> codedDiagnosis;
    @Child(name="presentedForm", type={Attachment.class}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Entire report as issued", formalDefinition="Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.")
    protected List<Attachment> presentedForm;
    private static final long serialVersionUID = 920334551L;
    @SearchParamDefinition(name="date", path="DiagnosticReport.effective[x]", description="The clinically relevant time of the report", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="DiagnosticReport.identifier", description="An identifier for the report", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="image", path="DiagnosticReport.image.link", description="A reference to the image source.", type="reference")
    public static final String SP_IMAGE = "image";
    @SearchParamDefinition(name="request", path="DiagnosticReport.request", description="Reference to the test or procedure request.", type="reference")
    public static final String SP_REQUEST = "request";
    @SearchParamDefinition(name="performer", path="DiagnosticReport.performer", description="Who was the source of the report (organization)", type="reference")
    public static final String SP_PERFORMER = "performer";
    @SearchParamDefinition(name="code", path="DiagnosticReport.code", description="The code for the report as a whole, as opposed to codes for the atomic results, which are the names on the observation resource referred to from the result", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="subject", path="DiagnosticReport.subject", description="The subject of the report", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="diagnosis", path="DiagnosticReport.codedDiagnosis", description="A coded diagnosis on the report", type="token")
    public static final String SP_DIAGNOSIS = "diagnosis";
    @SearchParamDefinition(name="encounter", path="DiagnosticReport.encounter", description="The Encounter when the order was made", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="result", path="DiagnosticReport.result", description="Link to an atomic result (observation resource)", type="reference")
    public static final String SP_RESULT = "result";
    @SearchParamDefinition(name="patient", path="DiagnosticReport.subject", description="The subject of the report if a patient", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="specimen", path="DiagnosticReport.specimen", description="The specimen details", type="reference")
    public static final String SP_SPECIMEN = "specimen";
    @SearchParamDefinition(name="issued", path="DiagnosticReport.issued", description="When the report was issued", type="date")
    public static final String SP_ISSUED = "issued";
    @SearchParamDefinition(name="category", path="DiagnosticReport.category", description="Which diagnostic discipline/department created the report", type="token")
    public static final String SP_CATEGORY = "category";
    @SearchParamDefinition(name="status", path="DiagnosticReport.status", description="The status of the report", type="token")
    public static final String SP_STATUS = "status";

    public DiagnosticReport() {
    }

    public DiagnosticReport(Enumeration<DiagnosticReportStatus> status, CodeableConcept code, Reference subject, Type effective, InstantType issued, Reference performer) {
        this.status = status;
        this.code = code;
        this.subject = subject;
        this.effective = effective;
        this.issued = issued;
        this.performer = performer;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public DiagnosticReport addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<DiagnosticReportStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public DiagnosticReport setStatusElement(Enumeration<DiagnosticReportStatus> value) {
        this.status = value;
        return this;
    }

    public DiagnosticReportStatus getStatus() {
        return this.status == null ? null : (DiagnosticReportStatus)((Object)this.status.getValue());
    }

    public DiagnosticReport setStatus(DiagnosticReportStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<DiagnosticReportStatus>(new DiagnosticReportStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public CodeableConcept getCategory() {
        if (this.category == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.category");
            }
            if (Configuration.doAutoCreate()) {
                this.category = new CodeableConcept();
            }
        }
        return this.category;
    }

    public boolean hasCategory() {
        return this.category != null && !this.category.isEmpty();
    }

    public DiagnosticReport setCategory(CodeableConcept value) {
        this.category = value;
        return this;
    }

    public CodeableConcept getCode() {
        if (this.code == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.code");
            }
            if (Configuration.doAutoCreate()) {
                this.code = new CodeableConcept();
            }
        }
        return this.code;
    }

    public boolean hasCode() {
        return this.code != null && !this.code.isEmpty();
    }

    public DiagnosticReport setCode(CodeableConcept value) {
        this.code = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public DiagnosticReport setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public DiagnosticReport setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public DiagnosticReport setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public DiagnosticReport setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public Type getEffective() {
        return this.effective;
    }

    public DateTimeType getEffectiveDateTimeType() throws FHIRException {
        if (!(this.effective instanceof DateTimeType)) {
            throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (DateTimeType)this.effective;
    }

    public boolean hasEffectiveDateTimeType() {
        return this.effective instanceof DateTimeType;
    }

    public Period getEffectivePeriod() throws FHIRException {
        if (!(this.effective instanceof Period)) {
            throw new FHIRException("Type mismatch: the type Period was expected, but " + this.effective.getClass().getName() + " was encountered");
        }
        return (Period)this.effective;
    }

    public boolean hasEffectivePeriod() {
        return this.effective instanceof Period;
    }

    public boolean hasEffective() {
        return this.effective != null && !this.effective.isEmpty();
    }

    public DiagnosticReport setEffective(Type value) {
        this.effective = value;
        return this;
    }

    public InstantType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new InstantType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public DiagnosticReport setIssuedElement(InstantType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public DiagnosticReport setIssued(Date value) {
        if (this.issued == null) {
            this.issued = new InstantType();
        }
        this.issued.setValue(value);
        return this;
    }

    public Reference getPerformer() {
        if (this.performer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.performer");
            }
            if (Configuration.doAutoCreate()) {
                this.performer = new Reference();
            }
        }
        return this.performer;
    }

    public boolean hasPerformer() {
        return this.performer != null && !this.performer.isEmpty();
    }

    public DiagnosticReport setPerformer(Reference value) {
        this.performer = value;
        return this;
    }

    public Resource getPerformerTarget() {
        return this.performerTarget;
    }

    public DiagnosticReport setPerformerTarget(Resource value) {
        this.performerTarget = value;
        return this;
    }

    public List<Reference> getRequest() {
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        return this.request;
    }

    public boolean hasRequest() {
        if (this.request == null) {
            return false;
        }
        for (Reference item : this.request) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addRequest() {
        Reference t = new Reference();
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return t;
    }

    public DiagnosticReport addRequest(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.request == null) {
            this.request = new ArrayList<Reference>();
        }
        this.request.add(t);
        return this;
    }

    public List<Resource> getRequestTarget() {
        if (this.requestTarget == null) {
            this.requestTarget = new ArrayList<Resource>();
        }
        return this.requestTarget;
    }

    public List<Reference> getSpecimen() {
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        return this.specimen;
    }

    public boolean hasSpecimen() {
        if (this.specimen == null) {
            return false;
        }
        for (Reference item : this.specimen) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSpecimen() {
        Reference t = new Reference();
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return t;
    }

    public DiagnosticReport addSpecimen(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.specimen == null) {
            this.specimen = new ArrayList<Reference>();
        }
        this.specimen.add(t);
        return this;
    }

    public List<Specimen> getSpecimenTarget() {
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        return this.specimenTarget;
    }

    public Specimen addSpecimenTarget() {
        Specimen r = new Specimen();
        if (this.specimenTarget == null) {
            this.specimenTarget = new ArrayList<Specimen>();
        }
        this.specimenTarget.add(r);
        return r;
    }

    public List<Reference> getResult() {
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        return this.result;
    }

    public boolean hasResult() {
        if (this.result == null) {
            return false;
        }
        for (Reference item : this.result) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addResult() {
        Reference t = new Reference();
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return t;
    }

    public DiagnosticReport addResult(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.result == null) {
            this.result = new ArrayList<Reference>();
        }
        this.result.add(t);
        return this;
    }

    public List<Observation> getResultTarget() {
        if (this.resultTarget == null) {
            this.resultTarget = new ArrayList<Observation>();
        }
        return this.resultTarget;
    }

    public Observation addResultTarget() {
        Observation r = new Observation();
        if (this.resultTarget == null) {
            this.resultTarget = new ArrayList<Observation>();
        }
        this.resultTarget.add(r);
        return r;
    }

    public List<Reference> getImagingStudy() {
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        return this.imagingStudy;
    }

    public boolean hasImagingStudy() {
        if (this.imagingStudy == null) {
            return false;
        }
        for (Reference item : this.imagingStudy) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addImagingStudy() {
        Reference t = new Reference();
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        this.imagingStudy.add(t);
        return t;
    }

    public DiagnosticReport addImagingStudy(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.imagingStudy == null) {
            this.imagingStudy = new ArrayList<Reference>();
        }
        this.imagingStudy.add(t);
        return this;
    }

    public List<Resource> getImagingStudyTarget() {
        if (this.imagingStudyTarget == null) {
            this.imagingStudyTarget = new ArrayList<Resource>();
        }
        return this.imagingStudyTarget;
    }

    public List<DiagnosticReportImageComponent> getImage() {
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImageComponent>();
        }
        return this.image;
    }

    public boolean hasImage() {
        if (this.image == null) {
            return false;
        }
        for (DiagnosticReportImageComponent item : this.image) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public DiagnosticReportImageComponent addImage() {
        DiagnosticReportImageComponent t = new DiagnosticReportImageComponent();
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImageComponent>();
        }
        this.image.add(t);
        return t;
    }

    public DiagnosticReport addImage(DiagnosticReportImageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.image == null) {
            this.image = new ArrayList<DiagnosticReportImageComponent>();
        }
        this.image.add(t);
        return this;
    }

    public StringType getConclusionElement() {
        if (this.conclusion == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create DiagnosticReport.conclusion");
            }
            if (Configuration.doAutoCreate()) {
                this.conclusion = new StringType();
            }
        }
        return this.conclusion;
    }

    public boolean hasConclusionElement() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public boolean hasConclusion() {
        return this.conclusion != null && !this.conclusion.isEmpty();
    }

    public DiagnosticReport setConclusionElement(StringType value) {
        this.conclusion = value;
        return this;
    }

    public String getConclusion() {
        return this.conclusion == null ? null : (String)this.conclusion.getValue();
    }

    public DiagnosticReport setConclusion(String value) {
        if (Utilities.noString((String)value)) {
            this.conclusion = null;
        } else {
            if (this.conclusion == null) {
                this.conclusion = new StringType();
            }
            this.conclusion.setValue(value);
        }
        return this;
    }

    public List<CodeableConcept> getCodedDiagnosis() {
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        return this.codedDiagnosis;
    }

    public boolean hasCodedDiagnosis() {
        if (this.codedDiagnosis == null) {
            return false;
        }
        for (CodeableConcept item : this.codedDiagnosis) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addCodedDiagnosis() {
        CodeableConcept t = new CodeableConcept();
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        this.codedDiagnosis.add(t);
        return t;
    }

    public DiagnosticReport addCodedDiagnosis(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.codedDiagnosis == null) {
            this.codedDiagnosis = new ArrayList<CodeableConcept>();
        }
        this.codedDiagnosis.add(t);
        return this;
    }

    public List<Attachment> getPresentedForm() {
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        return this.presentedForm;
    }

    public boolean hasPresentedForm() {
        if (this.presentedForm == null) {
            return false;
        }
        for (Attachment item : this.presentedForm) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPresentedForm() {
        Attachment t = new Attachment();
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return t;
    }

    public DiagnosticReport addPresentedForm(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.presentedForm == null) {
            this.presentedForm = new ArrayList<Attachment>();
        }
        this.presentedForm.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "The local ID assigned to the report by the order filler, usually by the Information System of the diagnostic service provider.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_STATUS, SP_CODE, "The status of the diagnostic report as a whole.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_CATEGORY, "CodeableConcept", "A code that classifies the clinical discipline, department or diagnostic service that created the report (e.g. cardiology, biochemistry, hematology, MRI). This is used for searching, sorting and display purposes.", 0, Integer.MAX_VALUE, this.category));
        childrenList.add(new Property(SP_CODE, "CodeableConcept", "A code or name that describes this diagnostic report.", 0, Integer.MAX_VALUE, this.code));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Group|Device|Location)", "The subject of the report. Usually, but not always, this is a patient. However diagnostic services also perform analyses on specimens collected from a variety of other sources.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "The link to the health care event (encounter) when the order was made.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("effective[x]", "dateTime|Period", "The time or time-period the observed values are related to. When the subject of the report is a patient, this is usually either the time of the procedure or of specimen collection(s), but very often the source of the date/time is not known, only the date/time itself.", 0, Integer.MAX_VALUE, this.effective));
        childrenList.add(new Property(SP_ISSUED, "instant", "The date and time that this version of the report was released from the source diagnostic service.", 0, Integer.MAX_VALUE, this.issued));
        childrenList.add(new Property(SP_PERFORMER, "Reference(Practitioner|Organization)", "The diagnostic service that is responsible for issuing the report.", 0, Integer.MAX_VALUE, this.performer));
        childrenList.add(new Property(SP_REQUEST, "Reference(DiagnosticOrder|ProcedureRequest|ReferralRequest)", "Details concerning a test or procedure requested.", 0, Integer.MAX_VALUE, this.request));
        childrenList.add(new Property(SP_SPECIMEN, "Reference(Specimen)", "Details about the specimens on which this diagnostic report is based.", 0, Integer.MAX_VALUE, this.specimen));
        childrenList.add(new Property(SP_RESULT, "Reference(Observation)", "Observations that are part of this diagnostic report. Observations can be simple name/value pairs (e.g. \"atomic\" results), or they can be grouping observations that include references to other members of the group (e.g. \"panels\").", 0, Integer.MAX_VALUE, this.result));
        childrenList.add(new Property("imagingStudy", "Reference(ImagingStudy|ImagingObjectSelection)", "One or more links to full details of any imaging performed during the diagnostic investigation. Typically, this is imaging performed by DICOM enabled modalities, but this is not required. A fully enabled PACS viewer can use this information to provide views of the source images.", 0, Integer.MAX_VALUE, this.imagingStudy));
        childrenList.add(new Property(SP_IMAGE, "", "A list of key images associated with this report. The images are generally created during the diagnostic process, and may be directly of the patient, or of treated specimens (i.e. slides of interest).", 0, Integer.MAX_VALUE, this.image));
        childrenList.add(new Property("conclusion", "string", "Concise and clinically contextualized narrative interpretation of the diagnostic report.", 0, Integer.MAX_VALUE, this.conclusion));
        childrenList.add(new Property("codedDiagnosis", "CodeableConcept", "Codes for the conclusion.", 0, Integer.MAX_VALUE, this.codedDiagnosis));
        childrenList.add(new Property("presentedForm", "Attachment", "Rich text representation of the entire result as issued by the diagnostic service. Multiple formats are allowed but they SHALL be semantically equivalent.", 0, Integer.MAX_VALUE, this.presentedForm));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_STATUS)) {
            this.status = new DiagnosticReportStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_CATEGORY)) {
            this.category = this.castToCodeableConcept(value);
        } else if (name.equals(SP_CODE)) {
            this.code = this.castToCodeableConcept(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("effective[x]")) {
            this.effective = (Type)value;
        } else if (name.equals(SP_ISSUED)) {
            this.issued = this.castToInstant(value);
        } else if (name.equals(SP_PERFORMER)) {
            this.performer = this.castToReference(value);
        } else if (name.equals(SP_REQUEST)) {
            this.getRequest().add(this.castToReference(value));
        } else if (name.equals(SP_SPECIMEN)) {
            this.getSpecimen().add(this.castToReference(value));
        } else if (name.equals(SP_RESULT)) {
            this.getResult().add(this.castToReference(value));
        } else if (name.equals("imagingStudy")) {
            this.getImagingStudy().add(this.castToReference(value));
        } else if (name.equals(SP_IMAGE)) {
            this.getImage().add((DiagnosticReportImageComponent)value);
        } else if (name.equals("conclusion")) {
            this.conclusion = this.castToString(value);
        } else if (name.equals("codedDiagnosis")) {
            this.getCodedDiagnosis().add(this.castToCodeableConcept(value));
        } else if (name.equals("presentedForm")) {
            this.getPresentedForm().add(this.castToAttachment(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.status");
        }
        if (name.equals(SP_CATEGORY)) {
            this.category = new CodeableConcept();
            return this.category;
        }
        if (name.equals(SP_CODE)) {
            this.code = new CodeableConcept();
            return this.code;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("effectiveDateTime")) {
            this.effective = new DateTimeType();
            return this.effective;
        }
        if (name.equals("effectivePeriod")) {
            this.effective = new Period();
            return this.effective;
        }
        if (name.equals(SP_ISSUED)) {
            throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.issued");
        }
        if (name.equals(SP_PERFORMER)) {
            this.performer = new Reference();
            return this.performer;
        }
        if (name.equals(SP_REQUEST)) {
            return this.addRequest();
        }
        if (name.equals(SP_SPECIMEN)) {
            return this.addSpecimen();
        }
        if (name.equals(SP_RESULT)) {
            return this.addResult();
        }
        if (name.equals("imagingStudy")) {
            return this.addImagingStudy();
        }
        if (name.equals(SP_IMAGE)) {
            return this.addImage();
        }
        if (name.equals("conclusion")) {
            throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.conclusion");
        }
        if (name.equals("codedDiagnosis")) {
            return this.addCodedDiagnosis();
        }
        if (name.equals("presentedForm")) {
            return this.addPresentedForm();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "DiagnosticReport";
    }

    @Override
    public DiagnosticReport copy() {
        DiagnosticReport dst = new DiagnosticReport();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.status = this.status == null ? null : this.status.copy();
        dst.category = this.category == null ? null : this.category.copy();
        dst.code = this.code == null ? null : this.code.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.effective = this.effective == null ? null : this.effective.copy();
        dst.issued = this.issued == null ? null : this.issued.copy();
        Reference reference = dst.performer = this.performer == null ? null : this.performer.copy();
        if (this.request != null) {
            dst.request = new ArrayList<Reference>();
            for (Reference reference2 : this.request) {
                dst.request.add(reference2.copy());
            }
        }
        if (this.specimen != null) {
            dst.specimen = new ArrayList<Reference>();
            for (Reference reference3 : this.specimen) {
                dst.specimen.add(reference3.copy());
            }
        }
        if (this.result != null) {
            dst.result = new ArrayList<Reference>();
            for (Reference reference4 : this.result) {
                dst.result.add(reference4.copy());
            }
        }
        if (this.imagingStudy != null) {
            dst.imagingStudy = new ArrayList<Reference>();
            for (Reference reference5 : this.imagingStudy) {
                dst.imagingStudy.add(reference5.copy());
            }
        }
        if (this.image != null) {
            dst.image = new ArrayList<DiagnosticReportImageComponent>();
            for (DiagnosticReportImageComponent diagnosticReportImageComponent : this.image) {
                dst.image.add(diagnosticReportImageComponent.copy());
            }
        }
        StringType stringType = dst.conclusion = this.conclusion == null ? null : this.conclusion.copy();
        if (this.codedDiagnosis != null) {
            dst.codedDiagnosis = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.codedDiagnosis) {
                dst.codedDiagnosis.add(codeableConcept.copy());
            }
        }
        if (this.presentedForm != null) {
            dst.presentedForm = new ArrayList<Attachment>();
            for (Attachment attachment : this.presentedForm) {
                dst.presentedForm.add(attachment.copy());
            }
        }
        return dst;
    }

    protected DiagnosticReport typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other;
        return DiagnosticReport.compareDeep(this.identifier, o.identifier, true) && DiagnosticReport.compareDeep(this.status, o.status, true) && DiagnosticReport.compareDeep(this.category, o.category, true) && DiagnosticReport.compareDeep(this.code, o.code, true) && DiagnosticReport.compareDeep(this.subject, o.subject, true) && DiagnosticReport.compareDeep(this.encounter, o.encounter, true) && DiagnosticReport.compareDeep(this.effective, o.effective, true) && DiagnosticReport.compareDeep(this.issued, o.issued, true) && DiagnosticReport.compareDeep(this.performer, o.performer, true) && DiagnosticReport.compareDeep(this.request, o.request, true) && DiagnosticReport.compareDeep(this.specimen, o.specimen, true) && DiagnosticReport.compareDeep(this.result, o.result, true) && DiagnosticReport.compareDeep(this.imagingStudy, o.imagingStudy, true) && DiagnosticReport.compareDeep(this.image, o.image, true) && DiagnosticReport.compareDeep(this.conclusion, o.conclusion, true) && DiagnosticReport.compareDeep(this.codedDiagnosis, o.codedDiagnosis, true) && DiagnosticReport.compareDeep(this.presentedForm, o.presentedForm, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof DiagnosticReport)) {
            return false;
        }
        DiagnosticReport o = (DiagnosticReport)other;
        return DiagnosticReport.compareValues(this.status, o.status, true) && DiagnosticReport.compareValues(this.issued, o.issued, true) && DiagnosticReport.compareValues(this.conclusion, o.conclusion, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.status != null && !this.status.isEmpty() || this.category != null && !this.category.isEmpty() || this.code != null && !this.code.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.effective != null && !this.effective.isEmpty() || this.issued != null && !this.issued.isEmpty() || this.performer != null && !this.performer.isEmpty() || this.request != null && !this.request.isEmpty() || this.specimen != null && !this.specimen.isEmpty() || this.result != null && !this.result.isEmpty() || this.imagingStudy != null && !this.imagingStudy.isEmpty() || this.image != null && !this.image.isEmpty() || this.conclusion != null && !this.conclusion.isEmpty() || this.codedDiagnosis != null && !this.codedDiagnosis.isEmpty() || this.presentedForm != null && !this.presentedForm.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.DiagnosticReport;
    }

    @Block
    public static class DiagnosticReportImageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="comment", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Comment about the image (e.g. explanation)", formalDefinition="A comment about the image. Typically, this is used to provide an explanation for why the image is included, or to draw the viewer's attention to important features.")
        protected StringType comment;
        @Child(name="link", type={Media.class}, order=2, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Reference to the image source", formalDefinition="Reference to the image source.")
        protected Reference link;
        protected Media linkTarget;
        private static final long serialVersionUID = 935791940L;

        public DiagnosticReportImageComponent() {
        }

        public DiagnosticReportImageComponent(Reference link) {
            this.link = link;
        }

        public StringType getCommentElement() {
            if (this.comment == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportImageComponent.comment");
                }
                if (Configuration.doAutoCreate()) {
                    this.comment = new StringType();
                }
            }
            return this.comment;
        }

        public boolean hasCommentElement() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public boolean hasComment() {
            return this.comment != null && !this.comment.isEmpty();
        }

        public DiagnosticReportImageComponent setCommentElement(StringType value) {
            this.comment = value;
            return this;
        }

        public String getComment() {
            return this.comment == null ? null : (String)this.comment.getValue();
        }

        public DiagnosticReportImageComponent setComment(String value) {
            if (Utilities.noString((String)value)) {
                this.comment = null;
            } else {
                if (this.comment == null) {
                    this.comment = new StringType();
                }
                this.comment.setValue(value);
            }
            return this;
        }

        public Reference getLink() {
            if (this.link == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportImageComponent.link");
                }
                if (Configuration.doAutoCreate()) {
                    this.link = new Reference();
                }
            }
            return this.link;
        }

        public boolean hasLink() {
            return this.link != null && !this.link.isEmpty();
        }

        public DiagnosticReportImageComponent setLink(Reference value) {
            this.link = value;
            return this;
        }

        public Media getLinkTarget() {
            if (this.linkTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create DiagnosticReportImageComponent.link");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkTarget = new Media();
                }
            }
            return this.linkTarget;
        }

        public DiagnosticReportImageComponent setLinkTarget(Media value) {
            this.linkTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("comment", "string", "A comment about the image. Typically, this is used to provide an explanation for why the image is included, or to draw the viewer's attention to important features.", 0, Integer.MAX_VALUE, this.comment));
            childrenList.add(new Property("link", "Reference(Media)", "Reference to the image source.", 0, Integer.MAX_VALUE, this.link));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("comment")) {
                this.comment = this.castToString(value);
            } else if (name.equals("link")) {
                this.link = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("comment")) {
                throw new FHIRException("Cannot call addChild on a singleton property DiagnosticReport.comment");
            }
            if (name.equals("link")) {
                this.link = new Reference();
                return this.link;
            }
            return super.addChild(name);
        }

        @Override
        public DiagnosticReportImageComponent copy() {
            DiagnosticReportImageComponent dst = new DiagnosticReportImageComponent();
            this.copyValues(dst);
            dst.comment = this.comment == null ? null : this.comment.copy();
            dst.link = this.link == null ? null : this.link.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticReportImageComponent)) {
                return false;
            }
            DiagnosticReportImageComponent o = (DiagnosticReportImageComponent)other;
            return DiagnosticReportImageComponent.compareDeep(this.comment, o.comment, true) && DiagnosticReportImageComponent.compareDeep(this.link, o.link, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof DiagnosticReportImageComponent)) {
                return false;
            }
            DiagnosticReportImageComponent o = (DiagnosticReportImageComponent)other;
            return DiagnosticReportImageComponent.compareValues(this.comment, o.comment, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.comment != null && !this.comment.isEmpty() || this.link != null && !this.link.isEmpty());
        }

        @Override
        public String fhirType() {
            return "DiagnosticReport.image";
        }
    }

    public static class DiagnosticReportStatusEnumFactory
    implements EnumFactory<DiagnosticReportStatus> {
        @Override
        public DiagnosticReportStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return DiagnosticReportStatus.REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return DiagnosticReportStatus.PARTIAL;
            }
            if ("final".equals(codeString)) {
                return DiagnosticReportStatus.FINAL;
            }
            if ("corrected".equals(codeString)) {
                return DiagnosticReportStatus.CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return DiagnosticReportStatus.APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return DiagnosticReportStatus.CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return DiagnosticReportStatus.ENTEREDINERROR;
            }
            throw new IllegalArgumentException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public Enumeration<DiagnosticReportStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.REGISTERED);
            }
            if ("partial".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.PARTIAL);
            }
            if ("final".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.FINAL);
            }
            if ("corrected".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CORRECTED);
            }
            if ("appended".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.APPENDED);
            }
            if ("cancelled".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.CANCELLED);
            }
            if ("entered-in-error".equals(codeString)) {
                return new Enumeration<DiagnosticReportStatus>(this, DiagnosticReportStatus.ENTEREDINERROR);
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(DiagnosticReportStatus code) {
            if (code == DiagnosticReportStatus.REGISTERED) {
                return "registered";
            }
            if (code == DiagnosticReportStatus.PARTIAL) {
                return "partial";
            }
            if (code == DiagnosticReportStatus.FINAL) {
                return "final";
            }
            if (code == DiagnosticReportStatus.CORRECTED) {
                return "corrected";
            }
            if (code == DiagnosticReportStatus.APPENDED) {
                return "appended";
            }
            if (code == DiagnosticReportStatus.CANCELLED) {
                return "cancelled";
            }
            if (code == DiagnosticReportStatus.ENTEREDINERROR) {
                return "entered-in-error";
            }
            return "?";
        }
    }

    public static enum DiagnosticReportStatus {
        REGISTERED,
        PARTIAL,
        FINAL,
        CORRECTED,
        APPENDED,
        CANCELLED,
        ENTEREDINERROR,
        NULL;


        public static DiagnosticReportStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("registered".equals(codeString)) {
                return REGISTERED;
            }
            if ("partial".equals(codeString)) {
                return PARTIAL;
            }
            if ("final".equals(codeString)) {
                return FINAL;
            }
            if ("corrected".equals(codeString)) {
                return CORRECTED;
            }
            if ("appended".equals(codeString)) {
                return APPENDED;
            }
            if ("cancelled".equals(codeString)) {
                return CANCELLED;
            }
            if ("entered-in-error".equals(codeString)) {
                return ENTEREDINERROR;
            }
            throw new FHIRException("Unknown DiagnosticReportStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case REGISTERED: {
                    return "registered";
                }
                case PARTIAL: {
                    return "partial";
                }
                case FINAL: {
                    return "final";
                }
                case CORRECTED: {
                    return "corrected";
                }
                case APPENDED: {
                    return "appended";
                }
                case CANCELLED: {
                    return "cancelled";
                }
                case ENTEREDINERROR: {
                    return "entered-in-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case REGISTERED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case PARTIAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case FINAL: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CORRECTED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case APPENDED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case CANCELLED: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case ENTEREDINERROR: {
                    return "http://hl7.org/fhir/diagnostic-report-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case REGISTERED: {
                    return "The existence of the report is registered, but there is nothing yet available.";
                }
                case PARTIAL: {
                    return "This is a partial (e.g. initial, interim or preliminary) report: data in the report may be incomplete or unverified.";
                }
                case FINAL: {
                    return "The report is complete and verified by an authorized person.";
                }
                case CORRECTED: {
                    return "The report has been modified subsequent to being Final, and is complete and verified by an authorized person. New content has been added, but existing content hasn't changed";
                }
                case APPENDED: {
                    return "The report has been modified subsequent to being Final, and is complete and verified by an authorized person. New content has been added, but existing content hasn't changed.";
                }
                case CANCELLED: {
                    return "The report is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
                }
                case ENTEREDINERROR: {
                    return "The report has been withdrawn following a previous final release.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case REGISTERED: {
                    return "Registered";
                }
                case PARTIAL: {
                    return "Partial";
                }
                case FINAL: {
                    return "Final";
                }
                case CORRECTED: {
                    return "Corrected";
                }
                case APPENDED: {
                    return "Appended";
                }
                case CANCELLED: {
                    return "Cancelled";
                }
                case ENTEREDINERROR: {
                    return "Entered in Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

