/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.BooleanType;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DateType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Encounter;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.IntegerType;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Quantity;
import org.hl7.fhir.dstu2.model.Questionnaire;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.TimeType;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="QuestionnaireResponse", profile="http://hl7.org/fhir/Profile/QuestionnaireResponse")
public class QuestionnaireResponse
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Unique id for this set of answers", formalDefinition="A business identifier assigned to a particular completed (or partially completed) questionnaire.")
    protected Identifier identifier;
    @Child(name="questionnaire", type={Questionnaire.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Form being answered", formalDefinition="Indicates the Questionnaire resource that defines the form for which answers are being provided.")
    protected Reference questionnaire;
    protected Questionnaire questionnaireTarget;
    @Child(name="status", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="in-progress | completed | amended", formalDefinition="The lifecycle status of the questionnaire response as a whole.")
    protected Enumeration<QuestionnaireResponseStatus> status;
    @Child(name="subject", type={}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The subject of the questions", formalDefinition="The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="author", type={Device.class, Practitioner.class, Patient.class, RelatedPerson.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Person who received and recorded the answers", formalDefinition="Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.")
    protected Reference author;
    protected Resource authorTarget;
    @Child(name="authored", type={DateTimeType.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Date this version was authored", formalDefinition="The date and/or time that this version of the questionnaire response was authored.")
    protected DateTimeType authored;
    @Child(name="source", type={Patient.class, Practitioner.class, RelatedPerson.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The person who answered the questions", formalDefinition="The person who answered the questions about the subject.")
    protected Reference source;
    protected Resource sourceTarget;
    @Child(name="encounter", type={Encounter.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Primary encounter during which the answers were collected", formalDefinition="Encounter during which this set of questionnaire response were collected. When there were multiple encounters, this is the one considered most relevant to the context of the answers.")
    protected Reference encounter;
    protected Encounter encounterTarget;
    @Child(name="group", type={}, order=8, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Grouped questions", formalDefinition="A group of questions to a possibly similarly grouped set of questions in the questionnaire response.")
    protected GroupComponent group;
    private static final long serialVersionUID = -1081988635L;
    @SearchParamDefinition(name="authored", path="QuestionnaireResponse.authored", description="When the questionnaire was authored", type="date")
    public static final String SP_AUTHORED = "authored";
    @SearchParamDefinition(name="questionnaire", path="QuestionnaireResponse.questionnaire", description="The questionnaire the answers are provided for", type="reference")
    public static final String SP_QUESTIONNAIRE = "questionnaire";
    @SearchParamDefinition(name="subject", path="QuestionnaireResponse.subject", description="The subject of the questionnaire", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="author", path="QuestionnaireResponse.author", description="The author of the questionnaire", type="reference")
    public static final String SP_AUTHOR = "author";
    @SearchParamDefinition(name="patient", path="QuestionnaireResponse.subject", description="The patient that is the subject of the questionnaire", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="encounter", path="QuestionnaireResponse.encounter", description="Encounter during which questionnaire was authored", type="reference")
    public static final String SP_ENCOUNTER = "encounter";
    @SearchParamDefinition(name="source", path="QuestionnaireResponse.source", description="The person who answered the questions", type="reference")
    public static final String SP_SOURCE = "source";
    @SearchParamDefinition(name="status", path="QuestionnaireResponse.status", description="The status of the questionnaire response", type="token")
    public static final String SP_STATUS = "status";

    public QuestionnaireResponse() {
    }

    public QuestionnaireResponse(Enumeration<QuestionnaireResponseStatus> status) {
        this.status = status;
    }

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public QuestionnaireResponse setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public Reference getQuestionnaire() {
        if (this.questionnaire == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.questionnaire");
            }
            if (Configuration.doAutoCreate()) {
                this.questionnaire = new Reference();
            }
        }
        return this.questionnaire;
    }

    public boolean hasQuestionnaire() {
        return this.questionnaire != null && !this.questionnaire.isEmpty();
    }

    public QuestionnaireResponse setQuestionnaire(Reference value) {
        this.questionnaire = value;
        return this;
    }

    public Questionnaire getQuestionnaireTarget() {
        if (this.questionnaireTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.questionnaire");
            }
            if (Configuration.doAutoCreate()) {
                this.questionnaireTarget = new Questionnaire();
            }
        }
        return this.questionnaireTarget;
    }

    public QuestionnaireResponse setQuestionnaireTarget(Questionnaire value) {
        this.questionnaireTarget = value;
        return this;
    }

    public Enumeration<QuestionnaireResponseStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<QuestionnaireResponseStatus>(new QuestionnaireResponseStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public QuestionnaireResponse setStatusElement(Enumeration<QuestionnaireResponseStatus> value) {
        this.status = value;
        return this;
    }

    public QuestionnaireResponseStatus getStatus() {
        return this.status == null ? null : (QuestionnaireResponseStatus)((Object)this.status.getValue());
    }

    public QuestionnaireResponse setStatus(QuestionnaireResponseStatus value) {
        if (this.status == null) {
            this.status = new Enumeration<QuestionnaireResponseStatus>(new QuestionnaireResponseStatusEnumFactory());
        }
        this.status.setValue((Object)value);
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public QuestionnaireResponse setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public QuestionnaireResponse setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public QuestionnaireResponse setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Resource getAuthorTarget() {
        return this.authorTarget;
    }

    public QuestionnaireResponse setAuthorTarget(Resource value) {
        this.authorTarget = value;
        return this;
    }

    public DateTimeType getAuthoredElement() {
        if (this.authored == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.authored");
            }
            if (Configuration.doAutoCreate()) {
                this.authored = new DateTimeType();
            }
        }
        return this.authored;
    }

    public boolean hasAuthoredElement() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public boolean hasAuthored() {
        return this.authored != null && !this.authored.isEmpty();
    }

    public QuestionnaireResponse setAuthoredElement(DateTimeType value) {
        this.authored = value;
        return this;
    }

    public Date getAuthored() {
        return this.authored == null ? null : (Date)this.authored.getValue();
    }

    public QuestionnaireResponse setAuthored(Date value) {
        if (value == null) {
            this.authored = null;
        } else {
            if (this.authored == null) {
                this.authored = new DateTimeType();
            }
            this.authored.setValue(value);
        }
        return this;
    }

    public Reference getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new Reference();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public QuestionnaireResponse setSource(Reference value) {
        this.source = value;
        return this;
    }

    public Resource getSourceTarget() {
        return this.sourceTarget;
    }

    public QuestionnaireResponse setSourceTarget(Resource value) {
        this.sourceTarget = value;
        return this;
    }

    public Reference getEncounter() {
        if (this.encounter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounter = new Reference();
            }
        }
        return this.encounter;
    }

    public boolean hasEncounter() {
        return this.encounter != null && !this.encounter.isEmpty();
    }

    public QuestionnaireResponse setEncounter(Reference value) {
        this.encounter = value;
        return this;
    }

    public Encounter getEncounterTarget() {
        if (this.encounterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.encounter");
            }
            if (Configuration.doAutoCreate()) {
                this.encounterTarget = new Encounter();
            }
        }
        return this.encounterTarget;
    }

    public QuestionnaireResponse setEncounterTarget(Encounter value) {
        this.encounterTarget = value;
        return this;
    }

    public GroupComponent getGroup() {
        if (this.group == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create QuestionnaireResponse.group");
            }
            if (Configuration.doAutoCreate()) {
                this.group = new GroupComponent();
            }
        }
        return this.group;
    }

    public boolean hasGroup() {
        return this.group != null && !this.group.isEmpty();
    }

    public QuestionnaireResponse setGroup(GroupComponent value) {
        this.group = value;
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property("identifier", "Identifier", "A business identifier assigned to a particular completed (or partially completed) questionnaire.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_QUESTIONNAIRE, "Reference(Questionnaire)", "Indicates the Questionnaire resource that defines the form for which answers are being provided.", 0, Integer.MAX_VALUE, this.questionnaire));
        childrenList.add(new Property(SP_STATUS, "code", "The lifecycle status of the questionnaire response as a whole.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Any)", "The subject of the questionnaire response.  This could be a patient, organization, practitioner, device, etc.  This is who/what the answers apply to, but is not necessarily the source of information.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Device|Practitioner|Patient|RelatedPerson)", "Person who received the answers to the questions in the QuestionnaireResponse and recorded them in the system.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_AUTHORED, "dateTime", "The date and/or time that this version of the questionnaire response was authored.", 0, Integer.MAX_VALUE, this.authored));
        childrenList.add(new Property(SP_SOURCE, "Reference(Patient|Practitioner|RelatedPerson)", "The person who answered the questions about the subject.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property(SP_ENCOUNTER, "Reference(Encounter)", "Encounter during which this set of questionnaire response were collected. When there were multiple encounters, this is the one considered most relevant to the context of the answers.", 0, Integer.MAX_VALUE, this.encounter));
        childrenList.add(new Property("group", "", "A group of questions to a possibly similarly grouped set of questions in the questionnaire response.", 0, Integer.MAX_VALUE, this.group));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals(SP_QUESTIONNAIRE)) {
            this.questionnaire = this.castToReference(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new QuestionnaireResponseStatusEnumFactory().fromType(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_AUTHORED)) {
            this.authored = this.castToDateTime(value);
        } else if (name.equals(SP_SOURCE)) {
            this.source = this.castToReference(value);
        } else if (name.equals(SP_ENCOUNTER)) {
            this.encounter = this.castToReference(value);
        } else if (name.equals("group")) {
            this.group = (GroupComponent)value;
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals("identifier")) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals(SP_QUESTIONNAIRE)) {
            this.questionnaire = new Reference();
            return this.questionnaire;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property QuestionnaireResponse.status");
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_AUTHORED)) {
            throw new FHIRException("Cannot call addChild on a singleton property QuestionnaireResponse.authored");
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new Reference();
            return this.source;
        }
        if (name.equals(SP_ENCOUNTER)) {
            this.encounter = new Reference();
            return this.encounter;
        }
        if (name.equals("group")) {
            this.group = new GroupComponent();
            return this.group;
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "QuestionnaireResponse";
    }

    @Override
    public QuestionnaireResponse copy() {
        QuestionnaireResponse dst = new QuestionnaireResponse();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.questionnaire = this.questionnaire == null ? null : this.questionnaire.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.authored = this.authored == null ? null : this.authored.copy();
        dst.source = this.source == null ? null : this.source.copy();
        dst.encounter = this.encounter == null ? null : this.encounter.copy();
        dst.group = this.group == null ? null : this.group.copy();
        return dst;
    }

    protected QuestionnaireResponse typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof QuestionnaireResponse)) {
            return false;
        }
        QuestionnaireResponse o = (QuestionnaireResponse)other;
        return QuestionnaireResponse.compareDeep(this.identifier, o.identifier, true) && QuestionnaireResponse.compareDeep(this.questionnaire, o.questionnaire, true) && QuestionnaireResponse.compareDeep(this.status, o.status, true) && QuestionnaireResponse.compareDeep(this.subject, o.subject, true) && QuestionnaireResponse.compareDeep(this.author, o.author, true) && QuestionnaireResponse.compareDeep(this.authored, o.authored, true) && QuestionnaireResponse.compareDeep(this.source, o.source, true) && QuestionnaireResponse.compareDeep(this.encounter, o.encounter, true) && QuestionnaireResponse.compareDeep(this.group, o.group, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof QuestionnaireResponse)) {
            return false;
        }
        QuestionnaireResponse o = (QuestionnaireResponse)other;
        return QuestionnaireResponse.compareValues(this.status, o.status, true) && QuestionnaireResponse.compareValues(this.authored, o.authored, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.questionnaire != null && !this.questionnaire.isEmpty() || this.status != null && !this.status.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.author != null && !this.author.isEmpty() || this.authored != null && !this.authored.isEmpty() || this.source != null && !this.source.isEmpty() || this.encounter != null && !this.encounter.isEmpty() || this.group != null && !this.group.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.QuestionnaireResponse;
    }

    @Block
    public static class QuestionAnswerComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="value", type={BooleanType.class, DecimalType.class, IntegerType.class, DateType.class, DateTimeType.class, InstantType.class, TimeType.class, StringType.class, UriType.class, Attachment.class, Coding.class, Quantity.class, Reference.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Single-valued answer to the question", formalDefinition="The answer (or one of the answers) provided by the respondent to the question.")
        protected Type value;
        @Child(name="group", type={GroupComponent.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested questionnaire group", formalDefinition="Nested group, containing nested question for this question. The order of groups within the question is relevant.")
        protected List<GroupComponent> group;
        private static final long serialVersionUID = -1223680118L;

        public Type getValue() {
            return this.value;
        }

        public BooleanType getValueBooleanType() throws FHIRException {
            if (!(this.value instanceof BooleanType)) {
                throw new FHIRException("Type mismatch: the type BooleanType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (BooleanType)this.value;
        }

        public boolean hasValueBooleanType() {
            return this.value instanceof BooleanType;
        }

        public DecimalType getValueDecimalType() throws FHIRException {
            if (!(this.value instanceof DecimalType)) {
                throw new FHIRException("Type mismatch: the type DecimalType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DecimalType)this.value;
        }

        public boolean hasValueDecimalType() {
            return this.value instanceof DecimalType;
        }

        public IntegerType getValueIntegerType() throws FHIRException {
            if (!(this.value instanceof IntegerType)) {
                throw new FHIRException("Type mismatch: the type IntegerType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (IntegerType)this.value;
        }

        public boolean hasValueIntegerType() {
            return this.value instanceof IntegerType;
        }

        public DateType getValueDateType() throws FHIRException {
            if (!(this.value instanceof DateType)) {
                throw new FHIRException("Type mismatch: the type DateType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateType)this.value;
        }

        public boolean hasValueDateType() {
            return this.value instanceof DateType;
        }

        public DateTimeType getValueDateTimeType() throws FHIRException {
            if (!(this.value instanceof DateTimeType)) {
                throw new FHIRException("Type mismatch: the type DateTimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (DateTimeType)this.value;
        }

        public boolean hasValueDateTimeType() {
            return this.value instanceof DateTimeType;
        }

        public InstantType getValueInstantType() throws FHIRException {
            if (!(this.value instanceof InstantType)) {
                throw new FHIRException("Type mismatch: the type InstantType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (InstantType)this.value;
        }

        public boolean hasValueInstantType() {
            return this.value instanceof InstantType;
        }

        public TimeType getValueTimeType() throws FHIRException {
            if (!(this.value instanceof TimeType)) {
                throw new FHIRException("Type mismatch: the type TimeType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (TimeType)this.value;
        }

        public boolean hasValueTimeType() {
            return this.value instanceof TimeType;
        }

        public StringType getValueStringType() throws FHIRException {
            if (!(this.value instanceof StringType)) {
                throw new FHIRException("Type mismatch: the type StringType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (StringType)this.value;
        }

        public boolean hasValueStringType() {
            return this.value instanceof StringType;
        }

        public UriType getValueUriType() throws FHIRException {
            if (!(this.value instanceof UriType)) {
                throw new FHIRException("Type mismatch: the type UriType was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (UriType)this.value;
        }

        public boolean hasValueUriType() {
            return this.value instanceof UriType;
        }

        public Attachment getValueAttachment() throws FHIRException {
            if (!(this.value instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Attachment)this.value;
        }

        public boolean hasValueAttachment() {
            return this.value instanceof Attachment;
        }

        public Coding getValueCoding() throws FHIRException {
            if (!(this.value instanceof Coding)) {
                throw new FHIRException("Type mismatch: the type Coding was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Coding)this.value;
        }

        public boolean hasValueCoding() {
            return this.value instanceof Coding;
        }

        public Quantity getValueQuantity() throws FHIRException {
            if (!(this.value instanceof Quantity)) {
                throw new FHIRException("Type mismatch: the type Quantity was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Quantity)this.value;
        }

        public boolean hasValueQuantity() {
            return this.value instanceof Quantity;
        }

        public Reference getValueReference() throws FHIRException {
            if (!(this.value instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.value.getClass().getName() + " was encountered");
            }
            return (Reference)this.value;
        }

        public boolean hasValueReference() {
            return this.value instanceof Reference;
        }

        public boolean hasValue() {
            return this.value != null && !this.value.isEmpty();
        }

        public QuestionAnswerComponent setValue(Type value) {
            this.value = value;
            return this;
        }

        public List<GroupComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            return this.group;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (GroupComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GroupComponent addGroup() {
            GroupComponent t = new GroupComponent();
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return t;
        }

        public QuestionAnswerComponent addGroup(GroupComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("value[x]", "boolean|decimal|integer|date|dateTime|instant|time|string|uri|Attachment|Coding|Quantity|Reference(Any)", "The answer (or one of the answers) provided by the respondent to the question.", 0, Integer.MAX_VALUE, this.value));
            childrenList.add(new Property("group", "@QuestionnaireResponse.group", "Nested group, containing nested question for this question. The order of groups within the question is relevant.", 0, Integer.MAX_VALUE, this.group));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("value[x]")) {
                this.value = (Type)value;
            } else if (name.equals("group")) {
                this.getGroup().add((GroupComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("valueBoolean")) {
                this.value = new BooleanType();
                return this.value;
            }
            if (name.equals("valueDecimal")) {
                this.value = new DecimalType();
                return this.value;
            }
            if (name.equals("valueInteger")) {
                this.value = new IntegerType();
                return this.value;
            }
            if (name.equals("valueDate")) {
                this.value = new DateType();
                return this.value;
            }
            if (name.equals("valueDateTime")) {
                this.value = new DateTimeType();
                return this.value;
            }
            if (name.equals("valueInstant")) {
                this.value = new InstantType();
                return this.value;
            }
            if (name.equals("valueTime")) {
                this.value = new TimeType();
                return this.value;
            }
            if (name.equals("valueString")) {
                this.value = new StringType();
                return this.value;
            }
            if (name.equals("valueUri")) {
                this.value = new UriType();
                return this.value;
            }
            if (name.equals("valueAttachment")) {
                this.value = new Attachment();
                return this.value;
            }
            if (name.equals("valueCoding")) {
                this.value = new Coding();
                return this.value;
            }
            if (name.equals("valueQuantity")) {
                this.value = new Quantity();
                return this.value;
            }
            if (name.equals("valueReference")) {
                this.value = new Reference();
                return this.value;
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionAnswerComponent copy() {
            QuestionAnswerComponent dst = new QuestionAnswerComponent();
            this.copyValues(dst);
            Type type = dst.value = this.value == null ? null : this.value.copy();
            if (this.group != null) {
                dst.group = new ArrayList<GroupComponent>();
                for (GroupComponent i : this.group) {
                    dst.group.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionAnswerComponent)) {
                return false;
            }
            QuestionAnswerComponent o = (QuestionAnswerComponent)other;
            return QuestionAnswerComponent.compareDeep(this.value, o.value, true) && QuestionAnswerComponent.compareDeep(this.group, o.group, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionAnswerComponent)) {
                return false;
            }
            QuestionAnswerComponent o = (QuestionAnswerComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.value != null && !this.value.isEmpty() || this.group != null && !this.group.isEmpty());
        }

        @Override
        public String fhirType() {
            return "QuestionnaireResponse.group.question.answer";
        }
    }

    @Block
    public static class QuestionComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Corresponding question within Questionnaire", formalDefinition="Identifies the question from the Questionnaire that corresponds to this question in the QuestionnaireResponse resource.")
        protected StringType linkId;
        @Child(name="text", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Text of the question as it is shown to the user", formalDefinition="The actual question as shown to the user to prompt them for an answer.")
        protected StringType text;
        @Child(name="answer", type={}, order=3, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="The response(s) to the question", formalDefinition="The respondent's answer(s) to the question.")
        protected List<QuestionAnswerComponent> answer;
        private static final long serialVersionUID = -265263901L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public QuestionComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public QuestionComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create QuestionComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public QuestionComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public QuestionComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public List<QuestionAnswerComponent> getAnswer() {
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionAnswerComponent>();
            }
            return this.answer;
        }

        public boolean hasAnswer() {
            if (this.answer == null) {
                return false;
            }
            for (QuestionAnswerComponent item : this.answer) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionAnswerComponent addAnswer() {
            QuestionAnswerComponent t = new QuestionAnswerComponent();
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionAnswerComponent>();
            }
            this.answer.add(t);
            return t;
        }

        public QuestionComponent addAnswer(QuestionAnswerComponent t) {
            if (t == null) {
                return this;
            }
            if (this.answer == null) {
                this.answer = new ArrayList<QuestionAnswerComponent>();
            }
            this.answer.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("linkId", "string", "Identifies the question from the Questionnaire that corresponds to this question in the QuestionnaireResponse resource.", 0, Integer.MAX_VALUE, this.linkId));
            childrenList.add(new Property("text", "string", "The actual question as shown to the user to prompt them for an answer.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("answer", "", "The respondent's answer(s) to the question.", 0, Integer.MAX_VALUE, this.answer));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = this.castToString(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("answer")) {
                this.getAnswer().add((QuestionAnswerComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a singleton property QuestionnaireResponse.linkId");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property QuestionnaireResponse.text");
            }
            if (name.equals("answer")) {
                return this.addAnswer();
            }
            return super.addChild(name);
        }

        @Override
        public QuestionComponent copy() {
            QuestionComponent dst = new QuestionComponent();
            this.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            StringType stringType = dst.text = this.text == null ? null : this.text.copy();
            if (this.answer != null) {
                dst.answer = new ArrayList<QuestionAnswerComponent>();
                for (QuestionAnswerComponent i : this.answer) {
                    dst.answer.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof QuestionComponent)) {
                return false;
            }
            QuestionComponent o = (QuestionComponent)other;
            return QuestionComponent.compareDeep(this.linkId, o.linkId, true) && QuestionComponent.compareDeep(this.text, o.text, true) && QuestionComponent.compareDeep(this.answer, o.answer, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof QuestionComponent)) {
                return false;
            }
            QuestionComponent o = (QuestionComponent)other;
            return QuestionComponent.compareValues(this.linkId, o.linkId, true) && QuestionComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.linkId != null && !this.linkId.isEmpty() || this.text != null && !this.text.isEmpty() || this.answer != null && !this.answer.isEmpty());
        }

        @Override
        public String fhirType() {
            return "QuestionnaireResponse.group.question";
        }
    }

    @Block
    public static class GroupComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="linkId", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Corresponding group within Questionnaire", formalDefinition="Identifies the group from the Questionnaire that corresponds to this group in the QuestionnaireResponse resource.")
        protected StringType linkId;
        @Child(name="title", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Name for this group", formalDefinition="Text that is displayed above the contents of the group.")
        protected StringType title;
        @Child(name="text", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Additional text for the group", formalDefinition="Additional text for the group, used for display purposes.")
        protected StringType text;
        @Child(name="subject", type={}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The subject this group's answers are about", formalDefinition="More specific subject this section's answers are about, details the subject given in QuestionnaireResponse.")
        protected Reference subject;
        protected Resource subjectTarget;
        @Child(name="group", type={GroupComponent.class}, order=5, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested questionnaire response group", formalDefinition="A sub-group within a group. The ordering of groups within this group is relevant.")
        protected List<GroupComponent> group;
        @Child(name="question", type={}, order=6, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Questions in this group", formalDefinition="Set of questions within this group. The order of questions within the group is relevant.")
        protected List<QuestionComponent> question;
        private static final long serialVersionUID = -1045990435L;

        public StringType getLinkIdElement() {
            if (this.linkId == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.linkId");
                }
                if (Configuration.doAutoCreate()) {
                    this.linkId = new StringType();
                }
            }
            return this.linkId;
        }

        public boolean hasLinkIdElement() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public boolean hasLinkId() {
            return this.linkId != null && !this.linkId.isEmpty();
        }

        public GroupComponent setLinkIdElement(StringType value) {
            this.linkId = value;
            return this;
        }

        public String getLinkId() {
            return this.linkId == null ? null : (String)this.linkId.getValue();
        }

        public GroupComponent setLinkId(String value) {
            if (Utilities.noString((String)value)) {
                this.linkId = null;
            } else {
                if (this.linkId == null) {
                    this.linkId = new StringType();
                }
                this.linkId.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public GroupComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public GroupComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public GroupComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public GroupComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public Reference getSubject() {
            if (this.subject == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create GroupComponent.subject");
                }
                if (Configuration.doAutoCreate()) {
                    this.subject = new Reference();
                }
            }
            return this.subject;
        }

        public boolean hasSubject() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public GroupComponent setSubject(Reference value) {
            this.subject = value;
            return this;
        }

        public Resource getSubjectTarget() {
            return this.subjectTarget;
        }

        public GroupComponent setSubjectTarget(Resource value) {
            this.subjectTarget = value;
            return this;
        }

        public List<GroupComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            return this.group;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (GroupComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public GroupComponent addGroup() {
            GroupComponent t = new GroupComponent();
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return t;
        }

        public GroupComponent addGroup(GroupComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<GroupComponent>();
            }
            this.group.add(t);
            return this;
        }

        public List<QuestionComponent> getQuestion() {
            if (this.question == null) {
                this.question = new ArrayList<QuestionComponent>();
            }
            return this.question;
        }

        public boolean hasQuestion() {
            if (this.question == null) {
                return false;
            }
            for (QuestionComponent item : this.question) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public QuestionComponent addQuestion() {
            QuestionComponent t = new QuestionComponent();
            if (this.question == null) {
                this.question = new ArrayList<QuestionComponent>();
            }
            this.question.add(t);
            return t;
        }

        public GroupComponent addQuestion(QuestionComponent t) {
            if (t == null) {
                return this;
            }
            if (this.question == null) {
                this.question = new ArrayList<QuestionComponent>();
            }
            this.question.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("linkId", "string", "Identifies the group from the Questionnaire that corresponds to this group in the QuestionnaireResponse resource.", 0, Integer.MAX_VALUE, this.linkId));
            childrenList.add(new Property("title", "string", "Text that is displayed above the contents of the group.", 0, Integer.MAX_VALUE, this.title));
            childrenList.add(new Property("text", "string", "Additional text for the group, used for display purposes.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property(QuestionnaireResponse.SP_SUBJECT, "Reference(Any)", "More specific subject this section's answers are about, details the subject given in QuestionnaireResponse.", 0, Integer.MAX_VALUE, this.subject));
            childrenList.add(new Property("group", "@QuestionnaireResponse.group", "A sub-group within a group. The ordering of groups within this group is relevant.", 0, Integer.MAX_VALUE, this.group));
            childrenList.add(new Property("question", "", "Set of questions within this group. The order of questions within the group is relevant.", 0, Integer.MAX_VALUE, this.question));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("linkId")) {
                this.linkId = this.castToString(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals(QuestionnaireResponse.SP_SUBJECT)) {
                this.subject = this.castToReference(value);
            } else if (name.equals("group")) {
                this.getGroup().add((GroupComponent)value);
            } else if (name.equals("question")) {
                this.getQuestion().add((QuestionComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("linkId")) {
                throw new FHIRException("Cannot call addChild on a singleton property QuestionnaireResponse.linkId");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a singleton property QuestionnaireResponse.title");
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property QuestionnaireResponse.text");
            }
            if (name.equals(QuestionnaireResponse.SP_SUBJECT)) {
                this.subject = new Reference();
                return this.subject;
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            if (name.equals("question")) {
                return this.addQuestion();
            }
            return super.addChild(name);
        }

        @Override
        public GroupComponent copy() {
            GroupComponent dst = new GroupComponent();
            this.copyValues(dst);
            dst.linkId = this.linkId == null ? null : this.linkId.copy();
            dst.title = this.title == null ? null : this.title.copy();
            dst.text = this.text == null ? null : this.text.copy();
            Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
            if (this.group != null) {
                dst.group = new ArrayList<GroupComponent>();
                for (GroupComponent groupComponent : this.group) {
                    dst.group.add(groupComponent.copy());
                }
            }
            if (this.question != null) {
                dst.question = new ArrayList<QuestionComponent>();
                for (QuestionComponent questionComponent : this.question) {
                    dst.question.add(questionComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof GroupComponent)) {
                return false;
            }
            GroupComponent o = (GroupComponent)other;
            return GroupComponent.compareDeep(this.linkId, o.linkId, true) && GroupComponent.compareDeep(this.title, o.title, true) && GroupComponent.compareDeep(this.text, o.text, true) && GroupComponent.compareDeep(this.subject, o.subject, true) && GroupComponent.compareDeep(this.group, o.group, true) && GroupComponent.compareDeep(this.question, o.question, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof GroupComponent)) {
                return false;
            }
            GroupComponent o = (GroupComponent)other;
            return GroupComponent.compareValues(this.linkId, o.linkId, true) && GroupComponent.compareValues(this.title, o.title, true) && GroupComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.linkId != null && !this.linkId.isEmpty() || this.title != null && !this.title.isEmpty() || this.text != null && !this.text.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.group != null && !this.group.isEmpty() || this.question != null && !this.question.isEmpty());
        }

        @Override
        public String fhirType() {
            return "QuestionnaireResponse.group";
        }
    }

    public static class QuestionnaireResponseStatusEnumFactory
    implements EnumFactory<QuestionnaireResponseStatus> {
        @Override
        public QuestionnaireResponseStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return QuestionnaireResponseStatus.INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return QuestionnaireResponseStatus.COMPLETED;
            }
            if ("amended".equals(codeString)) {
                return QuestionnaireResponseStatus.AMENDED;
            }
            throw new IllegalArgumentException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        public Enumeration<QuestionnaireResponseStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.INPROGRESS);
            }
            if ("completed".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.COMPLETED);
            }
            if ("amended".equals(codeString)) {
                return new Enumeration<QuestionnaireResponseStatus>(this, QuestionnaireResponseStatus.AMENDED);
            }
            throw new FHIRException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(QuestionnaireResponseStatus code) {
            if (code == QuestionnaireResponseStatus.INPROGRESS) {
                return "in-progress";
            }
            if (code == QuestionnaireResponseStatus.COMPLETED) {
                return "completed";
            }
            if (code == QuestionnaireResponseStatus.AMENDED) {
                return "amended";
            }
            return "?";
        }
    }

    public static enum QuestionnaireResponseStatus {
        INPROGRESS,
        COMPLETED,
        AMENDED,
        NULL;


        public static QuestionnaireResponseStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("in-progress".equals(codeString)) {
                return INPROGRESS;
            }
            if ("completed".equals(codeString)) {
                return COMPLETED;
            }
            if ("amended".equals(codeString)) {
                return AMENDED;
            }
            throw new FHIRException("Unknown QuestionnaireResponseStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case INPROGRESS: {
                    return "in-progress";
                }
                case COMPLETED: {
                    return "completed";
                }
                case AMENDED: {
                    return "amended";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case INPROGRESS: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case COMPLETED: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case AMENDED: {
                    return "http://hl7.org/fhir/questionnaire-answers-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case INPROGRESS: {
                    return "This QuestionnaireResponse has been partially filled out with answers, but changes or additions are still expected to be made to it.";
                }
                case COMPLETED: {
                    return "This QuestionnaireResponse has been filled out with answers, and the current content is regarded as definitive.";
                }
                case AMENDED: {
                    return "This QuestionnaireResponse has been filled out with answers, then marked as complete, yet changes or additions have been made to it afterwards.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case INPROGRESS: {
                    return "In Progress";
                }
                case COMPLETED: {
                    return "Completed";
                }
                case AMENDED: {
                    return "Amended";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

