/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Money;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Account", profile="http://hl7.org/fhir/Profile/Account")
public class Account
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Account number", formalDefinition="Unique identifier used to reference the account.  May or may not be intended for human use (e.g. credit card number).")
    protected List<Identifier> identifier;
    @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Human-readable label", formalDefinition="Name used for the account when displaying it to humans in reports, etc.")
    protected StringType name;
    @Child(name="type", type={CodeableConcept.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="E.g. patient, expense, depreciation", formalDefinition="Categorizes the account for reporting and searching purposes.")
    protected CodeableConcept type;
    @Child(name="status", type={CodeType.class}, order=3, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="active | inactive", formalDefinition="Indicates whether the account is presently used/useable or not.")
    protected Enumeration<AccountStatus> status;
    @Child(name="activePeriod", type={Period.class}, order=4, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Valid from..to", formalDefinition="Indicates the period of time over which the account is allowed.")
    protected Period activePeriod;
    @Child(name="currency", type={Coding.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Base currency in which balance is tracked", formalDefinition="Identifies the currency to which transactions must be converted when crediting or debiting the account.")
    protected Coding currency;
    @Child(name="balance", type={Money.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="How much is in account?", formalDefinition="Represents the sum of all credits less all debits associated with the account.  Might be positive, zero or negative.")
    protected Money balance;
    @Child(name="coveragePeriod", type={Period.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Transaction window", formalDefinition="Identifies the period of time the account applies to; e.g. accounts created per fiscal year, quarter, etc.")
    protected Period coveragePeriod;
    @Child(name="subject", type={Patient.class, Device.class, Practitioner.class, Location.class, HealthcareService.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="What is account tied to?", formalDefinition="Identifies the patient, device, practitioner, location or other object the account is associated with.")
    protected Reference subject;
    protected Resource subjectTarget;
    @Child(name="owner", type={Organization.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who is responsible?", formalDefinition="Indicates the organization, department, etc. with responsibility for the account.")
    protected Reference owner;
    protected Organization ownerTarget;
    @Child(name="description", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Explanation of purpose/use", formalDefinition="Provides additional information about what the account tracks and how it is used.")
    protected StringType description;
    private static final long serialVersionUID = -1926153194L;
    @SearchParamDefinition(name="owner", path="Account.owner", description="Who is responsible?", type="reference")
    public static final String SP_OWNER = "owner";
    @SearchParamDefinition(name="identifier", path="Account.identifier", description="Account number", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="period", path="Account.coveragePeriod", description="Transaction window", type="date")
    public static final String SP_PERIOD = "period";
    @SearchParamDefinition(name="balance", path="Account.balance", description="How much is in account?", type="quantity")
    public static final String SP_BALANCE = "balance";
    @SearchParamDefinition(name="subject", path="Account.subject", description="What is account tied to?", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="patient", path="Account.subject", description="What is account tied to?", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="name", path="Account.name", description="Human-readable label", type="string")
    public static final String SP_NAME = "name";
    @SearchParamDefinition(name="type", path="Account.type", description="E.g. patient, expense, depreciation", type="token")
    public static final String SP_TYPE = "type";
    @SearchParamDefinition(name="status", path="Account.status", description="active | inactive", type="token")
    public static final String SP_STATUS = "status";

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Account addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public StringType getNameElement() {
        if (this.name == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.name");
            }
            if (Configuration.doAutoCreate()) {
                this.name = new StringType();
            }
        }
        return this.name;
    }

    public boolean hasNameElement() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public Account setNameElement(StringType value) {
        this.name = value;
        return this;
    }

    public String getName() {
        return this.name == null ? null : (String)this.name.getValue();
    }

    public Account setName(String value) {
        if (Utilities.noString((String)value)) {
            this.name = null;
        } else {
            if (this.name == null) {
                this.name = new StringType();
            }
            this.name.setValue(value);
        }
        return this;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Account setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public Enumeration<AccountStatus> getStatusElement() {
        if (this.status == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.status");
            }
            if (Configuration.doAutoCreate()) {
                this.status = new Enumeration<AccountStatus>(new AccountStatusEnumFactory());
            }
        }
        return this.status;
    }

    public boolean hasStatusElement() {
        return this.status != null && !this.status.isEmpty();
    }

    public boolean hasStatus() {
        return this.status != null && !this.status.isEmpty();
    }

    public Account setStatusElement(Enumeration<AccountStatus> value) {
        this.status = value;
        return this;
    }

    public AccountStatus getStatus() {
        return this.status == null ? null : (AccountStatus)((Object)this.status.getValue());
    }

    public Account setStatus(AccountStatus value) {
        if (value == null) {
            this.status = null;
        } else {
            if (this.status == null) {
                this.status = new Enumeration<AccountStatus>(new AccountStatusEnumFactory());
            }
            this.status.setValue((Object)value);
        }
        return this;
    }

    public Period getActivePeriod() {
        if (this.activePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.activePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.activePeriod = new Period();
            }
        }
        return this.activePeriod;
    }

    public boolean hasActivePeriod() {
        return this.activePeriod != null && !this.activePeriod.isEmpty();
    }

    public Account setActivePeriod(Period value) {
        this.activePeriod = value;
        return this;
    }

    public Coding getCurrency() {
        if (this.currency == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.currency");
            }
            if (Configuration.doAutoCreate()) {
                this.currency = new Coding();
            }
        }
        return this.currency;
    }

    public boolean hasCurrency() {
        return this.currency != null && !this.currency.isEmpty();
    }

    public Account setCurrency(Coding value) {
        this.currency = value;
        return this;
    }

    public Money getBalance() {
        if (this.balance == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.balance");
            }
            if (Configuration.doAutoCreate()) {
                this.balance = new Money();
            }
        }
        return this.balance;
    }

    public boolean hasBalance() {
        return this.balance != null && !this.balance.isEmpty();
    }

    public Account setBalance(Money value) {
        this.balance = value;
        return this;
    }

    public Period getCoveragePeriod() {
        if (this.coveragePeriod == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.coveragePeriod");
            }
            if (Configuration.doAutoCreate()) {
                this.coveragePeriod = new Period();
            }
        }
        return this.coveragePeriod;
    }

    public boolean hasCoveragePeriod() {
        return this.coveragePeriod != null && !this.coveragePeriod.isEmpty();
    }

    public Account setCoveragePeriod(Period value) {
        this.coveragePeriod = value;
        return this;
    }

    public Reference getSubject() {
        if (this.subject == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.subject");
            }
            if (Configuration.doAutoCreate()) {
                this.subject = new Reference();
            }
        }
        return this.subject;
    }

    public boolean hasSubject() {
        return this.subject != null && !this.subject.isEmpty();
    }

    public Account setSubject(Reference value) {
        this.subject = value;
        return this;
    }

    public Resource getSubjectTarget() {
        return this.subjectTarget;
    }

    public Account setSubjectTarget(Resource value) {
        this.subjectTarget = value;
        return this;
    }

    public Reference getOwner() {
        if (this.owner == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.owner = new Reference();
            }
        }
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null && !this.owner.isEmpty();
    }

    public Account setOwner(Reference value) {
        this.owner = value;
        return this;
    }

    public Organization getOwnerTarget() {
        if (this.ownerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.owner");
            }
            if (Configuration.doAutoCreate()) {
                this.ownerTarget = new Organization();
            }
        }
        return this.ownerTarget;
    }

    public Account setOwnerTarget(Organization value) {
        this.ownerTarget = value;
        return this;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Account.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public Account setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public Account setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier used to reference the account.  May or may not be intended for human use (e.g. credit card number).", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_NAME, "string", "Name used for the account when displaying it to humans in reports, etc.", 0, Integer.MAX_VALUE, this.name));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "Categorizes the account for reporting and searching purposes.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_STATUS, "code", "Indicates whether the account is presently used/useable or not.", 0, Integer.MAX_VALUE, this.status));
        childrenList.add(new Property("activePeriod", "Period", "Indicates the period of time over which the account is allowed.", 0, Integer.MAX_VALUE, this.activePeriod));
        childrenList.add(new Property("currency", "Coding", "Identifies the currency to which transactions must be converted when crediting or debiting the account.", 0, Integer.MAX_VALUE, this.currency));
        childrenList.add(new Property(SP_BALANCE, "Money", "Represents the sum of all credits less all debits associated with the account.  Might be positive, zero or negative.", 0, Integer.MAX_VALUE, this.balance));
        childrenList.add(new Property("coveragePeriod", "Period", "Identifies the period of time the account applies to; e.g. accounts created per fiscal year, quarter, etc.", 0, Integer.MAX_VALUE, this.coveragePeriod));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Patient|Device|Practitioner|Location|HealthcareService|Organization)", "Identifies the patient, device, practitioner, location or other object the account is associated with.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property(SP_OWNER, "Reference(Organization)", "Indicates the organization, department, etc. with responsibility for the account.", 0, Integer.MAX_VALUE, this.owner));
        childrenList.add(new Property("description", "string", "Provides additional information about what the account tracks and how it is used.", 0, Integer.MAX_VALUE, this.description));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_NAME)) {
            this.name = this.castToString(value);
        } else if (name.equals(SP_TYPE)) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals(SP_STATUS)) {
            this.status = new AccountStatusEnumFactory().fromType(value);
        } else if (name.equals("activePeriod")) {
            this.activePeriod = this.castToPeriod(value);
        } else if (name.equals("currency")) {
            this.currency = this.castToCoding(value);
        } else if (name.equals(SP_BALANCE)) {
            this.balance = this.castToMoney(value);
        } else if (name.equals("coveragePeriod")) {
            this.coveragePeriod = this.castToPeriod(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.subject = this.castToReference(value);
        } else if (name.equals(SP_OWNER)) {
            this.owner = this.castToReference(value);
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_NAME)) {
            throw new FHIRException("Cannot call addChild on a singleton property Account.name");
        }
        if (name.equals(SP_TYPE)) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals(SP_STATUS)) {
            throw new FHIRException("Cannot call addChild on a singleton property Account.status");
        }
        if (name.equals("activePeriod")) {
            this.activePeriod = new Period();
            return this.activePeriod;
        }
        if (name.equals("currency")) {
            this.currency = new Coding();
            return this.currency;
        }
        if (name.equals(SP_BALANCE)) {
            this.balance = new Money();
            return this.balance;
        }
        if (name.equals("coveragePeriod")) {
            this.coveragePeriod = new Period();
            return this.coveragePeriod;
        }
        if (name.equals(SP_SUBJECT)) {
            this.subject = new Reference();
            return this.subject;
        }
        if (name.equals(SP_OWNER)) {
            this.owner = new Reference();
            return this.owner;
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a singleton property Account.description");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Account";
    }

    @Override
    public Account copy() {
        Account dst = new Account();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier i : this.identifier) {
                dst.identifier.add(i.copy());
            }
        }
        dst.name = this.name == null ? null : this.name.copy();
        dst.type = this.type == null ? null : this.type.copy();
        dst.status = this.status == null ? null : this.status.copy();
        dst.activePeriod = this.activePeriod == null ? null : this.activePeriod.copy();
        dst.currency = this.currency == null ? null : this.currency.copy();
        dst.balance = this.balance == null ? null : this.balance.copy();
        dst.coveragePeriod = this.coveragePeriod == null ? null : this.coveragePeriod.copy();
        dst.subject = this.subject == null ? null : this.subject.copy();
        dst.owner = this.owner == null ? null : this.owner.copy();
        dst.description = this.description == null ? null : this.description.copy();
        return dst;
    }

    protected Account typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Account)) {
            return false;
        }
        Account o = (Account)other;
        return Account.compareDeep(this.identifier, o.identifier, true) && Account.compareDeep(this.name, o.name, true) && Account.compareDeep(this.type, o.type, true) && Account.compareDeep(this.status, o.status, true) && Account.compareDeep(this.activePeriod, o.activePeriod, true) && Account.compareDeep(this.currency, o.currency, true) && Account.compareDeep(this.balance, o.balance, true) && Account.compareDeep(this.coveragePeriod, o.coveragePeriod, true) && Account.compareDeep(this.subject, o.subject, true) && Account.compareDeep(this.owner, o.owner, true) && Account.compareDeep(this.description, o.description, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Account)) {
            return false;
        }
        Account o = (Account)other;
        return Account.compareValues(this.name, o.name, true) && Account.compareValues(this.status, o.status, true) && Account.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.name != null && !this.name.isEmpty() || this.type != null && !this.type.isEmpty() || this.status != null && !this.status.isEmpty() || this.activePeriod != null && !this.activePeriod.isEmpty() || this.currency != null && !this.currency.isEmpty() || this.balance != null && !this.balance.isEmpty() || this.coveragePeriod != null && !this.coveragePeriod.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.owner != null && !this.owner.isEmpty() || this.description != null && !this.description.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Account;
    }

    public static class AccountStatusEnumFactory
    implements EnumFactory<AccountStatus> {
        @Override
        public AccountStatus fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("active".equals(codeString)) {
                return AccountStatus.ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return AccountStatus.INACTIVE;
            }
            throw new IllegalArgumentException("Unknown AccountStatus code '" + codeString + "'");
        }

        public Enumeration<AccountStatus> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.ACTIVE);
            }
            if ("inactive".equals(codeString)) {
                return new Enumeration<AccountStatus>(this, AccountStatus.INACTIVE);
            }
            throw new FHIRException("Unknown AccountStatus code '" + codeString + "'");
        }

        @Override
        public String toCode(AccountStatus code) {
            if (code == AccountStatus.NULL) {
                return null;
            }
            if (code == AccountStatus.ACTIVE) {
                return "active";
            }
            if (code == AccountStatus.INACTIVE) {
                return "inactive";
            }
            return "?";
        }
    }

    public static enum AccountStatus {
        ACTIVE,
        INACTIVE,
        NULL;


        public static AccountStatus fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("active".equals(codeString)) {
                return ACTIVE;
            }
            if ("inactive".equals(codeString)) {
                return INACTIVE;
            }
            throw new FHIRException("Unknown AccountStatus code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ACTIVE: {
                    return "active";
                }
                case INACTIVE: {
                    return "inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ACTIVE: {
                    return "http://hl7.org/fhir/account-status";
                }
                case INACTIVE: {
                    return "http://hl7.org/fhir/account-status";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ACTIVE: {
                    return "This account is active and may be used.";
                }
                case INACTIVE: {
                    return "This account is inactive and should not be used to track financial information.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ACTIVE: {
                    return "Active";
                }
                case INACTIVE: {
                    return "Inactive";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

