/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.Attachment;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Composition;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.DateTimeType;
import org.hl7.fhir.dstu2.model.DecimalType;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DocumentReference;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.Group;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Money;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.QuestionnaireResponse;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.SimpleQuantity;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.Substance;
import org.hl7.fhir.dstu2.model.Type;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Contract", profile="http://hl7.org/fhir/Profile/Contract")
public class Contract
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Contract identifier", formalDefinition="Unique identifier for this Contract.")
    protected Identifier identifier;
    @Child(name="issued", type={DateTimeType.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When this Contract was issued", formalDefinition="When this  Contract was issued.")
    protected DateTimeType issued;
    @Child(name="applies", type={Period.class}, order=2, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Effective time", formalDefinition="Relevant time or time-period when this Contract is applicable.")
    protected Period applies;
    @Child(name="subject", type={}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Subject of this Contract", formalDefinition="Who and/or what this Contract is about: typically a Patient, Organization, or valued items such as goods and services.")
    protected List<Reference> subject;
    protected List<Resource> subjectTarget;
    @Child(name="authority", type={Organization.class}, order=4, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Authority under which this Contract has standing", formalDefinition="A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.")
    protected List<Reference> authority;
    protected List<Organization> authorityTarget;
    @Child(name="domain", type={Location.class}, order=5, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Domain in which this Contract applies", formalDefinition="Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.")
    protected List<Reference> domain;
    protected List<Location> domainTarget;
    @Child(name="type", type={CodeableConcept.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Contract Tyoe", formalDefinition="Type of Contract such as an insurance policy, real estate contract, a will, power of attorny, Privacy or Security policy , trust framework agreement, etc.")
    protected CodeableConcept type;
    @Child(name="subType", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Contract Subtype", formalDefinition="More specific type or specialization of an overarching or more general contract such as auto insurance, home owner  insurance, prenupial agreement, Advanced-Directive, or privacy consent.")
    protected List<CodeableConcept> subType;
    @Child(name="action", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Action", formalDefinition="Action stipulated by this Contract.")
    protected List<CodeableConcept> action;
    @Child(name="actionReason", type={CodeableConcept.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Action Reason", formalDefinition="Reason for action stipulated by this Contract.")
    protected List<CodeableConcept> actionReason;
    @Child(name="actor", type={}, order=10, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Actor", formalDefinition="List of Contract actors.")
    protected List<ActorComponent> actor;
    @Child(name="valuedItem", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Valued Item", formalDefinition="Contract Valued Item List.")
    protected List<ValuedItemComponent> valuedItem;
    @Child(name="signer", type={}, order=12, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Signer", formalDefinition="Party signing this Contract.")
    protected List<SignatoryComponent> signer;
    @Child(name="term", type={}, order=13, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Term List", formalDefinition="One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.")
    protected List<TermComponent> term;
    @Child(name="binding", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=14, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Binding Contract", formalDefinition="Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.")
    protected Type binding;
    @Child(name="friendly", type={}, order=15, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Friendly Language", formalDefinition="The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.")
    protected List<FriendlyLanguageComponent> friendly;
    @Child(name="legal", type={}, order=16, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Contract Legal Language", formalDefinition="List of Legal expressions or representations of this Contract.")
    protected List<LegalLanguageComponent> legal;
    @Child(name="rule", type={}, order=17, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Computable Contract Language", formalDefinition="List of Computable Policy Rule Language Representations of this Contract.")
    protected List<ComputableLanguageComponent> rule;
    private static final long serialVersionUID = -1785608373L;
    @SearchParamDefinition(name="actor", path="Contract.actor.entity", description="Contract Actor Type", type="reference")
    public static final String SP_ACTOR = "actor";
    @SearchParamDefinition(name="identifier", path="Contract.identifier", description="The identity of the contract", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="subject", path="Contract.subject", description="The identity of the target of the contract", type="reference")
    public static final String SP_SUBJECT = "subject";
    @SearchParamDefinition(name="patient", path="Contract.subject", description="The identity of the target of the contract (if a patient)", type="reference")
    public static final String SP_PATIENT = "patient";
    @SearchParamDefinition(name="signer", path="Contract.signer.party", description="Contract Signatory Party", type="reference")
    public static final String SP_SIGNER = "signer";

    public Identifier getIdentifier() {
        if (this.identifier == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.identifier");
            }
            if (Configuration.doAutoCreate()) {
                this.identifier = new Identifier();
            }
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        return this.identifier != null && !this.identifier.isEmpty();
    }

    public Contract setIdentifier(Identifier value) {
        this.identifier = value;
        return this;
    }

    public DateTimeType getIssuedElement() {
        if (this.issued == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.issued");
            }
            if (Configuration.doAutoCreate()) {
                this.issued = new DateTimeType();
            }
        }
        return this.issued;
    }

    public boolean hasIssuedElement() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public boolean hasIssued() {
        return this.issued != null && !this.issued.isEmpty();
    }

    public Contract setIssuedElement(DateTimeType value) {
        this.issued = value;
        return this;
    }

    public Date getIssued() {
        return this.issued == null ? null : (Date)this.issued.getValue();
    }

    public Contract setIssued(Date value) {
        if (value == null) {
            this.issued = null;
        } else {
            if (this.issued == null) {
                this.issued = new DateTimeType();
            }
            this.issued.setValue(value);
        }
        return this;
    }

    public Period getApplies() {
        if (this.applies == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.applies");
            }
            if (Configuration.doAutoCreate()) {
                this.applies = new Period();
            }
        }
        return this.applies;
    }

    public boolean hasApplies() {
        return this.applies != null && !this.applies.isEmpty();
    }

    public Contract setApplies(Period value) {
        this.applies = value;
        return this;
    }

    public List<Reference> getSubject() {
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        return this.subject;
    }

    public boolean hasSubject() {
        if (this.subject == null) {
            return false;
        }
        for (Reference item : this.subject) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addSubject() {
        Reference t = new Reference();
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return t;
    }

    public Contract addSubject(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.subject == null) {
            this.subject = new ArrayList<Reference>();
        }
        this.subject.add(t);
        return this;
    }

    public List<Resource> getSubjectTarget() {
        if (this.subjectTarget == null) {
            this.subjectTarget = new ArrayList<Resource>();
        }
        return this.subjectTarget;
    }

    public List<Reference> getAuthority() {
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        return this.authority;
    }

    public boolean hasAuthority() {
        if (this.authority == null) {
            return false;
        }
        for (Reference item : this.authority) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addAuthority() {
        Reference t = new Reference();
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        this.authority.add(t);
        return t;
    }

    public Contract addAuthority(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.authority == null) {
            this.authority = new ArrayList<Reference>();
        }
        this.authority.add(t);
        return this;
    }

    public List<Organization> getAuthorityTarget() {
        if (this.authorityTarget == null) {
            this.authorityTarget = new ArrayList<Organization>();
        }
        return this.authorityTarget;
    }

    public Organization addAuthorityTarget() {
        Organization r = new Organization();
        if (this.authorityTarget == null) {
            this.authorityTarget = new ArrayList<Organization>();
        }
        this.authorityTarget.add(r);
        return r;
    }

    public List<Reference> getDomain() {
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        return this.domain;
    }

    public boolean hasDomain() {
        if (this.domain == null) {
            return false;
        }
        for (Reference item : this.domain) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addDomain() {
        Reference t = new Reference();
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        this.domain.add(t);
        return t;
    }

    public Contract addDomain(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.domain == null) {
            this.domain = new ArrayList<Reference>();
        }
        this.domain.add(t);
        return this;
    }

    public List<Location> getDomainTarget() {
        if (this.domainTarget == null) {
            this.domainTarget = new ArrayList<Location>();
        }
        return this.domainTarget;
    }

    public Location addDomainTarget() {
        Location r = new Location();
        if (this.domainTarget == null) {
            this.domainTarget = new ArrayList<Location>();
        }
        this.domainTarget.add(r);
        return r;
    }

    public CodeableConcept getType() {
        if (this.type == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Contract.type");
            }
            if (Configuration.doAutoCreate()) {
                this.type = new CodeableConcept();
            }
        }
        return this.type;
    }

    public boolean hasType() {
        return this.type != null && !this.type.isEmpty();
    }

    public Contract setType(CodeableConcept value) {
        this.type = value;
        return this;
    }

    public List<CodeableConcept> getSubType() {
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        return this.subType;
    }

    public boolean hasSubType() {
        if (this.subType == null) {
            return false;
        }
        for (CodeableConcept item : this.subType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSubType() {
        CodeableConcept t = new CodeableConcept();
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return t;
    }

    public Contract addSubType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.subType == null) {
            this.subType = new ArrayList<CodeableConcept>();
        }
        this.subType.add(t);
        return this;
    }

    public List<CodeableConcept> getAction() {
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        return this.action;
    }

    public boolean hasAction() {
        if (this.action == null) {
            return false;
        }
        for (CodeableConcept item : this.action) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addAction() {
        CodeableConcept t = new CodeableConcept();
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        this.action.add(t);
        return t;
    }

    public Contract addAction(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.action == null) {
            this.action = new ArrayList<CodeableConcept>();
        }
        this.action.add(t);
        return this;
    }

    public List<CodeableConcept> getActionReason() {
        if (this.actionReason == null) {
            this.actionReason = new ArrayList<CodeableConcept>();
        }
        return this.actionReason;
    }

    public boolean hasActionReason() {
        if (this.actionReason == null) {
            return false;
        }
        for (CodeableConcept item : this.actionReason) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addActionReason() {
        CodeableConcept t = new CodeableConcept();
        if (this.actionReason == null) {
            this.actionReason = new ArrayList<CodeableConcept>();
        }
        this.actionReason.add(t);
        return t;
    }

    public Contract addActionReason(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.actionReason == null) {
            this.actionReason = new ArrayList<CodeableConcept>();
        }
        this.actionReason.add(t);
        return this;
    }

    public List<ActorComponent> getActor() {
        if (this.actor == null) {
            this.actor = new ArrayList<ActorComponent>();
        }
        return this.actor;
    }

    public boolean hasActor() {
        if (this.actor == null) {
            return false;
        }
        for (ActorComponent item : this.actor) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ActorComponent addActor() {
        ActorComponent t = new ActorComponent();
        if (this.actor == null) {
            this.actor = new ArrayList<ActorComponent>();
        }
        this.actor.add(t);
        return t;
    }

    public Contract addActor(ActorComponent t) {
        if (t == null) {
            return this;
        }
        if (this.actor == null) {
            this.actor = new ArrayList<ActorComponent>();
        }
        this.actor.add(t);
        return this;
    }

    public List<ValuedItemComponent> getValuedItem() {
        if (this.valuedItem == null) {
            this.valuedItem = new ArrayList<ValuedItemComponent>();
        }
        return this.valuedItem;
    }

    public boolean hasValuedItem() {
        if (this.valuedItem == null) {
            return false;
        }
        for (ValuedItemComponent item : this.valuedItem) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ValuedItemComponent addValuedItem() {
        ValuedItemComponent t = new ValuedItemComponent();
        if (this.valuedItem == null) {
            this.valuedItem = new ArrayList<ValuedItemComponent>();
        }
        this.valuedItem.add(t);
        return t;
    }

    public Contract addValuedItem(ValuedItemComponent t) {
        if (t == null) {
            return this;
        }
        if (this.valuedItem == null) {
            this.valuedItem = new ArrayList<ValuedItemComponent>();
        }
        this.valuedItem.add(t);
        return this;
    }

    public List<SignatoryComponent> getSigner() {
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        return this.signer;
    }

    public boolean hasSigner() {
        if (this.signer == null) {
            return false;
        }
        for (SignatoryComponent item : this.signer) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public SignatoryComponent addSigner() {
        SignatoryComponent t = new SignatoryComponent();
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        this.signer.add(t);
        return t;
    }

    public Contract addSigner(SignatoryComponent t) {
        if (t == null) {
            return this;
        }
        if (this.signer == null) {
            this.signer = new ArrayList<SignatoryComponent>();
        }
        this.signer.add(t);
        return this;
    }

    public List<TermComponent> getTerm() {
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        return this.term;
    }

    public boolean hasTerm() {
        if (this.term == null) {
            return false;
        }
        for (TermComponent item : this.term) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public TermComponent addTerm() {
        TermComponent t = new TermComponent();
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        this.term.add(t);
        return t;
    }

    public Contract addTerm(TermComponent t) {
        if (t == null) {
            return this;
        }
        if (this.term == null) {
            this.term = new ArrayList<TermComponent>();
        }
        this.term.add(t);
        return this;
    }

    public Type getBinding() {
        return this.binding;
    }

    public Attachment getBindingAttachment() throws FHIRException {
        if (!(this.binding instanceof Attachment)) {
            throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.binding.getClass().getName() + " was encountered");
        }
        return (Attachment)this.binding;
    }

    public boolean hasBindingAttachment() {
        return this.binding instanceof Attachment;
    }

    public Reference getBindingReference() throws FHIRException {
        if (!(this.binding instanceof Reference)) {
            throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.binding.getClass().getName() + " was encountered");
        }
        return (Reference)this.binding;
    }

    public boolean hasBindingReference() {
        return this.binding instanceof Reference;
    }

    public boolean hasBinding() {
        return this.binding != null && !this.binding.isEmpty();
    }

    public Contract setBinding(Type value) {
        this.binding = value;
        return this;
    }

    public List<FriendlyLanguageComponent> getFriendly() {
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        return this.friendly;
    }

    public boolean hasFriendly() {
        if (this.friendly == null) {
            return false;
        }
        for (FriendlyLanguageComponent item : this.friendly) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public FriendlyLanguageComponent addFriendly() {
        FriendlyLanguageComponent t = new FriendlyLanguageComponent();
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        this.friendly.add(t);
        return t;
    }

    public Contract addFriendly(FriendlyLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.friendly == null) {
            this.friendly = new ArrayList<FriendlyLanguageComponent>();
        }
        this.friendly.add(t);
        return this;
    }

    public List<LegalLanguageComponent> getLegal() {
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        return this.legal;
    }

    public boolean hasLegal() {
        if (this.legal == null) {
            return false;
        }
        for (LegalLanguageComponent item : this.legal) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public LegalLanguageComponent addLegal() {
        LegalLanguageComponent t = new LegalLanguageComponent();
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        this.legal.add(t);
        return t;
    }

    public Contract addLegal(LegalLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.legal == null) {
            this.legal = new ArrayList<LegalLanguageComponent>();
        }
        this.legal.add(t);
        return this;
    }

    public List<ComputableLanguageComponent> getRule() {
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        return this.rule;
    }

    public boolean hasRule() {
        if (this.rule == null) {
            return false;
        }
        for (ComputableLanguageComponent item : this.rule) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ComputableLanguageComponent addRule() {
        ComputableLanguageComponent t = new ComputableLanguageComponent();
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        this.rule.add(t);
        return t;
    }

    public Contract addRule(ComputableLanguageComponent t) {
        if (t == null) {
            return this;
        }
        if (this.rule == null) {
            this.rule = new ArrayList<ComputableLanguageComponent>();
        }
        this.rule.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Unique identifier for this Contract.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("issued", "dateTime", "When this  Contract was issued.", 0, Integer.MAX_VALUE, this.issued));
        childrenList.add(new Property("applies", "Period", "Relevant time or time-period when this Contract is applicable.", 0, Integer.MAX_VALUE, this.applies));
        childrenList.add(new Property(SP_SUBJECT, "Reference(Any)", "Who and/or what this Contract is about: typically a Patient, Organization, or valued items such as goods and services.", 0, Integer.MAX_VALUE, this.subject));
        childrenList.add(new Property("authority", "Reference(Organization)", "A formally or informally recognized grouping of people, principals, organizations, or jurisdictions formed for the purpose of achieving some form of collective action such as the promulgation, administration and enforcement of contracts and policies.", 0, Integer.MAX_VALUE, this.authority));
        childrenList.add(new Property("domain", "Reference(Location)", "Recognized governance framework or system operating with a circumscribed scope in accordance with specified principles, policies, processes or procedures for managing rights, actions, or behaviors of parties or principals relative to resources.", 0, Integer.MAX_VALUE, this.domain));
        childrenList.add(new Property("type", "CodeableConcept", "Type of Contract such as an insurance policy, real estate contract, a will, power of attorny, Privacy or Security policy , trust framework agreement, etc.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property("subType", "CodeableConcept", "More specific type or specialization of an overarching or more general contract such as auto insurance, home owner  insurance, prenupial agreement, Advanced-Directive, or privacy consent.", 0, Integer.MAX_VALUE, this.subType));
        childrenList.add(new Property("action", "CodeableConcept", "Action stipulated by this Contract.", 0, Integer.MAX_VALUE, this.action));
        childrenList.add(new Property("actionReason", "CodeableConcept", "Reason for action stipulated by this Contract.", 0, Integer.MAX_VALUE, this.actionReason));
        childrenList.add(new Property(SP_ACTOR, "", "List of Contract actors.", 0, Integer.MAX_VALUE, this.actor));
        childrenList.add(new Property("valuedItem", "", "Contract Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem));
        childrenList.add(new Property(SP_SIGNER, "", "Party signing this Contract.", 0, Integer.MAX_VALUE, this.signer));
        childrenList.add(new Property("term", "", "One or more Contract Provisions, which may be related and conveyed as a group, and may contain nested groups.", 0, Integer.MAX_VALUE, this.term));
        childrenList.add(new Property("binding[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Legally binding Contract: This is the signed and legally recognized representation of the Contract, which is considered the \"source of truth\" and which would be the basis for legal action related to enforcement of this Contract.", 0, Integer.MAX_VALUE, this.binding));
        childrenList.add(new Property("friendly", "", "The \"patient friendly language\" versionof the Contract in whole or in parts. \"Patient friendly language\" means the representation of the Contract and Contract Provisions in a manner that is readily accessible and understandable by a layperson in accordance with best practices for communication styles that ensure that those agreeing to or signing the Contract understand the roles, actions, obligations, responsibilities, and implication of the agreement.", 0, Integer.MAX_VALUE, this.friendly));
        childrenList.add(new Property("legal", "", "List of Legal expressions or representations of this Contract.", 0, Integer.MAX_VALUE, this.legal));
        childrenList.add(new Property("rule", "", "List of Computable Policy Rule Language Representations of this Contract.", 0, Integer.MAX_VALUE, this.rule));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = this.castToIdentifier(value);
        } else if (name.equals("issued")) {
            this.issued = this.castToDateTime(value);
        } else if (name.equals("applies")) {
            this.applies = this.castToPeriod(value);
        } else if (name.equals(SP_SUBJECT)) {
            this.getSubject().add(this.castToReference(value));
        } else if (name.equals("authority")) {
            this.getAuthority().add(this.castToReference(value));
        } else if (name.equals("domain")) {
            this.getDomain().add(this.castToReference(value));
        } else if (name.equals("type")) {
            this.type = this.castToCodeableConcept(value);
        } else if (name.equals("subType")) {
            this.getSubType().add(this.castToCodeableConcept(value));
        } else if (name.equals("action")) {
            this.getAction().add(this.castToCodeableConcept(value));
        } else if (name.equals("actionReason")) {
            this.getActionReason().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_ACTOR)) {
            this.getActor().add((ActorComponent)value);
        } else if (name.equals("valuedItem")) {
            this.getValuedItem().add((ValuedItemComponent)value);
        } else if (name.equals(SP_SIGNER)) {
            this.getSigner().add((SignatoryComponent)value);
        } else if (name.equals("term")) {
            this.getTerm().add((TermComponent)value);
        } else if (name.equals("binding[x]")) {
            this.binding = (Type)value;
        } else if (name.equals("friendly")) {
            this.getFriendly().add((FriendlyLanguageComponent)value);
        } else if (name.equals("legal")) {
            this.getLegal().add((LegalLanguageComponent)value);
        } else if (name.equals("rule")) {
            this.getRule().add((ComputableLanguageComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.identifier = new Identifier();
            return this.identifier;
        }
        if (name.equals("issued")) {
            throw new FHIRException("Cannot call addChild on a singleton property Contract.issued");
        }
        if (name.equals("applies")) {
            this.applies = new Period();
            return this.applies;
        }
        if (name.equals(SP_SUBJECT)) {
            return this.addSubject();
        }
        if (name.equals("authority")) {
            return this.addAuthority();
        }
        if (name.equals("domain")) {
            return this.addDomain();
        }
        if (name.equals("type")) {
            this.type = new CodeableConcept();
            return this.type;
        }
        if (name.equals("subType")) {
            return this.addSubType();
        }
        if (name.equals("action")) {
            return this.addAction();
        }
        if (name.equals("actionReason")) {
            return this.addActionReason();
        }
        if (name.equals(SP_ACTOR)) {
            return this.addActor();
        }
        if (name.equals("valuedItem")) {
            return this.addValuedItem();
        }
        if (name.equals(SP_SIGNER)) {
            return this.addSigner();
        }
        if (name.equals("term")) {
            return this.addTerm();
        }
        if (name.equals("bindingAttachment")) {
            this.binding = new Attachment();
            return this.binding;
        }
        if (name.equals("bindingReference")) {
            this.binding = new Reference();
            return this.binding;
        }
        if (name.equals("friendly")) {
            return this.addFriendly();
        }
        if (name.equals("legal")) {
            return this.addLegal();
        }
        if (name.equals("rule")) {
            return this.addRule();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Contract";
    }

    @Override
    public Contract copy() {
        Contract dst = new Contract();
        this.copyValues(dst);
        dst.identifier = this.identifier == null ? null : this.identifier.copy();
        dst.issued = this.issued == null ? null : this.issued.copy();
        Period period = dst.applies = this.applies == null ? null : this.applies.copy();
        if (this.subject != null) {
            dst.subject = new ArrayList<Reference>();
            for (Reference reference : this.subject) {
                dst.subject.add(reference.copy());
            }
        }
        if (this.authority != null) {
            dst.authority = new ArrayList<Reference>();
            for (Reference reference : this.authority) {
                dst.authority.add(reference.copy());
            }
        }
        if (this.domain != null) {
            dst.domain = new ArrayList<Reference>();
            for (Reference reference : this.domain) {
                dst.domain.add(reference.copy());
            }
        }
        CodeableConcept codeableConcept = dst.type = this.type == null ? null : this.type.copy();
        if (this.subType != null) {
            dst.subType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.subType) {
                dst.subType.add(codeableConcept2.copy());
            }
        }
        if (this.action != null) {
            dst.action = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.action) {
                dst.action.add(codeableConcept3.copy());
            }
        }
        if (this.actionReason != null) {
            dst.actionReason = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept4 : this.actionReason) {
                dst.actionReason.add(codeableConcept4.copy());
            }
        }
        if (this.actor != null) {
            dst.actor = new ArrayList<ActorComponent>();
            for (ActorComponent actorComponent : this.actor) {
                dst.actor.add(actorComponent.copy());
            }
        }
        if (this.valuedItem != null) {
            dst.valuedItem = new ArrayList<ValuedItemComponent>();
            for (ValuedItemComponent valuedItemComponent : this.valuedItem) {
                dst.valuedItem.add(valuedItemComponent.copy());
            }
        }
        if (this.signer != null) {
            dst.signer = new ArrayList<SignatoryComponent>();
            for (SignatoryComponent signatoryComponent : this.signer) {
                dst.signer.add(signatoryComponent.copy());
            }
        }
        if (this.term != null) {
            dst.term = new ArrayList<TermComponent>();
            for (TermComponent termComponent : this.term) {
                dst.term.add(termComponent.copy());
            }
        }
        Type type = dst.binding = this.binding == null ? null : this.binding.copy();
        if (this.friendly != null) {
            dst.friendly = new ArrayList<FriendlyLanguageComponent>();
            for (FriendlyLanguageComponent friendlyLanguageComponent : this.friendly) {
                dst.friendly.add(friendlyLanguageComponent.copy());
            }
        }
        if (this.legal != null) {
            dst.legal = new ArrayList<LegalLanguageComponent>();
            for (LegalLanguageComponent legalLanguageComponent : this.legal) {
                dst.legal.add(legalLanguageComponent.copy());
            }
        }
        if (this.rule != null) {
            dst.rule = new ArrayList<ComputableLanguageComponent>();
            for (ComputableLanguageComponent computableLanguageComponent : this.rule) {
                dst.rule.add(computableLanguageComponent.copy());
            }
        }
        return dst;
    }

    protected Contract typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Contract)) {
            return false;
        }
        Contract o = (Contract)other;
        return Contract.compareDeep(this.identifier, o.identifier, true) && Contract.compareDeep(this.issued, o.issued, true) && Contract.compareDeep(this.applies, o.applies, true) && Contract.compareDeep(this.subject, o.subject, true) && Contract.compareDeep(this.authority, o.authority, true) && Contract.compareDeep(this.domain, o.domain, true) && Contract.compareDeep(this.type, o.type, true) && Contract.compareDeep(this.subType, o.subType, true) && Contract.compareDeep(this.action, o.action, true) && Contract.compareDeep(this.actionReason, o.actionReason, true) && Contract.compareDeep(this.actor, o.actor, true) && Contract.compareDeep(this.valuedItem, o.valuedItem, true) && Contract.compareDeep(this.signer, o.signer, true) && Contract.compareDeep(this.term, o.term, true) && Contract.compareDeep(this.binding, o.binding, true) && Contract.compareDeep(this.friendly, o.friendly, true) && Contract.compareDeep(this.legal, o.legal, true) && Contract.compareDeep(this.rule, o.rule, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Contract)) {
            return false;
        }
        Contract o = (Contract)other;
        return Contract.compareValues(this.issued, o.issued, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.issued != null && !this.issued.isEmpty() || this.applies != null && !this.applies.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.authority != null && !this.authority.isEmpty() || this.domain != null && !this.domain.isEmpty() || this.type != null && !this.type.isEmpty() || this.subType != null && !this.subType.isEmpty() || this.action != null && !this.action.isEmpty() || this.actionReason != null && !this.actionReason.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.valuedItem != null && !this.valuedItem.isEmpty() || this.signer != null && !this.signer.isEmpty() || this.term != null && !this.term.isEmpty() || this.binding != null && !this.binding.isEmpty() || this.friendly != null && !this.friendly.isEmpty() || this.legal != null && !this.legal.isEmpty() || this.rule != null && !this.rule.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Contract;
    }

    @Block
    public static class ComputableLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, DocumentReference.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Computable Contract Rules", formalDefinition="Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public ComputableLanguageComponent() {
        }

        public ComputableLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public ComputableLanguageComponent setContent(Type value) {
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("content[x]", "Attachment|Reference(DocumentReference)", "Computable Contract conveyed using a policy rule language (e.g. XACML, DKAL, SecPal).", 0, Integer.MAX_VALUE, this.content));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("content[x]")) {
                this.content = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public ComputableLanguageComponent copy() {
            ComputableLanguageComponent dst = new ComputableLanguageComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ComputableLanguageComponent)) {
                return false;
            }
            ComputableLanguageComponent o = (ComputableLanguageComponent)other;
            return ComputableLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ComputableLanguageComponent)) {
                return false;
            }
            ComputableLanguageComponent o = (ComputableLanguageComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.content == null || this.content.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.rule";
        }
    }

    @Block
    public static class LegalLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Legal Text", formalDefinition="Contract legal text in human renderable form.")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public LegalLanguageComponent() {
        }

        public LegalLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public LegalLanguageComponent setContent(Type value) {
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Contract legal text in human renderable form.", 0, Integer.MAX_VALUE, this.content));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("content[x]")) {
                this.content = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public LegalLanguageComponent copy() {
            LegalLanguageComponent dst = new LegalLanguageComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof LegalLanguageComponent)) {
                return false;
            }
            LegalLanguageComponent o = (LegalLanguageComponent)other;
            return LegalLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof LegalLanguageComponent)) {
                return false;
            }
            LegalLanguageComponent o = (LegalLanguageComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.content == null || this.content.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.legal";
        }
    }

    @Block
    public static class FriendlyLanguageComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="content", type={Attachment.class, Composition.class, DocumentReference.class, QuestionnaireResponse.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Easily comprehended representation of this Contract", formalDefinition="Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.")
        protected Type content;
        private static final long serialVersionUID = -1763459053L;

        public FriendlyLanguageComponent() {
        }

        public FriendlyLanguageComponent(Type content) {
            this.content = content;
        }

        public Type getContent() {
            return this.content;
        }

        public Attachment getContentAttachment() throws FHIRException {
            if (!(this.content instanceof Attachment)) {
                throw new FHIRException("Type mismatch: the type Attachment was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Attachment)this.content;
        }

        public boolean hasContentAttachment() {
            return this.content instanceof Attachment;
        }

        public Reference getContentReference() throws FHIRException {
            if (!(this.content instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.content.getClass().getName() + " was encountered");
            }
            return (Reference)this.content;
        }

        public boolean hasContentReference() {
            return this.content instanceof Reference;
        }

        public boolean hasContent() {
            return this.content != null && !this.content.isEmpty();
        }

        public FriendlyLanguageComponent setContent(Type value) {
            this.content = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("content[x]", "Attachment|Reference(Composition|DocumentReference|QuestionnaireResponse)", "Human readable rendering of this Contract in a format and representation intended to enhance comprehension and ensure understandability.", 0, Integer.MAX_VALUE, this.content));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("content[x]")) {
                this.content = (Type)value;
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("contentAttachment")) {
                this.content = new Attachment();
                return this.content;
            }
            if (name.equals("contentReference")) {
                this.content = new Reference();
                return this.content;
            }
            return super.addChild(name);
        }

        @Override
        public FriendlyLanguageComponent copy() {
            FriendlyLanguageComponent dst = new FriendlyLanguageComponent();
            this.copyValues(dst);
            dst.content = this.content == null ? null : this.content.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof FriendlyLanguageComponent)) {
                return false;
            }
            FriendlyLanguageComponent o = (FriendlyLanguageComponent)other;
            return FriendlyLanguageComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof FriendlyLanguageComponent)) {
                return false;
            }
            FriendlyLanguageComponent o = (FriendlyLanguageComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && (this.content == null || this.content.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.friendly";
        }
    }

    @Block
    public static class TermValuedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Type", formalDefinition="Specific type of Contract Provision Valued Item that may be priced.")
        protected Type entity;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Identifier", formalDefinition="Identifies a Contract Provision Valued Item instance.")
        protected Identifier identifier;
        @Child(name="effectiveTime", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Effective Tiem", formalDefinition="Indicates the time during which this Contract Term ValuedItem information is effective.")
        protected DateTimeType effectiveTime;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Count", formalDefinition="Specifies the units by which the Contract Provision Valued Item is measured or counted, and quantifies the countable or measurable Contract Term Valued Item instances.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item fee, charge, or cost", formalDefinition="A Contract Provision Valued Item unit valuation measure.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Price Scaling Factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of the Contract Provision Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item Difficulty Scaling Factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Provision Valued Item delivered. The concept of Points allows for assignment of point values for a Contract ProvisionValued Item, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total Contract Term Valued Item Value", formalDefinition="Expresses the product of the Contract Provision Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        private static final long serialVersionUID = 1782449516L;

        public Type getEntity() {
            return this.entity;
        }

        public CodeableConcept getEntityCodeableConcept() throws FHIRException {
            if (!(this.entity instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.entity;
        }

        public boolean hasEntityCodeableConcept() {
            return this.entity instanceof CodeableConcept;
        }

        public Reference getEntityReference() throws FHIRException {
            if (!(this.entity instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (Reference)this.entity;
        }

        public boolean hasEntityReference() {
            return this.entity instanceof Reference;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public TermValuedItemComponent setEntity(Type value) {
            this.entity = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public TermValuedItemComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getEffectiveTimeElement() {
            if (this.effectiveTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.effectiveTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveTime = new DateTimeType();
                }
            }
            return this.effectiveTime;
        }

        public boolean hasEffectiveTimeElement() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public boolean hasEffectiveTime() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public TermValuedItemComponent setEffectiveTimeElement(DateTimeType value) {
            this.effectiveTime = value;
            return this;
        }

        public Date getEffectiveTime() {
            return this.effectiveTime == null ? null : (Date)this.effectiveTime.getValue();
        }

        public TermValuedItemComponent setEffectiveTime(Date value) {
            if (value == null) {
                this.effectiveTime = null;
            } else {
                if (this.effectiveTime == null) {
                    this.effectiveTime = new DateTimeType();
                }
                this.effectiveTime.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public TermValuedItemComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public TermValuedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public TermValuedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public TermValuedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public TermValuedItemComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public TermValuedItemComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermValuedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public TermValuedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Provision Valued Item that may be priced.", 0, Integer.MAX_VALUE, this.entity));
            childrenList.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Provision Valued Item instance.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract Term ValuedItem information is effective.", 0, Integer.MAX_VALUE, this.effectiveTime));
            childrenList.add(new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Provision Valued Item is measured or counted, and quantifies the countable or measurable Contract Term Valued Item instances.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "A Contract Provision Valued Item unit valuation measure.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Provision Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Provision Valued Item delivered. The concept of Points allows for assignment of point values for a Contract ProvisionValued Item, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "Expresses the product of the Contract Provision Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity[x]")) {
                this.entity = (Type)value;
            } else if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("effectiveTime")) {
                this.effectiveTime = this.castToDateTime(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entityCodeableConcept")) {
                this.entity = new CodeableConcept();
                return this.entity;
            }
            if (name.equals("entityReference")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("effectiveTime")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.effectiveTime");
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            return super.addChild(name);
        }

        @Override
        public TermValuedItemComponent copy() {
            TermValuedItemComponent dst = new TermValuedItemComponent();
            this.copyValues(dst);
            dst.entity = this.entity == null ? null : this.entity.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.effectiveTime = this.effectiveTime == null ? null : this.effectiveTime.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TermValuedItemComponent)) {
                return false;
            }
            TermValuedItemComponent o = (TermValuedItemComponent)other;
            return TermValuedItemComponent.compareDeep(this.entity, o.entity, true) && TermValuedItemComponent.compareDeep(this.identifier, o.identifier, true) && TermValuedItemComponent.compareDeep(this.effectiveTime, o.effectiveTime, true) && TermValuedItemComponent.compareDeep(this.quantity, o.quantity, true) && TermValuedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && TermValuedItemComponent.compareDeep(this.factor, o.factor, true) && TermValuedItemComponent.compareDeep(this.points, o.points, true) && TermValuedItemComponent.compareDeep(this.net, o.net, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TermValuedItemComponent)) {
                return false;
            }
            TermValuedItemComponent o = (TermValuedItemComponent)other;
            return TermValuedItemComponent.compareValues(this.effectiveTime, o.effectiveTime, true) && TermValuedItemComponent.compareValues(this.factor, o.factor, true) && TermValuedItemComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.entity != null && !this.entity.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.effectiveTime != null && !this.effectiveTime.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.term.valuedItem";
        }
    }

    @Block
    public static class TermActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={Contract.class, Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Actor", formalDefinition="The actor assigned a role in this Contract Provision.")
        protected Reference entity;
        protected Resource entityTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Actor Role", formalDefinition="Role played by the actor assigned this role in this Contract Provision.")
        protected List<CodeableConcept> role;
        private static final long serialVersionUID = 1371245689L;

        public TermActorComponent() {
        }

        public TermActorComponent(Reference entity) {
            this.entity = entity;
        }

        public Reference getEntity() {
            if (this.entity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermActorComponent.entity");
                }
                if (Configuration.doAutoCreate()) {
                    this.entity = new Reference();
                }
            }
            return this.entity;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public TermActorComponent setEntity(Reference value) {
            this.entity = value;
            return this;
        }

        public Resource getEntityTarget() {
            return this.entityTarget;
        }

        public TermActorComponent setEntityTarget(Resource value) {
            this.entityTarget = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public TermActorComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("entity", "Reference(Contract|Device|Group|Location|Organization|Patient|Practitioner|RelatedPerson|Substance)", "The actor assigned a role in this Contract Provision.", 0, Integer.MAX_VALUE, this.entity));
            childrenList.add(new Property("role", "CodeableConcept", "Role played by the actor assigned this role in this Contract Provision.", 0, Integer.MAX_VALUE, this.role));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = this.castToReference(value);
            } else if (name.equals("role")) {
                this.getRole().add(this.castToCodeableConcept(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            return super.addChild(name);
        }

        @Override
        public TermActorComponent copy() {
            TermActorComponent dst = new TermActorComponent();
            this.copyValues(dst);
            Reference reference = dst.entity = this.entity == null ? null : this.entity.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.role) {
                    dst.role.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TermActorComponent)) {
                return false;
            }
            TermActorComponent o = (TermActorComponent)other;
            return TermActorComponent.compareDeep(this.entity, o.entity, true) && TermActorComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TermActorComponent)) {
                return false;
            }
            TermActorComponent o = (TermActorComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.entity != null && !this.entity.isEmpty() || this.role != null && !this.role.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.term.actor";
        }
    }

    @Block
    public static class TermComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term identifier", formalDefinition="Unique identifier for this particular Contract Provision.")
        protected Identifier identifier;
        @Child(name="issued", type={DateTimeType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Issue Date Time", formalDefinition="When this Contract Provision was issued.")
        protected DateTimeType issued;
        @Child(name="applies", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Contract Term Effective Time", formalDefinition="Relevant time or time-period when this Contract Provision is applicable.")
        protected Period applies;
        @Child(name="type", type={CodeableConcept.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Type", formalDefinition="Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.")
        protected CodeableConcept type;
        @Child(name="subType", type={CodeableConcept.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Subtype", formalDefinition="Subtype of this Contract Provision, e.g. life time maximum payment for a contract term for specific valued item, e.g. disability payment.")
        protected CodeableConcept subType;
        @Child(name="subject", type={}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Subject of this Contract Term", formalDefinition="Who or what this Contract Provision is about.")
        protected Reference subject;
        protected Resource subjectTarget;
        @Child(name="action", type={CodeableConcept.class}, order=7, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Action", formalDefinition="Action stipulated by this Contract Provision.")
        protected List<CodeableConcept> action;
        @Child(name="actionReason", type={CodeableConcept.class}, order=8, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Action Reason", formalDefinition="Reason or purpose for the action stipulated by this Contract Provision.")
        protected List<CodeableConcept> actionReason;
        @Child(name="actor", type={}, order=9, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Actor List", formalDefinition="List of actors participating in this Contract Provision.")
        protected List<TermActorComponent> actor;
        @Child(name="text", type={StringType.class}, order=10, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Human readable Contract term text", formalDefinition="Human readable form of this Contract Provision.")
        protected StringType text;
        @Child(name="valuedItem", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Term Valued Item", formalDefinition="Contract Provision Valued Item List.")
        protected List<TermValuedItemComponent> valuedItem;
        @Child(name="group", type={TermComponent.class}, order=12, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Nested Contract Term Group", formalDefinition="Nested group of Contract Provisions.")
        protected List<TermComponent> group;
        private static final long serialVersionUID = -1137577465L;

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public TermComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getIssuedElement() {
            if (this.issued == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.issued");
                }
                if (Configuration.doAutoCreate()) {
                    this.issued = new DateTimeType();
                }
            }
            return this.issued;
        }

        public boolean hasIssuedElement() {
            return this.issued != null && !this.issued.isEmpty();
        }

        public boolean hasIssued() {
            return this.issued != null && !this.issued.isEmpty();
        }

        public TermComponent setIssuedElement(DateTimeType value) {
            this.issued = value;
            return this;
        }

        public Date getIssued() {
            return this.issued == null ? null : (Date)this.issued.getValue();
        }

        public TermComponent setIssued(Date value) {
            if (value == null) {
                this.issued = null;
            } else {
                if (this.issued == null) {
                    this.issued = new DateTimeType();
                }
                this.issued.setValue(value);
            }
            return this;
        }

        public Period getApplies() {
            if (this.applies == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.applies");
                }
                if (Configuration.doAutoCreate()) {
                    this.applies = new Period();
                }
            }
            return this.applies;
        }

        public boolean hasApplies() {
            return this.applies != null && !this.applies.isEmpty();
        }

        public TermComponent setApplies(Period value) {
            this.applies = value;
            return this;
        }

        public CodeableConcept getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new CodeableConcept();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public TermComponent setType(CodeableConcept value) {
            this.type = value;
            return this;
        }

        public CodeableConcept getSubType() {
            if (this.subType == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.subType");
                }
                if (Configuration.doAutoCreate()) {
                    this.subType = new CodeableConcept();
                }
            }
            return this.subType;
        }

        public boolean hasSubType() {
            return this.subType != null && !this.subType.isEmpty();
        }

        public TermComponent setSubType(CodeableConcept value) {
            this.subType = value;
            return this;
        }

        public Reference getSubject() {
            if (this.subject == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.subject");
                }
                if (Configuration.doAutoCreate()) {
                    this.subject = new Reference();
                }
            }
            return this.subject;
        }

        public boolean hasSubject() {
            return this.subject != null && !this.subject.isEmpty();
        }

        public TermComponent setSubject(Reference value) {
            this.subject = value;
            return this;
        }

        public Resource getSubjectTarget() {
            return this.subjectTarget;
        }

        public TermComponent setSubjectTarget(Resource value) {
            this.subjectTarget = value;
            return this;
        }

        public List<CodeableConcept> getAction() {
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            return this.action;
        }

        public boolean hasAction() {
            if (this.action == null) {
                return false;
            }
            for (CodeableConcept item : this.action) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addAction() {
            CodeableConcept t = new CodeableConcept();
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return t;
        }

        public TermComponent addAction(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.action == null) {
                this.action = new ArrayList<CodeableConcept>();
            }
            this.action.add(t);
            return this;
        }

        public List<CodeableConcept> getActionReason() {
            if (this.actionReason == null) {
                this.actionReason = new ArrayList<CodeableConcept>();
            }
            return this.actionReason;
        }

        public boolean hasActionReason() {
            if (this.actionReason == null) {
                return false;
            }
            for (CodeableConcept item : this.actionReason) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addActionReason() {
            CodeableConcept t = new CodeableConcept();
            if (this.actionReason == null) {
                this.actionReason = new ArrayList<CodeableConcept>();
            }
            this.actionReason.add(t);
            return t;
        }

        public TermComponent addActionReason(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.actionReason == null) {
                this.actionReason = new ArrayList<CodeableConcept>();
            }
            this.actionReason.add(t);
            return this;
        }

        public List<TermActorComponent> getActor() {
            if (this.actor == null) {
                this.actor = new ArrayList<TermActorComponent>();
            }
            return this.actor;
        }

        public boolean hasActor() {
            if (this.actor == null) {
                return false;
            }
            for (TermActorComponent item : this.actor) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TermActorComponent addActor() {
            TermActorComponent t = new TermActorComponent();
            if (this.actor == null) {
                this.actor = new ArrayList<TermActorComponent>();
            }
            this.actor.add(t);
            return t;
        }

        public TermComponent addActor(TermActorComponent t) {
            if (t == null) {
                return this;
            }
            if (this.actor == null) {
                this.actor = new ArrayList<TermActorComponent>();
            }
            this.actor.add(t);
            return this;
        }

        public StringType getTextElement() {
            if (this.text == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create TermComponent.text");
                }
                if (Configuration.doAutoCreate()) {
                    this.text = new StringType();
                }
            }
            return this.text;
        }

        public boolean hasTextElement() {
            return this.text != null && !this.text.isEmpty();
        }

        public boolean hasText() {
            return this.text != null && !this.text.isEmpty();
        }

        public TermComponent setTextElement(StringType value) {
            this.text = value;
            return this;
        }

        public String getText() {
            return this.text == null ? null : (String)this.text.getValue();
        }

        public TermComponent setText(String value) {
            if (Utilities.noString((String)value)) {
                this.text = null;
            } else {
                if (this.text == null) {
                    this.text = new StringType();
                }
                this.text.setValue(value);
            }
            return this;
        }

        public List<TermValuedItemComponent> getValuedItem() {
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<TermValuedItemComponent>();
            }
            return this.valuedItem;
        }

        public boolean hasValuedItem() {
            if (this.valuedItem == null) {
                return false;
            }
            for (TermValuedItemComponent item : this.valuedItem) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TermValuedItemComponent addValuedItem() {
            TermValuedItemComponent t = new TermValuedItemComponent();
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<TermValuedItemComponent>();
            }
            this.valuedItem.add(t);
            return t;
        }

        public TermComponent addValuedItem(TermValuedItemComponent t) {
            if (t == null) {
                return this;
            }
            if (this.valuedItem == null) {
                this.valuedItem = new ArrayList<TermValuedItemComponent>();
            }
            this.valuedItem.add(t);
            return this;
        }

        public List<TermComponent> getGroup() {
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            return this.group;
        }

        public boolean hasGroup() {
            if (this.group == null) {
                return false;
            }
            for (TermComponent item : this.group) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public TermComponent addGroup() {
            TermComponent t = new TermComponent();
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            this.group.add(t);
            return t;
        }

        public TermComponent addGroup(TermComponent t) {
            if (t == null) {
                return this;
            }
            if (this.group == null) {
                this.group = new ArrayList<TermComponent>();
            }
            this.group.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Unique identifier for this particular Contract Provision.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("issued", "dateTime", "When this Contract Provision was issued.", 0, Integer.MAX_VALUE, this.issued));
            childrenList.add(new Property("applies", "Period", "Relevant time or time-period when this Contract Provision is applicable.", 0, Integer.MAX_VALUE, this.applies));
            childrenList.add(new Property("type", "CodeableConcept", "Type of Contract Provision such as specific requirements, purposes for actions, obligations, prohibitions, e.g. life time maximum benefit.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("subType", "CodeableConcept", "Subtype of this Contract Provision, e.g. life time maximum payment for a contract term for specific valued item, e.g. disability payment.", 0, Integer.MAX_VALUE, this.subType));
            childrenList.add(new Property(Contract.SP_SUBJECT, "Reference(Any)", "Who or what this Contract Provision is about.", 0, Integer.MAX_VALUE, this.subject));
            childrenList.add(new Property("action", "CodeableConcept", "Action stipulated by this Contract Provision.", 0, Integer.MAX_VALUE, this.action));
            childrenList.add(new Property("actionReason", "CodeableConcept", "Reason or purpose for the action stipulated by this Contract Provision.", 0, Integer.MAX_VALUE, this.actionReason));
            childrenList.add(new Property(Contract.SP_ACTOR, "", "List of actors participating in this Contract Provision.", 0, Integer.MAX_VALUE, this.actor));
            childrenList.add(new Property("text", "string", "Human readable form of this Contract Provision.", 0, Integer.MAX_VALUE, this.text));
            childrenList.add(new Property("valuedItem", "", "Contract Provision Valued Item List.", 0, Integer.MAX_VALUE, this.valuedItem));
            childrenList.add(new Property("group", "@Contract.term", "Nested group of Contract Provisions.", 0, Integer.MAX_VALUE, this.group));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("issued")) {
                this.issued = this.castToDateTime(value);
            } else if (name.equals("applies")) {
                this.applies = this.castToPeriod(value);
            } else if (name.equals("type")) {
                this.type = this.castToCodeableConcept(value);
            } else if (name.equals("subType")) {
                this.subType = this.castToCodeableConcept(value);
            } else if (name.equals(Contract.SP_SUBJECT)) {
                this.subject = this.castToReference(value);
            } else if (name.equals("action")) {
                this.getAction().add(this.castToCodeableConcept(value));
            } else if (name.equals("actionReason")) {
                this.getActionReason().add(this.castToCodeableConcept(value));
            } else if (name.equals(Contract.SP_ACTOR)) {
                this.getActor().add((TermActorComponent)value);
            } else if (name.equals("text")) {
                this.text = this.castToString(value);
            } else if (name.equals("valuedItem")) {
                this.getValuedItem().add((TermValuedItemComponent)value);
            } else if (name.equals("group")) {
                this.getGroup().add((TermComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("issued")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.issued");
            }
            if (name.equals("applies")) {
                this.applies = new Period();
                return this.applies;
            }
            if (name.equals("type")) {
                this.type = new CodeableConcept();
                return this.type;
            }
            if (name.equals("subType")) {
                this.subType = new CodeableConcept();
                return this.subType;
            }
            if (name.equals(Contract.SP_SUBJECT)) {
                this.subject = new Reference();
                return this.subject;
            }
            if (name.equals("action")) {
                return this.addAction();
            }
            if (name.equals("actionReason")) {
                return this.addActionReason();
            }
            if (name.equals(Contract.SP_ACTOR)) {
                return this.addActor();
            }
            if (name.equals("text")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.text");
            }
            if (name.equals("valuedItem")) {
                return this.addValuedItem();
            }
            if (name.equals("group")) {
                return this.addGroup();
            }
            return super.addChild(name);
        }

        @Override
        public TermComponent copy() {
            TermComponent dst = new TermComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.issued = this.issued == null ? null : this.issued.copy();
            dst.applies = this.applies == null ? null : this.applies.copy();
            dst.type = this.type == null ? null : this.type.copy();
            dst.subType = this.subType == null ? null : this.subType.copy();
            Reference reference = dst.subject = this.subject == null ? null : this.subject.copy();
            if (this.action != null) {
                dst.action = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.action) {
                    dst.action.add(codeableConcept.copy());
                }
            }
            if (this.actionReason != null) {
                dst.actionReason = new ArrayList<CodeableConcept>();
                for (CodeableConcept codeableConcept : this.actionReason) {
                    dst.actionReason.add(codeableConcept.copy());
                }
            }
            if (this.actor != null) {
                dst.actor = new ArrayList<TermActorComponent>();
                for (TermActorComponent termActorComponent : this.actor) {
                    dst.actor.add(termActorComponent.copy());
                }
            }
            StringType stringType = dst.text = this.text == null ? null : this.text.copy();
            if (this.valuedItem != null) {
                dst.valuedItem = new ArrayList<TermValuedItemComponent>();
                for (TermValuedItemComponent termValuedItemComponent : this.valuedItem) {
                    dst.valuedItem.add(termValuedItemComponent.copy());
                }
            }
            if (this.group != null) {
                dst.group = new ArrayList<TermComponent>();
                for (TermComponent termComponent : this.group) {
                    dst.group.add(termComponent.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof TermComponent)) {
                return false;
            }
            TermComponent o = (TermComponent)other;
            return TermComponent.compareDeep(this.identifier, o.identifier, true) && TermComponent.compareDeep(this.issued, o.issued, true) && TermComponent.compareDeep(this.applies, o.applies, true) && TermComponent.compareDeep(this.type, o.type, true) && TermComponent.compareDeep(this.subType, o.subType, true) && TermComponent.compareDeep(this.subject, o.subject, true) && TermComponent.compareDeep(this.action, o.action, true) && TermComponent.compareDeep(this.actionReason, o.actionReason, true) && TermComponent.compareDeep(this.actor, o.actor, true) && TermComponent.compareDeep(this.text, o.text, true) && TermComponent.compareDeep(this.valuedItem, o.valuedItem, true) && TermComponent.compareDeep(this.group, o.group, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof TermComponent)) {
                return false;
            }
            TermComponent o = (TermComponent)other;
            return TermComponent.compareValues(this.issued, o.issued, true) && TermComponent.compareValues(this.text, o.text, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.issued != null && !this.issued.isEmpty() || this.applies != null && !this.applies.isEmpty() || this.type != null && !this.type.isEmpty() || this.subType != null && !this.subType.isEmpty() || this.subject != null && !this.subject.isEmpty() || this.action != null && !this.action.isEmpty() || this.actionReason != null && !this.actionReason.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.text != null && !this.text.isEmpty() || this.valuedItem != null && !this.valuedItem.isEmpty() || this.group != null && !this.group.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.term";
        }
    }

    @Block
    public static class SignatoryComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="type", type={Coding.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Signer Type", formalDefinition="Role of this Contract signer, e.g. notary, grantee.")
        protected Coding type;
        @Child(name="party", type={Organization.class, Patient.class, Practitioner.class, RelatedPerson.class}, order=2, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Signatory Party", formalDefinition="Party which is a signator to this Contract.")
        protected Reference party;
        protected Resource partyTarget;
        @Child(name="signature", type={StringType.class}, order=3, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Documentation Signature", formalDefinition="Legally binding Contract DSIG signature contents in Base64.")
        protected StringType signature;
        private static final long serialVersionUID = -1870392043L;

        public SignatoryComponent() {
        }

        public SignatoryComponent(Coding type, Reference party, StringType signature) {
            this.type = type;
            this.party = party;
            this.signature = signature;
        }

        public Coding getType() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SignatoryComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new Coding();
                }
            }
            return this.type;
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public SignatoryComponent setType(Coding value) {
            this.type = value;
            return this;
        }

        public Reference getParty() {
            if (this.party == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SignatoryComponent.party");
                }
                if (Configuration.doAutoCreate()) {
                    this.party = new Reference();
                }
            }
            return this.party;
        }

        public boolean hasParty() {
            return this.party != null && !this.party.isEmpty();
        }

        public SignatoryComponent setParty(Reference value) {
            this.party = value;
            return this;
        }

        public Resource getPartyTarget() {
            return this.partyTarget;
        }

        public SignatoryComponent setPartyTarget(Resource value) {
            this.partyTarget = value;
            return this;
        }

        public StringType getSignatureElement() {
            if (this.signature == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create SignatoryComponent.signature");
                }
                if (Configuration.doAutoCreate()) {
                    this.signature = new StringType();
                }
            }
            return this.signature;
        }

        public boolean hasSignatureElement() {
            return this.signature != null && !this.signature.isEmpty();
        }

        public boolean hasSignature() {
            return this.signature != null && !this.signature.isEmpty();
        }

        public SignatoryComponent setSignatureElement(StringType value) {
            this.signature = value;
            return this;
        }

        public String getSignature() {
            return this.signature == null ? null : (String)this.signature.getValue();
        }

        public SignatoryComponent setSignature(String value) {
            if (this.signature == null) {
                this.signature = new StringType();
            }
            this.signature.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("type", "Coding", "Role of this Contract signer, e.g. notary, grantee.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("party", "Reference(Organization|Patient|Practitioner|RelatedPerson)", "Party which is a signator to this Contract.", 0, Integer.MAX_VALUE, this.party));
            childrenList.add(new Property("signature", "string", "Legally binding Contract DSIG signature contents in Base64.", 0, Integer.MAX_VALUE, this.signature));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("type")) {
                this.type = this.castToCoding(value);
            } else if (name.equals("party")) {
                this.party = this.castToReference(value);
            } else if (name.equals("signature")) {
                this.signature = this.castToString(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("type")) {
                this.type = new Coding();
                return this.type;
            }
            if (name.equals("party")) {
                this.party = new Reference();
                return this.party;
            }
            if (name.equals("signature")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.signature");
            }
            return super.addChild(name);
        }

        @Override
        public SignatoryComponent copy() {
            SignatoryComponent dst = new SignatoryComponent();
            this.copyValues(dst);
            dst.type = this.type == null ? null : this.type.copy();
            dst.party = this.party == null ? null : this.party.copy();
            dst.signature = this.signature == null ? null : this.signature.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof SignatoryComponent)) {
                return false;
            }
            SignatoryComponent o = (SignatoryComponent)other;
            return SignatoryComponent.compareDeep(this.type, o.type, true) && SignatoryComponent.compareDeep(this.party, o.party, true) && SignatoryComponent.compareDeep(this.signature, o.signature, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof SignatoryComponent)) {
                return false;
            }
            SignatoryComponent o = (SignatoryComponent)other;
            return SignatoryComponent.compareValues(this.signature, o.signature, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.type != null && !this.type.isEmpty() || this.party != null && !this.party.isEmpty() || this.signature != null && !this.signature.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.signer";
        }
    }

    @Block
    public static class ValuedItemComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Type", formalDefinition="Specific type of Contract Valued Item that may be priced.")
        protected Type entity;
        @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Identifier", formalDefinition="Identifies a Contract Valued Item instance.")
        protected Identifier identifier;
        @Child(name="effectiveTime", type={DateTimeType.class}, order=3, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Effective Tiem", formalDefinition="Indicates the time during which this Contract ValuedItem information is effective.")
        protected DateTimeType effectiveTime;
        @Child(name="quantity", type={SimpleQuantity.class}, order=4, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Count of Contract Valued Items", formalDefinition="Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.")
        protected SimpleQuantity quantity;
        @Child(name="unitPrice", type={Money.class}, order=5, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item fee, charge, or cost", formalDefinition="A Contract Valued Item unit valuation measure.")
        protected Money unitPrice;
        @Child(name="factor", type={DecimalType.class}, order=6, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Price Scaling Factor", formalDefinition="A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.")
        protected DecimalType factor;
        @Child(name="points", type={DecimalType.class}, order=7, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Valued Item Difficulty Scaling Factor", formalDefinition="An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.")
        protected DecimalType points;
        @Child(name="net", type={Money.class}, order=8, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Total Contract Valued Item Value", formalDefinition="Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.")
        protected Money net;
        private static final long serialVersionUID = 1782449516L;

        public Type getEntity() {
            return this.entity;
        }

        public CodeableConcept getEntityCodeableConcept() throws FHIRException {
            if (!(this.entity instanceof CodeableConcept)) {
                throw new FHIRException("Type mismatch: the type CodeableConcept was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (CodeableConcept)this.entity;
        }

        public boolean hasEntityCodeableConcept() {
            return this.entity instanceof CodeableConcept;
        }

        public Reference getEntityReference() throws FHIRException {
            if (!(this.entity instanceof Reference)) {
                throw new FHIRException("Type mismatch: the type Reference was expected, but " + this.entity.getClass().getName() + " was encountered");
            }
            return (Reference)this.entity;
        }

        public boolean hasEntityReference() {
            return this.entity instanceof Reference;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public ValuedItemComponent setEntity(Type value) {
            this.entity = value;
            return this;
        }

        public Identifier getIdentifier() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new Identifier();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public ValuedItemComponent setIdentifier(Identifier value) {
            this.identifier = value;
            return this;
        }

        public DateTimeType getEffectiveTimeElement() {
            if (this.effectiveTime == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.effectiveTime");
                }
                if (Configuration.doAutoCreate()) {
                    this.effectiveTime = new DateTimeType();
                }
            }
            return this.effectiveTime;
        }

        public boolean hasEffectiveTimeElement() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public boolean hasEffectiveTime() {
            return this.effectiveTime != null && !this.effectiveTime.isEmpty();
        }

        public ValuedItemComponent setEffectiveTimeElement(DateTimeType value) {
            this.effectiveTime = value;
            return this;
        }

        public Date getEffectiveTime() {
            return this.effectiveTime == null ? null : (Date)this.effectiveTime.getValue();
        }

        public ValuedItemComponent setEffectiveTime(Date value) {
            if (value == null) {
                this.effectiveTime = null;
            } else {
                if (this.effectiveTime == null) {
                    this.effectiveTime = new DateTimeType();
                }
                this.effectiveTime.setValue(value);
            }
            return this;
        }

        public SimpleQuantity getQuantity() {
            if (this.quantity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.quantity");
                }
                if (Configuration.doAutoCreate()) {
                    this.quantity = new SimpleQuantity();
                }
            }
            return this.quantity;
        }

        public boolean hasQuantity() {
            return this.quantity != null && !this.quantity.isEmpty();
        }

        public ValuedItemComponent setQuantity(SimpleQuantity value) {
            this.quantity = value;
            return this;
        }

        public Money getUnitPrice() {
            if (this.unitPrice == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.unitPrice");
                }
                if (Configuration.doAutoCreate()) {
                    this.unitPrice = new Money();
                }
            }
            return this.unitPrice;
        }

        public boolean hasUnitPrice() {
            return this.unitPrice != null && !this.unitPrice.isEmpty();
        }

        public ValuedItemComponent setUnitPrice(Money value) {
            this.unitPrice = value;
            return this;
        }

        public DecimalType getFactorElement() {
            if (this.factor == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.factor");
                }
                if (Configuration.doAutoCreate()) {
                    this.factor = new DecimalType();
                }
            }
            return this.factor;
        }

        public boolean hasFactorElement() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public boolean hasFactor() {
            return this.factor != null && !this.factor.isEmpty();
        }

        public ValuedItemComponent setFactorElement(DecimalType value) {
            this.factor = value;
            return this;
        }

        public BigDecimal getFactor() {
            return this.factor == null ? null : (BigDecimal)this.factor.getValue();
        }

        public ValuedItemComponent setFactor(BigDecimal value) {
            if (value == null) {
                this.factor = null;
            } else {
                if (this.factor == null) {
                    this.factor = new DecimalType();
                }
                this.factor.setValue(value);
            }
            return this;
        }

        public DecimalType getPointsElement() {
            if (this.points == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.points");
                }
                if (Configuration.doAutoCreate()) {
                    this.points = new DecimalType();
                }
            }
            return this.points;
        }

        public boolean hasPointsElement() {
            return this.points != null && !this.points.isEmpty();
        }

        public boolean hasPoints() {
            return this.points != null && !this.points.isEmpty();
        }

        public ValuedItemComponent setPointsElement(DecimalType value) {
            this.points = value;
            return this;
        }

        public BigDecimal getPoints() {
            return this.points == null ? null : (BigDecimal)this.points.getValue();
        }

        public ValuedItemComponent setPoints(BigDecimal value) {
            if (value == null) {
                this.points = null;
            } else {
                if (this.points == null) {
                    this.points = new DecimalType();
                }
                this.points.setValue(value);
            }
            return this;
        }

        public Money getNet() {
            if (this.net == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ValuedItemComponent.net");
                }
                if (Configuration.doAutoCreate()) {
                    this.net = new Money();
                }
            }
            return this.net;
        }

        public boolean hasNet() {
            return this.net != null && !this.net.isEmpty();
        }

        public ValuedItemComponent setNet(Money value) {
            this.net = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("entity[x]", "CodeableConcept|Reference(Any)", "Specific type of Contract Valued Item that may be priced.", 0, Integer.MAX_VALUE, this.entity));
            childrenList.add(new Property(Contract.SP_IDENTIFIER, "Identifier", "Identifies a Contract Valued Item instance.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property("effectiveTime", "dateTime", "Indicates the time during which this Contract ValuedItem information is effective.", 0, Integer.MAX_VALUE, this.effectiveTime));
            childrenList.add(new Property("quantity", "SimpleQuantity", "Specifies the units by which the Contract Valued Item is measured or counted, and quantifies the countable or measurable Contract Valued Item instances.", 0, Integer.MAX_VALUE, this.quantity));
            childrenList.add(new Property("unitPrice", "Money", "A Contract Valued Item unit valuation measure.", 0, Integer.MAX_VALUE, this.unitPrice));
            childrenList.add(new Property("factor", "decimal", "A real number that represents a multiplier used in determining the overall value of the Contract Valued Item delivered. The concept of a Factor allows for a discount or surcharge multiplier to be applied to a monetary amount.", 0, Integer.MAX_VALUE, this.factor));
            childrenList.add(new Property("points", "decimal", "An amount that expresses the weighting (based on difficulty, cost and/or resource intensiveness) associated with the Contract Valued Item delivered. The concept of Points allows for assignment of point values for a Contract Valued Item, such that a monetary amount can be assigned to each point.", 0, Integer.MAX_VALUE, this.points));
            childrenList.add(new Property("net", "Money", "Expresses the product of the Contract Valued Item unitQuantity and the unitPriceAmt. For example, the formula: unit Quantity * unit Price (Cost per Point) * factor Number  * points = net Amount. Quantity, factor and points are assumed to be 1 if not supplied.", 0, Integer.MAX_VALUE, this.net));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity[x]")) {
                this.entity = (Type)value;
            } else if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = this.castToIdentifier(value);
            } else if (name.equals("effectiveTime")) {
                this.effectiveTime = this.castToDateTime(value);
            } else if (name.equals("quantity")) {
                this.quantity = this.castToSimpleQuantity(value);
            } else if (name.equals("unitPrice")) {
                this.unitPrice = this.castToMoney(value);
            } else if (name.equals("factor")) {
                this.factor = this.castToDecimal(value);
            } else if (name.equals("points")) {
                this.points = this.castToDecimal(value);
            } else if (name.equals("net")) {
                this.net = this.castToMoney(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entityCodeableConcept")) {
                this.entity = new CodeableConcept();
                return this.entity;
            }
            if (name.equals("entityReference")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals(Contract.SP_IDENTIFIER)) {
                this.identifier = new Identifier();
                return this.identifier;
            }
            if (name.equals("effectiveTime")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.effectiveTime");
            }
            if (name.equals("quantity")) {
                this.quantity = new SimpleQuantity();
                return this.quantity;
            }
            if (name.equals("unitPrice")) {
                this.unitPrice = new Money();
                return this.unitPrice;
            }
            if (name.equals("factor")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.factor");
            }
            if (name.equals("points")) {
                throw new FHIRException("Cannot call addChild on a singleton property Contract.points");
            }
            if (name.equals("net")) {
                this.net = new Money();
                return this.net;
            }
            return super.addChild(name);
        }

        @Override
        public ValuedItemComponent copy() {
            ValuedItemComponent dst = new ValuedItemComponent();
            this.copyValues(dst);
            dst.entity = this.entity == null ? null : this.entity.copy();
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.effectiveTime = this.effectiveTime == null ? null : this.effectiveTime.copy();
            dst.quantity = this.quantity == null ? null : this.quantity.copy();
            dst.unitPrice = this.unitPrice == null ? null : this.unitPrice.copy();
            dst.factor = this.factor == null ? null : this.factor.copy();
            dst.points = this.points == null ? null : this.points.copy();
            dst.net = this.net == null ? null : this.net.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ValuedItemComponent)) {
                return false;
            }
            ValuedItemComponent o = (ValuedItemComponent)other;
            return ValuedItemComponent.compareDeep(this.entity, o.entity, true) && ValuedItemComponent.compareDeep(this.identifier, o.identifier, true) && ValuedItemComponent.compareDeep(this.effectiveTime, o.effectiveTime, true) && ValuedItemComponent.compareDeep(this.quantity, o.quantity, true) && ValuedItemComponent.compareDeep(this.unitPrice, o.unitPrice, true) && ValuedItemComponent.compareDeep(this.factor, o.factor, true) && ValuedItemComponent.compareDeep(this.points, o.points, true) && ValuedItemComponent.compareDeep(this.net, o.net, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ValuedItemComponent)) {
                return false;
            }
            ValuedItemComponent o = (ValuedItemComponent)other;
            return ValuedItemComponent.compareValues(this.effectiveTime, o.effectiveTime, true) && ValuedItemComponent.compareValues(this.factor, o.factor, true) && ValuedItemComponent.compareValues(this.points, o.points, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.entity != null && !this.entity.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.effectiveTime != null && !this.effectiveTime.isEmpty() || this.quantity != null && !this.quantity.isEmpty() || this.unitPrice != null && !this.unitPrice.isEmpty() || this.factor != null && !this.factor.isEmpty() || this.points != null && !this.points.isEmpty() || this.net != null && !this.net.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.valuedItem";
        }
    }

    @Block
    public static class ActorComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="entity", type={Contract.class, Device.class, Group.class, Location.class, Organization.class, Patient.class, Practitioner.class, RelatedPerson.class, Substance.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Contract Actor Type", formalDefinition="Who or what actors are assigned roles in this Contract.")
        protected Reference entity;
        protected Resource entityTarget;
        @Child(name="role", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=false)
        @Description(shortDefinition="Contract  Actor Role", formalDefinition="Role type of actors assigned roles in this Contract.")
        protected List<CodeableConcept> role;
        private static final long serialVersionUID = 1371245689L;

        public ActorComponent() {
        }

        public ActorComponent(Reference entity) {
            this.entity = entity;
        }

        public Reference getEntity() {
            if (this.entity == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ActorComponent.entity");
                }
                if (Configuration.doAutoCreate()) {
                    this.entity = new Reference();
                }
            }
            return this.entity;
        }

        public boolean hasEntity() {
            return this.entity != null && !this.entity.isEmpty();
        }

        public ActorComponent setEntity(Reference value) {
            this.entity = value;
            return this;
        }

        public Resource getEntityTarget() {
            return this.entityTarget;
        }

        public ActorComponent setEntityTarget(Resource value) {
            this.entityTarget = value;
            return this;
        }

        public List<CodeableConcept> getRole() {
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            return this.role;
        }

        public boolean hasRole() {
            if (this.role == null) {
                return false;
            }
            for (CodeableConcept item : this.role) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public CodeableConcept addRole() {
            CodeableConcept t = new CodeableConcept();
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return t;
        }

        public ActorComponent addRole(CodeableConcept t) {
            if (t == null) {
                return this;
            }
            if (this.role == null) {
                this.role = new ArrayList<CodeableConcept>();
            }
            this.role.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("entity", "Reference(Contract|Device|Group|Location|Organization|Patient|Practitioner|RelatedPerson|Substance)", "Who or what actors are assigned roles in this Contract.", 0, Integer.MAX_VALUE, this.entity));
            childrenList.add(new Property("role", "CodeableConcept", "Role type of actors assigned roles in this Contract.", 0, Integer.MAX_VALUE, this.role));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = this.castToReference(value);
            } else if (name.equals("role")) {
                this.getRole().add(this.castToCodeableConcept(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("entity")) {
                this.entity = new Reference();
                return this.entity;
            }
            if (name.equals("role")) {
                return this.addRole();
            }
            return super.addChild(name);
        }

        @Override
        public ActorComponent copy() {
            ActorComponent dst = new ActorComponent();
            this.copyValues(dst);
            Reference reference = dst.entity = this.entity == null ? null : this.entity.copy();
            if (this.role != null) {
                dst.role = new ArrayList<CodeableConcept>();
                for (CodeableConcept i : this.role) {
                    dst.role.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ActorComponent)) {
                return false;
            }
            ActorComponent o = (ActorComponent)other;
            return ActorComponent.compareDeep(this.entity, o.entity, true) && ActorComponent.compareDeep(this.role, o.role, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ActorComponent)) {
                return false;
            }
            ActorComponent o = (ActorComponent)other;
            return true;
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.entity != null && !this.entity.isEmpty() || this.role != null && !this.role.isEmpty());
        }

        @Override
        public String fhirType() {
            return "Contract.actor";
        }
    }
}

