/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2.model.BackboneElement;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeType;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Coding;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.ContactPoint;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.EnumFactory;
import org.hl7.fhir.dstu2.model.Enumeration;
import org.hl7.fhir.dstu2.model.IdType;
import org.hl7.fhir.dstu2.model.InstantType;
import org.hl7.fhir.dstu2.model.OperationOutcome;
import org.hl7.fhir.dstu2.model.Organization;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.PrimitiveType;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="MessageHeader", profile="http://hl7.org/fhir/Profile/MessageHeader")
public class MessageHeader
extends DomainResource {
    @Child(name="timestamp", type={InstantType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Time that the message was sent", formalDefinition="The time that the message was sent.")
    protected InstantType timestamp;
    @Child(name="event", type={Coding.class}, order=1, min=1, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Code for the event this message represents", formalDefinition="Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://hl7.org/fhir/message-events\".")
    protected Coding event;
    @Child(name="response", type={}, order=2, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="If this is a reply to prior message", formalDefinition="Information about the message that this message is a response to.  Only present if this message is a response.")
    protected MessageHeaderResponseComponent response;
    @Child(name="source", type={}, order=3, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Message Source Application", formalDefinition="The source application from which this message originated.")
    protected MessageSourceComponent source;
    @Child(name="destination", type={}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Message Destination Application(s)", formalDefinition="The destination application which the message is intended for.")
    protected List<MessageDestinationComponent> destination;
    @Child(name="enterer", type={Practitioner.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source of the data entry", formalDefinition="The person or device that performed the data entry leading to this message. Where there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.")
    protected Reference enterer;
    protected Practitioner entererTarget;
    @Child(name="author", type={Practitioner.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The source of the decision", formalDefinition="The logical author of the message - the person or device that decided the described event should happen. Where there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.")
    protected Reference author;
    protected Practitioner authorTarget;
    @Child(name="receiver", type={Practitioner.class, Organization.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Intended \"real-world\" recipient for the data", formalDefinition="Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.")
    protected Reference receiver;
    protected Resource receiverTarget;
    @Child(name="responsible", type={Practitioner.class, Organization.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Final responsibility for event", formalDefinition="The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.")
    protected Reference responsible;
    protected Resource responsibleTarget;
    @Child(name="reason", type={CodeableConcept.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Cause of event", formalDefinition="Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.")
    protected CodeableConcept reason;
    @Child(name="data", type={}, order=10, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The actual content of the message", formalDefinition="The actual data of the message - a reference to the root/focus class of the event.")
    protected List<Reference> data;
    protected List<Resource> dataTarget;
    private static final long serialVersionUID = 1429728517L;
    @SearchParamDefinition(name="code", path="MessageHeader.response.code", description="ok | transient-error | fatal-error", type="token")
    public static final String SP_CODE = "code";
    @SearchParamDefinition(name="data", path="MessageHeader.data", description="The actual content of the message", type="reference")
    public static final String SP_DATA = "data";
    @SearchParamDefinition(name="receiver", path="MessageHeader.receiver", description="Intended \"real-world\" recipient for the data", type="reference")
    public static final String SP_RECEIVER = "receiver";
    @SearchParamDefinition(name="author", path="MessageHeader.author", description="The source of the decision", type="reference")
    public static final String SP_AUTHOR = "author";
    @SearchParamDefinition(name="destination", path="MessageHeader.destination.name", description="Name of system", type="string")
    public static final String SP_DESTINATION = "destination";
    @SearchParamDefinition(name="source", path="MessageHeader.source.name", description="Name of system", type="string")
    public static final String SP_SOURCE = "source";
    @SearchParamDefinition(name="target", path="MessageHeader.destination.target", description="Particular delivery destination within the destination", type="reference")
    public static final String SP_TARGET = "target";
    @SearchParamDefinition(name="destination-uri", path="MessageHeader.destination.endpoint", description="Actual destination address or id", type="uri")
    public static final String SP_DESTINATIONURI = "destination-uri";
    @SearchParamDefinition(name="source-uri", path="MessageHeader.source.endpoint", description="Actual message source address or id", type="uri")
    public static final String SP_SOURCEURI = "source-uri";
    @SearchParamDefinition(name="responsible", path="MessageHeader.responsible", description="Final responsibility for event", type="reference")
    public static final String SP_RESPONSIBLE = "responsible";
    @SearchParamDefinition(name="response-id", path="MessageHeader.response.identifier", description="Id of original message", type="token")
    public static final String SP_RESPONSEID = "response-id";
    @SearchParamDefinition(name="enterer", path="MessageHeader.enterer", description="The source of the data entry", type="reference")
    public static final String SP_ENTERER = "enterer";
    @SearchParamDefinition(name="event", path="MessageHeader.event", description="Code for the event this message represents", type="token")
    public static final String SP_EVENT = "event";
    @SearchParamDefinition(name="timestamp", path="MessageHeader.timestamp", description="Time that the message was sent", type="date")
    public static final String SP_TIMESTAMP = "timestamp";

    public MessageHeader() {
    }

    public MessageHeader(InstantType timestamp, Coding event, MessageSourceComponent source) {
        this.timestamp = timestamp;
        this.event = event;
        this.source = source;
    }

    public InstantType getTimestampElement() {
        if (this.timestamp == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.timestamp");
            }
            if (Configuration.doAutoCreate()) {
                this.timestamp = new InstantType();
            }
        }
        return this.timestamp;
    }

    public boolean hasTimestampElement() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public boolean hasTimestamp() {
        return this.timestamp != null && !this.timestamp.isEmpty();
    }

    public MessageHeader setTimestampElement(InstantType value) {
        this.timestamp = value;
        return this;
    }

    public Date getTimestamp() {
        return this.timestamp == null ? null : (Date)this.timestamp.getValue();
    }

    public MessageHeader setTimestamp(Date value) {
        if (this.timestamp == null) {
            this.timestamp = new InstantType();
        }
        this.timestamp.setValue(value);
        return this;
    }

    public Coding getEvent() {
        if (this.event == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.event");
            }
            if (Configuration.doAutoCreate()) {
                this.event = new Coding();
            }
        }
        return this.event;
    }

    public boolean hasEvent() {
        return this.event != null && !this.event.isEmpty();
    }

    public MessageHeader setEvent(Coding value) {
        this.event = value;
        return this;
    }

    public MessageHeaderResponseComponent getResponse() {
        if (this.response == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.response");
            }
            if (Configuration.doAutoCreate()) {
                this.response = new MessageHeaderResponseComponent();
            }
        }
        return this.response;
    }

    public boolean hasResponse() {
        return this.response != null && !this.response.isEmpty();
    }

    public MessageHeader setResponse(MessageHeaderResponseComponent value) {
        this.response = value;
        return this;
    }

    public MessageSourceComponent getSource() {
        if (this.source == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.source");
            }
            if (Configuration.doAutoCreate()) {
                this.source = new MessageSourceComponent();
            }
        }
        return this.source;
    }

    public boolean hasSource() {
        return this.source != null && !this.source.isEmpty();
    }

    public MessageHeader setSource(MessageSourceComponent value) {
        this.source = value;
        return this;
    }

    public List<MessageDestinationComponent> getDestination() {
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        return this.destination;
    }

    public boolean hasDestination() {
        if (this.destination == null) {
            return false;
        }
        for (MessageDestinationComponent item : this.destination) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public MessageDestinationComponent addDestination() {
        MessageDestinationComponent t = new MessageDestinationComponent();
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        this.destination.add(t);
        return t;
    }

    public MessageHeader addDestination(MessageDestinationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.destination == null) {
            this.destination = new ArrayList<MessageDestinationComponent>();
        }
        this.destination.add(t);
        return this;
    }

    public Reference getEnterer() {
        if (this.enterer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.enterer = new Reference();
            }
        }
        return this.enterer;
    }

    public boolean hasEnterer() {
        return this.enterer != null && !this.enterer.isEmpty();
    }

    public MessageHeader setEnterer(Reference value) {
        this.enterer = value;
        return this;
    }

    public Practitioner getEntererTarget() {
        if (this.entererTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.enterer");
            }
            if (Configuration.doAutoCreate()) {
                this.entererTarget = new Practitioner();
            }
        }
        return this.entererTarget;
    }

    public MessageHeader setEntererTarget(Practitioner value) {
        this.entererTarget = value;
        return this;
    }

    public Reference getAuthor() {
        if (this.author == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.author");
            }
            if (Configuration.doAutoCreate()) {
                this.author = new Reference();
            }
        }
        return this.author;
    }

    public boolean hasAuthor() {
        return this.author != null && !this.author.isEmpty();
    }

    public MessageHeader setAuthor(Reference value) {
        this.author = value;
        return this;
    }

    public Practitioner getAuthorTarget() {
        if (this.authorTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.author");
            }
            if (Configuration.doAutoCreate()) {
                this.authorTarget = new Practitioner();
            }
        }
        return this.authorTarget;
    }

    public MessageHeader setAuthorTarget(Practitioner value) {
        this.authorTarget = value;
        return this;
    }

    public Reference getReceiver() {
        if (this.receiver == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.receiver");
            }
            if (Configuration.doAutoCreate()) {
                this.receiver = new Reference();
            }
        }
        return this.receiver;
    }

    public boolean hasReceiver() {
        return this.receiver != null && !this.receiver.isEmpty();
    }

    public MessageHeader setReceiver(Reference value) {
        this.receiver = value;
        return this;
    }

    public Resource getReceiverTarget() {
        return this.receiverTarget;
    }

    public MessageHeader setReceiverTarget(Resource value) {
        this.receiverTarget = value;
        return this;
    }

    public Reference getResponsible() {
        if (this.responsible == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.responsible");
            }
            if (Configuration.doAutoCreate()) {
                this.responsible = new Reference();
            }
        }
        return this.responsible;
    }

    public boolean hasResponsible() {
        return this.responsible != null && !this.responsible.isEmpty();
    }

    public MessageHeader setResponsible(Reference value) {
        this.responsible = value;
        return this;
    }

    public Resource getResponsibleTarget() {
        return this.responsibleTarget;
    }

    public MessageHeader setResponsibleTarget(Resource value) {
        this.responsibleTarget = value;
        return this;
    }

    public CodeableConcept getReason() {
        if (this.reason == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create MessageHeader.reason");
            }
            if (Configuration.doAutoCreate()) {
                this.reason = new CodeableConcept();
            }
        }
        return this.reason;
    }

    public boolean hasReason() {
        return this.reason != null && !this.reason.isEmpty();
    }

    public MessageHeader setReason(CodeableConcept value) {
        this.reason = value;
        return this;
    }

    public List<Reference> getData() {
        if (this.data == null) {
            this.data = new ArrayList<Reference>();
        }
        return this.data;
    }

    public boolean hasData() {
        if (this.data == null) {
            return false;
        }
        for (Reference item : this.data) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addData() {
        Reference t = new Reference();
        if (this.data == null) {
            this.data = new ArrayList<Reference>();
        }
        this.data.add(t);
        return t;
    }

    public MessageHeader addData(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.data == null) {
            this.data = new ArrayList<Reference>();
        }
        this.data.add(t);
        return this;
    }

    public List<Resource> getDataTarget() {
        if (this.dataTarget == null) {
            this.dataTarget = new ArrayList<Resource>();
        }
        return this.dataTarget;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_TIMESTAMP, "instant", "The time that the message was sent.", 0, Integer.MAX_VALUE, this.timestamp));
        childrenList.add(new Property(SP_EVENT, "Coding", "Code that identifies the event this message represents and connects it with its definition. Events defined as part of the FHIR specification have the system value \"http://hl7.org/fhir/message-events\".", 0, Integer.MAX_VALUE, this.event));
        childrenList.add(new Property("response", "", "Information about the message that this message is a response to.  Only present if this message is a response.", 0, Integer.MAX_VALUE, this.response));
        childrenList.add(new Property(SP_SOURCE, "", "The source application from which this message originated.", 0, Integer.MAX_VALUE, this.source));
        childrenList.add(new Property(SP_DESTINATION, "", "The destination application which the message is intended for.", 0, Integer.MAX_VALUE, this.destination));
        childrenList.add(new Property(SP_ENTERER, "Reference(Practitioner)", "The person or device that performed the data entry leading to this message. Where there is more than one candidate, pick the most proximal to the message. Can provide other enterers in extensions.", 0, Integer.MAX_VALUE, this.enterer));
        childrenList.add(new Property(SP_AUTHOR, "Reference(Practitioner)", "The logical author of the message - the person or device that decided the described event should happen. Where there is more than one candidate, pick the most proximal to the MessageHeader. Can provide other authors in extensions.", 0, Integer.MAX_VALUE, this.author));
        childrenList.add(new Property(SP_RECEIVER, "Reference(Practitioner|Organization)", "Allows data conveyed by a message to be addressed to a particular person or department when routing to a specific application isn't sufficient.", 0, Integer.MAX_VALUE, this.receiver));
        childrenList.add(new Property(SP_RESPONSIBLE, "Reference(Practitioner|Organization)", "The person or organization that accepts overall responsibility for the contents of the message. The implication is that the message event happened under the policies of the responsible party.", 0, Integer.MAX_VALUE, this.responsible));
        childrenList.add(new Property("reason", "CodeableConcept", "Coded indication of the cause for the event - indicates  a reason for the occurrence of the event that is a focus of this message.", 0, Integer.MAX_VALUE, this.reason));
        childrenList.add(new Property(SP_DATA, "Reference(Any)", "The actual data of the message - a reference to the root/focus class of the event.", 0, Integer.MAX_VALUE, this.data));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_TIMESTAMP)) {
            this.timestamp = this.castToInstant(value);
        } else if (name.equals(SP_EVENT)) {
            this.event = this.castToCoding(value);
        } else if (name.equals("response")) {
            this.response = (MessageHeaderResponseComponent)value;
        } else if (name.equals(SP_SOURCE)) {
            this.source = (MessageSourceComponent)value;
        } else if (name.equals(SP_DESTINATION)) {
            this.getDestination().add((MessageDestinationComponent)value);
        } else if (name.equals(SP_ENTERER)) {
            this.enterer = this.castToReference(value);
        } else if (name.equals(SP_AUTHOR)) {
            this.author = this.castToReference(value);
        } else if (name.equals(SP_RECEIVER)) {
            this.receiver = this.castToReference(value);
        } else if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = this.castToReference(value);
        } else if (name.equals("reason")) {
            this.reason = this.castToCodeableConcept(value);
        } else if (name.equals(SP_DATA)) {
            this.getData().add(this.castToReference(value));
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_TIMESTAMP)) {
            throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.timestamp");
        }
        if (name.equals(SP_EVENT)) {
            this.event = new Coding();
            return this.event;
        }
        if (name.equals("response")) {
            this.response = new MessageHeaderResponseComponent();
            return this.response;
        }
        if (name.equals(SP_SOURCE)) {
            this.source = new MessageSourceComponent();
            return this.source;
        }
        if (name.equals(SP_DESTINATION)) {
            return this.addDestination();
        }
        if (name.equals(SP_ENTERER)) {
            this.enterer = new Reference();
            return this.enterer;
        }
        if (name.equals(SP_AUTHOR)) {
            this.author = new Reference();
            return this.author;
        }
        if (name.equals(SP_RECEIVER)) {
            this.receiver = new Reference();
            return this.receiver;
        }
        if (name.equals(SP_RESPONSIBLE)) {
            this.responsible = new Reference();
            return this.responsible;
        }
        if (name.equals("reason")) {
            this.reason = new CodeableConcept();
            return this.reason;
        }
        if (name.equals(SP_DATA)) {
            return this.addData();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "MessageHeader";
    }

    @Override
    public MessageHeader copy() {
        MessageHeader dst = new MessageHeader();
        this.copyValues(dst);
        dst.timestamp = this.timestamp == null ? null : this.timestamp.copy();
        dst.event = this.event == null ? null : this.event.copy();
        dst.response = this.response == null ? null : this.response.copy();
        MessageSourceComponent messageSourceComponent = dst.source = this.source == null ? null : this.source.copy();
        if (this.destination != null) {
            dst.destination = new ArrayList<MessageDestinationComponent>();
            for (MessageDestinationComponent messageDestinationComponent : this.destination) {
                dst.destination.add(messageDestinationComponent.copy());
            }
        }
        dst.enterer = this.enterer == null ? null : this.enterer.copy();
        dst.author = this.author == null ? null : this.author.copy();
        dst.receiver = this.receiver == null ? null : this.receiver.copy();
        dst.responsible = this.responsible == null ? null : this.responsible.copy();
        CodeableConcept codeableConcept = dst.reason = this.reason == null ? null : this.reason.copy();
        if (this.data != null) {
            dst.data = new ArrayList<Reference>();
            for (Reference reference : this.data) {
                dst.data.add(reference.copy());
            }
        }
        return dst;
    }

    protected MessageHeader typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof MessageHeader)) {
            return false;
        }
        MessageHeader o = (MessageHeader)other;
        return MessageHeader.compareDeep(this.timestamp, o.timestamp, true) && MessageHeader.compareDeep(this.event, o.event, true) && MessageHeader.compareDeep(this.response, o.response, true) && MessageHeader.compareDeep(this.source, o.source, true) && MessageHeader.compareDeep(this.destination, o.destination, true) && MessageHeader.compareDeep(this.enterer, o.enterer, true) && MessageHeader.compareDeep(this.author, o.author, true) && MessageHeader.compareDeep(this.receiver, o.receiver, true) && MessageHeader.compareDeep(this.responsible, o.responsible, true) && MessageHeader.compareDeep(this.reason, o.reason, true) && MessageHeader.compareDeep(this.data, o.data, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof MessageHeader)) {
            return false;
        }
        MessageHeader o = (MessageHeader)other;
        return MessageHeader.compareValues(this.timestamp, o.timestamp, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.timestamp != null && !this.timestamp.isEmpty() || this.event != null && !this.event.isEmpty() || this.response != null && !this.response.isEmpty() || this.source != null && !this.source.isEmpty() || this.destination != null && !this.destination.isEmpty() || this.enterer != null && !this.enterer.isEmpty() || this.author != null && !this.author.isEmpty() || this.receiver != null && !this.receiver.isEmpty() || this.responsible != null && !this.responsible.isEmpty() || this.reason != null && !this.reason.isEmpty() || this.data != null && !this.data.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.MessageHeader;
    }

    @Block
    public static class MessageDestinationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the target system.")
        protected StringType name;
        @Child(name="target", type={Device.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Particular delivery destination within the destination", formalDefinition="Identifies the target end system in situations where the initial message transmission is to an intermediary system.")
        protected Reference target;
        protected Device targetTarget;
        @Child(name="endpoint", type={UriType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual destination address or id", formalDefinition="Indicates where the message should be routed to.")
        protected UriType endpoint;
        private static final long serialVersionUID = -2097633309L;

        public MessageDestinationComponent() {
        }

        public MessageDestinationComponent(UriType endpoint) {
            this.endpoint = endpoint;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MessageDestinationComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MessageDestinationComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public Reference getTarget() {
            if (this.target == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.target = new Reference();
                }
            }
            return this.target;
        }

        public boolean hasTarget() {
            return this.target != null && !this.target.isEmpty();
        }

        public MessageDestinationComponent setTarget(Reference value) {
            this.target = value;
            return this;
        }

        public Device getTargetTarget() {
            if (this.targetTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.target");
                }
                if (Configuration.doAutoCreate()) {
                    this.targetTarget = new Device();
                }
            }
            return this.targetTarget;
        }

        public MessageDestinationComponent setTargetTarget(Device value) {
            this.targetTarget = value;
            return this;
        }

        public UriType getEndpointElement() {
            if (this.endpoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageDestinationComponent.endpoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.endpoint = new UriType();
                }
            }
            return this.endpoint;
        }

        public boolean hasEndpointElement() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public boolean hasEndpoint() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public MessageDestinationComponent setEndpointElement(UriType value) {
            this.endpoint = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint == null ? null : (String)this.endpoint.getValue();
        }

        public MessageDestinationComponent setEndpoint(String value) {
            if (this.endpoint == null) {
                this.endpoint = new UriType();
            }
            this.endpoint.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "Human-readable name for the target system.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property(MessageHeader.SP_TARGET, "Reference(Device)", "Identifies the target end system in situations where the initial message transmission is to an intermediary system.", 0, Integer.MAX_VALUE, this.target));
            childrenList.add(new Property("endpoint", "uri", "Indicates where the message should be routed to.", 0, Integer.MAX_VALUE, this.endpoint));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals(MessageHeader.SP_TARGET)) {
                this.target = this.castToReference(value);
            } else if (name.equals("endpoint")) {
                this.endpoint = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.name");
            }
            if (name.equals(MessageHeader.SP_TARGET)) {
                this.target = new Reference();
                return this.target;
            }
            if (name.equals("endpoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.endpoint");
            }
            return super.addChild(name);
        }

        @Override
        public MessageDestinationComponent copy() {
            MessageDestinationComponent dst = new MessageDestinationComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.target = this.target == null ? null : this.target.copy();
            dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MessageDestinationComponent)) {
                return false;
            }
            MessageDestinationComponent o = (MessageDestinationComponent)other;
            return MessageDestinationComponent.compareDeep(this.name, o.name, true) && MessageDestinationComponent.compareDeep(this.target, o.target, true) && MessageDestinationComponent.compareDeep(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MessageDestinationComponent)) {
                return false;
            }
            MessageDestinationComponent o = (MessageDestinationComponent)other;
            return MessageDestinationComponent.compareValues(this.name, o.name, true) && MessageDestinationComponent.compareValues(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.target != null && !this.target.isEmpty() || this.endpoint != null && !this.endpoint.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MessageHeader.destination";
        }
    }

    @Block
    public static class MessageSourceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="name", type={StringType.class}, order=1, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of system", formalDefinition="Human-readable name for the source system.")
        protected StringType name;
        @Child(name="software", type={StringType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Name of software running the system", formalDefinition="May include configuration or other information useful in debugging.")
        protected StringType software;
        @Child(name="version", type={StringType.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Version of software running", formalDefinition="Can convey versions of multiple systems in situations where a message passes through multiple hands.")
        protected StringType version;
        @Child(name="contact", type={ContactPoint.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Human contact for problems", formalDefinition="An e-mail, phone, website or other contact point to use to resolve issues with message communications.")
        protected ContactPoint contact;
        @Child(name="endpoint", type={UriType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Actual message source address or id", formalDefinition="Identifies the routing target to send acknowledgements to.")
        protected UriType endpoint;
        private static final long serialVersionUID = -115878196L;

        public MessageSourceComponent() {
        }

        public MessageSourceComponent(UriType endpoint) {
            this.endpoint = endpoint;
        }

        public StringType getNameElement() {
            if (this.name == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.name");
                }
                if (Configuration.doAutoCreate()) {
                    this.name = new StringType();
                }
            }
            return this.name;
        }

        public boolean hasNameElement() {
            return this.name != null && !this.name.isEmpty();
        }

        public boolean hasName() {
            return this.name != null && !this.name.isEmpty();
        }

        public MessageSourceComponent setNameElement(StringType value) {
            this.name = value;
            return this;
        }

        public String getName() {
            return this.name == null ? null : (String)this.name.getValue();
        }

        public MessageSourceComponent setName(String value) {
            if (Utilities.noString((String)value)) {
                this.name = null;
            } else {
                if (this.name == null) {
                    this.name = new StringType();
                }
                this.name.setValue(value);
            }
            return this;
        }

        public StringType getSoftwareElement() {
            if (this.software == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.software");
                }
                if (Configuration.doAutoCreate()) {
                    this.software = new StringType();
                }
            }
            return this.software;
        }

        public boolean hasSoftwareElement() {
            return this.software != null && !this.software.isEmpty();
        }

        public boolean hasSoftware() {
            return this.software != null && !this.software.isEmpty();
        }

        public MessageSourceComponent setSoftwareElement(StringType value) {
            this.software = value;
            return this;
        }

        public String getSoftware() {
            return this.software == null ? null : (String)this.software.getValue();
        }

        public MessageSourceComponent setSoftware(String value) {
            if (Utilities.noString((String)value)) {
                this.software = null;
            } else {
                if (this.software == null) {
                    this.software = new StringType();
                }
                this.software.setValue(value);
            }
            return this;
        }

        public StringType getVersionElement() {
            if (this.version == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.version");
                }
                if (Configuration.doAutoCreate()) {
                    this.version = new StringType();
                }
            }
            return this.version;
        }

        public boolean hasVersionElement() {
            return this.version != null && !this.version.isEmpty();
        }

        public boolean hasVersion() {
            return this.version != null && !this.version.isEmpty();
        }

        public MessageSourceComponent setVersionElement(StringType value) {
            this.version = value;
            return this;
        }

        public String getVersion() {
            return this.version == null ? null : (String)this.version.getValue();
        }

        public MessageSourceComponent setVersion(String value) {
            if (Utilities.noString((String)value)) {
                this.version = null;
            } else {
                if (this.version == null) {
                    this.version = new StringType();
                }
                this.version.setValue(value);
            }
            return this;
        }

        public ContactPoint getContact() {
            if (this.contact == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.contact");
                }
                if (Configuration.doAutoCreate()) {
                    this.contact = new ContactPoint();
                }
            }
            return this.contact;
        }

        public boolean hasContact() {
            return this.contact != null && !this.contact.isEmpty();
        }

        public MessageSourceComponent setContact(ContactPoint value) {
            this.contact = value;
            return this;
        }

        public UriType getEndpointElement() {
            if (this.endpoint == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageSourceComponent.endpoint");
                }
                if (Configuration.doAutoCreate()) {
                    this.endpoint = new UriType();
                }
            }
            return this.endpoint;
        }

        public boolean hasEndpointElement() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public boolean hasEndpoint() {
            return this.endpoint != null && !this.endpoint.isEmpty();
        }

        public MessageSourceComponent setEndpointElement(UriType value) {
            this.endpoint = value;
            return this;
        }

        public String getEndpoint() {
            return this.endpoint == null ? null : (String)this.endpoint.getValue();
        }

        public MessageSourceComponent setEndpoint(String value) {
            if (this.endpoint == null) {
                this.endpoint = new UriType();
            }
            this.endpoint.setValue(value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("name", "string", "Human-readable name for the source system.", 0, Integer.MAX_VALUE, this.name));
            childrenList.add(new Property("software", "string", "May include configuration or other information useful in debugging.", 0, Integer.MAX_VALUE, this.software));
            childrenList.add(new Property("version", "string", "Can convey versions of multiple systems in situations where a message passes through multiple hands.", 0, Integer.MAX_VALUE, this.version));
            childrenList.add(new Property("contact", "ContactPoint", "An e-mail, phone, website or other contact point to use to resolve issues with message communications.", 0, Integer.MAX_VALUE, this.contact));
            childrenList.add(new Property("endpoint", "uri", "Identifies the routing target to send acknowledgements to.", 0, Integer.MAX_VALUE, this.endpoint));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("name")) {
                this.name = this.castToString(value);
            } else if (name.equals("software")) {
                this.software = this.castToString(value);
            } else if (name.equals("version")) {
                this.version = this.castToString(value);
            } else if (name.equals("contact")) {
                this.contact = this.castToContactPoint(value);
            } else if (name.equals("endpoint")) {
                this.endpoint = this.castToUri(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("name")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.name");
            }
            if (name.equals("software")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.software");
            }
            if (name.equals("version")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.version");
            }
            if (name.equals("contact")) {
                this.contact = new ContactPoint();
                return this.contact;
            }
            if (name.equals("endpoint")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.endpoint");
            }
            return super.addChild(name);
        }

        @Override
        public MessageSourceComponent copy() {
            MessageSourceComponent dst = new MessageSourceComponent();
            this.copyValues(dst);
            dst.name = this.name == null ? null : this.name.copy();
            dst.software = this.software == null ? null : this.software.copy();
            dst.version = this.version == null ? null : this.version.copy();
            dst.contact = this.contact == null ? null : this.contact.copy();
            dst.endpoint = this.endpoint == null ? null : this.endpoint.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MessageSourceComponent)) {
                return false;
            }
            MessageSourceComponent o = (MessageSourceComponent)other;
            return MessageSourceComponent.compareDeep(this.name, o.name, true) && MessageSourceComponent.compareDeep(this.software, o.software, true) && MessageSourceComponent.compareDeep(this.version, o.version, true) && MessageSourceComponent.compareDeep(this.contact, o.contact, true) && MessageSourceComponent.compareDeep(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MessageSourceComponent)) {
                return false;
            }
            MessageSourceComponent o = (MessageSourceComponent)other;
            return MessageSourceComponent.compareValues(this.name, o.name, true) && MessageSourceComponent.compareValues(this.software, o.software, true) && MessageSourceComponent.compareValues(this.version, o.version, true) && MessageSourceComponent.compareValues(this.endpoint, o.endpoint, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.name != null && !this.name.isEmpty() || this.software != null && !this.software.isEmpty() || this.version != null && !this.version.isEmpty() || this.contact != null && !this.contact.isEmpty() || this.endpoint != null && !this.endpoint.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MessageHeader.source";
        }
    }

    @Block
    public static class MessageHeaderResponseComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="identifier", type={IdType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Id of original message", formalDefinition="The id of the message that this message is a response to.")
        protected IdType identifier;
        @Child(name="code", type={CodeType.class}, order=2, min=1, max=1, modifier=true, summary=true)
        @Description(shortDefinition="ok | transient-error | fatal-error", formalDefinition="Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.")
        protected Enumeration<ResponseType> code;
        @Child(name="details", type={OperationOutcome.class}, order=3, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Specific list of hints/warnings/errors", formalDefinition="Full details of any issues found in the message.")
        protected Reference details;
        protected OperationOutcome detailsTarget;
        private static final long serialVersionUID = -1008716838L;

        public MessageHeaderResponseComponent() {
        }

        public MessageHeaderResponseComponent(IdType identifier, Enumeration<ResponseType> code) {
            this.identifier = identifier;
            this.code = code;
        }

        public IdType getIdentifierElement() {
            if (this.identifier == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.identifier");
                }
                if (Configuration.doAutoCreate()) {
                    this.identifier = new IdType();
                }
            }
            return this.identifier;
        }

        public boolean hasIdentifierElement() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public boolean hasIdentifier() {
            return this.identifier != null && !this.identifier.isEmpty();
        }

        public MessageHeaderResponseComponent setIdentifierElement(IdType value) {
            this.identifier = value;
            return this;
        }

        public String getIdentifier() {
            return this.identifier == null ? null : this.identifier.getValue();
        }

        public MessageHeaderResponseComponent setIdentifier(String value) {
            if (this.identifier == null) {
                this.identifier = new IdType();
            }
            this.identifier.setValue(value);
            return this;
        }

        public Enumeration<ResponseType> getCodeElement() {
            if (this.code == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.code");
                }
                if (Configuration.doAutoCreate()) {
                    this.code = new Enumeration<ResponseType>(new ResponseTypeEnumFactory());
                }
            }
            return this.code;
        }

        public boolean hasCodeElement() {
            return this.code != null && !this.code.isEmpty();
        }

        public boolean hasCode() {
            return this.code != null && !this.code.isEmpty();
        }

        public MessageHeaderResponseComponent setCodeElement(Enumeration<ResponseType> value) {
            this.code = value;
            return this;
        }

        public ResponseType getCode() {
            return this.code == null ? null : (ResponseType)((Object)this.code.getValue());
        }

        public MessageHeaderResponseComponent setCode(ResponseType value) {
            if (this.code == null) {
                this.code = new Enumeration<ResponseType>(new ResponseTypeEnumFactory());
            }
            this.code.setValue((Object)value);
            return this;
        }

        public Reference getDetails() {
            if (this.details == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.details");
                }
                if (Configuration.doAutoCreate()) {
                    this.details = new Reference();
                }
            }
            return this.details;
        }

        public boolean hasDetails() {
            return this.details != null && !this.details.isEmpty();
        }

        public MessageHeaderResponseComponent setDetails(Reference value) {
            this.details = value;
            return this;
        }

        public OperationOutcome getDetailsTarget() {
            if (this.detailsTarget == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create MessageHeaderResponseComponent.details");
                }
                if (Configuration.doAutoCreate()) {
                    this.detailsTarget = new OperationOutcome();
                }
            }
            return this.detailsTarget;
        }

        public MessageHeaderResponseComponent setDetailsTarget(OperationOutcome value) {
            this.detailsTarget = value;
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property("identifier", "id", "The id of the message that this message is a response to.", 0, Integer.MAX_VALUE, this.identifier));
            childrenList.add(new Property(MessageHeader.SP_CODE, MessageHeader.SP_CODE, "Code that identifies the type of response to the message - whether it was successful or not, and whether it should be resent or not.", 0, Integer.MAX_VALUE, this.code));
            childrenList.add(new Property("details", "Reference(OperationOutcome)", "Full details of any issues found in the message.", 0, Integer.MAX_VALUE, this.details));
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals("identifier")) {
                this.identifier = this.castToId(value);
            } else if (name.equals(MessageHeader.SP_CODE)) {
                this.code = new ResponseTypeEnumFactory().fromType(value);
            } else if (name.equals("details")) {
                this.details = this.castToReference(value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("identifier")) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.identifier");
            }
            if (name.equals(MessageHeader.SP_CODE)) {
                throw new FHIRException("Cannot call addChild on a singleton property MessageHeader.code");
            }
            if (name.equals("details")) {
                this.details = new Reference();
                return this.details;
            }
            return super.addChild(name);
        }

        @Override
        public MessageHeaderResponseComponent copy() {
            MessageHeaderResponseComponent dst = new MessageHeaderResponseComponent();
            this.copyValues(dst);
            dst.identifier = this.identifier == null ? null : this.identifier.copy();
            dst.code = this.code == null ? null : this.code.copy();
            dst.details = this.details == null ? null : this.details.copy();
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof MessageHeaderResponseComponent)) {
                return false;
            }
            MessageHeaderResponseComponent o = (MessageHeaderResponseComponent)other;
            return MessageHeaderResponseComponent.compareDeep(this.identifier, o.identifier, true) && MessageHeaderResponseComponent.compareDeep(this.code, o.code, true) && MessageHeaderResponseComponent.compareDeep(this.details, o.details, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof MessageHeaderResponseComponent)) {
                return false;
            }
            MessageHeaderResponseComponent o = (MessageHeaderResponseComponent)other;
            return MessageHeaderResponseComponent.compareValues(this.identifier, o.identifier, true) && MessageHeaderResponseComponent.compareValues(this.code, o.code, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.code != null && !this.code.isEmpty() || this.details != null && !this.details.isEmpty());
        }

        @Override
        public String fhirType() {
            return "MessageHeader.response";
        }
    }

    public static class ResponseTypeEnumFactory
    implements EnumFactory<ResponseType> {
        @Override
        public ResponseType fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return ResponseType.OK;
            }
            if ("transient-error".equals(codeString)) {
                return ResponseType.TRANSIENTERROR;
            }
            if ("fatal-error".equals(codeString)) {
                return ResponseType.FATALERROR;
            }
            throw new IllegalArgumentException("Unknown ResponseType code '" + codeString + "'");
        }

        public Enumeration<ResponseType> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.OK);
            }
            if ("transient-error".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.TRANSIENTERROR);
            }
            if ("fatal-error".equals(codeString)) {
                return new Enumeration<ResponseType>(this, ResponseType.FATALERROR);
            }
            throw new FHIRException("Unknown ResponseType code '" + codeString + "'");
        }

        @Override
        public String toCode(ResponseType code) {
            if (code == ResponseType.NULL) {
                return null;
            }
            if (code == ResponseType.OK) {
                return "ok";
            }
            if (code == ResponseType.TRANSIENTERROR) {
                return "transient-error";
            }
            if (code == ResponseType.FATALERROR) {
                return "fatal-error";
            }
            return "?";
        }
    }

    public static enum ResponseType {
        OK,
        TRANSIENTERROR,
        FATALERROR,
        NULL;


        public static ResponseType fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ok".equals(codeString)) {
                return OK;
            }
            if ("transient-error".equals(codeString)) {
                return TRANSIENTERROR;
            }
            if ("fatal-error".equals(codeString)) {
                return FATALERROR;
            }
            throw new FHIRException("Unknown ResponseType code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case OK: {
                    return "ok";
                }
                case TRANSIENTERROR: {
                    return "transient-error";
                }
                case FATALERROR: {
                    return "fatal-error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case OK: {
                    return "http://hl7.org/fhir/response-code";
                }
                case TRANSIENTERROR: {
                    return "http://hl7.org/fhir/response-code";
                }
                case FATALERROR: {
                    return "http://hl7.org/fhir/response-code";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case OK: {
                    return "The message was accepted and processed without error.";
                }
                case TRANSIENTERROR: {
                    return "Some internal unexpected error occurred - wait and try again. Note - this is usually used for things like database unavailable, which may be expected to resolve, though human intervention may be required.";
                }
                case FATALERROR: {
                    return "The message was rejected because of some content in it. There is no point in re-sending without change. The response narrative SHALL describe the issue.";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case OK: {
                    return "OK";
                }
                case TRANSIENTERROR: {
                    return "Transient Error";
                }
                case FATALERROR: {
                    return "Fatal Error";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

