/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.model;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2.model.Base;
import org.hl7.fhir.dstu2.model.CodeableConcept;
import org.hl7.fhir.dstu2.model.Configuration;
import org.hl7.fhir.dstu2.model.Device;
import org.hl7.fhir.dstu2.model.DomainResource;
import org.hl7.fhir.dstu2.model.HealthcareService;
import org.hl7.fhir.dstu2.model.Identifier;
import org.hl7.fhir.dstu2.model.Location;
import org.hl7.fhir.dstu2.model.Patient;
import org.hl7.fhir.dstu2.model.Period;
import org.hl7.fhir.dstu2.model.Practitioner;
import org.hl7.fhir.dstu2.model.Property;
import org.hl7.fhir.dstu2.model.Reference;
import org.hl7.fhir.dstu2.model.RelatedPerson;
import org.hl7.fhir.dstu2.model.Resource;
import org.hl7.fhir.dstu2.model.ResourceType;
import org.hl7.fhir.dstu2.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Schedule", profile="http://hl7.org/fhir/Profile/Schedule")
public class Schedule
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="External Ids for this item.")
    protected List<Identifier> identifier;
    @Child(name="type", type={CodeableConcept.class}, order=1, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="The schedule type can be used for the categorization of healthcare services or other appointment types", formalDefinition="The schedule type can be used for the categorization of healthcare services or other appointment types.")
    protected List<CodeableConcept> type;
    @Child(name="actor", type={Patient.class, Practitioner.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The resource this Schedule resource is providing availability information for. These are expected to usually be one of HealthcareService, Location, Practitioner, Device, Patient or RelatedPerson", formalDefinition="The resource this Schedule resource is providing availability information for. These are expected to usually be one of HealthcareService, Location, Practitioner, Device, Patient or RelatedPerson.")
    protected Reference actor;
    protected Resource actorTarget;
    @Child(name="planningHorizon", type={Period.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period of time that the slots that are attached to this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates", formalDefinition="The period of time that the slots that are attached to this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates.")
    protected Period planningHorizon;
    @Child(name="comment", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments on the availability to describe any extended information. Such as custom constraints on the slot(s) that may be associated", formalDefinition="Comments on the availability to describe any extended information. Such as custom constraints on the slot(s) that may be associated.")
    protected StringType comment;
    private static final long serialVersionUID = 158030926L;
    @SearchParamDefinition(name="actor", path="Schedule.actor", description="The individual(HealthcareService, Practitioner, Location, ...) to find a Schedule for", type="reference")
    public static final String SP_ACTOR = "actor";
    @SearchParamDefinition(name="date", path="Schedule.planningHorizon", description="Search for Schedule resources that have a period that contains this date specified", type="date")
    public static final String SP_DATE = "date";
    @SearchParamDefinition(name="identifier", path="Schedule.identifier", description="A Schedule Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    @SearchParamDefinition(name="type", path="Schedule.type", description="The type of appointments that can be booked into associated slot(s)", type="token")
    public static final String SP_TYPE = "type";

    public Schedule() {
    }

    public Schedule(Reference actor) {
        this.actor = actor;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Schedule addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public List<CodeableConcept> getType() {
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        return this.type;
    }

    public boolean hasType() {
        if (this.type == null) {
            return false;
        }
        for (CodeableConcept item : this.type) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addType() {
        CodeableConcept t = new CodeableConcept();
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return t;
    }

    public Schedule addType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.type == null) {
            this.type = new ArrayList<CodeableConcept>();
        }
        this.type.add(t);
        return this;
    }

    public Reference getActor() {
        if (this.actor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.actor");
            }
            if (Configuration.doAutoCreate()) {
                this.actor = new Reference();
            }
        }
        return this.actor;
    }

    public boolean hasActor() {
        return this.actor != null && !this.actor.isEmpty();
    }

    public Schedule setActor(Reference value) {
        this.actor = value;
        return this;
    }

    public Resource getActorTarget() {
        return this.actorTarget;
    }

    public Schedule setActorTarget(Resource value) {
        this.actorTarget = value;
        return this;
    }

    public Period getPlanningHorizon() {
        if (this.planningHorizon == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.planningHorizon");
            }
            if (Configuration.doAutoCreate()) {
                this.planningHorizon = new Period();
            }
        }
        return this.planningHorizon;
    }

    public boolean hasPlanningHorizon() {
        return this.planningHorizon != null && !this.planningHorizon.isEmpty();
    }

    public Schedule setPlanningHorizon(Period value) {
        this.planningHorizon = value;
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Schedule setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Schedule setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "External Ids for this item.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property(SP_TYPE, "CodeableConcept", "The schedule type can be used for the categorization of healthcare services or other appointment types.", 0, Integer.MAX_VALUE, this.type));
        childrenList.add(new Property(SP_ACTOR, "Reference(Patient|Practitioner|RelatedPerson|Device|HealthcareService|Location)", "The resource this Schedule resource is providing availability information for. These are expected to usually be one of HealthcareService, Location, Practitioner, Device, Patient or RelatedPerson.", 0, Integer.MAX_VALUE, this.actor));
        childrenList.add(new Property("planningHorizon", "Period", "The period of time that the slots that are attached to this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates.", 0, Integer.MAX_VALUE, this.planningHorizon));
        childrenList.add(new Property("comment", "string", "Comments on the availability to describe any extended information. Such as custom constraints on the slot(s) that may be associated.", 0, Integer.MAX_VALUE, this.comment));
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals(SP_TYPE)) {
            this.getType().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_ACTOR)) {
            this.actor = this.castToReference(value);
        } else if (name.equals("planningHorizon")) {
            this.planningHorizon = this.castToPeriod(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_TYPE)) {
            return this.addType();
        }
        if (name.equals(SP_ACTOR)) {
            this.actor = new Reference();
            return this.actor;
        }
        if (name.equals("planningHorizon")) {
            this.planningHorizon = new Period();
            return this.planningHorizon;
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a singleton property Schedule.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Schedule";
    }

    @Override
    public Schedule copy() {
        Schedule dst = new Schedule();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        if (this.type != null) {
            dst.type = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.type) {
                dst.type.add(codeableConcept.copy());
            }
        }
        dst.actor = this.actor == null ? null : this.actor.copy();
        dst.planningHorizon = this.planningHorizon == null ? null : this.planningHorizon.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        return dst;
    }

    protected Schedule typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Schedule)) {
            return false;
        }
        Schedule o = (Schedule)other;
        return Schedule.compareDeep(this.identifier, o.identifier, true) && Schedule.compareDeep(this.type, o.type, true) && Schedule.compareDeep(this.actor, o.actor, true) && Schedule.compareDeep(this.planningHorizon, o.planningHorizon, true) && Schedule.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Schedule)) {
            return false;
        }
        Schedule o = (Schedule)other;
        return Schedule.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.type != null && !this.type.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.planningHorizon != null && !this.planningHorizon.isEmpty() || this.comment != null && !this.comment.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Schedule;
    }
}

