/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.terminologies;

import java.util.Iterator;
import java.util.List;
import org.hl7.fhir.dstu2.model.UriType;
import org.hl7.fhir.dstu2.model.ValueSet;
import org.hl7.fhir.dstu2.terminologies.ValueSetChecker;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu2.utils.EOperationOutcome;
import org.hl7.fhir.dstu2.utils.IWorkerContext;

@Deprecated
public class ValueSetCheckerSimple
implements ValueSetChecker {
    private ValueSet valueset;
    private ValueSetExpanderFactory factory;
    private IWorkerContext context;

    public ValueSetCheckerSimple(ValueSet source, ValueSetExpanderFactory factory, IWorkerContext context) {
        this.valueset = source;
        this.factory = factory;
        this.context = context;
    }

    @Override
    public boolean codeInValueSet(String system, String code) throws EOperationOutcome, Exception {
        if (this.valueset.hasCodeSystem() && system.equals(this.valueset.getCodeSystem().getSystem()) && this.codeInDefine(this.valueset.getCodeSystem().getConcept(), code, this.valueset.getCodeSystem().getCaseSensitive())) {
            return true;
        }
        if (this.valueset.hasCompose()) {
            boolean ok = false;
            for (UriType uri : this.valueset.getCompose().getImport()) {
                ok = ok || this.inImport((String)uri.getValue(), system, code);
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getInclude()) {
                ok = ok || this.inComponent(vsi, system, code);
            }
            for (ValueSet.ConceptSetComponent vsi : this.valueset.getCompose().getExclude()) {
                ok = ok && !this.inComponent(vsi, system, code);
            }
        }
        return false;
    }

    private boolean inImport(String uri, String system, String code) throws EOperationOutcome, Exception {
        ValueSet vs = this.context.fetchResource(ValueSet.class, uri);
        if (vs == null) {
            return false;
        }
        return this.codeInExpansion(this.factory.getExpander().expand(vs), system, code);
    }

    private boolean codeInExpansion(ValueSetExpander.ValueSetExpansionOutcome vso, String system, String code) throws EOperationOutcome, Exception {
        if (vso.getService() != null) {
            return vso.getService().codeInValueSet(system, code);
        }
        for (ValueSet.ValueSetExpansionContainsComponent c : vso.getValueset().getExpansion().getContains()) {
            if (code.equals(c.getCode()) && (system == null || system.equals(c.getSystem()))) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean codeinExpansion(ValueSet.ValueSetExpansionContainsComponent cnt, String system, String code) {
        for (ValueSet.ValueSetExpansionContainsComponent c : cnt.getContains()) {
            if (code.equals(c.getCode()) && system.equals(c.getSystem().toString())) {
                return true;
            }
            if (!this.codeinExpansion(c, system, code)) continue;
            return true;
        }
        return false;
    }

    private boolean inComponent(ValueSet.ConceptSetComponent vsi, String system, String code) {
        if (!vsi.getSystem().equals(system)) {
            return false;
        }
        for (ValueSet.ConceptReferenceComponent conceptReferenceComponent : vsi.getConcept()) {
            if (!conceptReferenceComponent.getCode().equals(code)) continue;
            return true;
        }
        ValueSet def = this.context.fetchCodeSystem(system);
        if (def != null) {
            if (!def.getCodeSystem().getCaseSensitive()) {
                for (ValueSet.ConceptReferenceComponent cc2 : vsi.getConcept()) {
                    if (!cc2.getCode().equalsIgnoreCase(code)) continue;
                    return false;
                }
            }
            if (vsi.getConcept().isEmpty() && vsi.getFilter().isEmpty()) {
                return this.codeInDefine(def.getCodeSystem().getConcept(), code, def.getCodeSystem().getCaseSensitive());
            }
            Iterator<ValueSet.ConceptSetFilterComponent> iterator = vsi.getFilter().iterator();
            if (iterator.hasNext()) {
                ValueSet.ConceptSetFilterComponent f = iterator.next();
                throw new Error("not done yet: " + f.getValue());
            }
            return false;
        }
        if (this.context.supportsSystem(system)) {
            IWorkerContext.ValidationResult validationResult = this.context.validateCode(system, code, null, vsi);
            return validationResult.isOk();
        }
        return false;
    }

    private boolean codeInDefine(List<ValueSet.ConceptDefinitionComponent> concepts, String code, boolean caseSensitive) {
        for (ValueSet.ConceptDefinitionComponent c : concepts) {
            if (caseSensitive && code.equals(c.getCode())) {
                return true;
            }
            if (!caseSensitive && code.equalsIgnoreCase(c.getCode())) {
                return true;
            }
            if (!this.codeInDefine(c.getConcept(), code, caseSensitive)) continue;
            return true;
        }
        return false;
    }
}

