/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.hl7.fhir.utilities.filesystem.CSFileInputStream;
import org.hl7.fhir.utilities.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

@Deprecated
public class Translations {
    private String[] lang;
    private Map<String, Element> messages = new HashMap<String, Element>();

    public void setLang(String lang) {
        this.lang = lang.split("[.;]");
    }

    public void load(String filename) throws FileNotFoundException, SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = XMLUtil.newXXEProtectedDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.loadMessages(builder.parse((InputStream)new CSFileInputStream(filename)));
    }

    private void loadMessages(Document doc) {
        Element element = XMLUtil.getFirstChild((Element)doc.getDocumentElement());
        while (element != null) {
            this.messages.put(element.getAttribute("id"), element);
            element = XMLUtil.getNextSibling((Element)element);
        }
    }

    public boolean hasTranslation(String id) {
        return this.messages.containsKey(id);
    }

    public String getMessage(String id, String defaultMsg) {
        return this.getMessage(id, this.lang, defaultMsg);
    }

    public String getMessage(String id, String lang, String defaultMsg) {
        return this.getMessage(id, lang.split("[.;]"), defaultMsg);
    }

    private String getMessage(String id, String[] lang, String defaultMsg) {
        String res;
        Element msg = this.messages.get(id);
        if (msg == null) {
            return defaultMsg;
        }
        for (String l : lang) {
            String res2 = this.getByLang(msg, l);
            if (res2 == null) continue;
            return res2;
        }
        if (defaultMsg == null && (res = this.getByLang(msg, "en")) != null) {
            return res;
        }
        return defaultMsg;
    }

    private String getByLang(Element msg, String lang) {
        Element c = XMLUtil.getFirstChild((Element)msg);
        while (c != null) {
            if (c.getAttribute("lang").equals(lang)) {
                return c.getTextContent();
            }
            c = XMLUtil.getNextSibling((Element)c);
        }
        return null;
    }

    public String getLangDesc(String s) {
        if (s.equals("en")) {
            return "English";
        }
        if (s.equals("nl")) {
            return "Nederlands (Dutch)";
        }
        if (s.equals("de")) {
            return "Deutsch (German)";
        }
        if (s.equals("du")) {
            return "\u0440\u0443\u0301\u0441\u0441\u043a\u0438\u0439 (Russian)";
        }
        return "\"" + s + "\"";
    }
}

