/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContentType {
    XML,
    JSON,
    NULL;


    public static ContentType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("xml".equals(codeString)) {
            return XML;
        }
        if ("json".equals(codeString)) {
            return JSON;
        }
        throw new FHIRException("Unknown ContentType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case XML: {
                return "xml";
            }
            case JSON: {
                return "json";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/content-type";
    }

    public String getDefinition() {
        switch (this) {
            case XML: {
                return "XML content-type corresponding to the application/xml+fhir mime-type.";
            }
            case JSON: {
                return "JSON content-type corresponding to the application/json+fhir mime-type.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case XML: {
                return "xml";
            }
            case JSON: {
                return "json";
            }
        }
        return "?";
    }
}

