/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaNotidentifiedPresentPresentextensive {
    NOTIDENTIFIED,
    PRESENTANDEXTENSIVE,
    NULL;


    public static NehtaNehtaNotidentifiedPresentPresentextensive fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not_identified".equals(codeString)) {
            return NOTIDENTIFIED;
        }
        if ("present_and_extensive".equals(codeString)) {
            return PRESENTANDEXTENSIVE;
        }
        throw new FHIRException("Unknown NehtaNehtaNotidentifiedPresentPresentextensive code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTIDENTIFIED: {
                return "not_identified";
            }
            case PRESENTANDEXTENSIVE: {
                return "present_and_extensive";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-notidentified-present-presentextensive";
    }

    public String getDefinition() {
        switch (this) {
            case NOTIDENTIFIED: {
                return "Indicates whether value was not identified";
            }
            case PRESENTANDEXTENSIVE: {
                return "Indicates whether invasion was presetn and extensive";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTIDENTIFIED: {
                return "Not identified";
            }
            case PRESENTANDEXTENSIVE: {
                return "Present and extensive";
            }
        }
        return "?";
    }
}

