/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.ProtocolType;

public class ProtocolTypeEnumFactory
implements EnumFactory<ProtocolType> {
    @Override
    public ProtocolType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("condition".equals(codeString)) {
            return ProtocolType.CONDITION;
        }
        if ("device".equals(codeString)) {
            return ProtocolType.DEVICE;
        }
        if ("drug".equals(codeString)) {
            return ProtocolType.DRUG;
        }
        if ("study".equals(codeString)) {
            return ProtocolType.STUDY;
        }
        throw new IllegalArgumentException("Unknown ProtocolType code '" + codeString + "'");
    }

    @Override
    public String toCode(ProtocolType code) {
        if (code == ProtocolType.CONDITION) {
            return "condition";
        }
        if (code == ProtocolType.DEVICE) {
            return "device";
        }
        if (code == ProtocolType.DRUG) {
            return "drug";
        }
        if (code == ProtocolType.STUDY) {
            return "study";
        }
        return "?";
    }

    @Override
    public String toSystem(ProtocolType code) {
        return code.getSystem();
    }
}

