/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum QicorePatientMilitaryService {
    NOTINDICATED,
    NOMILITARYSERVICE,
    VETERAN,
    ACTIVEDUTY,
    ACTIVERESERVE,
    INACTIVERESERVE,
    NULL;


    public static QicorePatientMilitaryService fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("not-indicated".equals(codeString)) {
            return NOTINDICATED;
        }
        if ("no-military-service".equals(codeString)) {
            return NOMILITARYSERVICE;
        }
        if ("veteran".equals(codeString)) {
            return VETERAN;
        }
        if ("active-duty".equals(codeString)) {
            return ACTIVEDUTY;
        }
        if ("active-reserve".equals(codeString)) {
            return ACTIVERESERVE;
        }
        if ("inactive-reserve".equals(codeString)) {
            return INACTIVERESERVE;
        }
        throw new FHIRException("Unknown QicorePatientMilitaryService code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case NOTINDICATED: {
                return "not-indicated";
            }
            case NOMILITARYSERVICE: {
                return "no-military-service";
            }
            case VETERAN: {
                return "veteran";
            }
            case ACTIVEDUTY: {
                return "active-duty";
            }
            case ACTIVERESERVE: {
                return "active-reserve";
            }
            case INACTIVERESERVE: {
                return "inactive-reserve";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/qicore-military-service";
    }

    public String getDefinition() {
        switch (this) {
            case NOTINDICATED: {
                return "The military status is not indicated";
            }
            case NOMILITARYSERVICE: {
                return "The subject has no history of military service";
            }
            case VETERAN: {
                return "The subject is has served in the military but is no longer active";
            }
            case ACTIVEDUTY: {
                return "The subject is not a reserve member and is currently engaged in full-time military activity";
            }
            case ACTIVERESERVE: {
                return "The subject is a reserve member and is currently engaged in full-time military activity";
            }
            case INACTIVERESERVE: {
                return "The subject is a reserve member and is not currently engaged in full-time military activity";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case NOTINDICATED: {
                return "Not Indicated";
            }
            case NOMILITARYSERVICE: {
                return "No Military Service";
            }
            case VETERAN: {
                return "Veteran";
            }
            case ACTIVEDUTY: {
                return "Active Duty";
            }
            case ACTIVERESERVE: {
                return "Active Reserve";
            }
            case INACTIVERESERVE: {
                return "Inactive Reserve";
            }
        }
        return "?";
    }
}

