/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.utils.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.hl7.fhir.dstu2016may.model.Bundle;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.ConceptMap;
import org.hl7.fhir.dstu2016may.model.Conformance;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Parameters;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.utils.client.ClientUtils;
import org.hl7.fhir.dstu2016may.utils.client.EFhirClientException;
import org.hl7.fhir.dstu2016may.utils.client.ResourceAddress;
import org.hl7.fhir.dstu2016may.utils.client.ResourceFormat;
import org.hl7.fhir.dstu2016may.utils.client.ResourceRequest;
import org.hl7.fhir.utilities.Utilities;

public class FHIRToolingClient {
    public static final String DATETIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ssK";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String hostKey = "http.proxyHost";
    public static final String portKey = "http.proxyPort";
    private String base;
    private ResourceAddress resourceAddress;
    private ResourceFormat preferredResourceFormat = ResourceFormat.RESOURCE_XML;
    private HttpHost proxy;
    private int maxResultSetSize = -1;
    private Conformance conf;

    public FHIRToolingClient(String baseServiceUrl) throws URISyntaxException {
        this.detectProxy();
        this.initialize(baseServiceUrl);
    }

    public void configureProxy(String proxyHost, int proxyPort) {
        this.proxy = new HttpHost(proxyHost, proxyPort);
    }

    public void detectProxy() {
        String host = System.getenv(hostKey);
        String port = System.getenv(portKey);
        if (host == null) {
            host = System.getProperty(hostKey);
        }
        if (port == null) {
            port = System.getProperty(portKey);
        }
        if (host != null && port != null) {
            this.configureProxy(host, Integer.parseInt(port));
        }
    }

    public void initialize(String baseServiceUrl) throws URISyntaxException {
        this.base = baseServiceUrl;
        this.resourceAddress = new ResourceAddress(baseServiceUrl);
        this.maxResultSetSize = -1;
        this.checkConformance();
    }

    private void checkConformance() {
        try {
            this.conf = this.getConformanceStatementQuick();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public String getPreferredResourceFormat() {
        return this.preferredResourceFormat.getHeader();
    }

    public void setPreferredResourceFormat(ResourceFormat resourceFormat) {
        this.preferredResourceFormat = resourceFormat;
    }

    public int getMaximumRecordCount() {
        return this.maxResultSetSize;
    }

    public void setMaximumRecordCount(int maxResultSetSize) {
        this.maxResultSetSize = maxResultSetSize;
    }

    public Conformance getConformanceStatement() throws EFhirClientException {
        if (this.conf != null) {
            return this.conf;
        }
        return this.getConformanceStatement(false);
    }

    public Conformance getConformanceStatement(boolean useOptionsVerb) {
        Conformance conformance = null;
        try {
            conformance = useOptionsVerb ? (Conformance)ClientUtils.issueOptionsRequest(this.resourceAddress.getBaseServiceUri(), this.getPreferredResourceFormat(), this.proxy).getReference() : (Conformance)ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(false), this.getPreferredResourceFormat(), this.proxy).getReference();
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to fetch the server's conformance statement", e);
        }
        return conformance;
    }

    public Conformance getConformanceStatementQuick() throws EFhirClientException {
        if (this.conf != null) {
            return this.conf;
        }
        return this.getConformanceStatementQuick(false);
    }

    public Conformance getConformanceStatementQuick(boolean useOptionsVerb) {
        Conformance conformance = null;
        try {
            conformance = useOptionsVerb ? (Conformance)ClientUtils.issueOptionsRequest(this.resourceAddress.getBaseServiceUri(), this.getPreferredResourceFormat(), this.proxy).getReference() : (Conformance)ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveMetadataUri(true), this.getPreferredResourceFormat(), this.proxy).getReference();
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to fetch the server's conformance statement", e);
        }
        return conformance;
    }

    public <T extends Resource> T read(Class<T> resourceClass, String id) {
        ResourceRequest result = null;
        try {
            result = ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndId(resourceClass, id), this.getPreferredResourceFormat(), this.proxy);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this resource", e);
        }
        return result.getPayload();
    }

    public <T extends Resource> T vread(Class<T> resourceClass, String id, String version) {
        ResourceRequest result = null;
        try {
            result = ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveGetUriFromResourceClassAndIdAndVersion(resourceClass, id, version), this.getPreferredResourceFormat(), this.proxy);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addErrorStatus(405);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to read this version of the resource", e);
        }
        return result.getPayload();
    }

    public <T extends Resource> Parameters operateType(Class<T> resourceClass, String name, Parameters params) {
        boolean complex = false;
        for (Parameters.ParametersParameterComponent p : params.getParameter()) {
            complex = complex || !(p.getValue() instanceof PrimitiveType);
        }
        Object searchResults = null;
        String ps = "";
        try {
            if (!complex) {
                for (Parameters.ParametersParameterComponent p : params.getParameter()) {
                    if (!(p.getValue() instanceof PrimitiveType)) continue;
                    ps = ps + p.getName() + "=" + Utilities.encodeUri((String)((PrimitiveType)p.getValue()).asStringValue()) + "&";
                }
            }
            ResourceRequest result = complex ? ClientUtils.issuePostRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, ps), ClientUtils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), this.proxy) : ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveOperationURLFromClass(resourceClass, name, ps), this.getPreferredResourceFormat(), this.proxy);
            result.addErrorStatus(410);
            result.addErrorStatus(404);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
            if (result.getPayload() instanceof Parameters) {
                return (Parameters)result.getPayload();
            }
            Parameters p_out = new Parameters();
            p_out.addParameter().setName("return").setResource((Resource)result.getPayload());
            return p_out;
        }
        catch (Exception e) {
            this.handleException("Error performing operation '" + name + "' with parameters " + ps, e);
            return null;
        }
    }

    public Bundle transaction(Bundle batch) {
        Bundle transactionResult = null;
        try {
            transactionResult = ClientUtils.postBatchRequest(this.resourceAddress.getBaseServiceUri(), ClientUtils.getFeedAsByteArray(batch, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), this.proxy);
        }
        catch (Exception e) {
            this.handleException("An error occurred trying to process this transaction request", e);
        }
        return transactionResult;
    }

    public <T extends Resource> OperationOutcome validate(Class<T> resourceClass, T resource, String id) {
        ResourceRequest result = null;
        try {
            result = ClientUtils.issuePostRequest(this.resourceAddress.resolveValidateUri(resourceClass, id), ClientUtils.getResourceAsByteArray(resource, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), this.proxy);
            result.addErrorStatus(400);
            result.addErrorStatus(422);
            result.addSuccessStatus(200);
            if (result.isUnsuccessfulRequest()) {
                throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
            }
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to validate this resource", e);
        }
        return (OperationOutcome)result.getPayload();
    }

    protected void handleException(String message, Exception e) throws EFhirClientException {
        if (e instanceof EFhirClientException) {
            throw (EFhirClientException)e;
        }
        throw new EFhirClientException(message, e);
    }

    protected boolean isJson(String format) {
        boolean isJson = false;
        if (format.toLowerCase().contains("json")) {
            isJson = true;
        }
        return isJson;
    }

    public Bundle fetchFeed(String url) {
        Bundle feed = null;
        try {
            feed = ClientUtils.issueGetFeedRequest(new URI(url), this.getPreferredResourceFormat(), this.proxy);
        }
        catch (Exception e) {
            this.handleException("An error has occurred while trying to retrieve history since last update", e);
        }
        return feed;
    }

    public ValueSet expandValueset(ValueSet source) {
        List<Header> headers = null;
        ResourceRequest result = ClientUtils.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand"), ClientUtils.getResourceAsByteArray(source, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, this.proxy);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ValueSet)result.getPayload();
    }

    public Parameters lookupCode(Map<String, String> params) {
        ResourceRequest result = ClientUtils.issueGetResourceRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "lookup", params), this.getPreferredResourceFormat(), this.proxy);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (Parameters)result.getPayload();
    }

    public ValueSet expandValueset(ValueSet source, Map<String, String> params) {
        List<Header> headers = null;
        ResourceRequest result = ClientUtils.issuePostRequest(this.resourceAddress.resolveOperationUri(ValueSet.class, "expand", params), ClientUtils.getResourceAsByteArray(source, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, this.proxy);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ValueSet)result.getPayload();
    }

    public String getAddress() {
        return this.base;
    }

    public ConceptMap initializeClosure(String name) {
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        List<Header> headers = null;
        ResourceRequest result = ClientUtils.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), ClientUtils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, this.proxy);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ConceptMap)result.getPayload();
    }

    public ConceptMap updateClosure(String name, Coding coding) {
        Parameters params = new Parameters();
        params.addParameter().setName("name").setValue(new StringType(name));
        params.addParameter().setName("concept").setValue(coding);
        List<Header> headers = null;
        ResourceRequest result = ClientUtils.issuePostRequest(this.resourceAddress.resolveOperationUri(null, "closure", new HashMap<String, String>()), ClientUtils.getResourceAsByteArray(params, false, this.isJson(this.getPreferredResourceFormat())), this.getPreferredResourceFormat(), headers, this.proxy);
        result.addErrorStatus(410);
        result.addErrorStatus(404);
        result.addErrorStatus(405);
        result.addErrorStatus(422);
        result.addSuccessStatus(200);
        result.addSuccessStatus(201);
        if (result.isUnsuccessfulRequest()) {
            throw new EFhirClientException("Server returned error code " + result.getHttpStatus(), (OperationOutcome)result.getPayload());
        }
        return (ConceptMap)result.getPayload();
    }
}

