/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeableConcept;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.Device;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.HealthcareService;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.Location;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Period;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.RelatedPerson;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="Schedule", profile="http://hl7.org/fhir/Profile/Schedule")
public class Schedule
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="External Ids for this item", formalDefinition="External Ids for this item.")
    protected List<Identifier> identifier;
    @Child(name="serviceCategory", type={CodeableConcept.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="A broad categorisation of the service that is to be performed during this appointment", formalDefinition="A broad categorisation of the service that is to be performed during this appointment.")
    protected CodeableConcept serviceCategory;
    @Child(name="serviceType", type={CodeableConcept.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specific service that is to be performed during this appointment", formalDefinition="The specific service that is to be performed during this appointment.")
    protected List<CodeableConcept> serviceType;
    @Child(name="specialty", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment", formalDefinition="The specialty of a practitioner that would be required to perform the service requested in this appointment.")
    protected List<CodeableConcept> specialty;
    @Child(name="actor", type={Patient.class, Practitioner.class, RelatedPerson.class, Device.class, HealthcareService.class, Location.class}, order=4, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The resource this Schedule resource is providing availability information for. These are expected to usually be one of HealthcareService, Location, Practitioner, Device, Patient or RelatedPerson", formalDefinition="The resource this Schedule resource is providing availability information for. These are expected to usually be one of HealthcareService, Location, Practitioner, Device, Patient or RelatedPerson.")
    protected Reference actor;
    protected Resource actorTarget;
    @Child(name="planningHorizon", type={Period.class}, order=5, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The period of time that the slots that are attached to this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates", formalDefinition="The period of time that the slots that are attached to this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates.")
    protected Period planningHorizon;
    @Child(name="comment", type={StringType.class}, order=6, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Comments on the availability to describe any extended information. Such as custom constraints on the slot(s) that may be associated", formalDefinition="Comments on the availability to describe any extended information. Such as custom constraints on the slot(s) that may be associated.")
    protected StringType comment;
    private static final long serialVersionUID = 1234951934L;
    @SearchParamDefinition(name="actor", path="Schedule.actor", description="The individual(HealthcareService, Practitioner, Location, ...) to find a Schedule for", type="reference")
    public static final String SP_ACTOR = "actor";
    public static final ReferenceClientParam ACTOR = new ReferenceClientParam("actor");
    public static final Include INCLUDE_ACTOR = new Include("Schedule:actor").toLocked();
    @SearchParamDefinition(name="date", path="Schedule.planningHorizon", description="Search for Schedule resources that have a period that contains this date specified", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="type", path="Schedule.serviceType", description="The type of appointments that can be booked into associated slot(s)", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="identifier", path="Schedule.identifier", description="A Schedule Identifier", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");

    public Schedule() {
    }

    public Schedule(Reference actor) {
        this.actor = actor;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public Schedule addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public CodeableConcept getServiceCategory() {
        if (this.serviceCategory == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.serviceCategory");
            }
            if (Configuration.doAutoCreate()) {
                this.serviceCategory = new CodeableConcept();
            }
        }
        return this.serviceCategory;
    }

    public boolean hasServiceCategory() {
        return this.serviceCategory != null && !this.serviceCategory.isEmpty();
    }

    public Schedule setServiceCategory(CodeableConcept value) {
        this.serviceCategory = value;
        return this;
    }

    public List<CodeableConcept> getServiceType() {
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        return this.serviceType;
    }

    public boolean hasServiceType() {
        if (this.serviceType == null) {
            return false;
        }
        for (CodeableConcept item : this.serviceType) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addServiceType() {
        CodeableConcept t = new CodeableConcept();
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return t;
    }

    public Schedule addServiceType(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.serviceType == null) {
            this.serviceType = new ArrayList<CodeableConcept>();
        }
        this.serviceType.add(t);
        return this;
    }

    public List<CodeableConcept> getSpecialty() {
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        return this.specialty;
    }

    public boolean hasSpecialty() {
        if (this.specialty == null) {
            return false;
        }
        for (CodeableConcept item : this.specialty) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addSpecialty() {
        CodeableConcept t = new CodeableConcept();
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return t;
    }

    public Schedule addSpecialty(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.specialty == null) {
            this.specialty = new ArrayList<CodeableConcept>();
        }
        this.specialty.add(t);
        return this;
    }

    public Reference getActor() {
        if (this.actor == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.actor");
            }
            if (Configuration.doAutoCreate()) {
                this.actor = new Reference();
            }
        }
        return this.actor;
    }

    public boolean hasActor() {
        return this.actor != null && !this.actor.isEmpty();
    }

    public Schedule setActor(Reference value) {
        this.actor = value;
        return this;
    }

    public Resource getActorTarget() {
        return this.actorTarget;
    }

    public Schedule setActorTarget(Resource value) {
        this.actorTarget = value;
        return this;
    }

    public Period getPlanningHorizon() {
        if (this.planningHorizon == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.planningHorizon");
            }
            if (Configuration.doAutoCreate()) {
                this.planningHorizon = new Period();
            }
        }
        return this.planningHorizon;
    }

    public boolean hasPlanningHorizon() {
        return this.planningHorizon != null && !this.planningHorizon.isEmpty();
    }

    public Schedule setPlanningHorizon(Period value) {
        this.planningHorizon = value;
        return this;
    }

    public StringType getCommentElement() {
        if (this.comment == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create Schedule.comment");
            }
            if (Configuration.doAutoCreate()) {
                this.comment = new StringType();
            }
        }
        return this.comment;
    }

    public boolean hasCommentElement() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public boolean hasComment() {
        return this.comment != null && !this.comment.isEmpty();
    }

    public Schedule setCommentElement(StringType value) {
        this.comment = value;
        return this;
    }

    public String getComment() {
        return this.comment == null ? null : (String)this.comment.getValue();
    }

    public Schedule setComment(String value) {
        if (Utilities.noString((String)value)) {
            this.comment = null;
        } else {
            if (this.comment == null) {
                this.comment = new StringType();
            }
            this.comment.setValue(value);
        }
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "External Ids for this item.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("serviceCategory", "CodeableConcept", "A broad categorisation of the service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceCategory));
        childrenList.add(new Property("serviceType", "CodeableConcept", "The specific service that is to be performed during this appointment.", 0, Integer.MAX_VALUE, this.serviceType));
        childrenList.add(new Property("specialty", "CodeableConcept", "The specialty of a practitioner that would be required to perform the service requested in this appointment.", 0, Integer.MAX_VALUE, this.specialty));
        childrenList.add(new Property(SP_ACTOR, "Reference(Patient|Practitioner|RelatedPerson|Device|HealthcareService|Location)", "The resource this Schedule resource is providing availability information for. These are expected to usually be one of HealthcareService, Location, Practitioner, Device, Patient or RelatedPerson.", 0, Integer.MAX_VALUE, this.actor));
        childrenList.add(new Property("planningHorizon", "Period", "The period of time that the slots that are attached to this Schedule resource cover (even if none exist). These  cover the amount of time that an organization's planning horizon; the interval for which they are currently accepting appointments. This does not define a \"template\" for planning outside these dates.", 0, Integer.MAX_VALUE, this.planningHorizon));
        childrenList.add(new Property("comment", "string", "Comments on the availability to describe any extended information. Such as custom constraints on the slot(s) that may be associated.", 0, Integer.MAX_VALUE, this.comment));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1281188563: {
                Base[] baseArray;
                if (this.serviceCategory == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.serviceCategory;
                }
                return baseArray;
            }
            case -1928370289: {
                return this.serviceType == null ? new Base[]{} : this.serviceType.toArray(new Base[this.serviceType.size()]);
            }
            case -1694759682: {
                return this.specialty == null ? new Base[]{} : this.specialty.toArray(new Base[this.specialty.size()]);
            }
            case 92645877: {
                Base[] baseArray;
                if (this.actor == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.actor;
                }
                return baseArray;
            }
            case -1718507650: {
                Base[] baseArray;
                if (this.planningHorizon == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.planningHorizon;
                }
                return baseArray;
            }
            case 950398559: {
                Base[] baseArray;
                if (this.comment == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.comment;
                }
                return baseArray;
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 1281188563: {
                this.serviceCategory = this.castToCodeableConcept(value);
                break;
            }
            case -1928370289: {
                this.getServiceType().add(this.castToCodeableConcept(value));
                break;
            }
            case -1694759682: {
                this.getSpecialty().add(this.castToCodeableConcept(value));
                break;
            }
            case 92645877: {
                this.actor = this.castToReference(value);
                break;
            }
            case -1718507650: {
                this.planningHorizon = this.castToPeriod(value);
                break;
            }
            case 950398559: {
                this.comment = this.castToString(value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("serviceCategory")) {
            this.serviceCategory = this.castToCodeableConcept(value);
        } else if (name.equals("serviceType")) {
            this.getServiceType().add(this.castToCodeableConcept(value));
        } else if (name.equals("specialty")) {
            this.getSpecialty().add(this.castToCodeableConcept(value));
        } else if (name.equals(SP_ACTOR)) {
            this.actor = this.castToReference(value);
        } else if (name.equals("planningHorizon")) {
            this.planningHorizon = this.castToPeriod(value);
        } else if (name.equals("comment")) {
            this.comment = this.castToString(value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1281188563: {
                return this.getServiceCategory();
            }
            case -1928370289: {
                return this.addServiceType();
            }
            case -1694759682: {
                return this.addSpecialty();
            }
            case 92645877: {
                return this.getActor();
            }
            case -1718507650: {
                return this.getPlanningHorizon();
            }
            case 950398559: {
                throw new FHIRException("Cannot make property comment as it is not a complex type");
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("serviceCategory")) {
            this.serviceCategory = new CodeableConcept();
            return this.serviceCategory;
        }
        if (name.equals("serviceType")) {
            return this.addServiceType();
        }
        if (name.equals("specialty")) {
            return this.addSpecialty();
        }
        if (name.equals(SP_ACTOR)) {
            this.actor = new Reference();
            return this.actor;
        }
        if (name.equals("planningHorizon")) {
            this.planningHorizon = new Period();
            return this.planningHorizon;
        }
        if (name.equals("comment")) {
            throw new FHIRException("Cannot call addChild on a primitive type Schedule.comment");
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "Schedule";
    }

    @Override
    public Schedule copy() {
        Schedule dst = new Schedule();
        this.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        CodeableConcept codeableConcept = dst.serviceCategory = this.serviceCategory == null ? null : this.serviceCategory.copy();
        if (this.serviceType != null) {
            dst.serviceType = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept2 : this.serviceType) {
                dst.serviceType.add(codeableConcept2.copy());
            }
        }
        if (this.specialty != null) {
            dst.specialty = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept3 : this.specialty) {
                dst.specialty.add(codeableConcept3.copy());
            }
        }
        dst.actor = this.actor == null ? null : this.actor.copy();
        dst.planningHorizon = this.planningHorizon == null ? null : this.planningHorizon.copy();
        dst.comment = this.comment == null ? null : this.comment.copy();
        return dst;
    }

    protected Schedule typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof Schedule)) {
            return false;
        }
        Schedule o = (Schedule)other;
        return Schedule.compareDeep(this.identifier, o.identifier, true) && Schedule.compareDeep(this.serviceCategory, o.serviceCategory, true) && Schedule.compareDeep(this.serviceType, o.serviceType, true) && Schedule.compareDeep(this.specialty, o.specialty, true) && Schedule.compareDeep(this.actor, o.actor, true) && Schedule.compareDeep(this.planningHorizon, o.planningHorizon, true) && Schedule.compareDeep(this.comment, o.comment, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof Schedule)) {
            return false;
        }
        Schedule o = (Schedule)other;
        return Schedule.compareValues(this.comment, o.comment, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.serviceCategory != null && !this.serviceCategory.isEmpty() || this.serviceType != null && !this.serviceType.isEmpty() || this.specialty != null && !this.specialty.isEmpty() || this.actor != null && !this.actor.isEmpty() || this.planningHorizon != null && !this.planningHorizon.isEmpty() || this.comment != null && !this.comment.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.Schedule;
    }
}

