/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ContractAction {
    ACTIONA,
    ACTIONB,
    NULL;


    public static ContractAction fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("action-a".equals(codeString)) {
            return ACTIONA;
        }
        if ("action-b".equals(codeString)) {
            return ACTIONB;
        }
        throw new FHIRException("Unknown ContractAction code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ACTIONA: {
                return "action-a";
            }
            case ACTIONB: {
                return "action-b";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://www.hl7.org/fhir/contractaction";
    }

    public String getDefinition() {
        switch (this) {
            case ACTIONA: {
                return "";
            }
            case ACTIONB: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ACTIONA: {
                return "action-a";
            }
            case ACTIONB: {
                return "action-b";
            }
        }
        return "?";
    }
}

