/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum HspcObservationHeightPrecond {
    _84138,
    _84139,
    _84140,
    _84141,
    NULL;


    public static HspcObservationHeightPrecond fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("84138".equals(codeString)) {
            return _84138;
        }
        if ("84139".equals(codeString)) {
            return _84139;
        }
        if ("84140".equals(codeString)) {
            return _84140;
        }
        if ("84141".equals(codeString)) {
            return _84141;
        }
        throw new FHIRException("Unknown HspcObservationHeightPrecond code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _84138: {
                return "84138";
            }
            case _84139: {
                return "84139";
            }
            case _84140: {
                return "84140";
            }
            case _84141: {
                return "84141";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7,org/fhir/observation-hspc-heightPrecond";
    }

    public String getDefinition() {
        switch (this) {
            case _84138: {
                return "The individual's height was measured while the individual was wearing shoes";
            }
            case _84139: {
                return "The individual's height was measured without the individual wearing shoes.";
            }
            case _84140: {
                return "The individual's height was measured while the individual was lying down.";
            }
            case _84141: {
                return "The individual's height was measured while the individual was standing up.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _84138: {
                return "Height (body length) with shoes";
            }
            case _84139: {
                return "Height (body length) without shoes";
            }
            case _84140: {
                return "Height (body length) with patient reclining";
            }
            case _84141: {
                return "Height (body length) with patient standing";
            }
        }
        return "?";
    }
}

