/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaTumourStageGrouping {
    _0,
    I,
    IIA,
    IIB,
    IIC,
    IIIA,
    IIIB,
    IIIC,
    IVA,
    IVB,
    NULL;


    public static NehtaTumourStageGrouping fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("0".equals(codeString)) {
            return _0;
        }
        if ("i".equals(codeString)) {
            return I;
        }
        if ("iia".equals(codeString)) {
            return IIA;
        }
        if ("iib".equals(codeString)) {
            return IIB;
        }
        if ("iic".equals(codeString)) {
            return IIC;
        }
        if ("iiia".equals(codeString)) {
            return IIIA;
        }
        if ("iiib".equals(codeString)) {
            return IIIB;
        }
        if ("iiic".equals(codeString)) {
            return IIIC;
        }
        if ("iva".equals(codeString)) {
            return IVA;
        }
        if ("ivb".equals(codeString)) {
            return IVB;
        }
        throw new FHIRException("Unknown NehtaTumourStageGrouping code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case _0: {
                return "0";
            }
            case I: {
                return "i";
            }
            case IIA: {
                return "iia";
            }
            case IIB: {
                return "iib";
            }
            case IIC: {
                return "iic";
            }
            case IIIA: {
                return "iiia";
            }
            case IIIB: {
                return "iiib";
            }
            case IIIC: {
                return "iiic";
            }
            case IVA: {
                return "iva";
            }
            case IVB: {
                return "ivb";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/tumour-stage-grouping";
    }

    public String getDefinition() {
        switch (this) {
            case _0: {
                return "";
            }
            case I: {
                return "";
            }
            case IIA: {
                return "";
            }
            case IIB: {
                return "";
            }
            case IIC: {
                return "";
            }
            case IIIA: {
                return "";
            }
            case IIIB: {
                return "";
            }
            case IIIC: {
                return "";
            }
            case IVA: {
                return "";
            }
            case IVB: {
                return "";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case _0: {
                return "0 Tis N0 M0";
            }
            case I: {
                return "I T1 N0 M0\n  T2 N0 M0";
            }
            case IIA: {
                return "IIA T3 N0 M0";
            }
            case IIB: {
                return "IIB T4a N0 M0";
            }
            case IIC: {
                return "IIC T4b N0 M0";
            }
            case IIIA: {
                return "IIIA T1-T2 N1/N1c M0\n       T1       N2a        M0";
            }
            case IIIB: {
                return "IIIB T3-T4a N1/N1c M0\n       T2-T3   N2a        M0\n       T1-T2   N2b        M0";
            }
            case IIIC: {
                return "IIIC T4a       N2a      M0\n       T3-T4a N2b      M0\n       T4b       N1-N2 M0";
            }
            case IVA: {
                return "IVA Any T Any N M1a";
            }
            case IVB: {
                return "IVB Any T Any N M1b";
            }
        }
        return "?";
    }
}

