/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ObservationStatus {
    REGISTERED,
    PRELIMINARY,
    FINAL,
    AMENDED,
    CANCELLED,
    ENTEREDINERROR,
    UNKNOWN,
    NULL;


    public static ObservationStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("registered".equals(codeString)) {
            return REGISTERED;
        }
        if ("preliminary".equals(codeString)) {
            return PRELIMINARY;
        }
        if ("final".equals(codeString)) {
            return FINAL;
        }
        if ("amended".equals(codeString)) {
            return AMENDED;
        }
        if ("cancelled".equals(codeString)) {
            return CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        if ("unknown".equals(codeString)) {
            return UNKNOWN;
        }
        throw new FHIRException("Unknown ObservationStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REGISTERED: {
                return "registered";
            }
            case PRELIMINARY: {
                return "preliminary";
            }
            case FINAL: {
                return "final";
            }
            case AMENDED: {
                return "amended";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
            case UNKNOWN: {
                return "unknown";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/observation-status";
    }

    public String getDefinition() {
        switch (this) {
            case REGISTERED: {
                return "The existence of the observation is registered, but there is no result yet available.";
            }
            case PRELIMINARY: {
                return "This is an initial or interim observation: data may be incomplete or unverified.";
            }
            case FINAL: {
                return "The observation is complete and verified by an authorized person  (who may be the same person who entered the observation based on policy).";
            }
            case AMENDED: {
                return "The observation has been modified subsequent to being Final, and is complete and verified by an authorized person.";
            }
            case CANCELLED: {
                return "The observation is unavailable because the measurement was not started or not completed (also sometimes called \"aborted\").";
            }
            case ENTEREDINERROR: {
                return "The observation has been withdrawn following previous final release.";
            }
            case UNKNOWN: {
                return "The observation status is unknown.  Note that \"unknown\" is a value of last resort and every attempt should be made to provide a meaningful value other than \"unknown\".";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REGISTERED: {
                return "Registered";
            }
            case PRELIMINARY: {
                return "Preliminary";
            }
            case FINAL: {
                return "Final";
            }
            case AMENDED: {
                return "Amended";
            }
            case CANCELLED: {
                return "cancelled";
            }
            case ENTEREDINERROR: {
                return "Entered in Error";
            }
            case UNKNOWN: {
                return "Unknown Status";
            }
        }
        return "?";
    }
}

