/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.rest.gclient.UriClientParam;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.dstu2016may.model.Attachment;
import org.hl7.fhir.dstu2016may.model.BackboneElement;
import org.hl7.fhir.dstu2016may.model.Base;
import org.hl7.fhir.dstu2016may.model.CodeType;
import org.hl7.fhir.dstu2016may.model.Coding;
import org.hl7.fhir.dstu2016may.model.Configuration;
import org.hl7.fhir.dstu2016may.model.DateTimeType;
import org.hl7.fhir.dstu2016may.model.DiagnosticOrder;
import org.hl7.fhir.dstu2016may.model.DomainResource;
import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.Enumeration;
import org.hl7.fhir.dstu2016may.model.Identifier;
import org.hl7.fhir.dstu2016may.model.OidType;
import org.hl7.fhir.dstu2016may.model.Patient;
import org.hl7.fhir.dstu2016may.model.Practitioner;
import org.hl7.fhir.dstu2016may.model.PrimitiveType;
import org.hl7.fhir.dstu2016may.model.Procedure;
import org.hl7.fhir.dstu2016may.model.Property;
import org.hl7.fhir.dstu2016may.model.Reference;
import org.hl7.fhir.dstu2016may.model.ResourceType;
import org.hl7.fhir.dstu2016may.model.StringType;
import org.hl7.fhir.dstu2016may.model.UnsignedIntType;
import org.hl7.fhir.dstu2016may.model.UriType;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.utilities.Utilities;

@ResourceDef(name="ImagingStudy", profile="http://hl7.org/fhir/Profile/ImagingStudy")
public class ImagingStudy
extends DomainResource {
    @Child(name="uid", type={OidType.class}, order=0, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Formal identifier for the study", formalDefinition="Formal identifier for the study.")
    protected OidType uid;
    @Child(name="accession", type={Identifier.class}, order=1, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Related workflow identifier (\"Accession Number\")", formalDefinition="Accession Number is an identifier related to some aspect of imaging workflow and data management. Usage may vary across different institutions.  See for instance [IHE Radiology Technical Framework Volume 1 Appendix A](http://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Rev13.0_Vol1_FT_2014-07-30.pdf).")
    protected Identifier accession;
    @Child(name="identifier", type={Identifier.class}, order=2, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Other identifiers for the study", formalDefinition="Other identifiers for the study.")
    protected List<Identifier> identifier;
    @Child(name="availability", type={CodeType.class}, order=3, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="ONLINE | OFFLINE | NEARLINE | UNAVAILABLE (0008,0056)", formalDefinition="Availability of study (online, offline or nearline).")
    protected Enumeration<InstanceAvailability> availability;
    @Child(name="modalityList", type={Coding.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="All series modality if actual acquisition modalities", formalDefinition="A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19).")
    protected List<Coding> modalityList;
    @Child(name="patient", type={Patient.class}, order=5, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who the images are of", formalDefinition="The patient imaged in the study.")
    protected Reference patient;
    protected Patient patientTarget;
    @Child(name="started", type={DateTimeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="When the study was started", formalDefinition="Date and Time the study started.")
    protected DateTimeType started;
    @Child(name="order", type={DiagnosticOrder.class}, order=7, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Order(s) that caused this study to be performed", formalDefinition="A list of the diagnostic orders that resulted in this imaging study being performed.")
    protected List<Reference> order;
    protected List<DiagnosticOrder> orderTarget;
    @Child(name="referrer", type={Practitioner.class}, order=8, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Referring physician (0008,0090)", formalDefinition="The requesting/referring physician.")
    protected Reference referrer;
    protected Practitioner referrerTarget;
    @Child(name="interpreter", type={Practitioner.class}, order=9, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Who interpreted images", formalDefinition="Who read the study and interpreted the images or other content.")
    protected Reference interpreter;
    protected Practitioner interpreterTarget;
    @Child(name="url", type={UriType.class}, order=10, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Retrieve URI", formalDefinition="WADO-RS resource where Study is available.")
    protected UriType url;
    @Child(name="numberOfSeries", type={UnsignedIntType.class}, order=11, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of Study Related Series", formalDefinition="Number of Series in Study.")
    protected UnsignedIntType numberOfSeries;
    @Child(name="numberOfInstances", type={UnsignedIntType.class}, order=12, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Number of Study Related Instances", formalDefinition="Number of SOP Instances in Study.")
    protected UnsignedIntType numberOfInstances;
    @Child(name="procedure", type={Procedure.class}, order=13, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Type of procedure performed", formalDefinition="Type of procedure performed.")
    protected List<Reference> procedure;
    protected List<Procedure> procedureTarget;
    @Child(name="description", type={StringType.class}, order=14, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="Institution-generated description", formalDefinition="Institution-generated description or classification of the Study performed.")
    protected StringType description;
    @Child(name="series", type={}, order=15, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Each study has one or more series of instances", formalDefinition="Each study has one or more series of images or other content.")
    protected List<ImagingStudySeriesComponent> series;
    private static final long serialVersionUID = 1998463596L;
    @SearchParamDefinition(name="uid", path="ImagingStudy.series.instance.uid", description="The instance unique identifier", type="uri")
    public static final String SP_UID = "uid";
    public static final UriClientParam UID = new UriClientParam("uid");
    @SearchParamDefinition(name="series", path="ImagingStudy.series.uid", description="The identifier of the series of images", type="uri")
    public static final String SP_SERIES = "series";
    public static final UriClientParam SERIES = new UriClientParam("series");
    @SearchParamDefinition(name="patient", path="ImagingStudy.patient", description="Who the study is about", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("ImagingStudy:patient").toLocked();
    @SearchParamDefinition(name="order", path="ImagingStudy.order", description="The order for the image", type="reference")
    public static final String SP_ORDER = "order";
    public static final ReferenceClientParam ORDER = new ReferenceClientParam("order");
    public static final Include INCLUDE_ORDER = new Include("ImagingStudy:order").toLocked();
    @SearchParamDefinition(name="bodysite", path="ImagingStudy.series.bodySite", description="The body site studied", type="token")
    public static final String SP_BODYSITE = "bodysite";
    public static final TokenClientParam BODYSITE = new TokenClientParam("bodysite");
    @SearchParamDefinition(name="accession", path="ImagingStudy.accession", description="The accession identifier for the study", type="token")
    public static final String SP_ACCESSION = "accession";
    public static final TokenClientParam ACCESSION = new TokenClientParam("accession");
    @SearchParamDefinition(name="study", path="ImagingStudy.uid", description="The study identifier for the image", type="uri")
    public static final String SP_STUDY = "study";
    public static final UriClientParam STUDY = new UriClientParam("study");
    @SearchParamDefinition(name="modality", path="ImagingStudy.series.modality", description="The modality of the series", type="token")
    public static final String SP_MODALITY = "modality";
    public static final TokenClientParam MODALITY = new TokenClientParam("modality");
    @SearchParamDefinition(name="started", path="ImagingStudy.started", description="When the study was started", type="date")
    public static final String SP_STARTED = "started";
    public static final DateClientParam STARTED = new DateClientParam("started");
    @SearchParamDefinition(name="identifier", path="ImagingStudy.identifier", description="Other identifiers for the Study", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="dicom-class", path="ImagingStudy.series.instance.sopClass", description="The type of the instance", type="uri")
    public static final String SP_DICOM_CLASS = "dicom-class";
    public static final UriClientParam DICOM_CLASS = new UriClientParam("dicom-class");

    public ImagingStudy() {
    }

    public ImagingStudy(OidType uid, Reference patient, UnsignedIntType numberOfSeries, UnsignedIntType numberOfInstances) {
        this.uid = uid;
        this.patient = patient;
        this.numberOfSeries = numberOfSeries;
        this.numberOfInstances = numberOfInstances;
    }

    public OidType getUidElement() {
        if (this.uid == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.uid");
            }
            if (Configuration.doAutoCreate()) {
                this.uid = new OidType();
            }
        }
        return this.uid;
    }

    public boolean hasUidElement() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public boolean hasUid() {
        return this.uid != null && !this.uid.isEmpty();
    }

    public ImagingStudy setUidElement(OidType value) {
        this.uid = value;
        return this;
    }

    public String getUid() {
        return this.uid == null ? null : (String)this.uid.getValue();
    }

    public ImagingStudy setUid(String value) {
        if (this.uid == null) {
            this.uid = new OidType();
        }
        this.uid.setValue(value);
        return this;
    }

    public Identifier getAccession() {
        if (this.accession == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.accession");
            }
            if (Configuration.doAutoCreate()) {
                this.accession = new Identifier();
            }
        }
        return this.accession;
    }

    public boolean hasAccession() {
        return this.accession != null && !this.accession.isEmpty();
    }

    public ImagingStudy setAccession(Identifier value) {
        this.accession = value;
        return this;
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public ImagingStudy addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Enumeration<InstanceAvailability> getAvailabilityElement() {
        if (this.availability == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.availability");
            }
            if (Configuration.doAutoCreate()) {
                this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
            }
        }
        return this.availability;
    }

    public boolean hasAvailabilityElement() {
        return this.availability != null && !this.availability.isEmpty();
    }

    public boolean hasAvailability() {
        return this.availability != null && !this.availability.isEmpty();
    }

    public ImagingStudy setAvailabilityElement(Enumeration<InstanceAvailability> value) {
        this.availability = value;
        return this;
    }

    public InstanceAvailability getAvailability() {
        return this.availability == null ? null : (InstanceAvailability)((Object)this.availability.getValue());
    }

    public ImagingStudy setAvailability(InstanceAvailability value) {
        if (value == null) {
            this.availability = null;
        } else {
            if (this.availability == null) {
                this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
            }
            this.availability.setValue((Object)value);
        }
        return this;
    }

    public List<Coding> getModalityList() {
        if (this.modalityList == null) {
            this.modalityList = new ArrayList<Coding>();
        }
        return this.modalityList;
    }

    public boolean hasModalityList() {
        if (this.modalityList == null) {
            return false;
        }
        for (Coding item : this.modalityList) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Coding addModalityList() {
        Coding t = new Coding();
        if (this.modalityList == null) {
            this.modalityList = new ArrayList<Coding>();
        }
        this.modalityList.add(t);
        return t;
    }

    public ImagingStudy addModalityList(Coding t) {
        if (t == null) {
            return this;
        }
        if (this.modalityList == null) {
            this.modalityList = new ArrayList<Coding>();
        }
        this.modalityList.add(t);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public ImagingStudy setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public Patient getPatientTarget() {
        if (this.patientTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patientTarget = new Patient();
            }
        }
        return this.patientTarget;
    }

    public ImagingStudy setPatientTarget(Patient value) {
        this.patientTarget = value;
        return this;
    }

    public DateTimeType getStartedElement() {
        if (this.started == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.started");
            }
            if (Configuration.doAutoCreate()) {
                this.started = new DateTimeType();
            }
        }
        return this.started;
    }

    public boolean hasStartedElement() {
        return this.started != null && !this.started.isEmpty();
    }

    public boolean hasStarted() {
        return this.started != null && !this.started.isEmpty();
    }

    public ImagingStudy setStartedElement(DateTimeType value) {
        this.started = value;
        return this;
    }

    public Date getStarted() {
        return this.started == null ? null : (Date)this.started.getValue();
    }

    public ImagingStudy setStarted(Date value) {
        if (value == null) {
            this.started = null;
        } else {
            if (this.started == null) {
                this.started = new DateTimeType();
            }
            this.started.setValue(value);
        }
        return this;
    }

    public List<Reference> getOrder() {
        if (this.order == null) {
            this.order = new ArrayList<Reference>();
        }
        return this.order;
    }

    public boolean hasOrder() {
        if (this.order == null) {
            return false;
        }
        for (Reference item : this.order) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addOrder() {
        Reference t = new Reference();
        if (this.order == null) {
            this.order = new ArrayList<Reference>();
        }
        this.order.add(t);
        return t;
    }

    public ImagingStudy addOrder(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.order == null) {
            this.order = new ArrayList<Reference>();
        }
        this.order.add(t);
        return this;
    }

    public List<DiagnosticOrder> getOrderTarget() {
        if (this.orderTarget == null) {
            this.orderTarget = new ArrayList<DiagnosticOrder>();
        }
        return this.orderTarget;
    }

    public DiagnosticOrder addOrderTarget() {
        DiagnosticOrder r = new DiagnosticOrder();
        if (this.orderTarget == null) {
            this.orderTarget = new ArrayList<DiagnosticOrder>();
        }
        this.orderTarget.add(r);
        return r;
    }

    public Reference getReferrer() {
        if (this.referrer == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.referrer");
            }
            if (Configuration.doAutoCreate()) {
                this.referrer = new Reference();
            }
        }
        return this.referrer;
    }

    public boolean hasReferrer() {
        return this.referrer != null && !this.referrer.isEmpty();
    }

    public ImagingStudy setReferrer(Reference value) {
        this.referrer = value;
        return this;
    }

    public Practitioner getReferrerTarget() {
        if (this.referrerTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.referrer");
            }
            if (Configuration.doAutoCreate()) {
                this.referrerTarget = new Practitioner();
            }
        }
        return this.referrerTarget;
    }

    public ImagingStudy setReferrerTarget(Practitioner value) {
        this.referrerTarget = value;
        return this;
    }

    public Reference getInterpreter() {
        if (this.interpreter == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.interpreter");
            }
            if (Configuration.doAutoCreate()) {
                this.interpreter = new Reference();
            }
        }
        return this.interpreter;
    }

    public boolean hasInterpreter() {
        return this.interpreter != null && !this.interpreter.isEmpty();
    }

    public ImagingStudy setInterpreter(Reference value) {
        this.interpreter = value;
        return this;
    }

    public Practitioner getInterpreterTarget() {
        if (this.interpreterTarget == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.interpreter");
            }
            if (Configuration.doAutoCreate()) {
                this.interpreterTarget = new Practitioner();
            }
        }
        return this.interpreterTarget;
    }

    public ImagingStudy setInterpreterTarget(Practitioner value) {
        this.interpreterTarget = value;
        return this;
    }

    public UriType getUrlElement() {
        if (this.url == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.url");
            }
            if (Configuration.doAutoCreate()) {
                this.url = new UriType();
            }
        }
        return this.url;
    }

    public boolean hasUrlElement() {
        return this.url != null && !this.url.isEmpty();
    }

    public boolean hasUrl() {
        return this.url != null && !this.url.isEmpty();
    }

    public ImagingStudy setUrlElement(UriType value) {
        this.url = value;
        return this;
    }

    public String getUrl() {
        return this.url == null ? null : (String)this.url.getValue();
    }

    public ImagingStudy setUrl(String value) {
        if (Utilities.noString((String)value)) {
            this.url = null;
        } else {
            if (this.url == null) {
                this.url = new UriType();
            }
            this.url.setValue(value);
        }
        return this;
    }

    public UnsignedIntType getNumberOfSeriesElement() {
        if (this.numberOfSeries == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.numberOfSeries");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfSeries = new UnsignedIntType();
            }
        }
        return this.numberOfSeries;
    }

    public boolean hasNumberOfSeriesElement() {
        return this.numberOfSeries != null && !this.numberOfSeries.isEmpty();
    }

    public boolean hasNumberOfSeries() {
        return this.numberOfSeries != null && !this.numberOfSeries.isEmpty();
    }

    public ImagingStudy setNumberOfSeriesElement(UnsignedIntType value) {
        this.numberOfSeries = value;
        return this;
    }

    public int getNumberOfSeries() {
        return this.numberOfSeries == null || this.numberOfSeries.isEmpty() ? 0 : (Integer)this.numberOfSeries.getValue();
    }

    public ImagingStudy setNumberOfSeries(int value) {
        if (this.numberOfSeries == null) {
            this.numberOfSeries = new UnsignedIntType();
        }
        this.numberOfSeries.setValue((Object)value);
        return this;
    }

    public UnsignedIntType getNumberOfInstancesElement() {
        if (this.numberOfInstances == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.numberOfInstances");
            }
            if (Configuration.doAutoCreate()) {
                this.numberOfInstances = new UnsignedIntType();
            }
        }
        return this.numberOfInstances;
    }

    public boolean hasNumberOfInstancesElement() {
        return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
    }

    public boolean hasNumberOfInstances() {
        return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
    }

    public ImagingStudy setNumberOfInstancesElement(UnsignedIntType value) {
        this.numberOfInstances = value;
        return this;
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances == null || this.numberOfInstances.isEmpty() ? 0 : (Integer)this.numberOfInstances.getValue();
    }

    public ImagingStudy setNumberOfInstances(int value) {
        if (this.numberOfInstances == null) {
            this.numberOfInstances = new UnsignedIntType();
        }
        this.numberOfInstances.setValue((Object)value);
        return this;
    }

    public List<Reference> getProcedure() {
        if (this.procedure == null) {
            this.procedure = new ArrayList<Reference>();
        }
        return this.procedure;
    }

    public boolean hasProcedure() {
        if (this.procedure == null) {
            return false;
        }
        for (Reference item : this.procedure) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Reference addProcedure() {
        Reference t = new Reference();
        if (this.procedure == null) {
            this.procedure = new ArrayList<Reference>();
        }
        this.procedure.add(t);
        return t;
    }

    public ImagingStudy addProcedure(Reference t) {
        if (t == null) {
            return this;
        }
        if (this.procedure == null) {
            this.procedure = new ArrayList<Reference>();
        }
        this.procedure.add(t);
        return this;
    }

    public List<Procedure> getProcedureTarget() {
        if (this.procedureTarget == null) {
            this.procedureTarget = new ArrayList<Procedure>();
        }
        return this.procedureTarget;
    }

    public Procedure addProcedureTarget() {
        Procedure r = new Procedure();
        if (this.procedureTarget == null) {
            this.procedureTarget = new ArrayList<Procedure>();
        }
        this.procedureTarget.add(r);
        return r;
    }

    public StringType getDescriptionElement() {
        if (this.description == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create ImagingStudy.description");
            }
            if (Configuration.doAutoCreate()) {
                this.description = new StringType();
            }
        }
        return this.description;
    }

    public boolean hasDescriptionElement() {
        return this.description != null && !this.description.isEmpty();
    }

    public boolean hasDescription() {
        return this.description != null && !this.description.isEmpty();
    }

    public ImagingStudy setDescriptionElement(StringType value) {
        this.description = value;
        return this;
    }

    public String getDescription() {
        return this.description == null ? null : (String)this.description.getValue();
    }

    public ImagingStudy setDescription(String value) {
        if (Utilities.noString((String)value)) {
            this.description = null;
        } else {
            if (this.description == null) {
                this.description = new StringType();
            }
            this.description.setValue(value);
        }
        return this;
    }

    public List<ImagingStudySeriesComponent> getSeries() {
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        return this.series;
    }

    public boolean hasSeries() {
        if (this.series == null) {
            return false;
        }
        for (ImagingStudySeriesComponent item : this.series) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ImagingStudySeriesComponent addSeries() {
        ImagingStudySeriesComponent t = new ImagingStudySeriesComponent();
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        this.series.add(t);
        return t;
    }

    public ImagingStudy addSeries(ImagingStudySeriesComponent t) {
        if (t == null) {
            return this;
        }
        if (this.series == null) {
            this.series = new ArrayList<ImagingStudySeriesComponent>();
        }
        this.series.add(t);
        return this;
    }

    @Override
    protected void listChildren(List<Property> childrenList) {
        super.listChildren(childrenList);
        childrenList.add(new Property(SP_UID, "oid", "Formal identifier for the study.", 0, Integer.MAX_VALUE, this.uid));
        childrenList.add(new Property(SP_ACCESSION, "Identifier", "Accession Number is an identifier related to some aspect of imaging workflow and data management. Usage may vary across different institutions.  See for instance [IHE Radiology Technical Framework Volume 1 Appendix A](http://www.ihe.net/uploadedFiles/Documents/Radiology/IHE_RAD_TF_Rev13.0_Vol1_FT_2014-07-30.pdf).", 0, Integer.MAX_VALUE, this.accession));
        childrenList.add(new Property(SP_IDENTIFIER, "Identifier", "Other identifiers for the study.", 0, Integer.MAX_VALUE, this.identifier));
        childrenList.add(new Property("availability", "code", "Availability of study (online, offline or nearline).", 0, Integer.MAX_VALUE, this.availability));
        childrenList.add(new Property("modalityList", "Coding", "A list of all the Series.ImageModality values that are actual acquisition modalities, i.e. those in the DICOM Context Group 29 (value set OID 1.2.840.10008.6.1.19).", 0, Integer.MAX_VALUE, this.modalityList));
        childrenList.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient imaged in the study.", 0, Integer.MAX_VALUE, this.patient));
        childrenList.add(new Property(SP_STARTED, "dateTime", "Date and Time the study started.", 0, Integer.MAX_VALUE, this.started));
        childrenList.add(new Property(SP_ORDER, "Reference(DiagnosticOrder)", "A list of the diagnostic orders that resulted in this imaging study being performed.", 0, Integer.MAX_VALUE, this.order));
        childrenList.add(new Property("referrer", "Reference(Practitioner)", "The requesting/referring physician.", 0, Integer.MAX_VALUE, this.referrer));
        childrenList.add(new Property("interpreter", "Reference(Practitioner)", "Who read the study and interpreted the images or other content.", 0, Integer.MAX_VALUE, this.interpreter));
        childrenList.add(new Property("url", "uri", "WADO-RS resource where Study is available.", 0, Integer.MAX_VALUE, this.url));
        childrenList.add(new Property("numberOfSeries", "unsignedInt", "Number of Series in Study.", 0, Integer.MAX_VALUE, this.numberOfSeries));
        childrenList.add(new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in Study.", 0, Integer.MAX_VALUE, this.numberOfInstances));
        childrenList.add(new Property("procedure", "Reference(Procedure)", "Type of procedure performed.", 0, Integer.MAX_VALUE, this.procedure));
        childrenList.add(new Property("description", "string", "Institution-generated description or classification of the Study performed.", 0, Integer.MAX_VALUE, this.description));
        childrenList.add(new Property(SP_SERIES, "", "Each study has one or more series of images or other content.", 0, Integer.MAX_VALUE, this.series));
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case 115792: {
                Base[] baseArray;
                if (this.uid == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.uid;
                }
                return baseArray;
            }
            case -2115028956: {
                Base[] baseArray;
                if (this.accession == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.accession;
                }
                return baseArray;
            }
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case 1997542747: {
                Base[] baseArray;
                if (this.availability == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.availability;
                }
                return baseArray;
            }
            case -1030238433: {
                return this.modalityList == null ? new Base[]{} : this.modalityList.toArray(new Base[this.modalityList.size()]);
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.patient;
                }
                return baseArray;
            }
            case -1897185151: {
                Base[] baseArray;
                if (this.started == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.started;
                }
                return baseArray;
            }
            case 106006350: {
                return this.order == null ? new Base[]{} : this.order.toArray(new Base[this.order.size()]);
            }
            case -722568161: {
                Base[] baseArray;
                if (this.referrer == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray7 = new Base[1];
                    baseArray = baseArray7;
                    baseArray7[0] = this.referrer;
                }
                return baseArray;
            }
            case -2008009094: {
                Base[] baseArray;
                if (this.interpreter == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray8 = new Base[1];
                    baseArray = baseArray8;
                    baseArray8[0] = this.interpreter;
                }
                return baseArray;
            }
            case 116079: {
                Base[] baseArray;
                if (this.url == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray9 = new Base[1];
                    baseArray = baseArray9;
                    baseArray9[0] = this.url;
                }
                return baseArray;
            }
            case 1920000407: {
                Base[] baseArray;
                if (this.numberOfSeries == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray10 = new Base[1];
                    baseArray = baseArray10;
                    baseArray10[0] = this.numberOfSeries;
                }
                return baseArray;
            }
            case -1043544226: {
                Base[] baseArray;
                if (this.numberOfInstances == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray11 = new Base[1];
                    baseArray = baseArray11;
                    baseArray11[0] = this.numberOfInstances;
                }
                return baseArray;
            }
            case -1095204141: {
                return this.procedure == null ? new Base[]{} : this.procedure.toArray(new Base[this.procedure.size()]);
            }
            case -1724546052: {
                Base[] baseArray;
                if (this.description == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray12 = new Base[1];
                    baseArray = baseArray12;
                    baseArray12[0] = this.description;
                }
                return baseArray;
            }
            case -905838985: {
                return this.series == null ? new Base[]{} : this.series.toArray(new Base[this.series.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public void setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case 115792: {
                this.uid = this.castToOid(value);
                break;
            }
            case -2115028956: {
                this.accession = this.castToIdentifier(value);
                break;
            }
            case -1618432855: {
                this.getIdentifier().add(this.castToIdentifier(value));
                break;
            }
            case 1997542747: {
                this.availability = new InstanceAvailabilityEnumFactory().fromType(value);
                break;
            }
            case -1030238433: {
                this.getModalityList().add(this.castToCoding(value));
                break;
            }
            case -791418107: {
                this.patient = this.castToReference(value);
                break;
            }
            case -1897185151: {
                this.started = this.castToDateTime(value);
                break;
            }
            case 106006350: {
                this.getOrder().add(this.castToReference(value));
                break;
            }
            case -722568161: {
                this.referrer = this.castToReference(value);
                break;
            }
            case -2008009094: {
                this.interpreter = this.castToReference(value);
                break;
            }
            case 116079: {
                this.url = this.castToUri(value);
                break;
            }
            case 1920000407: {
                this.numberOfSeries = this.castToUnsignedInt(value);
                break;
            }
            case -1043544226: {
                this.numberOfInstances = this.castToUnsignedInt(value);
                break;
            }
            case -1095204141: {
                this.getProcedure().add(this.castToReference(value));
                break;
            }
            case -1724546052: {
                this.description = this.castToString(value);
                break;
            }
            case -905838985: {
                this.getSeries().add((ImagingStudySeriesComponent)value);
                break;
            }
            default: {
                super.setProperty(hash, name, value);
            }
        }
    }

    @Override
    public void setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_UID)) {
            this.uid = this.castToOid(value);
        } else if (name.equals(SP_ACCESSION)) {
            this.accession = this.castToIdentifier(value);
        } else if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(this.castToIdentifier(value));
        } else if (name.equals("availability")) {
            this.availability = new InstanceAvailabilityEnumFactory().fromType(value);
        } else if (name.equals("modalityList")) {
            this.getModalityList().add(this.castToCoding(value));
        } else if (name.equals(SP_PATIENT)) {
            this.patient = this.castToReference(value);
        } else if (name.equals(SP_STARTED)) {
            this.started = this.castToDateTime(value);
        } else if (name.equals(SP_ORDER)) {
            this.getOrder().add(this.castToReference(value));
        } else if (name.equals("referrer")) {
            this.referrer = this.castToReference(value);
        } else if (name.equals("interpreter")) {
            this.interpreter = this.castToReference(value);
        } else if (name.equals("url")) {
            this.url = this.castToUri(value);
        } else if (name.equals("numberOfSeries")) {
            this.numberOfSeries = this.castToUnsignedInt(value);
        } else if (name.equals("numberOfInstances")) {
            this.numberOfInstances = this.castToUnsignedInt(value);
        } else if (name.equals("procedure")) {
            this.getProcedure().add(this.castToReference(value));
        } else if (name.equals("description")) {
            this.description = this.castToString(value);
        } else if (name.equals(SP_SERIES)) {
            this.getSeries().add((ImagingStudySeriesComponent)value);
        } else {
            super.setProperty(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case 115792: {
                throw new FHIRException("Cannot make property uid as it is not a complex type");
            }
            case -2115028956: {
                return this.getAccession();
            }
            case -1618432855: {
                return this.addIdentifier();
            }
            case 1997542747: {
                throw new FHIRException("Cannot make property availability as it is not a complex type");
            }
            case -1030238433: {
                return this.addModalityList();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -1897185151: {
                throw new FHIRException("Cannot make property started as it is not a complex type");
            }
            case 106006350: {
                return this.addOrder();
            }
            case -722568161: {
                return this.getReferrer();
            }
            case -2008009094: {
                return this.getInterpreter();
            }
            case 116079: {
                throw new FHIRException("Cannot make property url as it is not a complex type");
            }
            case 1920000407: {
                throw new FHIRException("Cannot make property numberOfSeries as it is not a complex type");
            }
            case -1043544226: {
                throw new FHIRException("Cannot make property numberOfInstances as it is not a complex type");
            }
            case -1095204141: {
                return this.addProcedure();
            }
            case -1724546052: {
                throw new FHIRException("Cannot make property description as it is not a complex type");
            }
            case -905838985: {
                return this.addSeries();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_UID)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.uid");
        }
        if (name.equals(SP_ACCESSION)) {
            this.accession = new Identifier();
            return this.accession;
        }
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals("availability")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.availability");
        }
        if (name.equals("modalityList")) {
            return this.addModalityList();
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_STARTED)) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.started");
        }
        if (name.equals(SP_ORDER)) {
            return this.addOrder();
        }
        if (name.equals("referrer")) {
            this.referrer = new Reference();
            return this.referrer;
        }
        if (name.equals("interpreter")) {
            this.interpreter = new Reference();
            return this.interpreter;
        }
        if (name.equals("url")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.url");
        }
        if (name.equals("numberOfSeries")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfSeries");
        }
        if (name.equals("numberOfInstances")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfInstances");
        }
        if (name.equals("procedure")) {
            return this.addProcedure();
        }
        if (name.equals("description")) {
            throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.description");
        }
        if (name.equals(SP_SERIES)) {
            return this.addSeries();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "ImagingStudy";
    }

    @Override
    public ImagingStudy copy() {
        ImagingStudy dst = new ImagingStudy();
        this.copyValues(dst);
        dst.uid = this.uid == null ? null : this.uid.copy();
        Identifier identifier = dst.accession = this.accession == null ? null : this.accession.copy();
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier2 : this.identifier) {
                dst.identifier.add(identifier2.copy());
            }
        }
        Enumeration<InstanceAvailability> enumeration = dst.availability = this.availability == null ? null : this.availability.copy();
        if (this.modalityList != null) {
            dst.modalityList = new ArrayList<Coding>();
            for (Coding coding : this.modalityList) {
                dst.modalityList.add(coding.copy());
            }
        }
        dst.patient = this.patient == null ? null : this.patient.copy();
        DateTimeType dateTimeType = dst.started = this.started == null ? null : this.started.copy();
        if (this.order != null) {
            dst.order = new ArrayList<Reference>();
            for (Reference reference : this.order) {
                dst.order.add(reference.copy());
            }
        }
        dst.referrer = this.referrer == null ? null : this.referrer.copy();
        dst.interpreter = this.interpreter == null ? null : this.interpreter.copy();
        dst.url = this.url == null ? null : this.url.copy();
        dst.numberOfSeries = this.numberOfSeries == null ? null : this.numberOfSeries.copy();
        UnsignedIntType unsignedIntType = dst.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
        if (this.procedure != null) {
            dst.procedure = new ArrayList<Reference>();
            for (Reference reference : this.procedure) {
                dst.procedure.add(reference.copy());
            }
        }
        StringType stringType = dst.description = this.description == null ? null : this.description.copy();
        if (this.series != null) {
            dst.series = new ArrayList<ImagingStudySeriesComponent>();
            for (ImagingStudySeriesComponent imagingStudySeriesComponent : this.series) {
                dst.series.add(imagingStudySeriesComponent.copy());
            }
        }
        return dst;
    }

    protected ImagingStudy typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other) {
        if (!super.equalsDeep(other)) {
            return false;
        }
        if (!(other instanceof ImagingStudy)) {
            return false;
        }
        ImagingStudy o = (ImagingStudy)other;
        return ImagingStudy.compareDeep(this.uid, o.uid, true) && ImagingStudy.compareDeep(this.accession, o.accession, true) && ImagingStudy.compareDeep(this.identifier, o.identifier, true) && ImagingStudy.compareDeep(this.availability, o.availability, true) && ImagingStudy.compareDeep(this.modalityList, o.modalityList, true) && ImagingStudy.compareDeep(this.patient, o.patient, true) && ImagingStudy.compareDeep(this.started, o.started, true) && ImagingStudy.compareDeep(this.order, o.order, true) && ImagingStudy.compareDeep(this.referrer, o.referrer, true) && ImagingStudy.compareDeep(this.interpreter, o.interpreter, true) && ImagingStudy.compareDeep(this.url, o.url, true) && ImagingStudy.compareDeep(this.numberOfSeries, o.numberOfSeries, true) && ImagingStudy.compareDeep(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudy.compareDeep(this.procedure, o.procedure, true) && ImagingStudy.compareDeep(this.description, o.description, true) && ImagingStudy.compareDeep(this.series, o.series, true);
    }

    @Override
    public boolean equalsShallow(Base other) {
        if (!super.equalsShallow(other)) {
            return false;
        }
        if (!(other instanceof ImagingStudy)) {
            return false;
        }
        ImagingStudy o = (ImagingStudy)other;
        return ImagingStudy.compareValues(this.uid, o.uid, true) && ImagingStudy.compareValues(this.availability, o.availability, true) && ImagingStudy.compareValues(this.started, o.started, true) && ImagingStudy.compareValues(this.url, o.url, true) && ImagingStudy.compareValues(this.numberOfSeries, o.numberOfSeries, true) && ImagingStudy.compareValues(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudy.compareValues(this.description, o.description, true);
    }

    @Override
    public boolean isEmpty() {
        return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.accession != null && !this.accession.isEmpty() || this.identifier != null && !this.identifier.isEmpty() || this.availability != null && !this.availability.isEmpty() || this.modalityList != null && !this.modalityList.isEmpty() || this.patient != null && !this.patient.isEmpty() || this.started != null && !this.started.isEmpty() || this.order != null && !this.order.isEmpty() || this.referrer != null && !this.referrer.isEmpty() || this.interpreter != null && !this.interpreter.isEmpty() || this.url != null && !this.url.isEmpty() || this.numberOfSeries != null && !this.numberOfSeries.isEmpty() || this.numberOfInstances != null && !this.numberOfInstances.isEmpty() || this.procedure != null && !this.procedure.isEmpty() || this.description != null && !this.description.isEmpty() || this.series != null && !this.series.isEmpty());
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.ImagingStudy;
    }

    @Block
    public static class ImagingStudySeriesInstanceComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formal identifier for this instance", formalDefinition="Formal identifier for this image or other content.")
        protected OidType uid;
        @Child(name="number", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The number of this instance in the series", formalDefinition="The number of instance in the series.")
        protected UnsignedIntType number;
        @Child(name="sopClass", type={OidType.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="DICOM class type", formalDefinition="DICOM instance  type.")
        protected OidType sopClass;
        @Child(name="type", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Type of instance (image etc.)", formalDefinition="A human-friendly SOP Class name.")
        protected StringType type;
        @Child(name="title", type={StringType.class}, order=5, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Description of instance", formalDefinition="The description of the instance.")
        protected StringType title;
        @Child(name="content", type={Attachment.class}, order=6, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="The instance payload, such as the image binary data or URL to it", formalDefinition="Content of the instance or a rendering thereof (e.g. a JPEG of an image, or an XML of a structured report). May be represented for example by inline encoding; by a URL reference to a WADO-RS service that makes the instance available; or to a FHIR Resource (e.g. Media, Document, etc.). Multiple content attachments may be used for alternate representations of the instance.")
        protected List<Attachment> content;
        private static final long serialVersionUID = -693669901L;

        public ImagingStudySeriesInstanceComponent() {
        }

        public ImagingStudySeriesInstanceComponent(OidType uid, OidType sopClass) {
            this.uid = uid;
            this.sopClass = sopClass;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public ImagingStudySeriesInstanceComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UnsignedIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new UnsignedIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setNumberElement(UnsignedIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public ImagingStudySeriesInstanceComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new UnsignedIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public OidType getSopClassElement() {
            if (this.sopClass == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.sopClass");
                }
                if (Configuration.doAutoCreate()) {
                    this.sopClass = new OidType();
                }
            }
            return this.sopClass;
        }

        public boolean hasSopClassElement() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public boolean hasSopClass() {
            return this.sopClass != null && !this.sopClass.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setSopClassElement(OidType value) {
            this.sopClass = value;
            return this;
        }

        public String getSopClass() {
            return this.sopClass == null ? null : (String)this.sopClass.getValue();
        }

        public ImagingStudySeriesInstanceComponent setSopClass(String value) {
            if (this.sopClass == null) {
                this.sopClass = new OidType();
            }
            this.sopClass.setValue(value);
            return this;
        }

        public StringType getTypeElement() {
            if (this.type == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.type");
                }
                if (Configuration.doAutoCreate()) {
                    this.type = new StringType();
                }
            }
            return this.type;
        }

        public boolean hasTypeElement() {
            return this.type != null && !this.type.isEmpty();
        }

        public boolean hasType() {
            return this.type != null && !this.type.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setTypeElement(StringType value) {
            this.type = value;
            return this;
        }

        public String getType() {
            return this.type == null ? null : (String)this.type.getValue();
        }

        public ImagingStudySeriesInstanceComponent setType(String value) {
            if (Utilities.noString((String)value)) {
                this.type = null;
            } else {
                if (this.type == null) {
                    this.type = new StringType();
                }
                this.type.setValue(value);
            }
            return this;
        }

        public StringType getTitleElement() {
            if (this.title == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesInstanceComponent.title");
                }
                if (Configuration.doAutoCreate()) {
                    this.title = new StringType();
                }
            }
            return this.title;
        }

        public boolean hasTitleElement() {
            return this.title != null && !this.title.isEmpty();
        }

        public boolean hasTitle() {
            return this.title != null && !this.title.isEmpty();
        }

        public ImagingStudySeriesInstanceComponent setTitleElement(StringType value) {
            this.title = value;
            return this;
        }

        public String getTitle() {
            return this.title == null ? null : (String)this.title.getValue();
        }

        public ImagingStudySeriesInstanceComponent setTitle(String value) {
            if (Utilities.noString((String)value)) {
                this.title = null;
            } else {
                if (this.title == null) {
                    this.title = new StringType();
                }
                this.title.setValue(value);
            }
            return this;
        }

        public List<Attachment> getContent() {
            if (this.content == null) {
                this.content = new ArrayList<Attachment>();
            }
            return this.content;
        }

        public boolean hasContent() {
            if (this.content == null) {
                return false;
            }
            for (Attachment item : this.content) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public Attachment addContent() {
            Attachment t = new Attachment();
            if (this.content == null) {
                this.content = new ArrayList<Attachment>();
            }
            this.content.add(t);
            return t;
        }

        public ImagingStudySeriesInstanceComponent addContent(Attachment t) {
            if (t == null) {
                return this;
            }
            if (this.content == null) {
                this.content = new ArrayList<Attachment>();
            }
            this.content.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ImagingStudy.SP_UID, "oid", "Formal identifier for this image or other content.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("number", "unsignedInt", "The number of instance in the series.", 0, Integer.MAX_VALUE, this.number));
            childrenList.add(new Property("sopClass", "oid", "DICOM instance  type.", 0, Integer.MAX_VALUE, this.sopClass));
            childrenList.add(new Property("type", "string", "A human-friendly SOP Class name.", 0, Integer.MAX_VALUE, this.type));
            childrenList.add(new Property("title", "string", "The description of the instance.", 0, Integer.MAX_VALUE, this.title));
            childrenList.add(new Property("content", "Attachment", "Content of the instance or a rendering thereof (e.g. a JPEG of an image, or an XML of a structured report). May be represented for example by inline encoding; by a URL reference to a WADO-RS service that makes the instance available; or to a FHIR Resource (e.g. Media, Document, etc.). Multiple content attachments may be used for alternate representations of the instance.", 0, Integer.MAX_VALUE, this.content));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.number;
                    }
                    return baseArray;
                }
                case 1560041540: {
                    Base[] baseArray;
                    if (this.sopClass == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.sopClass;
                    }
                    return baseArray;
                }
                case 3575610: {
                    Base[] baseArray;
                    if (this.type == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.type;
                    }
                    return baseArray;
                }
                case 110371416: {
                    Base[] baseArray;
                    if (this.title == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.title;
                    }
                    return baseArray;
                }
                case 951530617: {
                    return this.content == null ? new Base[]{} : this.content.toArray(new Base[this.content.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case -1034364087: {
                    this.number = this.castToUnsignedInt(value);
                    break;
                }
                case 1560041540: {
                    this.sopClass = this.castToOid(value);
                    break;
                }
                case 3575610: {
                    this.type = this.castToString(value);
                    break;
                }
                case 110371416: {
                    this.title = this.castToString(value);
                    break;
                }
                case 951530617: {
                    this.getContent().add(this.castToAttachment(value));
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                this.uid = this.castToOid(value);
            } else if (name.equals("number")) {
                this.number = this.castToUnsignedInt(value);
            } else if (name.equals("sopClass")) {
                this.sopClass = this.castToOid(value);
            } else if (name.equals("type")) {
                this.type = this.castToString(value);
            } else if (name.equals("title")) {
                this.title = this.castToString(value);
            } else if (name.equals("content")) {
                this.getContent().add(this.castToAttachment(value));
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case -1034364087: {
                    throw new FHIRException("Cannot make property number as it is not a complex type");
                }
                case 1560041540: {
                    throw new FHIRException("Cannot make property sopClass as it is not a complex type");
                }
                case 3575610: {
                    throw new FHIRException("Cannot make property type as it is not a complex type");
                }
                case 110371416: {
                    throw new FHIRException("Cannot make property title as it is not a complex type");
                }
                case 951530617: {
                    return this.addContent();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.uid");
            }
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.number");
            }
            if (name.equals("sopClass")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.sopClass");
            }
            if (name.equals("type")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.type");
            }
            if (name.equals("title")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.title");
            }
            if (name.equals("content")) {
                return this.addContent();
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudySeriesInstanceComponent copy() {
            ImagingStudySeriesInstanceComponent dst = new ImagingStudySeriesInstanceComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.number = this.number == null ? null : this.number.copy();
            dst.sopClass = this.sopClass == null ? null : this.sopClass.copy();
            dst.type = this.type == null ? null : this.type.copy();
            StringType stringType = dst.title = this.title == null ? null : this.title.copy();
            if (this.content != null) {
                dst.content = new ArrayList<Attachment>();
                for (Attachment i : this.content) {
                    dst.content.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImagingStudySeriesInstanceComponent)) {
                return false;
            }
            ImagingStudySeriesInstanceComponent o = (ImagingStudySeriesInstanceComponent)other;
            return ImagingStudySeriesInstanceComponent.compareDeep(this.uid, o.uid, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.number, o.number, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.sopClass, o.sopClass, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.type, o.type, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.title, o.title, true) && ImagingStudySeriesInstanceComponent.compareDeep(this.content, o.content, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImagingStudySeriesInstanceComponent)) {
                return false;
            }
            ImagingStudySeriesInstanceComponent o = (ImagingStudySeriesInstanceComponent)other;
            return ImagingStudySeriesInstanceComponent.compareValues(this.uid, o.uid, true) && ImagingStudySeriesInstanceComponent.compareValues(this.number, o.number, true) && ImagingStudySeriesInstanceComponent.compareValues(this.sopClass, o.sopClass, true) && ImagingStudySeriesInstanceComponent.compareValues(this.type, o.type, true) && ImagingStudySeriesInstanceComponent.compareValues(this.title, o.title, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.number != null && !this.number.isEmpty() || this.sopClass != null && !this.sopClass.isEmpty() || this.type != null && !this.type.isEmpty() || this.title != null && !this.title.isEmpty() || this.content != null && !this.content.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.series.instance";
        }
    }

    @Block
    public static class ImagingStudySeriesComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="uid", type={OidType.class}, order=1, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Formal identifier for this series", formalDefinition="Formal identifier for this series.")
        protected OidType uid;
        @Child(name="number", type={UnsignedIntType.class}, order=2, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Numeric identifier of this series", formalDefinition="The Numeric identifier of this series in the study.")
        protected UnsignedIntType number;
        @Child(name="modality", type={Coding.class}, order=3, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="The modality of the instances in the series", formalDefinition="The modality of this series sequence.")
        protected Coding modality;
        @Child(name="description", type={StringType.class}, order=4, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="A short human readable summary of the series", formalDefinition="A description of the series.")
        protected StringType description;
        @Child(name="numberOfInstances", type={UnsignedIntType.class}, order=5, min=1, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Number of Series Related Instances", formalDefinition="Number of SOP Instances in Series.")
        protected UnsignedIntType numberOfInstances;
        @Child(name="availability", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="ONLINE | OFFLINE | NEARLINE | UNAVAILABLE", formalDefinition="Availability of series (online, offline or nearline).")
        protected Enumeration<InstanceAvailability> availability;
        @Child(name="url", type={UriType.class}, order=7, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Location of the referenced instance(s)", formalDefinition="URI/URL specifying the location of the referenced series using WADO-RS.")
        protected UriType url;
        @Child(name="bodySite", type={Coding.class}, order=8, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body part examined", formalDefinition="Body part examined. See  DICOM Part 16 Annex L for the mapping from DICOM to Snomed CT.")
        protected Coding bodySite;
        @Child(name="laterality", type={Coding.class}, order=9, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="Body part laterality", formalDefinition="Laterality if body site is paired anatomic structure and laterality is not pre-coordinated in body site code.")
        protected Coding laterality;
        @Child(name="started", type={DateTimeType.class}, order=10, min=0, max=1, modifier=false, summary=true)
        @Description(shortDefinition="When the series started", formalDefinition="The date and time the series was started.")
        protected DateTimeType started;
        @Child(name="instance", type={}, order=11, min=0, max=-1, modifier=false, summary=true)
        @Description(shortDefinition="A single SOP instance from the series", formalDefinition="A single SOP Instance within the series, e.g. an image, or presentation state.")
        protected List<ImagingStudySeriesInstanceComponent> instance;
        private static final long serialVersionUID = 42813749L;

        public ImagingStudySeriesComponent() {
        }

        public ImagingStudySeriesComponent(OidType uid, Coding modality, UnsignedIntType numberOfInstances) {
            this.uid = uid;
            this.modality = modality;
            this.numberOfInstances = numberOfInstances;
        }

        public OidType getUidElement() {
            if (this.uid == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.uid");
                }
                if (Configuration.doAutoCreate()) {
                    this.uid = new OidType();
                }
            }
            return this.uid;
        }

        public boolean hasUidElement() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public boolean hasUid() {
            return this.uid != null && !this.uid.isEmpty();
        }

        public ImagingStudySeriesComponent setUidElement(OidType value) {
            this.uid = value;
            return this;
        }

        public String getUid() {
            return this.uid == null ? null : (String)this.uid.getValue();
        }

        public ImagingStudySeriesComponent setUid(String value) {
            if (this.uid == null) {
                this.uid = new OidType();
            }
            this.uid.setValue(value);
            return this;
        }

        public UnsignedIntType getNumberElement() {
            if (this.number == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.number");
                }
                if (Configuration.doAutoCreate()) {
                    this.number = new UnsignedIntType();
                }
            }
            return this.number;
        }

        public boolean hasNumberElement() {
            return this.number != null && !this.number.isEmpty();
        }

        public boolean hasNumber() {
            return this.number != null && !this.number.isEmpty();
        }

        public ImagingStudySeriesComponent setNumberElement(UnsignedIntType value) {
            this.number = value;
            return this;
        }

        public int getNumber() {
            return this.number == null || this.number.isEmpty() ? 0 : (Integer)this.number.getValue();
        }

        public ImagingStudySeriesComponent setNumber(int value) {
            if (this.number == null) {
                this.number = new UnsignedIntType();
            }
            this.number.setValue((Object)value);
            return this;
        }

        public Coding getModality() {
            if (this.modality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.modality");
                }
                if (Configuration.doAutoCreate()) {
                    this.modality = new Coding();
                }
            }
            return this.modality;
        }

        public boolean hasModality() {
            return this.modality != null && !this.modality.isEmpty();
        }

        public ImagingStudySeriesComponent setModality(Coding value) {
            this.modality = value;
            return this;
        }

        public StringType getDescriptionElement() {
            if (this.description == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.description");
                }
                if (Configuration.doAutoCreate()) {
                    this.description = new StringType();
                }
            }
            return this.description;
        }

        public boolean hasDescriptionElement() {
            return this.description != null && !this.description.isEmpty();
        }

        public boolean hasDescription() {
            return this.description != null && !this.description.isEmpty();
        }

        public ImagingStudySeriesComponent setDescriptionElement(StringType value) {
            this.description = value;
            return this;
        }

        public String getDescription() {
            return this.description == null ? null : (String)this.description.getValue();
        }

        public ImagingStudySeriesComponent setDescription(String value) {
            if (Utilities.noString((String)value)) {
                this.description = null;
            } else {
                if (this.description == null) {
                    this.description = new StringType();
                }
                this.description.setValue(value);
            }
            return this;
        }

        public UnsignedIntType getNumberOfInstancesElement() {
            if (this.numberOfInstances == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.numberOfInstances");
                }
                if (Configuration.doAutoCreate()) {
                    this.numberOfInstances = new UnsignedIntType();
                }
            }
            return this.numberOfInstances;
        }

        public boolean hasNumberOfInstancesElement() {
            return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
        }

        public boolean hasNumberOfInstances() {
            return this.numberOfInstances != null && !this.numberOfInstances.isEmpty();
        }

        public ImagingStudySeriesComponent setNumberOfInstancesElement(UnsignedIntType value) {
            this.numberOfInstances = value;
            return this;
        }

        public int getNumberOfInstances() {
            return this.numberOfInstances == null || this.numberOfInstances.isEmpty() ? 0 : (Integer)this.numberOfInstances.getValue();
        }

        public ImagingStudySeriesComponent setNumberOfInstances(int value) {
            if (this.numberOfInstances == null) {
                this.numberOfInstances = new UnsignedIntType();
            }
            this.numberOfInstances.setValue((Object)value);
            return this;
        }

        public Enumeration<InstanceAvailability> getAvailabilityElement() {
            if (this.availability == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.availability");
                }
                if (Configuration.doAutoCreate()) {
                    this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
                }
            }
            return this.availability;
        }

        public boolean hasAvailabilityElement() {
            return this.availability != null && !this.availability.isEmpty();
        }

        public boolean hasAvailability() {
            return this.availability != null && !this.availability.isEmpty();
        }

        public ImagingStudySeriesComponent setAvailabilityElement(Enumeration<InstanceAvailability> value) {
            this.availability = value;
            return this;
        }

        public InstanceAvailability getAvailability() {
            return this.availability == null ? null : (InstanceAvailability)((Object)this.availability.getValue());
        }

        public ImagingStudySeriesComponent setAvailability(InstanceAvailability value) {
            if (value == null) {
                this.availability = null;
            } else {
                if (this.availability == null) {
                    this.availability = new Enumeration<InstanceAvailability>(new InstanceAvailabilityEnumFactory());
                }
                this.availability.setValue((Object)value);
            }
            return this;
        }

        public UriType getUrlElement() {
            if (this.url == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.url");
                }
                if (Configuration.doAutoCreate()) {
                    this.url = new UriType();
                }
            }
            return this.url;
        }

        public boolean hasUrlElement() {
            return this.url != null && !this.url.isEmpty();
        }

        public boolean hasUrl() {
            return this.url != null && !this.url.isEmpty();
        }

        public ImagingStudySeriesComponent setUrlElement(UriType value) {
            this.url = value;
            return this;
        }

        public String getUrl() {
            return this.url == null ? null : (String)this.url.getValue();
        }

        public ImagingStudySeriesComponent setUrl(String value) {
            if (Utilities.noString((String)value)) {
                this.url = null;
            } else {
                if (this.url == null) {
                    this.url = new UriType();
                }
                this.url.setValue(value);
            }
            return this;
        }

        public Coding getBodySite() {
            if (this.bodySite == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.bodySite");
                }
                if (Configuration.doAutoCreate()) {
                    this.bodySite = new Coding();
                }
            }
            return this.bodySite;
        }

        public boolean hasBodySite() {
            return this.bodySite != null && !this.bodySite.isEmpty();
        }

        public ImagingStudySeriesComponent setBodySite(Coding value) {
            this.bodySite = value;
            return this;
        }

        public Coding getLaterality() {
            if (this.laterality == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.laterality");
                }
                if (Configuration.doAutoCreate()) {
                    this.laterality = new Coding();
                }
            }
            return this.laterality;
        }

        public boolean hasLaterality() {
            return this.laterality != null && !this.laterality.isEmpty();
        }

        public ImagingStudySeriesComponent setLaterality(Coding value) {
            this.laterality = value;
            return this;
        }

        public DateTimeType getStartedElement() {
            if (this.started == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create ImagingStudySeriesComponent.started");
                }
                if (Configuration.doAutoCreate()) {
                    this.started = new DateTimeType();
                }
            }
            return this.started;
        }

        public boolean hasStartedElement() {
            return this.started != null && !this.started.isEmpty();
        }

        public boolean hasStarted() {
            return this.started != null && !this.started.isEmpty();
        }

        public ImagingStudySeriesComponent setStartedElement(DateTimeType value) {
            this.started = value;
            return this;
        }

        public Date getStarted() {
            return this.started == null ? null : (Date)this.started.getValue();
        }

        public ImagingStudySeriesComponent setStarted(Date value) {
            if (value == null) {
                this.started = null;
            } else {
                if (this.started == null) {
                    this.started = new DateTimeType();
                }
                this.started.setValue(value);
            }
            return this;
        }

        public List<ImagingStudySeriesInstanceComponent> getInstance() {
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            return this.instance;
        }

        public boolean hasInstance() {
            if (this.instance == null) {
                return false;
            }
            for (ImagingStudySeriesInstanceComponent item : this.instance) {
                if (item.isEmpty()) continue;
                return true;
            }
            return false;
        }

        public ImagingStudySeriesInstanceComponent addInstance() {
            ImagingStudySeriesInstanceComponent t = new ImagingStudySeriesInstanceComponent();
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            this.instance.add(t);
            return t;
        }

        public ImagingStudySeriesComponent addInstance(ImagingStudySeriesInstanceComponent t) {
            if (t == null) {
                return this;
            }
            if (this.instance == null) {
                this.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
            }
            this.instance.add(t);
            return this;
        }

        @Override
        protected void listChildren(List<Property> childrenList) {
            super.listChildren(childrenList);
            childrenList.add(new Property(ImagingStudy.SP_UID, "oid", "Formal identifier for this series.", 0, Integer.MAX_VALUE, this.uid));
            childrenList.add(new Property("number", "unsignedInt", "The Numeric identifier of this series in the study.", 0, Integer.MAX_VALUE, this.number));
            childrenList.add(new Property(ImagingStudy.SP_MODALITY, "Coding", "The modality of this series sequence.", 0, Integer.MAX_VALUE, this.modality));
            childrenList.add(new Property("description", "string", "A description of the series.", 0, Integer.MAX_VALUE, this.description));
            childrenList.add(new Property("numberOfInstances", "unsignedInt", "Number of SOP Instances in Series.", 0, Integer.MAX_VALUE, this.numberOfInstances));
            childrenList.add(new Property("availability", "code", "Availability of series (online, offline or nearline).", 0, Integer.MAX_VALUE, this.availability));
            childrenList.add(new Property("url", "uri", "URI/URL specifying the location of the referenced series using WADO-RS.", 0, Integer.MAX_VALUE, this.url));
            childrenList.add(new Property("bodySite", "Coding", "Body part examined. See  DICOM Part 16 Annex L for the mapping from DICOM to Snomed CT.", 0, Integer.MAX_VALUE, this.bodySite));
            childrenList.add(new Property("laterality", "Coding", "Laterality if body site is paired anatomic structure and laterality is not pre-coordinated in body site code.", 0, Integer.MAX_VALUE, this.laterality));
            childrenList.add(new Property(ImagingStudy.SP_STARTED, "dateTime", "The date and time the series was started.", 0, Integer.MAX_VALUE, this.started));
            childrenList.add(new Property("instance", "", "A single SOP Instance within the series, e.g. an image, or presentation state.", 0, Integer.MAX_VALUE, this.instance));
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case 115792: {
                    Base[] baseArray;
                    if (this.uid == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.uid;
                    }
                    return baseArray;
                }
                case -1034364087: {
                    Base[] baseArray;
                    if (this.number == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.number;
                    }
                    return baseArray;
                }
                case -622722335: {
                    Base[] baseArray;
                    if (this.modality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray4 = new Base[1];
                        baseArray = baseArray4;
                        baseArray4[0] = this.modality;
                    }
                    return baseArray;
                }
                case -1724546052: {
                    Base[] baseArray;
                    if (this.description == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray5 = new Base[1];
                        baseArray = baseArray5;
                        baseArray5[0] = this.description;
                    }
                    return baseArray;
                }
                case -1043544226: {
                    Base[] baseArray;
                    if (this.numberOfInstances == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray6 = new Base[1];
                        baseArray = baseArray6;
                        baseArray6[0] = this.numberOfInstances;
                    }
                    return baseArray;
                }
                case 1997542747: {
                    Base[] baseArray;
                    if (this.availability == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray7 = new Base[1];
                        baseArray = baseArray7;
                        baseArray7[0] = this.availability;
                    }
                    return baseArray;
                }
                case 116079: {
                    Base[] baseArray;
                    if (this.url == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray8 = new Base[1];
                        baseArray = baseArray8;
                        baseArray8[0] = this.url;
                    }
                    return baseArray;
                }
                case 1702620169: {
                    Base[] baseArray;
                    if (this.bodySite == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray9 = new Base[1];
                        baseArray = baseArray9;
                        baseArray9[0] = this.bodySite;
                    }
                    return baseArray;
                }
                case -170291817: {
                    Base[] baseArray;
                    if (this.laterality == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray10 = new Base[1];
                        baseArray = baseArray10;
                        baseArray10[0] = this.laterality;
                    }
                    return baseArray;
                }
                case -1897185151: {
                    Base[] baseArray;
                    if (this.started == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray11 = new Base[1];
                        baseArray = baseArray11;
                        baseArray11[0] = this.started;
                    }
                    return baseArray;
                }
                case 555127957: {
                    return this.instance == null ? new Base[]{} : this.instance.toArray(new Base[this.instance.size()]);
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public void setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case 115792: {
                    this.uid = this.castToOid(value);
                    break;
                }
                case -1034364087: {
                    this.number = this.castToUnsignedInt(value);
                    break;
                }
                case -622722335: {
                    this.modality = this.castToCoding(value);
                    break;
                }
                case -1724546052: {
                    this.description = this.castToString(value);
                    break;
                }
                case -1043544226: {
                    this.numberOfInstances = this.castToUnsignedInt(value);
                    break;
                }
                case 1997542747: {
                    this.availability = new InstanceAvailabilityEnumFactory().fromType(value);
                    break;
                }
                case 116079: {
                    this.url = this.castToUri(value);
                    break;
                }
                case 1702620169: {
                    this.bodySite = this.castToCoding(value);
                    break;
                }
                case -170291817: {
                    this.laterality = this.castToCoding(value);
                    break;
                }
                case -1897185151: {
                    this.started = this.castToDateTime(value);
                    break;
                }
                case 555127957: {
                    this.getInstance().add((ImagingStudySeriesInstanceComponent)value);
                    break;
                }
                default: {
                    super.setProperty(hash, name, value);
                }
            }
        }

        @Override
        public void setProperty(String name, Base value) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                this.uid = this.castToOid(value);
            } else if (name.equals("number")) {
                this.number = this.castToUnsignedInt(value);
            } else if (name.equals(ImagingStudy.SP_MODALITY)) {
                this.modality = this.castToCoding(value);
            } else if (name.equals("description")) {
                this.description = this.castToString(value);
            } else if (name.equals("numberOfInstances")) {
                this.numberOfInstances = this.castToUnsignedInt(value);
            } else if (name.equals("availability")) {
                this.availability = new InstanceAvailabilityEnumFactory().fromType(value);
            } else if (name.equals("url")) {
                this.url = this.castToUri(value);
            } else if (name.equals("bodySite")) {
                this.bodySite = this.castToCoding(value);
            } else if (name.equals("laterality")) {
                this.laterality = this.castToCoding(value);
            } else if (name.equals(ImagingStudy.SP_STARTED)) {
                this.started = this.castToDateTime(value);
            } else if (name.equals("instance")) {
                this.getInstance().add((ImagingStudySeriesInstanceComponent)value);
            } else {
                super.setProperty(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case 115792: {
                    throw new FHIRException("Cannot make property uid as it is not a complex type");
                }
                case -1034364087: {
                    throw new FHIRException("Cannot make property number as it is not a complex type");
                }
                case -622722335: {
                    return this.getModality();
                }
                case -1724546052: {
                    throw new FHIRException("Cannot make property description as it is not a complex type");
                }
                case -1043544226: {
                    throw new FHIRException("Cannot make property numberOfInstances as it is not a complex type");
                }
                case 1997542747: {
                    throw new FHIRException("Cannot make property availability as it is not a complex type");
                }
                case 116079: {
                    throw new FHIRException("Cannot make property url as it is not a complex type");
                }
                case 1702620169: {
                    return this.getBodySite();
                }
                case -170291817: {
                    return this.getLaterality();
                }
                case -1897185151: {
                    throw new FHIRException("Cannot make property started as it is not a complex type");
                }
                case 555127957: {
                    return this.addInstance();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals(ImagingStudy.SP_UID)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.uid");
            }
            if (name.equals("number")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.number");
            }
            if (name.equals(ImagingStudy.SP_MODALITY)) {
                this.modality = new Coding();
                return this.modality;
            }
            if (name.equals("description")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.description");
            }
            if (name.equals("numberOfInstances")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.numberOfInstances");
            }
            if (name.equals("availability")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.availability");
            }
            if (name.equals("url")) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.url");
            }
            if (name.equals("bodySite")) {
                this.bodySite = new Coding();
                return this.bodySite;
            }
            if (name.equals("laterality")) {
                this.laterality = new Coding();
                return this.laterality;
            }
            if (name.equals(ImagingStudy.SP_STARTED)) {
                throw new FHIRException("Cannot call addChild on a primitive type ImagingStudy.started");
            }
            if (name.equals("instance")) {
                return this.addInstance();
            }
            return super.addChild(name);
        }

        @Override
        public ImagingStudySeriesComponent copy() {
            ImagingStudySeriesComponent dst = new ImagingStudySeriesComponent();
            this.copyValues(dst);
            dst.uid = this.uid == null ? null : this.uid.copy();
            dst.number = this.number == null ? null : this.number.copy();
            dst.modality = this.modality == null ? null : this.modality.copy();
            dst.description = this.description == null ? null : this.description.copy();
            dst.numberOfInstances = this.numberOfInstances == null ? null : this.numberOfInstances.copy();
            dst.availability = this.availability == null ? null : this.availability.copy();
            dst.url = this.url == null ? null : this.url.copy();
            dst.bodySite = this.bodySite == null ? null : this.bodySite.copy();
            dst.laterality = this.laterality == null ? null : this.laterality.copy();
            DateTimeType dateTimeType = dst.started = this.started == null ? null : this.started.copy();
            if (this.instance != null) {
                dst.instance = new ArrayList<ImagingStudySeriesInstanceComponent>();
                for (ImagingStudySeriesInstanceComponent i : this.instance) {
                    dst.instance.add(i.copy());
                }
            }
            return dst;
        }

        @Override
        public boolean equalsDeep(Base other) {
            if (!super.equalsDeep(other)) {
                return false;
            }
            if (!(other instanceof ImagingStudySeriesComponent)) {
                return false;
            }
            ImagingStudySeriesComponent o = (ImagingStudySeriesComponent)other;
            return ImagingStudySeriesComponent.compareDeep(this.uid, o.uid, true) && ImagingStudySeriesComponent.compareDeep(this.number, o.number, true) && ImagingStudySeriesComponent.compareDeep(this.modality, o.modality, true) && ImagingStudySeriesComponent.compareDeep(this.description, o.description, true) && ImagingStudySeriesComponent.compareDeep(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudySeriesComponent.compareDeep(this.availability, o.availability, true) && ImagingStudySeriesComponent.compareDeep(this.url, o.url, true) && ImagingStudySeriesComponent.compareDeep(this.bodySite, o.bodySite, true) && ImagingStudySeriesComponent.compareDeep(this.laterality, o.laterality, true) && ImagingStudySeriesComponent.compareDeep(this.started, o.started, true) && ImagingStudySeriesComponent.compareDeep(this.instance, o.instance, true);
        }

        @Override
        public boolean equalsShallow(Base other) {
            if (!super.equalsShallow(other)) {
                return false;
            }
            if (!(other instanceof ImagingStudySeriesComponent)) {
                return false;
            }
            ImagingStudySeriesComponent o = (ImagingStudySeriesComponent)other;
            return ImagingStudySeriesComponent.compareValues(this.uid, o.uid, true) && ImagingStudySeriesComponent.compareValues(this.number, o.number, true) && ImagingStudySeriesComponent.compareValues(this.description, o.description, true) && ImagingStudySeriesComponent.compareValues(this.numberOfInstances, o.numberOfInstances, true) && ImagingStudySeriesComponent.compareValues(this.availability, o.availability, true) && ImagingStudySeriesComponent.compareValues(this.url, o.url, true) && ImagingStudySeriesComponent.compareValues(this.started, o.started, true);
        }

        @Override
        public boolean isEmpty() {
            return !(!super.isEmpty() || this.uid != null && !this.uid.isEmpty() || this.number != null && !this.number.isEmpty() || this.modality != null && !this.modality.isEmpty() || this.description != null && !this.description.isEmpty() || this.numberOfInstances != null && !this.numberOfInstances.isEmpty() || this.availability != null && !this.availability.isEmpty() || this.url != null && !this.url.isEmpty() || this.bodySite != null && !this.bodySite.isEmpty() || this.laterality != null && !this.laterality.isEmpty() || this.started != null && !this.started.isEmpty() || this.instance != null && !this.instance.isEmpty());
        }

        @Override
        public String fhirType() {
            return "ImagingStudy.series";
        }
    }

    public static class InstanceAvailabilityEnumFactory
    implements EnumFactory<InstanceAvailability> {
        @Override
        public InstanceAvailability fromCode(String codeString) throws IllegalArgumentException {
            if ((codeString == null || "".equals(codeString)) && (codeString == null || "".equals(codeString))) {
                return null;
            }
            if ("ONLINE".equals(codeString)) {
                return InstanceAvailability.ONLINE;
            }
            if ("OFFLINE".equals(codeString)) {
                return InstanceAvailability.OFFLINE;
            }
            if ("NEARLINE".equals(codeString)) {
                return InstanceAvailability.NEARLINE;
            }
            if ("UNAVAILABLE".equals(codeString)) {
                return InstanceAvailability.UNAVAILABLE;
            }
            throw new IllegalArgumentException("Unknown InstanceAvailability code '" + codeString + "'");
        }

        public Enumeration<InstanceAvailability> fromType(Base code) throws FHIRException {
            if (code == null || code.isEmpty()) {
                return null;
            }
            String codeString = ((PrimitiveType)code).asStringValue();
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ONLINE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.ONLINE);
            }
            if ("OFFLINE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.OFFLINE);
            }
            if ("NEARLINE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.NEARLINE);
            }
            if ("UNAVAILABLE".equals(codeString)) {
                return new Enumeration<InstanceAvailability>(this, InstanceAvailability.UNAVAILABLE);
            }
            throw new FHIRException("Unknown InstanceAvailability code '" + codeString + "'");
        }

        @Override
        public String toCode(InstanceAvailability code) {
            if (code == InstanceAvailability.ONLINE) {
                return "ONLINE";
            }
            if (code == InstanceAvailability.OFFLINE) {
                return "OFFLINE";
            }
            if (code == InstanceAvailability.NEARLINE) {
                return "NEARLINE";
            }
            if (code == InstanceAvailability.UNAVAILABLE) {
                return "UNAVAILABLE";
            }
            return "?";
        }

        @Override
        public String toSystem(InstanceAvailability code) {
            return code.getSystem();
        }
    }

    public static enum InstanceAvailability {
        ONLINE,
        OFFLINE,
        NEARLINE,
        UNAVAILABLE,
        NULL;


        public static InstanceAvailability fromCode(String codeString) throws FHIRException {
            if (codeString == null || "".equals(codeString)) {
                return null;
            }
            if ("ONLINE".equals(codeString)) {
                return ONLINE;
            }
            if ("OFFLINE".equals(codeString)) {
                return OFFLINE;
            }
            if ("NEARLINE".equals(codeString)) {
                return NEARLINE;
            }
            if ("UNAVAILABLE".equals(codeString)) {
                return UNAVAILABLE;
            }
            throw new FHIRException("Unknown InstanceAvailability code '" + codeString + "'");
        }

        public String toCode() {
            switch (this) {
                case ONLINE: {
                    return "ONLINE";
                }
                case OFFLINE: {
                    return "OFFLINE";
                }
                case NEARLINE: {
                    return "NEARLINE";
                }
                case UNAVAILABLE: {
                    return "UNAVAILABLE";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getSystem() {
            switch (this) {
                case ONLINE: {
                    return "http://nema.org/dicom/dicm";
                }
                case OFFLINE: {
                    return "http://nema.org/dicom/dicm";
                }
                case NEARLINE: {
                    return "http://nema.org/dicom/dicm";
                }
                case UNAVAILABLE: {
                    return "http://nema.org/dicom/dicm";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDefinition() {
            switch (this) {
                case ONLINE: {
                    return "";
                }
                case OFFLINE: {
                    return "";
                }
                case NEARLINE: {
                    return "";
                }
                case UNAVAILABLE: {
                    return "";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }

        public String getDisplay() {
            switch (this) {
                case ONLINE: {
                    return "ONLINE";
                }
                case OFFLINE: {
                    return "OFFLINE";
                }
                case NEARLINE: {
                    return "NEARLINE";
                }
                case UNAVAILABLE: {
                    return "UNAVAILABLE";
                }
                case NULL: {
                    return null;
                }
            }
            return "?";
        }
    }
}

