/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum MapListMode {
    FIRST,
    SHARE,
    LAST,
    NULL;


    public static MapListMode fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("first".equals(codeString)) {
            return FIRST;
        }
        if ("share".equals(codeString)) {
            return SHARE;
        }
        if ("last".equals(codeString)) {
            return LAST;
        }
        throw new FHIRException("Unknown MapListMode code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case FIRST: {
                return "first";
            }
            case SHARE: {
                return "share";
            }
            case LAST: {
                return "last";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/map-list-mode";
    }

    public String getDefinition() {
        switch (this) {
            case FIRST: {
                return "when the target list is being assembled, the items for this rule go first. If more that one rule defines a first item (for a given instance of mapping) then this is an error";
            }
            case SHARE: {
                return "the target instance is shared with the target instances generated by another rule (up to the first common n items, then create new ones)";
            }
            case LAST: {
                return "when the target list is being assembled, the items for this rule go last. If more that one rule defines a last item (for a given instance of mapping) then this is an error";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case FIRST: {
                return "First";
            }
            case SHARE: {
                return "Share";
            }
            case LAST: {
                return "Last";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

