/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum NehtaNehtaCrcRelAnteriorPeritonealReflection {
    ENTIRELYABOVE,
    ASTRIDE,
    ENTIRELYBELOW,
    NULL;


    public static NehtaNehtaCrcRelAnteriorPeritonealReflection fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("entirely_above".equals(codeString)) {
            return ENTIRELYABOVE;
        }
        if ("astride".equals(codeString)) {
            return ASTRIDE;
        }
        if ("entirely_below".equals(codeString)) {
            return ENTIRELYBELOW;
        }
        throw new FHIRException("Unknown NehtaNehtaCrcRelAnteriorPeritonealReflection code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case ENTIRELYABOVE: {
                return "entirely_above";
            }
            case ASTRIDE: {
                return "astride";
            }
            case ENTIRELYBELOW: {
                return "entirely_below";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/nehta-crc-rel-anterior-peritoneal-reflection";
    }

    public String getDefinition() {
        switch (this) {
            case ENTIRELYABOVE: {
                return "The rectal tumour is entirely above the level of the peritoneal reflection anteriorly";
            }
            case ASTRIDE: {
                return "The rectal tumour is astride (or at) the level of the peritoneal reflection anteriorly";
            }
            case ENTIRELYBELOW: {
                return "The rectal tumour is entirely below the level of the peritoneal reflection anteriorly";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case ENTIRELYABOVE: {
                return "Entirely above";
            }
            case ASTRIDE: {
                return "Astride";
            }
            case ENTIRELYBELOW: {
                return "Entirely below";
            }
            case NULL: {
                return null;
            }
        }
        return "?";
    }
}

