/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.model.codesystems;

import org.hl7.fhir.dstu2016may.model.EnumFactory;
import org.hl7.fhir.dstu2016may.model.codesystems.OrderSetParticipant;

public class OrderSetParticipantEnumFactory
implements EnumFactory<OrderSetParticipant> {
    @Override
    public OrderSetParticipant fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("patient".equals(codeString)) {
            return OrderSetParticipant.PATIENT;
        }
        if ("person".equals(codeString)) {
            return OrderSetParticipant.PERSON;
        }
        if ("practitioner".equals(codeString)) {
            return OrderSetParticipant.PRACTITIONER;
        }
        if ("related-person".equals(codeString)) {
            return OrderSetParticipant.RELATEDPERSON;
        }
        throw new IllegalArgumentException("Unknown OrderSetParticipant code '" + codeString + "'");
    }

    @Override
    public String toCode(OrderSetParticipant code) {
        if (code == OrderSetParticipant.PATIENT) {
            return "patient";
        }
        if (code == OrderSetParticipant.PERSON) {
            return "person";
        }
        if (code == OrderSetParticipant.PRACTITIONER) {
            return "practitioner";
        }
        if (code == OrderSetParticipant.RELATEDPERSON) {
            return "related-person";
        }
        return "?";
    }

    @Override
    public String toSystem(OrderSetParticipant code) {
        return code.getSystem();
    }
}

