/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.dstu2016may.terminologies;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.hl7.fhir.dstu2016may.formats.IParser;
import org.hl7.fhir.dstu2016may.model.OperationOutcome;
import org.hl7.fhir.dstu2016may.model.Resource;
import org.hl7.fhir.dstu2016may.model.ValueSet;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpander;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpanderFactory;
import org.hl7.fhir.dstu2016may.terminologies.ValueSetExpanderSimple;
import org.hl7.fhir.dstu2016may.utils.IWorkerContext;
import org.hl7.fhir.dstu2016may.utils.ToolingExtensions;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;

public class ValueSetExpansionCache
implements ValueSetExpanderFactory {
    private static final String VS_ID_EXT = "http://tools/cache";
    private final Map<String, ValueSetExpander.ValueSetExpansionOutcome> expansions = new HashMap<String, ValueSetExpander.ValueSetExpansionOutcome>();
    private final IWorkerContext context;
    private final String cacheFolder;

    public ValueSetExpansionCache(IWorkerContext context) {
        this.cacheFolder = null;
        this.context = context;
    }

    public ValueSetExpansionCache(IWorkerContext context, String cacheFolder) throws FHIRFormatError, IOException {
        this.context = context;
        this.cacheFolder = cacheFolder;
        if (this.cacheFolder != null) {
            this.loadCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadCache() throws FHIRFormatError, IOException {
        File[] files;
        for (File f : files = new File(this.cacheFolder).listFiles()) {
            if (!f.getName().endsWith(".xml")) continue;
            FileInputStream is = new FileInputStream(f);
            try {
                Resource r = this.context.newXmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).parse(is);
                if (r instanceof OperationOutcome) {
                    OperationOutcome oo = (OperationOutcome)r;
                    this.expansions.put(ToolingExtensions.getExtension(oo, VS_ID_EXT).getValue().toString(), new ValueSetExpander.ValueSetExpansionOutcome(new XhtmlComposer(true, false).composePlainText(oo.getText().getDiv())));
                    continue;
                }
                ValueSet vs = (ValueSet)r;
                this.expansions.put(vs.getUrl(), new ValueSetExpander.ValueSetExpansionOutcome(vs, null));
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    @Override
    public ValueSetExpander getExpander() {
        return new CacheAwareExpander();
    }

    public class CacheAwareExpander
    implements ValueSetExpander {
        @Override
        public ValueSetExpander.ValueSetExpansionOutcome expand(ValueSet source) throws ValueSetExpander.ETooCostly, IOException {
            if (ValueSetExpansionCache.this.expansions.containsKey(source.getUrl())) {
                return (ValueSetExpander.ValueSetExpansionOutcome)ValueSetExpansionCache.this.expansions.get(source.getUrl());
            }
            ValueSetExpanderSimple vse = new ValueSetExpanderSimple(ValueSetExpansionCache.this.context, ValueSetExpansionCache.this);
            ValueSetExpander.ValueSetExpansionOutcome vso = vse.expand(source);
            if (vso.getError() != null) {
                vso = ValueSetExpansionCache.this.context.expandVS(source, false);
                FileOutputStream s = new FileOutputStream(Utilities.path((String[])new String[]{ValueSetExpansionCache.this.cacheFolder, this.makeFile(source.getUrl())}));
                ValueSetExpansionCache.this.context.newXmlParser().setOutputStyle(IParser.OutputStyle.PRETTY).compose(s, vso.getValueset());
                s.close();
            }
            ValueSetExpansionCache.this.expansions.put(source.getUrl(), vso);
            return vso;
        }

        private String makeFile(String url) {
            return url.replace("$", "").replace(":", "").replace("//", "/").replace("/", "_") + ".xml";
        }
    }
}

